/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.regexp;

import com.puppycrawl.tools.checkstyle.api.FileText;
import com.puppycrawl.tools.checkstyle.api.LineColumn;
import com.puppycrawl.tools.checkstyle.checks.regexp.DetectorOptions;
import java.util.regex.Matcher;

class MultilineDetector {
    private final DetectorOptions mOptions;
    private int mCurrentMatches;
    private Matcher mMatcher;
    private FileText mText;

    public MultilineDetector(DetectorOptions aOptions) {
        this.mOptions = aOptions;
    }

    public void processLines(FileText aText) {
        this.mText = aText;
        this.resetState();
        this.mMatcher = this.mOptions.getPattern().matcher(this.mText.getFullText());
        this.findMatch();
        this.finish();
    }

    private void findMatch() {
        boolean foundMatch = this.mMatcher.find();
        if (!foundMatch) {
            return;
        }
        LineColumn start = this.mText.lineColumn(this.mMatcher.start());
        LineColumn end = this.mText.lineColumn(this.mMatcher.end());
        if (!this.mOptions.getSuppressor().shouldSuppress(start.getLine(), start.getColumn(), end.getLine(), end.getColumn())) {
            ++this.mCurrentMatches;
            if (this.mCurrentMatches > this.mOptions.getMaximum()) {
                if ("".equals(this.mOptions.getMessage())) {
                    this.mOptions.getReporter().log(start.getLine(), "regexp.exceeded", this.mMatcher.pattern().toString());
                } else {
                    this.mOptions.getReporter().log(start.getLine(), this.mOptions.getMessage(), new Object[0]);
                }
            }
        }
        this.findMatch();
    }

    private void finish() {
        if (this.mCurrentMatches < this.mOptions.getMinimum()) {
            if ("".equals(this.mOptions.getMessage())) {
                this.mOptions.getReporter().log(0, "regexp.minimum", this.mOptions.getMinimum(), this.mOptions.getFormat());
            } else {
                this.mOptions.getReporter().log(0, this.mOptions.getMessage(), new Object[0]);
            }
        }
    }

    private void resetState() {
        this.mCurrentMatches = 0;
    }
}

