/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.report.xml.writer.impl.base;

import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.collections.ArrayStack;
import org.apache.rat.report.xml.writer.IXmlWriter;
import org.apache.rat.report.xml.writer.InvalidXmlException;
import org.apache.rat.report.xml.writer.OperationNotAllowedException;

public final class XmlWriter
implements IXmlWriter {
    private static final byte NAME_START_MASK = 2;
    private static final byte NAME_MASK = 4;
    private static final byte NAME_BODY_CHAR = 4;
    private static final byte NAME_START_OR_BODY_CHAR = 6;
    private static final boolean[] ALLOWED_CHARACTERS = new boolean[65536];
    private static final byte[] CHARACTER_CODES;
    private final Writer writer;
    private final ArrayStack elementNames;
    private final Set<CharSequence> currentAttributes = new HashSet<CharSequence>();
    boolean elementsWritten = false;
    boolean inElement = false;
    boolean prologWritten = false;

    public XmlWriter(Writer writer) {
        this.writer = writer;
        this.elementNames = new ArrayStack();
    }

    public IXmlWriter startDocument() throws IOException {
        if (this.elementsWritten) {
            throw new OperationNotAllowedException("Document already started");
        }
        if (this.prologWritten) {
            throw new OperationNotAllowedException("Only one prolog allowed");
        }
        this.writer.write("<?xml version='1.0'?>");
        this.prologWritten = true;
        return this;
    }

    public IXmlWriter openElement(CharSequence elementName) throws IOException {
        if (this.elementsWritten && this.elementNames.isEmpty()) {
            throw new OperationNotAllowedException("Root element already closed. Cannot open new element.");
        }
        if (!this.isValidName(elementName)) {
            throw new InvalidXmlException("'" + elementName + "' is not a valid element name");
        }
        this.elementsWritten = true;
        if (this.inElement) {
            this.writer.write(62);
        }
        this.writer.write(60);
        this.rawWrite(elementName);
        this.inElement = true;
        this.elementNames.push((Object)elementName);
        this.currentAttributes.clear();
        return this;
    }

    public IXmlWriter attribute(CharSequence name, CharSequence value) throws IOException {
        if (this.elementNames.isEmpty()) {
            if (this.elementsWritten) {
                throw new OperationNotAllowedException("Root element has already been closed.");
            }
            throw new OperationNotAllowedException("Close called before an element has been opened.");
        }
        if (!this.isValidName(name)) {
            throw new InvalidXmlException("'" + name + "' is not a valid attribute name.");
        }
        if (!this.inElement) {
            throw new InvalidXmlException("Attributes can only be written in elements");
        }
        if (this.currentAttributes.contains(name)) {
            throw new InvalidXmlException("Each attribute can only be written once");
        }
        this.writer.write(32);
        this.rawWrite(name);
        this.writer.write(61);
        this.writer.write(39);
        this.writeAttributeContent(value);
        this.writer.write(39);
        this.currentAttributes.add(name);
        return this;
    }

    private void writeAttributeContent(CharSequence content) throws IOException {
        this.writeEscaped(content, true);
    }

    public IXmlWriter content(CharSequence content) throws IOException {
        if (this.elementNames.isEmpty()) {
            if (this.elementsWritten) {
                throw new OperationNotAllowedException("Root element has already been closed.");
            }
            throw new OperationNotAllowedException("An element must be opened before content can be written.");
        }
        if (this.inElement) {
            this.writer.write(62);
        }
        this.writeBodyContent(content);
        this.inElement = false;
        return this;
    }

    private void writeBodyContent(CharSequence content) throws IOException {
        this.writeEscaped(content, false);
    }

    private void writeEscaped(CharSequence content, boolean isAttributeContent) throws IOException {
        int length = content.length();
        for (int i = 0; i < length; ++i) {
            char character = content.charAt(i);
            if (character == '&') {
                this.writer.write("&amp;");
                continue;
            }
            if (character == '<') {
                this.writer.write("&lt;");
                continue;
            }
            if (character == '>') {
                this.writer.write("&gt;");
                continue;
            }
            if (isAttributeContent && character == '\'') {
                this.writer.write("&apos;");
                continue;
            }
            if (isAttributeContent && character == '\"') {
                this.writer.write("&quot;");
                continue;
            }
            if (this.isOutOfRange(character)) {
                this.writer.write(63);
                continue;
            }
            this.writer.write(character);
        }
    }

    private boolean isOutOfRange(char character) {
        boolean result = !ALLOWED_CHARACTERS[character];
        return result;
    }

    public IXmlWriter closeElement() throws IOException {
        if (this.elementNames.isEmpty()) {
            if (this.elementsWritten) {
                throw new OperationNotAllowedException("Root element has already been closed.");
            }
            throw new OperationNotAllowedException("Close called before an element has been opened.");
        }
        CharSequence elementName = (CharSequence)this.elementNames.pop();
        if (this.inElement) {
            this.writer.write(47);
            this.writer.write(62);
        } else {
            this.writer.write(60);
            this.writer.write(47);
            this.rawWrite(elementName);
            this.writer.write(62);
        }
        this.writer.flush();
        this.inElement = false;
        return this;
    }

    public IXmlWriter closeDocument() throws IOException {
        if (this.elementNames.isEmpty() && !this.elementsWritten) {
            throw new OperationNotAllowedException("Close called before an element has been opened.");
        }
        while (!this.elementNames.isEmpty()) {
            this.closeElement();
        }
        this.writer.flush();
        return this;
    }

    private void rawWrite(CharSequence sequence) throws IOException {
        for (int i = 0; i < sequence.length(); ++i) {
            char charAt = sequence.charAt(i);
            this.writer.write(charAt);
        }
    }

    private boolean isValidName(CharSequence sequence) {
        boolean result = true;
        int length = sequence.length();
        for (int i = 0; i < length; ++i) {
            char character = sequence.charAt(i);
            if (i == 0) {
                if (this.isValidNameStart(character)) continue;
                result = false;
                break;
            }
            if (this.isValidNameBody(character)) continue;
            result = false;
            break;
        }
        return result;
    }

    private boolean isValidNameStart(char character) {
        byte code = CHARACTER_CODES[character];
        boolean result = (code & 2) > 0;
        return result;
    }

    private boolean isValidNameBody(char character) {
        byte code = CHARACTER_CODES[character];
        boolean result = (code & 4) > 0;
        return result;
    }

    static {
        Arrays.fill(ALLOWED_CHARACTERS, false);
        XmlWriter.ALLOWED_CHARACTERS[9] = true;
        XmlWriter.ALLOWED_CHARACTERS[10] = true;
        XmlWriter.ALLOWED_CHARACTERS[13] = true;
        Arrays.fill(ALLOWED_CHARACTERS, 32, 55295, true);
        Arrays.fill(ALLOWED_CHARACTERS, 57344, 65533, true);
        CHARACTER_CODES = new byte[65536];
        XmlWriter.CHARACTER_CODES[95] = 6;
        XmlWriter.CHARACTER_CODES[58] = 6;
        Arrays.fill(CHARACTER_CODES, 65, 90, (byte)6);
        Arrays.fill(CHARACTER_CODES, 97, 122, (byte)6);
        Arrays.fill(CHARACTER_CODES, 192, 214, (byte)6);
        Arrays.fill(CHARACTER_CODES, 216, 246, (byte)6);
        Arrays.fill(CHARACTER_CODES, 248, 255, (byte)6);
        Arrays.fill(CHARACTER_CODES, 256, 305, (byte)6);
        Arrays.fill(CHARACTER_CODES, 308, 318, (byte)6);
        Arrays.fill(CHARACTER_CODES, 321, 328, (byte)6);
        Arrays.fill(CHARACTER_CODES, 330, 382, (byte)6);
        Arrays.fill(CHARACTER_CODES, 384, 451, (byte)6);
        Arrays.fill(CHARACTER_CODES, 461, 496, (byte)6);
        Arrays.fill(CHARACTER_CODES, 500, 501, (byte)6);
        Arrays.fill(CHARACTER_CODES, 506, 535, (byte)6);
        Arrays.fill(CHARACTER_CODES, 592, 680, (byte)6);
        Arrays.fill(CHARACTER_CODES, 699, 705, (byte)6);
        XmlWriter.CHARACTER_CODES[902] = 6;
        Arrays.fill(CHARACTER_CODES, 904, 906, (byte)6);
        XmlWriter.CHARACTER_CODES[908] = 6;
        Arrays.fill(CHARACTER_CODES, 910, 929, (byte)6);
        Arrays.fill(CHARACTER_CODES, 931, 974, (byte)6);
        Arrays.fill(CHARACTER_CODES, 976, 982, (byte)6);
        XmlWriter.CHARACTER_CODES[986] = 6;
        XmlWriter.CHARACTER_CODES[988] = 6;
        XmlWriter.CHARACTER_CODES[990] = 6;
        XmlWriter.CHARACTER_CODES[992] = 6;
        Arrays.fill(CHARACTER_CODES, 994, 1011, (byte)6);
        Arrays.fill(CHARACTER_CODES, 1025, 1036, (byte)6);
        Arrays.fill(CHARACTER_CODES, 1038, 1103, (byte)6);
        Arrays.fill(CHARACTER_CODES, 1105, 1116, (byte)6);
        Arrays.fill(CHARACTER_CODES, 1118, 1153, (byte)6);
        Arrays.fill(CHARACTER_CODES, 1168, 1220, (byte)6);
        Arrays.fill(CHARACTER_CODES, 1223, 1224, (byte)6);
        Arrays.fill(CHARACTER_CODES, 1227, 1228, (byte)6);
        Arrays.fill(CHARACTER_CODES, 1232, 1259, (byte)6);
        Arrays.fill(CHARACTER_CODES, 1262, 1269, (byte)6);
        Arrays.fill(CHARACTER_CODES, 1272, 1273, (byte)6);
        Arrays.fill(CHARACTER_CODES, 1329, 1366, (byte)6);
        XmlWriter.CHARACTER_CODES[1369] = 6;
        Arrays.fill(CHARACTER_CODES, 1377, 1414, (byte)6);
        Arrays.fill(CHARACTER_CODES, 1488, 1514, (byte)6);
        Arrays.fill(CHARACTER_CODES, 1520, 1522, (byte)6);
        Arrays.fill(CHARACTER_CODES, 1569, 1594, (byte)6);
        Arrays.fill(CHARACTER_CODES, 1601, 1610, (byte)6);
        Arrays.fill(CHARACTER_CODES, 1649, 1719, (byte)6);
        Arrays.fill(CHARACTER_CODES, 1722, 1726, (byte)6);
        Arrays.fill(CHARACTER_CODES, 1728, 1742, (byte)6);
        Arrays.fill(CHARACTER_CODES, 1744, 1747, (byte)6);
        XmlWriter.CHARACTER_CODES[1749] = 6;
        Arrays.fill(CHARACTER_CODES, 1765, 1766, (byte)6);
        Arrays.fill(CHARACTER_CODES, 2309, 2361, (byte)6);
        XmlWriter.CHARACTER_CODES[2365] = 6;
        Arrays.fill(CHARACTER_CODES, 2392, 2401, (byte)6);
        Arrays.fill(CHARACTER_CODES, 2437, 2444, (byte)6);
        Arrays.fill(CHARACTER_CODES, 2447, 2448, (byte)6);
        Arrays.fill(CHARACTER_CODES, 2451, 2472, (byte)6);
        Arrays.fill(CHARACTER_CODES, 2474, 2480, (byte)6);
        XmlWriter.CHARACTER_CODES[2482] = 6;
        Arrays.fill(CHARACTER_CODES, 2486, 2489, (byte)6);
        Arrays.fill(CHARACTER_CODES, 2524, 2525, (byte)6);
        Arrays.fill(CHARACTER_CODES, 2527, 2529, (byte)6);
        Arrays.fill(CHARACTER_CODES, 2544, 2545, (byte)6);
        Arrays.fill(CHARACTER_CODES, 2565, 2570, (byte)6);
        Arrays.fill(CHARACTER_CODES, 2575, 2576, (byte)6);
        Arrays.fill(CHARACTER_CODES, 2579, 2600, (byte)6);
        Arrays.fill(CHARACTER_CODES, 2602, 2608, (byte)6);
        Arrays.fill(CHARACTER_CODES, 2610, 2611, (byte)6);
        Arrays.fill(CHARACTER_CODES, 2613, 2614, (byte)6);
        Arrays.fill(CHARACTER_CODES, 2616, 2617, (byte)6);
        Arrays.fill(CHARACTER_CODES, 2649, 2652, (byte)6);
        XmlWriter.CHARACTER_CODES[2654] = 6;
        Arrays.fill(CHARACTER_CODES, 2674, 2676, (byte)6);
        Arrays.fill(CHARACTER_CODES, 2693, 2699, (byte)6);
        XmlWriter.CHARACTER_CODES[2701] = 6;
        Arrays.fill(CHARACTER_CODES, 2703, 2705, (byte)6);
        Arrays.fill(CHARACTER_CODES, 2707, 2728, (byte)6);
        Arrays.fill(CHARACTER_CODES, 2730, 2736, (byte)6);
        Arrays.fill(CHARACTER_CODES, 2738, 2739, (byte)6);
        Arrays.fill(CHARACTER_CODES, 2741, 2745, (byte)6);
        XmlWriter.CHARACTER_CODES[2749] = 6;
        XmlWriter.CHARACTER_CODES[2784] = 6;
        Arrays.fill(CHARACTER_CODES, 2821, 2828, (byte)6);
        Arrays.fill(CHARACTER_CODES, 2831, 2832, (byte)6);
        Arrays.fill(CHARACTER_CODES, 2835, 2856, (byte)6);
        Arrays.fill(CHARACTER_CODES, 2858, 2864, (byte)6);
        Arrays.fill(CHARACTER_CODES, 2866, 2867, (byte)6);
        Arrays.fill(CHARACTER_CODES, 2870, 2873, (byte)6);
        XmlWriter.CHARACTER_CODES[2877] = 6;
        Arrays.fill(CHARACTER_CODES, 2908, 2909, (byte)6);
        Arrays.fill(CHARACTER_CODES, 2911, 2913, (byte)6);
        Arrays.fill(CHARACTER_CODES, 2949, 2954, (byte)6);
        Arrays.fill(CHARACTER_CODES, 2958, 2960, (byte)6);
        Arrays.fill(CHARACTER_CODES, 2962, 2965, (byte)6);
        Arrays.fill(CHARACTER_CODES, 2969, 2970, (byte)6);
        XmlWriter.CHARACTER_CODES[2972] = 6;
        Arrays.fill(CHARACTER_CODES, 2974, 2975, (byte)6);
        Arrays.fill(CHARACTER_CODES, 2979, 2980, (byte)6);
        Arrays.fill(CHARACTER_CODES, 2984, 2986, (byte)6);
        Arrays.fill(CHARACTER_CODES, 2990, 2997, (byte)6);
        Arrays.fill(CHARACTER_CODES, 2999, 3001, (byte)6);
        Arrays.fill(CHARACTER_CODES, 3077, 3084, (byte)6);
        Arrays.fill(CHARACTER_CODES, 3086, 3088, (byte)6);
        Arrays.fill(CHARACTER_CODES, 3090, 3112, (byte)6);
        Arrays.fill(CHARACTER_CODES, 3114, 3123, (byte)6);
        Arrays.fill(CHARACTER_CODES, 3125, 3129, (byte)6);
        Arrays.fill(CHARACTER_CODES, 3168, 3169, (byte)6);
        Arrays.fill(CHARACTER_CODES, 3205, 3212, (byte)6);
        Arrays.fill(CHARACTER_CODES, 3214, 3216, (byte)6);
        Arrays.fill(CHARACTER_CODES, 3218, 3240, (byte)6);
        Arrays.fill(CHARACTER_CODES, 3242, 3251, (byte)6);
        Arrays.fill(CHARACTER_CODES, 3253, 3257, (byte)6);
        XmlWriter.CHARACTER_CODES[3294] = 6;
        Arrays.fill(CHARACTER_CODES, 3296, 3297, (byte)6);
        Arrays.fill(CHARACTER_CODES, 3333, 3340, (byte)6);
        Arrays.fill(CHARACTER_CODES, 3342, 3344, (byte)6);
        Arrays.fill(CHARACTER_CODES, 3346, 3368, (byte)6);
        Arrays.fill(CHARACTER_CODES, 3370, 3385, (byte)6);
        Arrays.fill(CHARACTER_CODES, 3424, 3425, (byte)6);
        Arrays.fill(CHARACTER_CODES, 3585, 3630, (byte)6);
        XmlWriter.CHARACTER_CODES[3632] = 6;
        Arrays.fill(CHARACTER_CODES, 3634, 3635, (byte)6);
        Arrays.fill(CHARACTER_CODES, 3648, 3653, (byte)6);
        Arrays.fill(CHARACTER_CODES, 3713, 3714, (byte)6);
        XmlWriter.CHARACTER_CODES[3716] = 6;
        Arrays.fill(CHARACTER_CODES, 3719, 3720, (byte)6);
        XmlWriter.CHARACTER_CODES[3722] = 6;
        XmlWriter.CHARACTER_CODES[3725] = 6;
        Arrays.fill(CHARACTER_CODES, 3732, 3735, (byte)6);
        Arrays.fill(CHARACTER_CODES, 3737, 3743, (byte)6);
        Arrays.fill(CHARACTER_CODES, 3745, 3747, (byte)6);
        XmlWriter.CHARACTER_CODES[3749] = 6;
        XmlWriter.CHARACTER_CODES[3751] = 6;
        Arrays.fill(CHARACTER_CODES, 3754, 3755, (byte)6);
        Arrays.fill(CHARACTER_CODES, 3757, 3758, (byte)6);
        XmlWriter.CHARACTER_CODES[3760] = 6;
        Arrays.fill(CHARACTER_CODES, 3762, 3763, (byte)6);
        XmlWriter.CHARACTER_CODES[3773] = 6;
        Arrays.fill(CHARACTER_CODES, 3776, 3780, (byte)6);
        Arrays.fill(CHARACTER_CODES, 3904, 3911, (byte)6);
        Arrays.fill(CHARACTER_CODES, 3913, 3945, (byte)6);
        Arrays.fill(CHARACTER_CODES, 4256, 4293, (byte)6);
        Arrays.fill(CHARACTER_CODES, 4304, 4342, (byte)6);
        XmlWriter.CHARACTER_CODES[4352] = 6;
        Arrays.fill(CHARACTER_CODES, 4354, 4355, (byte)6);
        Arrays.fill(CHARACTER_CODES, 4357, 4359, (byte)6);
        XmlWriter.CHARACTER_CODES[4361] = 6;
        Arrays.fill(CHARACTER_CODES, 4363, 4364, (byte)6);
        Arrays.fill(CHARACTER_CODES, 4366, 4370, (byte)6);
        XmlWriter.CHARACTER_CODES[4412] = 6;
        XmlWriter.CHARACTER_CODES[4414] = 6;
        XmlWriter.CHARACTER_CODES[4416] = 6;
        XmlWriter.CHARACTER_CODES[4428] = 6;
        XmlWriter.CHARACTER_CODES[4430] = 6;
        XmlWriter.CHARACTER_CODES[4432] = 6;
        Arrays.fill(CHARACTER_CODES, 4436, 4437, (byte)6);
        XmlWriter.CHARACTER_CODES[4441] = 6;
        Arrays.fill(CHARACTER_CODES, 4447, 4449, (byte)6);
        XmlWriter.CHARACTER_CODES[4451] = 6;
        XmlWriter.CHARACTER_CODES[4453] = 6;
        XmlWriter.CHARACTER_CODES[4455] = 6;
        XmlWriter.CHARACTER_CODES[4457] = 6;
        Arrays.fill(CHARACTER_CODES, 4461, 4462, (byte)6);
        Arrays.fill(CHARACTER_CODES, 4466, 4467, (byte)6);
        XmlWriter.CHARACTER_CODES[4469] = 6;
        XmlWriter.CHARACTER_CODES[4510] = 6;
        XmlWriter.CHARACTER_CODES[4520] = 6;
        XmlWriter.CHARACTER_CODES[4523] = 6;
        Arrays.fill(CHARACTER_CODES, 4526, 4527, (byte)6);
        Arrays.fill(CHARACTER_CODES, 4535, 4536, (byte)6);
        XmlWriter.CHARACTER_CODES[4538] = 6;
        Arrays.fill(CHARACTER_CODES, 4540, 4546, (byte)6);
        XmlWriter.CHARACTER_CODES[4587] = 6;
        XmlWriter.CHARACTER_CODES[4592] = 6;
        XmlWriter.CHARACTER_CODES[4601] = 6;
        Arrays.fill(CHARACTER_CODES, 7680, 7835, (byte)6);
        Arrays.fill(CHARACTER_CODES, 7840, 7929, (byte)6);
        Arrays.fill(CHARACTER_CODES, 7936, 7957, (byte)6);
        Arrays.fill(CHARACTER_CODES, 7960, 7965, (byte)6);
        Arrays.fill(CHARACTER_CODES, 7968, 8005, (byte)6);
        Arrays.fill(CHARACTER_CODES, 8008, 8013, (byte)6);
        Arrays.fill(CHARACTER_CODES, 8016, 8023, (byte)6);
        XmlWriter.CHARACTER_CODES[8025] = 6;
        XmlWriter.CHARACTER_CODES[8027] = 6;
        XmlWriter.CHARACTER_CODES[8029] = 6;
        Arrays.fill(CHARACTER_CODES, 8031, 8061, (byte)6);
        Arrays.fill(CHARACTER_CODES, 8064, 8116, (byte)6);
        Arrays.fill(CHARACTER_CODES, 8118, 8124, (byte)6);
        XmlWriter.CHARACTER_CODES[8126] = 6;
        Arrays.fill(CHARACTER_CODES, 8130, 8132, (byte)6);
        Arrays.fill(CHARACTER_CODES, 8134, 8140, (byte)6);
        Arrays.fill(CHARACTER_CODES, 8144, 8147, (byte)6);
        Arrays.fill(CHARACTER_CODES, 8150, 8155, (byte)6);
        Arrays.fill(CHARACTER_CODES, 8160, 8172, (byte)6);
        Arrays.fill(CHARACTER_CODES, 8178, 8180, (byte)6);
        Arrays.fill(CHARACTER_CODES, 8182, 8188, (byte)6);
        XmlWriter.CHARACTER_CODES[8486] = 6;
        Arrays.fill(CHARACTER_CODES, 8490, 8491, (byte)6);
        XmlWriter.CHARACTER_CODES[8494] = 6;
        Arrays.fill(CHARACTER_CODES, 8576, 8578, (byte)6);
        Arrays.fill(CHARACTER_CODES, 12353, 12436, (byte)6);
        Arrays.fill(CHARACTER_CODES, 12449, 12538, (byte)6);
        Arrays.fill(CHARACTER_CODES, 12549, 12588, (byte)6);
        Arrays.fill(CHARACTER_CODES, 44032, 55203, (byte)6);
        Arrays.fill(CHARACTER_CODES, 19968, 40869, (byte)6);
        XmlWriter.CHARACTER_CODES[12295] = 6;
        Arrays.fill(CHARACTER_CODES, 12321, 12329, (byte)6);
        XmlWriter.CHARACTER_CODES[46] = 4;
        XmlWriter.CHARACTER_CODES[45] = 4;
        Arrays.fill(CHARACTER_CODES, 768, 837, (byte)4);
        Arrays.fill(CHARACTER_CODES, 864, 865, (byte)4);
        Arrays.fill(CHARACTER_CODES, 1155, 1158, (byte)4);
        Arrays.fill(CHARACTER_CODES, 1425, 1441, (byte)4);
        Arrays.fill(CHARACTER_CODES, 1443, 1465, (byte)4);
        Arrays.fill(CHARACTER_CODES, 1467, 1469, (byte)4);
        XmlWriter.CHARACTER_CODES[1471] = 4;
        Arrays.fill(CHARACTER_CODES, 1473, 1474, (byte)4);
        XmlWriter.CHARACTER_CODES[1476] = 4;
        Arrays.fill(CHARACTER_CODES, 1611, 1618, (byte)4);
        XmlWriter.CHARACTER_CODES[1648] = 4;
        Arrays.fill(CHARACTER_CODES, 1750, 1756, (byte)4);
        Arrays.fill(CHARACTER_CODES, 1757, 1759, (byte)4);
        Arrays.fill(CHARACTER_CODES, 1760, 1764, (byte)4);
        Arrays.fill(CHARACTER_CODES, 1767, 1768, (byte)4);
        Arrays.fill(CHARACTER_CODES, 1770, 1773, (byte)4);
        Arrays.fill(CHARACTER_CODES, 2305, 2307, (byte)4);
        XmlWriter.CHARACTER_CODES[2364] = 4;
        Arrays.fill(CHARACTER_CODES, 2366, 2380, (byte)4);
        XmlWriter.CHARACTER_CODES[2381] = 4;
        Arrays.fill(CHARACTER_CODES, 2385, 2388, (byte)4);
        Arrays.fill(CHARACTER_CODES, 2402, 2403, (byte)4);
        Arrays.fill(CHARACTER_CODES, 2433, 2435, (byte)4);
        XmlWriter.CHARACTER_CODES[2492] = 4;
        XmlWriter.CHARACTER_CODES[2494] = 4;
        XmlWriter.CHARACTER_CODES[2495] = 4;
        Arrays.fill(CHARACTER_CODES, 2496, 2500, (byte)4);
        Arrays.fill(CHARACTER_CODES, 2503, 2504, (byte)4);
        Arrays.fill(CHARACTER_CODES, 2507, 2509, (byte)4);
        XmlWriter.CHARACTER_CODES[2519] = 4;
        Arrays.fill(CHARACTER_CODES, 2530, 2531, (byte)4);
        XmlWriter.CHARACTER_CODES[2562] = 4;
        XmlWriter.CHARACTER_CODES[2620] = 4;
        XmlWriter.CHARACTER_CODES[2622] = 4;
        XmlWriter.CHARACTER_CODES[2623] = 4;
        Arrays.fill(CHARACTER_CODES, 2624, 2626, (byte)4);
        Arrays.fill(CHARACTER_CODES, 2631, 2632, (byte)4);
        Arrays.fill(CHARACTER_CODES, 2635, 2637, (byte)4);
        Arrays.fill(CHARACTER_CODES, 2672, 2673, (byte)4);
        Arrays.fill(CHARACTER_CODES, 2689, 2691, (byte)4);
        XmlWriter.CHARACTER_CODES[2748] = 4;
        Arrays.fill(CHARACTER_CODES, 2750, 2757, (byte)4);
        Arrays.fill(CHARACTER_CODES, 2759, 2761, (byte)4);
        Arrays.fill(CHARACTER_CODES, 2763, 2765, (byte)4);
        Arrays.fill(CHARACTER_CODES, 2817, 2819, (byte)4);
        XmlWriter.CHARACTER_CODES[2876] = 4;
        Arrays.fill(CHARACTER_CODES, 2878, 2883, (byte)4);
        Arrays.fill(CHARACTER_CODES, 2887, 2888, (byte)4);
        Arrays.fill(CHARACTER_CODES, 2891, 2893, (byte)4);
        Arrays.fill(CHARACTER_CODES, 2902, 2903, (byte)4);
        Arrays.fill(CHARACTER_CODES, 2946, 2947, (byte)4);
        Arrays.fill(CHARACTER_CODES, 3006, 3010, (byte)4);
        Arrays.fill(CHARACTER_CODES, 3014, 3016, (byte)4);
        Arrays.fill(CHARACTER_CODES, 3018, 3021, (byte)4);
        XmlWriter.CHARACTER_CODES[3031] = 4;
        Arrays.fill(CHARACTER_CODES, 3073, 3075, (byte)4);
        Arrays.fill(CHARACTER_CODES, 3134, 3140, (byte)4);
        Arrays.fill(CHARACTER_CODES, 3142, 3144, (byte)4);
        Arrays.fill(CHARACTER_CODES, 3146, 3149, (byte)4);
        Arrays.fill(CHARACTER_CODES, 3157, 3158, (byte)4);
        Arrays.fill(CHARACTER_CODES, 3202, 3203, (byte)4);
        Arrays.fill(CHARACTER_CODES, 3262, 3268, (byte)4);
        Arrays.fill(CHARACTER_CODES, 3270, 3272, (byte)4);
        Arrays.fill(CHARACTER_CODES, 3274, 3277, (byte)4);
        Arrays.fill(CHARACTER_CODES, 3285, 3286, (byte)4);
        Arrays.fill(CHARACTER_CODES, 3330, 3331, (byte)4);
        Arrays.fill(CHARACTER_CODES, 3390, 3395, (byte)4);
        Arrays.fill(CHARACTER_CODES, 3398, 3400, (byte)4);
        Arrays.fill(CHARACTER_CODES, 3402, 3405, (byte)4);
        XmlWriter.CHARACTER_CODES[3415] = 4;
        XmlWriter.CHARACTER_CODES[3633] = 4;
        Arrays.fill(CHARACTER_CODES, 3636, 3642, (byte)4);
        Arrays.fill(CHARACTER_CODES, 3655, 3662, (byte)4);
        XmlWriter.CHARACTER_CODES[3761] = 4;
        Arrays.fill(CHARACTER_CODES, 3764, 3769, (byte)4);
        Arrays.fill(CHARACTER_CODES, 3771, 3772, (byte)4);
        Arrays.fill(CHARACTER_CODES, 3784, 3789, (byte)4);
        Arrays.fill(CHARACTER_CODES, 3864, 3865, (byte)4);
        XmlWriter.CHARACTER_CODES[3893] = 4;
        XmlWriter.CHARACTER_CODES[3895] = 4;
        XmlWriter.CHARACTER_CODES[3897] = 4;
        XmlWriter.CHARACTER_CODES[3902] = 4;
        XmlWriter.CHARACTER_CODES[3903] = 4;
        Arrays.fill(CHARACTER_CODES, 3953, 3972, (byte)4);
        Arrays.fill(CHARACTER_CODES, 3974, 3979, (byte)4);
        Arrays.fill(CHARACTER_CODES, 3984, 3989, (byte)4);
        XmlWriter.CHARACTER_CODES[3991] = 4;
        Arrays.fill(CHARACTER_CODES, 3993, 4013, (byte)4);
        Arrays.fill(CHARACTER_CODES, 4017, 4023, (byte)4);
        XmlWriter.CHARACTER_CODES[4025] = 4;
        Arrays.fill(CHARACTER_CODES, 8400, 8412, (byte)4);
        XmlWriter.CHARACTER_CODES[8417] = 4;
        Arrays.fill(CHARACTER_CODES, 12330, 12335, (byte)4);
        XmlWriter.CHARACTER_CODES[12441] = 4;
        XmlWriter.CHARACTER_CODES[12442] = 4;
        Arrays.fill(CHARACTER_CODES, 48, 57, (byte)4);
        Arrays.fill(CHARACTER_CODES, 1632, 1641, (byte)4);
        Arrays.fill(CHARACTER_CODES, 1776, 1785, (byte)4);
        Arrays.fill(CHARACTER_CODES, 2406, 2415, (byte)4);
        Arrays.fill(CHARACTER_CODES, 2534, 2543, (byte)4);
        Arrays.fill(CHARACTER_CODES, 2662, 2671, (byte)4);
        Arrays.fill(CHARACTER_CODES, 2790, 2799, (byte)4);
        Arrays.fill(CHARACTER_CODES, 2918, 2927, (byte)4);
        Arrays.fill(CHARACTER_CODES, 3047, 3055, (byte)4);
        Arrays.fill(CHARACTER_CODES, 3174, 3183, (byte)4);
        Arrays.fill(CHARACTER_CODES, 3302, 3311, (byte)4);
        Arrays.fill(CHARACTER_CODES, 3430, 3439, (byte)4);
        Arrays.fill(CHARACTER_CODES, 3664, 3673, (byte)4);
        Arrays.fill(CHARACTER_CODES, 3792, 3801, (byte)4);
        Arrays.fill(CHARACTER_CODES, 3872, 3881, (byte)4);
        XmlWriter.CHARACTER_CODES[183] = 4;
        XmlWriter.CHARACTER_CODES[720] = 4;
        XmlWriter.CHARACTER_CODES[721] = 4;
        XmlWriter.CHARACTER_CODES[903] = 4;
        XmlWriter.CHARACTER_CODES[1600] = 4;
        XmlWriter.CHARACTER_CODES[3654] = 4;
        XmlWriter.CHARACTER_CODES[3782] = 4;
        XmlWriter.CHARACTER_CODES[12293] = 4;
        Arrays.fill(CHARACTER_CODES, 12337, 12341, (byte)4);
        Arrays.fill(CHARACTER_CODES, 12445, 12446, (byte)4);
        Arrays.fill(CHARACTER_CODES, 12540, 12542, (byte)4);
    }
}

