/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.svn;

import java.io.IOException;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.tmatesoft.svn.core.ISVNDirEntryHandler;
import org.tmatesoft.svn.core.ISVNLogEntryHandler;
import org.tmatesoft.svn.core.SVNAuthenticationException;
import org.tmatesoft.svn.core.SVNCancelException;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNDirEntry;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLock;
import org.tmatesoft.svn.core.SVNLogEntry;
import org.tmatesoft.svn.core.SVNLogEntryPath;
import org.tmatesoft.svn.core.SVNMergeInfo;
import org.tmatesoft.svn.core.SVNMergeInfoInheritance;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.delta.SVNDeltaReader;
import org.tmatesoft.svn.core.internal.io.svn.ISVNConnector;
import org.tmatesoft.svn.core.internal.io.svn.SVNCommitEditor;
import org.tmatesoft.svn.core.internal.io.svn.SVNConnection;
import org.tmatesoft.svn.core.internal.io.svn.SVNEditModeReader;
import org.tmatesoft.svn.core.internal.io.svn.SVNItem;
import org.tmatesoft.svn.core.internal.io.svn.SVNReader;
import org.tmatesoft.svn.core.internal.io.svn.SVNRepositoryFactoryImpl;
import org.tmatesoft.svn.core.internal.util.SVNDate;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.internal.util.SVNMergeInfoUtil;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.SVNDepthFilterEditor;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.ISVNFileRevisionHandler;
import org.tmatesoft.svn.core.io.ISVNLocationEntryHandler;
import org.tmatesoft.svn.core.io.ISVNLocationSegmentHandler;
import org.tmatesoft.svn.core.io.ISVNLockHandler;
import org.tmatesoft.svn.core.io.ISVNReplayHandler;
import org.tmatesoft.svn.core.io.ISVNReporter;
import org.tmatesoft.svn.core.io.ISVNReporterBaton;
import org.tmatesoft.svn.core.io.ISVNSession;
import org.tmatesoft.svn.core.io.ISVNWorkspaceMediator;
import org.tmatesoft.svn.core.io.SVNCapability;
import org.tmatesoft.svn.core.io.SVNFileRevision;
import org.tmatesoft.svn.core.io.SVNLocationEntry;
import org.tmatesoft.svn.core.io.SVNLocationSegment;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNRepositoryImpl
extends SVNRepository
implements ISVNReporter {
    private static final String DIRENT_KIND = "kind";
    private static final String DIRENT_SIZE = "size";
    private static final String DIRENT_HAS_PROPS = "has-props";
    private static final String DIRENT_CREATED_REV = "created-rev";
    private static final String DIRENT_TIME = "time";
    private static final String DIRENT_LAST_AUTHOR = "last-author";
    private SVNConnection myConnection;
    private String myRealm;
    private String myExternalUserName;

    protected SVNRepositoryImpl(SVNURL location, ISVNSession options) {
        super(location, options);
    }

    public void testConnection() throws SVNException {
        try {
            this.openConnection();
        }
        catch (SVNException e) {
            this.closeSession();
            throw e;
        }
        finally {
            this.closeConnection();
        }
    }

    public void setLocation(SVNURL url, boolean forceReconnect) throws SVNException {
        if (url == null) {
            return;
        }
        if (!url.getProtocol().equals(this.myLocation.getProtocol())) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_NOT_IMPLEMENTED, "SVNRepository URL could not be changed from ''{0}'' to ''{1}''; create new SVNRepository instance instead", new Object[]{this.myLocation, url});
            SVNErrorManager.error(err, SVNLogType.NETWORK);
        }
        if (this.myConnection == null) {
            forceReconnect = true;
        }
        if (forceReconnect) {
            this.closeSession();
            this.myLocation = url;
            this.myRealm = null;
            this.myRepositoryRoot = null;
            this.myRepositoryUUID = null;
            return;
        }
        try {
            this.openConnection();
            if (this.reparent(url)) {
                this.myLocation = url;
                return;
            }
            this.setLocation(url, true);
        }
        catch (SVNException e) {
            this.closeSession();
            throw e;
        }
        finally {
            this.closeConnection();
        }
    }

    private boolean reparent(SVNURL url) throws SVNException {
        block4: {
            if (this.myConnection != null) {
                if (this.getLocation().equals(url)) {
                    return true;
                }
                try {
                    Object[] buffer = new Object[]{"reparent", url.toString()};
                    this.write("(w(s))", buffer);
                    this.authenticate();
                    this.read("", null, false);
                    String newLocation = url.toString();
                    String rootLocation = this.myRepositoryRoot.toString();
                    return newLocation.startsWith(rootLocation) && (newLocation.length() == rootLocation.length() || newLocation.length() > rootLocation.length() && newLocation.charAt(rootLocation.length()) == '/');
                }
                catch (SVNException e) {
                    if (!(e instanceof SVNCancelException) && !(e instanceof SVNAuthenticationException)) break block4;
                    throw e;
                }
            }
        }
        return false;
    }

    public long getLatestRevision() throws SVNException {
        Object[] buffer = new Object[]{"get-latest-rev"};
        List values = null;
        try {
            this.openConnection();
            this.write("(w())", buffer);
            this.authenticate();
            values = this.read("r", null, false);
        }
        catch (SVNException e) {
            this.closeSession();
            throw e;
        }
        finally {
            this.closeConnection();
        }
        return SVNReader.getLong(values, 0);
    }

    public long getDatedRevision(Date date) throws SVNException {
        if (date == null) {
            date = new Date(System.currentTimeMillis());
        }
        Object[] buffer = new Object[]{"get-dated-rev", date};
        List values = null;
        try {
            this.openConnection();
            this.write("(w(s))", buffer);
            this.authenticate();
            values = this.read("r", null, false);
        }
        catch (SVNException e) {
            this.closeSession();
            throw e;
        }
        finally {
            this.closeConnection();
        }
        return SVNReader.getLong(values, 0);
    }

    public SVNProperties getRevisionProperties(long revision, SVNProperties properties) throws SVNException {
        SVNRepositoryImpl.assertValidRevision(revision);
        if (properties == null) {
            properties = new SVNProperties();
        }
        Object[] buffer = new Object[]{"rev-proplist", SVNRepositoryImpl.getRevisionObject(revision)};
        try {
            this.openConnection();
            this.write("(w(n))", buffer);
            this.authenticate();
            List items = this.read("l", null, false);
            properties = SVNReader.getProperties(items, 0, properties);
        }
        catch (SVNException e) {
            this.closeSession();
            throw e;
        }
        finally {
            this.closeConnection();
        }
        return properties;
    }

    public SVNPropertyValue getRevisionPropertyValue(long revision, String propertyName) throws SVNException {
        SVNRepositoryImpl.assertValidRevision(revision);
        Object[] buffer = new Object[]{"rev-prop", SVNRepositoryImpl.getRevisionObject(revision), propertyName};
        List values = null;
        try {
            this.openConnection();
            this.write("(w(ns))", buffer);
            this.authenticate();
            values = this.read("(?b)", null, false);
        }
        catch (SVNException e) {
            this.closeSession();
            throw e;
        }
        finally {
            this.closeConnection();
        }
        byte[] bytes = SVNReader.getBytes(values, 0);
        return bytes == null ? null : SVNPropertyValue.create(propertyName, bytes);
    }

    public SVNNodeKind checkPath(String path, long revision) throws SVNException {
        try {
            this.openConnection();
            path = this.getRepositoryPath(path);
            Object[] buffer = new Object[]{"check-path", path, SVNRepositoryImpl.getRevisionObject(revision)};
            this.write("(w(s(n)))", buffer);
            this.authenticate();
            List values = this.read("w", null, false);
            SVNNodeKind sVNNodeKind = SVNNodeKind.parseKind(SVNReader.getString(values, 0));
            return sVNNodeKind;
        }
        catch (SVNException e) {
            this.closeSession();
            throw e;
        }
        finally {
            this.closeConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getLocationsImpl(String path, long pegRevision, long[] revisions, ISVNLocationEntryHandler handler) throws SVNException {
        SVNRepositoryImpl.assertValidRevision(pegRevision);
        for (int i = 0; i < revisions.length; ++i) {
            SVNRepositoryImpl.assertValidRevision(revisions[i]);
        }
        int count = 0;
        try {
            SVNItem item;
            this.openConnection();
            path = this.getRepositoryPath(path);
            Object[] buffer = new Object[]{"get-locations", path, SVNRepositoryImpl.getRevisionObject(pegRevision), revisions};
            this.write("(w(sn(*n)))", buffer);
            this.authenticate();
            while ((item = this.readItem(false)).getKind() != 0 || !"done".equals(item.getWord())) {
                if (item.getKind() != 2) {
                    SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_SVN_MALFORMED_DATA, "Location entry not a list");
                    SVNErrorManager.error(err, SVNLogType.NETWORK);
                    continue;
                }
                List values = SVNReader.parseTuple("rs", item.getItems(), null);
                ++count;
                if (handler == null) continue;
                long revision = SVNReader.getLong(values, 0);
                String locationPath = SVNReader.getString(values, 1);
                if (locationPath == null) continue;
                locationPath = SVNRepositoryImpl.ensureAbsolutePath(locationPath);
                handler.handleLocationEntry(new SVNLocationEntry(revision, locationPath));
            }
            this.read("", null, false);
        }
        catch (SVNException e) {
            this.closeSession();
            this.handleUnsupportedCommand(e, "'get-locations' not implemented");
        }
        finally {
            this.closeConnection();
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long getLocationSegmentsImpl(String path, long pegRevision, long startRevision, long endRevision, ISVNLocationSegmentHandler handler) throws SVNException {
        long count = 0L;
        try {
            this.openConnection();
            path = this.getRepositoryPath(path);
            Object[] buffer = new Object[]{"get-location-segments", path, SVNRepositoryImpl.getRevisionObject(pegRevision), SVNRepositoryImpl.getRevisionObject(startRevision), SVNRepositoryImpl.getRevisionObject(endRevision)};
            this.write("(w(s(n)(n)(n)))", buffer);
            this.authenticate();
            boolean isDone = false;
            while (!isDone) {
                SVNItem item = this.readItem(false);
                if (item.getKind() == 0 && "done".equals(item.getWord())) {
                    isDone = true;
                    continue;
                }
                if (item.getKind() != 2) {
                    SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_SVN_MALFORMED_DATA, "Location segment entry not a list");
                    SVNErrorManager.error(err, SVNLogType.NETWORK);
                    continue;
                }
                List segmentAttrs = SVNReader.parseTuple("rr(?s)", item.getItems(), null);
                long rangeStartRevision = SVNReader.getLong(segmentAttrs, 0);
                long rangeEndRevision = SVNReader.getLong(segmentAttrs, 1);
                String rangePath = SVNReader.getString(segmentAttrs, 2);
                if (SVNRepository.isInvalidRevision(rangeStartRevision) || SVNRepository.isInvalidRevision(rangeEndRevision)) {
                    SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_SVN_MALFORMED_DATA, "Expected valid revision range");
                    SVNErrorManager.error(err, SVNLogType.NETWORK);
                }
                if (rangePath != null) {
                    rangePath = SVNRepositoryImpl.ensureAbsolutePath(rangePath);
                }
                if (handler != null) {
                    handler.handleLocationSegment(new SVNLocationSegment(rangeStartRevision, rangeEndRevision, rangePath));
                }
                count += rangeEndRevision - rangeStartRevision + 1L;
            }
            this.read("", null, false);
        }
        catch (SVNException e) {
            this.closeSession();
            this.handleUnsupportedCommand(e, "'get-location-segments' not implemented");
        }
        finally {
            this.closeConnection();
        }
        return count;
    }

    public long getFile(String path, long revision, SVNProperties properties, OutputStream contents) throws SVNException {
        Long rev = revision > 0L ? new Long(revision) : null;
        try {
            this.openConnection();
            Object[] buffer = new Object[]{"get-file", this.getRepositoryPath(path), rev, properties != null, contents != null};
            this.write("(w(s(n)ww))", buffer);
            this.authenticate();
            List values = this.read("(?s)rl", null, false);
            MessageDigest digest = null;
            try {
                digest = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException e) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "MD5 implementation not found: {0}", e.getMessage());
                SVNErrorManager.error(err, e, SVNLogType.NETWORK);
            }
            String expectedChecksum = SVNReader.getString(values, 0);
            if (properties != null) {
                properties = SVNReader.getProperties(values, 2, properties);
                properties.put("svn:entry:revision", SVNReader.getString(values, 1));
                properties.put("svn:entry:checksum", expectedChecksum);
            }
            if (contents != null) {
                String resultChecksum;
                SVNErrorMessage err;
                while (true) {
                    SVNItem item;
                    if ((item = this.readItem(false)).getKind() != 1) {
                        err = SVNErrorMessage.create(SVNErrorCode.RA_SVN_MALFORMED_DATA, "Non-string as part of file contents");
                        SVNErrorManager.error(err, SVNLogType.NETWORK);
                    }
                    if (item.getBytes().length == 0) break;
                    if (expectedChecksum != null) {
                        digest.update(item.getBytes());
                    }
                    try {
                        contents.write(item.getBytes());
                    }
                    catch (IOException e) {
                        SVNErrorMessage err2 = SVNErrorMessage.create(SVNErrorCode.RA_SVN_IO_ERROR, e.getMessage());
                        SVNErrorManager.error(err2, SVNLogType.NETWORK);
                    }
                }
                this.read("", null, false);
                if (expectedChecksum != null && !expectedChecksum.equals(resultChecksum = SVNFileUtil.toHexDigest(digest))) {
                    err = SVNErrorMessage.create(SVNErrorCode.CHECKSUM_MISMATCH, "Checksum mismatch for ''{0}''\nexpected checksum: ''{1}''\nactual checksum: ''{2}''", new Object[]{path, expectedChecksum, resultChecksum});
                    SVNErrorManager.error(err, SVNLogType.NETWORK);
                }
            }
            long l = SVNReader.getLong(values, 1);
            return l;
        }
        catch (SVNException e) {
            this.closeSession();
            throw e;
        }
        finally {
            this.closeConnection();
        }
    }

    public long getDir(String path, long revision, SVNProperties properties, ISVNDirEntryHandler handler) throws SVNException {
        return this.getDir(path, revision, properties, -1, handler);
    }

    public long getDir(String path, long revision, SVNProperties properties, int entryFields, ISVNDirEntryHandler handler) throws SVNException {
        Long rev = SVNRepositoryImpl.getRevisionObject(revision);
        try {
            this.openConnection();
            String fullPath = this.getFullPath(path);
            SVNURL url = this.getLocation().setPath(fullPath, false);
            path = this.getRepositoryPath(path);
            LinkedList<String> individualProps = new LinkedList<String>();
            if ((entryFields & 1) != 0) {
                individualProps.add(DIRENT_KIND);
            }
            if ((entryFields & 2) != 0) {
                individualProps.add(DIRENT_SIZE);
            }
            if ((entryFields & 4) != 0) {
                individualProps.add(DIRENT_HAS_PROPS);
            }
            if ((entryFields & 8) != 0) {
                individualProps.add(DIRENT_CREATED_REV);
            }
            if ((entryFields & 0x10) != 0) {
                individualProps.add(DIRENT_TIME);
            }
            if ((entryFields & 0x20) != 0) {
                individualProps.add(DIRENT_LAST_AUTHOR);
            }
            Object[] buffer = new Object[]{"get-dir", path, rev, properties != null, handler != null, individualProps.size() > 0 ? individualProps.toArray(new String[individualProps.size()]) : null};
            this.write("(w(s(n)ww(*w)))", buffer);
            this.authenticate();
            List values = this.read("rll", null, false);
            long l = revision = values.get(0) != null ? SVNReader.getLong(values, 0) : revision;
            if (properties != null) {
                SVNReader.getProperties(values, 1, properties);
            }
            if (handler != null) {
                SVNURL repositoryRoot = this.getRepositoryRoot(false);
                List dirents = (List)values.get(2);
                for (SVNItem item : dirents) {
                    if (item.getKind() != 2) {
                        SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_SVN_MALFORMED_DATA, "Dirlist element not a list");
                        SVNErrorManager.error(err, SVNLogType.NETWORK);
                    }
                    List direntProps = SVNReader.parseTuple("swnsr(?s)(?s)", item.getItems(), null);
                    String name = SVNReader.getString(direntProps, 0);
                    SVNNodeKind kind = SVNNodeKind.parseKind(SVNReader.getString(direntProps, 1));
                    long size = SVNReader.getLong(direntProps, 2);
                    boolean hasProps = SVNReader.getBoolean(direntProps, 3);
                    long createdRevision = SVNReader.getLong(direntProps, 4);
                    SVNDate createdDate = SVNDate.parseDate(SVNReader.getString(direntProps, 5));
                    String lastAuthor = SVNReader.getString(direntProps, 6);
                    handler.handleDirEntry(new SVNDirEntry(url.appendPath(name, false), repositoryRoot, name, kind, size, hasProps, createdRevision, createdDate, lastAuthor));
                }
            }
        }
        catch (SVNException e) {
            this.closeSession();
            throw e;
        }
        finally {
            this.closeConnection();
        }
        return revision;
    }

    public SVNDirEntry getDir(String path, long revision, boolean includeComment, final Collection entries) throws SVNException {
        Long rev = SVNRepositoryImpl.getRevisionObject(revision);
        SVNDirEntry parentEntry = null;
        try {
            this.openConnection();
            final SVNURL url = this.getLocation().setPath(this.getFullPath(path), false);
            final SVNURL repositoryRoot = this.getRepositoryRoot(false);
            ISVNDirEntryHandler handler = new ISVNDirEntryHandler(){

                public void handleDirEntry(SVNDirEntry dirEntry) throws SVNException {
                    if (entries != null) {
                        dirEntry = new SVNDirEntry(url.appendPath(dirEntry.getName(), false), repositoryRoot, dirEntry.getName(), dirEntry.getKind(), dirEntry.getSize(), dirEntry.hasProperties(), dirEntry.getRevision(), dirEntry.getDate(), dirEntry.getAuthor());
                        entries.add(dirEntry);
                    }
                }
            };
            path = this.getRepositoryPath(path);
            Object[] buffer = new Object[]{"stat", path, SVNRepositoryImpl.getRevisionObject(revision)};
            this.write("(w(s(n)))", buffer);
            this.authenticate();
            List values = this.read("(?l)", null, false);
            values = (List)values.get(0);
            if (values != null) {
                List direntProps = SVNReader.parseTuple("wnsr(?s)(?s)", values, null);
                SVNNodeKind kind = SVNNodeKind.parseKind(SVNReader.getString(direntProps, 0));
                long size = SVNReader.getLong(direntProps, 1);
                boolean hasProps = SVNReader.getBoolean(direntProps, 2);
                long createdRevision = SVNReader.getLong(direntProps, 3);
                SVNDate createdDate = SVNDate.parseDate(SVNReader.getString(direntProps, 4));
                String lastAuthor = SVNReader.getString(direntProps, 5);
                parentEntry = new SVNDirEntry(url, repositoryRoot, "", kind, size, hasProps, createdRevision, createdDate, lastAuthor);
            }
            buffer = new Object[]{"get-dir", path, rev, Boolean.FALSE, Boolean.TRUE};
            this.write("(w(s(n)ww))", buffer);
            this.authenticate();
            values = this.read("rll", null, false);
            long l = revision = values.get(0) != null ? SVNReader.getLong(values, 0) : revision;
            if (handler != null) {
                List dirents = (List)values.get(2);
                for (SVNItem item : dirents) {
                    if (item.getKind() != 2) {
                        SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_SVN_MALFORMED_DATA, "Dirlist element not a list");
                        SVNErrorManager.error(err, SVNLogType.NETWORK);
                    }
                    List direntProps = SVNReader.parseTuple("swnsr(?s)(?s)", item.getItems(), null);
                    String name = SVNReader.getString(direntProps, 0);
                    SVNNodeKind kind = SVNNodeKind.parseKind(SVNReader.getString(direntProps, 1));
                    long size = SVNReader.getLong(direntProps, 2);
                    boolean hasProps = SVNReader.getBoolean(direntProps, 3);
                    long createdRevision = SVNReader.getLong(direntProps, 4);
                    SVNDate createdDate = SVNDate.parseDate(SVNReader.getString(direntProps, 5));
                    String lastAuthor = SVNReader.getString(direntProps, 6);
                    handler.handleDirEntry(new SVNDirEntry(url.appendPath(name, false), repositoryRoot, name, kind, size, hasProps, createdRevision, createdDate, lastAuthor));
                }
            }
            if (includeComment && entries != null) {
                SVNHashMap messages = new SVNHashMap();
                for (SVNDirEntry entry : entries) {
                    Long key = SVNRepositoryImpl.getRevisionObject(entry.getRevision());
                    if (messages.containsKey(key)) {
                        entry.setCommitMessage((String)messages.get(key));
                        continue;
                    }
                    buffer = new Object[]{"rev-prop", key, "svn:log"};
                    this.write("(w(ns))", buffer);
                    this.authenticate();
                    values = this.read("(?s)", null, false);
                    String msg = SVNReader.getString(values, 0);
                    messages.put(key, msg);
                    entry.setCommitMessage(msg);
                }
            }
        }
        catch (SVNException e) {
            this.closeSession();
            throw e;
        }
        finally {
            this.closeConnection();
        }
        return parentEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getFileRevisionsImpl(String path, long startRevision, long endRevision, boolean includeMergedRevisions, ISVNFileRevisionHandler handler) throws SVNException {
        Long srev = SVNRepositoryImpl.getRevisionObject(startRevision);
        Long erev = SVNRepositoryImpl.getRevisionObject(endRevision);
        SVNDeltaReader deltaReader = new SVNDeltaReader();
        try {
            SVNItem item;
            this.openConnection();
            Object[] buffer = new Object[]{"get-file-revs", this.getRepositoryPath(path), srev, erev, Boolean.toString(includeMergedRevisions)};
            this.write("(w(s(n)(n)w))", buffer);
            this.authenticate();
            boolean hasRevision = false;
            int count = 0;
            while ((item = this.readItem(false)).getKind() != 0 || !"done".equals(item.getWord())) {
                boolean hasDelta;
                SVNItem chunkItem;
                hasRevision = true;
                if (item.getKind() != 2) {
                    SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_SVN_MALFORMED_DATA, "Revision entry not a list");
                    SVNErrorManager.error(err, SVNLogType.NETWORK);
                }
                List items = SVNReader.parseTuple("srll?s", item.getItems(), null);
                String name = null;
                SVNFileRevision fileRevision = null;
                if (handler != null) {
                    name = SVNReader.getString(items, 0);
                    long revision = SVNReader.getLong(items, 1);
                    SVNProperties properties = SVNReader.getProperties(items, 2, null);
                    SVNProperties propertiesDelta = SVNReader.getPropertyDiffs(items, 3, null);
                    boolean isMergedRevision = SVNReader.getBoolean(items, 4);
                    if (name != null) {
                        fileRevision = new SVNFileRevision(name, revision, properties, propertiesDelta, isMergedRevision);
                    }
                }
                if ((chunkItem = this.readItem(false)).getKind() != 1) {
                    SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_SVN_MALFORMED_DATA, "Text delta chunk not a string");
                    SVNErrorManager.error(err, SVNLogType.NETWORK);
                }
                boolean bl = hasDelta = chunkItem.getBytes().length > 0;
                if (handler != null && fileRevision != null) {
                    handler.openRevision(fileRevision);
                }
                if (hasDelta) {
                    byte[] line;
                    if (handler != null) {
                        handler.applyTextDelta(name == null ? path : name, null);
                    }
                    while ((line = chunkItem.getBytes()) != null && line.length != 0) {
                        deltaReader.nextWindow(line, 0, line.length, name == null ? path : name, handler);
                        chunkItem = this.readItem(false);
                        if (chunkItem.getKind() == 1) continue;
                        SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_SVN_MALFORMED_DATA, "Text delta chunk not a string");
                        SVNErrorManager.error(err, SVNLogType.NETWORK);
                    }
                    deltaReader.reset(name == null ? path : name, handler);
                    if (handler != null) {
                        handler.textDeltaEnd(name == null ? path : name);
                    }
                }
                if (handler == null) continue;
                handler.closeRevision(name == null ? path : name);
                ++count;
            }
            this.read("", null, false);
            if (!hasRevision) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_SVN_MALFORMED_DATA, "The get-file-revs command didn't return any revisions");
                SVNErrorManager.error(err, SVNLogType.NETWORK);
            }
            int n = count;
            return n;
        }
        catch (SVNException e) {
            this.closeSession();
            this.handleUnsupportedCommand(e, "'get-file-revs' not implemented");
        }
        finally {
            this.closeConnection();
        }
        return -1;
    }

    protected long logImpl(String[] targetPaths, long startRevision, long endRevision, boolean changedPaths, boolean strictNode, long limit, boolean includeMergedRevisions, String[] revisionPropertyNames, ISVNLogEntryHandler handler) throws SVNException {
        long count = 0L;
        int nestLevel = 0;
        long latestRev = -1L;
        if (SVNRepositoryImpl.isInvalidRevision(startRevision)) {
            startRevision = latestRev = this.getLatestRevision();
        }
        if (SVNRepositoryImpl.isInvalidRevision(endRevision)) {
            endRevision = latestRev != -1L ? latestRev : this.getLatestRevision();
        }
        try {
            SVNItem item;
            Object[] buffer;
            this.openConnection();
            String[] repositoryPaths = this.getRepositoryPaths(targetPaths);
            if (repositoryPaths == null || repositoryPaths.length == 0) {
                repositoryPaths = new String[]{""};
            }
            if (repositoryPaths.length == 1 && "/".equals(repositoryPaths[0])) {
                repositoryPaths[0] = "";
            }
            boolean wantCustomRevProps = false;
            if (revisionPropertyNames != null && revisionPropertyNames.length > 0) {
                Object[] realBuffer = new Object[]{"log", repositoryPaths, SVNRepositoryImpl.getRevisionObject(startRevision), SVNRepositoryImpl.getRevisionObject(endRevision), changedPaths, strictNode, new Long(limit > 0L ? limit : 0L), includeMergedRevisions, "revprops", revisionPropertyNames};
                for (int i = 0; i < revisionPropertyNames.length; ++i) {
                    String propName = revisionPropertyNames[i];
                    if ("svn:author".equals(propName) || "svn:date".equals(propName) || "svn:log".equals(propName)) continue;
                    wantCustomRevProps = true;
                    break;
                }
                buffer = realBuffer;
                this.write("(w((*s)(n)(n)wwnww(*s)))", buffer);
            } else {
                buffer = new Object[]{"log", repositoryPaths, SVNRepositoryImpl.getRevisionObject(startRevision), SVNRepositoryImpl.getRevisionObject(endRevision), changedPaths, strictNode, new Long(limit > 0L ? limit : 0L), includeMergedRevisions, "all-revprops"};
                this.write("(w((*s)(n)(n)wwnww()))", buffer);
            }
            this.authenticate();
            while ((item = this.readItem(false)).getKind() != 0 || !"done".equals(item.getWord())) {
                if (item.getKind() != 2) {
                    SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_SVN_MALFORMED_DATA, "Log entry not a list");
                    SVNErrorManager.error(err, SVNLogType.NETWORK);
                }
                List items = SVNReader.parseTuple("lr(?s)(?s)(?s)?ssnl", item.getItems(), null);
                List changedPathsList = (List)items.get(0);
                SVNHashMap changedPathsMap = new SVNHashMap();
                if (changedPathsList != null && changedPathsList.size() > 0) {
                    for (SVNItem pathItem : changedPathsList) {
                        if (pathItem.getKind() != 2) {
                            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_SVN_MALFORMED_DATA, "Changed-path entry not a list");
                            SVNErrorManager.error(err, SVNLogType.NETWORK);
                        }
                        List pathItems = SVNReader.parseTuple("sw(?sr)?(?s)", pathItem.getItems(), null);
                        String path = SVNReader.getString(pathItems, 0);
                        String action = SVNReader.getString(pathItems, 1);
                        String copyPath = SVNReader.getString(pathItems, 2);
                        long copyRevision = SVNReader.getLong(pathItems, 3);
                        String kind = SVNReader.getString(pathItems, 4);
                        changedPathsMap.put(path, new SVNLogEntryPath(path, action.charAt(0), copyPath, copyRevision, kind != null ? SVNNodeKind.parseKind(kind) : SVNNodeKind.UNKNOWN));
                    }
                }
                if (nestLevel == 0) {
                    ++count;
                }
                long revision = 0L;
                SVNProperties revisionProperties = null;
                SVNProperties logEntryProperties = new SVNProperties();
                boolean hasChildren = false;
                if (handler != null && (limit <= 0L || count <= limit || nestLevel != 0)) {
                    revision = SVNReader.getLong(items, 1);
                    String author = SVNReader.getString(items, 2);
                    Date date = SVNReader.getDate(items, 3);
                    if (date == SVNDate.NULL) {
                        date = null;
                    }
                    String message = SVNReader.getString(items, 4);
                    hasChildren = SVNReader.getBoolean(items, 5);
                    boolean invalidRevision = SVNReader.getBoolean(items, 6);
                    revisionProperties = SVNReader.getProperties(items, 8, null);
                    if (invalidRevision) {
                        revision = -1L;
                    }
                    if (wantCustomRevProps && revisionProperties == null) {
                        SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_NOT_IMPLEMENTED, "Server does not support custom revprops via log");
                        SVNErrorManager.error(err, SVNLogType.NETWORK);
                    }
                    if (revisionProperties != null) {
                        for (String name : revisionProperties.nameSet()) {
                            logEntryProperties.put(name, revisionProperties.getSVNPropertyValue(name));
                        }
                    }
                    if (revisionPropertyNames == null || revisionPropertyNames.length == 0) {
                        if (author != null) {
                            logEntryProperties.put("svn:author", author);
                        }
                        if (date != null) {
                            logEntryProperties.put("svn:date", SVNDate.formatDate(date));
                        }
                        if (message != null) {
                            logEntryProperties.put("svn:log", message);
                        }
                    } else {
                        for (int i = 0; i < revisionPropertyNames.length; ++i) {
                            String revPropName = revisionPropertyNames[i];
                            if (author != null && "svn:author".equals(revPropName)) {
                                logEntryProperties.put("svn:author", author);
                            }
                            if (date != null && "svn:date".equals(revPropName)) {
                                logEntryProperties.put("svn:date", SVNDate.formatDate(date));
                            }
                            if (message == null || !"svn:log".equals(revPropName)) continue;
                            logEntryProperties.put("svn:log", message);
                        }
                    }
                }
                if (handler == null || limit > 0L && count > limit && nestLevel == 0) continue;
                SVNLogEntry logEntry = new SVNLogEntry(changedPathsMap, revision, logEntryProperties, hasChildren);
                handler.handleLogEntry(logEntry);
                if (logEntry.hasChildren()) {
                    ++nestLevel;
                }
                if (logEntry.getRevision() >= 0L || --nestLevel >= 0) continue;
                nestLevel = 0;
            }
            this.read("", null, false);
            long l = count;
            return l;
        }
        catch (SVNException e) {
            this.closeSession();
            throw e;
        }
        finally {
            this.closeConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replay(long lowRevision, long highRevision, boolean sendDeltas, ISVNEditor editor) throws SVNException {
        Object[] buffer = new Object[]{"replay", SVNRepositoryImpl.getRevisionObject(highRevision), SVNRepositoryImpl.getRevisionObject(lowRevision), sendDeltas};
        try {
            this.openConnection();
            this.write("(w(nnw))", buffer);
            this.authenticate();
            SVNEditModeReader editReader = new SVNEditModeReader(this.myConnection, editor, true);
            editReader.driveEditor();
            this.read("", null, false);
        }
        catch (SVNException e) {
            this.closeSession();
            this.handleUnsupportedCommand(e, "Server doesn't support the replay command");
        }
        finally {
            this.closeConnection();
        }
    }

    public void setRevisionPropertyValue(long revision, String propertyName, SVNPropertyValue propertyValue) throws SVNException {
        SVNRepositoryImpl.assertValidRevision(revision);
        byte[] bytes = SVNPropertyValue.getPropertyAsBytes(propertyValue);
        Object[] buffer = new Object[]{"change-rev-prop", SVNRepositoryImpl.getRevisionObject(revision), propertyName, bytes};
        try {
            this.openConnection();
            this.write("(w(nsb))", buffer);
            this.authenticate();
            this.read("", null, false);
        }
        catch (SVNException e) {
            this.closeSession();
            throw e;
        }
        finally {
            this.closeConnection();
        }
    }

    public ISVNEditor getCommitEditor(String logMessage, Map locks, boolean keepLocks, ISVNWorkspaceMediator mediator) throws SVNException {
        try {
            this.openConnection();
            if (locks != null) {
                this.write("(w(s(*l)w))", new Object[]{"commit", logMessage, locks, keepLocks});
            } else {
                this.write("(w(s))", new Object[]{"commit", logMessage});
            }
            this.authenticate();
            this.read("", null, false);
            return new SVNCommitEditor(this, this.myConnection, new SVNCommitEditor.ISVNCommitCallback(){

                public void run(SVNException error) {
                    if (error != null) {
                        SVNRepositoryImpl.this.closeSession();
                    }
                    SVNRepositoryImpl.this.closeConnection();
                }
            });
        }
        catch (SVNException e) {
            this.closeSession();
            this.closeConnection();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SVNLock getLock(String path) throws SVNException {
        try {
            this.openConnection();
            path = this.getRepositoryPath(path);
            Object[] buffer = new Object[]{"get-lock", path};
            this.write("(w(s))", buffer);
            this.authenticate();
            List items = this.read("(?l)", null, false);
            items = (List)items.get(0);
            SVNLock sVNLock = SVNReader.getLock(items);
            return sVNLock;
        }
        catch (SVNException e) {
            this.closeSession();
            this.handleUnsupportedCommand(e, "Server doesn't support the get-lock command");
        }
        finally {
            this.closeConnection();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SVNLock[] getLocks(String path) throws SVNException {
        try {
            this.openConnection();
            path = this.getRepositoryPath(path);
            Object[] buffer = new Object[]{"get-locks", path};
            this.write("(w(s))", buffer);
            this.authenticate();
            List items = this.read("l", null, false);
            items = (List)items.get(0);
            ArrayList<SVNLock> locks = new ArrayList<SVNLock>();
            for (SVNItem item : items) {
                SVNLock lock;
                if (item.getKind() != 2) {
                    SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_SVN_MALFORMED_DATA, "Lock element not a list");
                    SVNErrorManager.error(err, SVNLogType.NETWORK);
                }
                if ((lock = SVNReader.getLock(item.getItems())) == null) continue;
                locks.add(lock);
            }
            SVNLock[] sVNLockArray = locks.toArray(new SVNLock[locks.size()]);
            return sVNLockArray;
        }
        catch (SVNException e) {
            this.closeSession();
            this.handleUnsupportedCommand(e, "Server doesn't support the get-lock command");
        }
        finally {
            this.closeConnection();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lock(Map pathsToRevisions, String comment, boolean force, ISVNLockHandler handler) throws SVNException {
        block20: {
            SVNItem item;
            boolean done;
            try {
                this.openConnection();
                Object[] buffer = new Object[]{"lock-many", comment, force};
                this.write("(w((s)w(", buffer);
                buffer = new Object[2];
                Iterator paths = pathsToRevisions.keySet().iterator();
                while (paths.hasNext()) {
                    buffer[0] = paths.next();
                    buffer[1] = pathsToRevisions.get(buffer[0]);
                    this.write("(s(n))", buffer);
                }
                this.write(")))", buffer);
                try {
                    this.authenticate();
                }
                catch (SVNException e) {
                    if (e.getErrorMessage() != null && e.getErrorMessage().getErrorCode() == SVNErrorCode.RA_SVN_UNKNOWN_CMD) {
                        this.closeSession();
                        this.closeConnection();
                        this.openConnection();
                        this.lock12(pathsToRevisions, comment, force, handler);
                        this.closeConnection();
                        return;
                    }
                    this.closeSession();
                    throw e;
                }
                done = false;
            }
            catch (SVNException e) {
                this.closeSession();
                this.handleUnsupportedCommand(e, "Server doesn't support the lock command");
                break block20;
            }
            finally {
                this.closeConnection();
            }
            for (String path : pathsToRevisions.keySet()) {
                SVNLock lock = null;
                SVNErrorMessage error = null;
                SVNItem item2 = this.readItem(false);
                if (item2.getKind() == 0 && "done".equals(item2.getWord())) {
                    done = true;
                    break;
                }
                if (item2.getKind() != 2) {
                    SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_SVN_MALFORMED_DATA, "Lock response not a list");
                    SVNErrorManager.error(err, SVNLogType.NETWORK);
                }
                try {
                    List values = SVNReader.parseTuple("wl", item2.getItems(), null);
                    String status = SVNReader.getString(values, 0);
                    List items = (List)values.get(1);
                    if ("success".equals(status)) {
                        lock = SVNReader.getLock(items);
                        if (lock == null) continue;
                        path = lock.getPath();
                    } else if ("failure".equals(status)) {
                        SVNReader.handleFailureStatus(items);
                    } else {
                        SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_SVN_MALFORMED_DATA);
                        SVNErrorManager.error(err, SVNLogType.NETWORK);
                    }
                }
                catch (SVNException e) {
                    path = this.getRepositoryPath(path);
                    error = e.getErrorMessage();
                }
                if (handler == null) continue;
                handler.handleLock(path, lock, error);
            }
            if (!(done || (item = this.readItem(false)).getKind() == 0 && "done".equals(item.getWord()))) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_SVN_MALFORMED_DATA, "Didn't receive end marker for lock responses");
                SVNErrorManager.error(err, SVNLogType.NETWORK);
            }
            this.read("", null, false);
        }
    }

    private void lock12(Map pathsToRevisions, String comment, boolean force, ISVNLockHandler handler) throws SVNException {
        for (String path : pathsToRevisions.keySet()) {
            List items;
            SVNErrorMessage error;
            block4: {
                Long revision = (Long)pathsToRevisions.get(path);
                path = this.getRepositoryPath(path);
                Object[] buffer = new Object[]{"lock", path, comment, force, revision};
                this.write("(w(s(s)w(n)))", buffer);
                this.authenticate();
                error = null;
                items = null;
                try {
                    items = this.read("l", null, false);
                    items = (List)items.get(0);
                }
                catch (SVNException e) {
                    SVNErrorCode code;
                    if (e.getErrorMessage() != null && ((code = e.getErrorMessage().getErrorCode()) == SVNErrorCode.FS_PATH_ALREADY_LOCKED || code == SVNErrorCode.FS_OUT_OF_DATE)) {
                        error = e.getErrorMessage();
                    }
                    if (error != null) break block4;
                    throw e;
                }
            }
            if (handler == null) continue;
            SVNLock lock = items == null ? null : SVNReader.getLock(items);
            handler.handleLock(path, lock, error);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlock(Map pathToTokens, boolean force, ISVNLockHandler handler) throws SVNException {
        block20: {
            SVNItem item;
            boolean done;
            try {
                this.openConnection();
                Object[] buffer = new Object[]{"unlock-many", force};
                this.write("(w(w(", buffer);
                buffer = new Object[2];
                Iterator paths = pathToTokens.keySet().iterator();
                while (paths.hasNext()) {
                    buffer[0] = paths.next();
                    buffer[1] = pathToTokens.get(buffer[0]);
                    this.write("(s(s))", buffer);
                }
                this.write(")))", buffer);
                try {
                    this.authenticate();
                }
                catch (SVNException e) {
                    if (e.getErrorMessage() != null && e.getErrorMessage().getErrorCode() == SVNErrorCode.RA_SVN_UNKNOWN_CMD) {
                        this.closeSession();
                        this.closeConnection();
                        this.openConnection();
                        this.unlock12(pathToTokens, force, handler);
                        this.closeConnection();
                        return;
                    }
                    throw e;
                }
                done = false;
            }
            catch (SVNException e) {
                this.closeSession();
                this.handleUnsupportedCommand(e, "Server doesn't support the unlock command");
                break block20;
            }
            finally {
                this.closeConnection();
            }
            for (String path : pathToTokens.keySet()) {
                String id = (String)pathToTokens.get(path);
                SVNErrorMessage error = null;
                try {
                    SVNItem item2 = this.readItem(false);
                    if (item2.getKind() == 0 && "done".equals(item2.getWord())) {
                        done = true;
                        break;
                    }
                    if (item2.getKind() != 2) {
                        SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_SVN_MALFORMED_DATA, "Unlock response not a list");
                        SVNErrorManager.error(err, SVNLogType.NETWORK);
                    }
                    List values = SVNReader.parseTuple("wl", item2.getItems(), null);
                    String status = SVNReader.getString(values, 0);
                    List items = (List)values.get(1);
                    if ("success".equals(status)) {
                        values = SVNReader.parseTuple("s", items, null);
                        path = SVNReader.getString(values, 0);
                    } else if ("failure".equals(status)) {
                        SVNReader.handleFailureStatus(items);
                    } else {
                        SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_SVN_MALFORMED_DATA);
                        SVNErrorManager.error(err, SVNLogType.NETWORK);
                    }
                }
                catch (SVNException e) {
                    error = e.getErrorMessage();
                }
                path = this.getRepositoryPath(path);
                if (handler == null) continue;
                handler.handleUnlock(path, new SVNLock(path, id, null, null, null, null), error);
            }
            if (!(done || (item = this.readItem(false)).getKind() == 0 && "done".equals(item.getWord()))) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_SVN_MALFORMED_DATA, "Didn't receive end marker for unlock responses");
                SVNErrorManager.error(err, SVNLogType.NETWORK);
            }
            this.read("", null, false);
        }
    }

    private void unlock12(Map pathToTokens, boolean force, ISVNLockHandler handler) throws SVNException {
        for (String path : pathToTokens.keySet()) {
            SVNLock lock;
            Object[] buffer;
            String id = (String)pathToTokens.get(path);
            path = this.getRepositoryPath(path);
            if (id == null) {
                buffer = new Object[]{"get-lock", path};
                this.write("(w(s))", buffer);
                this.authenticate();
                List items = this.read("l", null, false);
                items = (List)items.get(0);
                lock = SVNReader.getLock(items);
                if (lock == null) {
                    lock = new SVNLock(path, "", null, null, null, null);
                    SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_NOT_LOCKED, "No lock on path ''{0}''", path);
                    if (handler == null) continue;
                    handler.handleUnlock(path, lock, err);
                    continue;
                }
                id = lock.getID();
            }
            buffer = new Object[]{"unlock", path, id, force};
            this.write("(w(s(s)w))", buffer);
            this.authenticate();
            SVNErrorMessage error = null;
            try {
                this.read("", null, false);
            }
            catch (SVNException e) {
                if (e.getErrorMessage() != null && e.getErrorMessage().getErrorCode() == SVNErrorCode.RA_NOT_LOCKED) {
                    error = e.getErrorMessage();
                    error = SVNErrorMessage.create(error.getErrorCode(), error.getMessageTemplate(), path);
                }
                throw e;
            }
            if (handler == null) continue;
            lock = new SVNLock(path, id, null, null, null, null);
            handler.handleUnlock(path, lock, error);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SVNDirEntry info(String path, long revision) throws SVNException {
        try {
            this.openConnection();
            String fullPath = this.getFullPath(path);
            SVNURL url = this.getLocation().setPath(fullPath, false);
            path = this.getRepositoryPath(path);
            Object[] buffer = new Object[]{"stat", path, SVNRepositoryImpl.getRevisionObject(revision)};
            this.write("(w(s(n)))", buffer);
            this.authenticate();
            SVNDirEntry entry = null;
            List items = this.read("(?l)", null, false);
            if (items == null || items.isEmpty()) {
                SVNDirEntry sVNDirEntry = null;
                return sVNDirEntry;
            }
            if ((items = (List)items.get(0)) != null && !items.isEmpty()) {
                SVNURL repositoryRoot = this.getRepositoryRoot(false);
                List values = SVNReader.parseTuple("wnsr(?s)(?s)", items, null);
                SVNNodeKind kind = SVNNodeKind.parseKind(SVNReader.getString(values, 0));
                long size = SVNReader.getLong(values, 1);
                boolean hasProperties = SVNReader.getBoolean(values, 2);
                long createdRevision = SVNReader.getLong(values, 3);
                SVNDate createdDate = SVNDate.parseDate(SVNReader.getString(values, 4));
                String lastAuthor = SVNReader.getString(values, 5);
                entry = new SVNDirEntry(url, repositoryRoot, SVNPathUtil.tail(path), kind, size, hasProperties, createdRevision, createdDate, lastAuthor);
            }
            SVNDirEntry sVNDirEntry = entry;
            return sVNDirEntry;
        }
        catch (SVNException e) {
            this.closeSession();
            this.handleUnsupportedCommand(e, "'stat' not implemented");
        }
        finally {
            this.closeConnection();
        }
        return null;
    }

    void updateCredentials(String uuid, SVNURL rootURL) throws SVNException {
        if (this.getRepositoryRoot(false) != null) {
            return;
        }
        this.setRepositoryCredentials(uuid, rootURL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void openConnection() throws SVNException {
        this.lock();
        this.fireConnectionOpened();
        if (this.myConnection != null && this.myConnection.isConnectionStale()) {
            this.closeSession();
        }
        if (this.myConnection != null) {
            if (this.reparent(this.getLocation())) {
                return;
            }
            this.closeSession();
        }
        ISVNConnector connector = SVNRepositoryFactoryImpl.getConnectorFactory().createConnector(this);
        this.myConnection = new SVNConnection(connector, this);
        try {
            this.myConnection.open(this);
            this.authenticate();
        }
        finally {
            if (this.myConnection != null) {
                this.myRealm = this.myConnection.getRealm();
            }
        }
    }

    protected void closeConnection() {
        if (!this.getOptions().keepConnection(this)) {
            this.closeSession();
        }
        this.unlock();
        this.fireConnectionClosed();
    }

    public String getRealm() {
        return this.myRealm;
    }

    void authenticate() throws SVNException {
        if (this.myConnection != null) {
            this.myConnection.authenticate(this);
        }
    }

    private void write(String template, Object[] values) throws SVNException {
        if (this.myConnection == null) {
            SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.RA_SVN_CONNECTION_CLOSED), SVNLogType.NETWORK);
        }
        this.myConnection.write(template, values);
    }

    private List read(String template, List values, boolean readMalformedData) throws SVNException {
        if (this.myConnection == null) {
            SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.RA_SVN_CONNECTION_CLOSED), SVNLogType.NETWORK);
        }
        return this.myConnection.read(template, values, readMalformedData);
    }

    private SVNItem readItem(boolean readMalformedData) throws SVNException {
        if (this.myConnection == null) {
            SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.RA_SVN_CONNECTION_CLOSED), SVNLogType.NETWORK);
        }
        return this.myConnection.readItem(readMalformedData);
    }

    private List readTuple(String template, boolean readMalformedData) throws SVNException {
        if (this.myConnection == null) {
            SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.RA_SVN_CONNECTION_CLOSED), SVNLogType.NETWORK);
        }
        return this.myConnection.readTuple(template, readMalformedData);
    }

    public void setPath(String path, String lockToken, long revision, boolean startEmpty) throws SVNException {
        this.setPath(path, lockToken, revision, SVNDepth.INFINITY, startEmpty);
    }

    public void deletePath(String path) throws SVNException {
        this.write("(w(s))", new Object[]{"delete-path", path});
    }

    public void linkPath(SVNURL url, String path, String lockToken, long revision, boolean startEmpty) throws SVNException {
        this.linkPath(url, path, lockToken, revision, SVNDepth.INFINITY, startEmpty);
    }

    public void finishReport() throws SVNException {
        this.write("(w())", new Object[]{"finish-report"});
    }

    public void abortReport() throws SVNException {
        this.write("(w())", new Object[]{"abort-report"});
    }

    private String[] getRepositoryPaths(String[] paths) throws SVNException {
        if (paths == null || paths.length == 0) {
            return paths;
        }
        String[] fullPaths = new String[paths.length];
        for (int i = 0; i < paths.length; ++i) {
            fullPaths[i] = this.getRepositoryPath(paths[i]);
        }
        return fullPaths;
    }

    public void setExternalUserName(String userName) {
        this.myExternalUserName = userName;
    }

    public String getExternalUserName() {
        return this.myExternalUserName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void closeSession() {
        this.lock(true);
        try {
            if (this.myConnection == null) return;
            try {
                this.myConnection.close();
                this.myConnection = null;
                return;
            }
            catch (SVNException sVNException) {
                return;
            }
            finally {
                this.myConnection = null;
            }
        }
        finally {
            this.unlock();
        }
    }

    private void handleUnsupportedCommand(SVNException e, String message) throws SVNException {
        if (e.getErrorMessage() != null && e.getErrorMessage().getErrorCode() == SVNErrorCode.RA_SVN_UNKNOWN_CMD) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_NOT_IMPLEMENTED, message);
            SVNErrorManager.error(err, e.getErrorMessage(), SVNLogType.NETWORK);
        }
        throw e;
    }

    public void linkPath(SVNURL url, String path, String lockToken, long revision, SVNDepth depth, boolean startEmpty) throws SVNException {
        SVNRepositoryImpl.assertValidRevision(revision);
        this.write("(w(ssnw(s)w))", new Object[]{"link-path", path, url.toString(), SVNRepositoryImpl.getRevisionObject(revision), startEmpty, lockToken, SVNDepth.asString(depth)});
    }

    public void setPath(String path, String lockToken, long revision, SVNDepth depth, boolean startEmpty) throws SVNException {
        SVNRepositoryImpl.assertValidRevision(revision);
        this.write("(w(snw(s)w))", new Object[]{"set-path", path, SVNRepositoryImpl.getRevisionObject(revision), startEmpty, lockToken, SVNDepth.asString(depth)});
    }

    public void diff(SVNURL url, long targetRevision, long revision, String target, boolean ignoreAncestry, SVNDepth depth, boolean getContents, ISVNReporterBaton reporter, ISVNEditor editor) throws SVNException {
        boolean recursive = SVNRepositoryImpl.getRecurseFromDepth(depth);
        boolean hasTarget = target != null;
        String string = target = target == null ? "" : target;
        if (url == null) {
            SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.BAD_URL, "URL can not be NULL"), SVNLogType.NETWORK);
        }
        editor = this.getDepthFilterEditor(editor, depth, hasTarget);
        Object[] buffer = new Object[]{"diff", SVNRepositoryImpl.getRevisionObject(targetRevision), target, recursive, ignoreAncestry, url.toString(), getContents, SVNDepth.asString(depth)};
        try {
            this.openConnection();
            this.write("(w((n)swwsww))", buffer);
            this.authenticate();
            reporter.report(this);
            this.authenticate();
            SVNEditModeReader editReader = new SVNEditModeReader(this.myConnection, editor, false);
            editReader.driveEditor();
            this.read("", null, false);
        }
        catch (SVNException e) {
            this.closeSession();
            throw e;
        }
        finally {
            this.closeConnection();
        }
    }

    public void status(long revision, String target, SVNDepth depth, ISVNReporterBaton reporter, ISVNEditor editor) throws SVNException {
        boolean recursive = SVNRepositoryImpl.getRecurseFromDepth(depth);
        boolean hasTarget = target != null;
        target = target == null ? "" : target;
        editor = this.getDepthFilterEditor(editor, depth, hasTarget);
        Object[] buffer = new Object[]{"status", target, recursive, SVNRepositoryImpl.getRevisionObject(revision), SVNDepth.asString(depth)};
        try {
            this.openConnection();
            this.write("(w(sw(n)w))", buffer);
            this.authenticate();
            reporter.report(this);
            this.authenticate();
            SVNEditModeReader editReader = new SVNEditModeReader(this.myConnection, editor, false);
            editReader.driveEditor();
            this.read("", null, false);
        }
        catch (SVNException e) {
            this.closeSession();
            throw e;
        }
        finally {
            this.closeConnection();
        }
    }

    public void update(SVNURL url, long revision, String target, SVNDepth depth, ISVNReporterBaton reporter, ISVNEditor editor) throws SVNException {
        boolean recursive = SVNRepositoryImpl.getRecurseFromDepth(depth);
        boolean hasTarget = target != null;
        String string = target = target == null ? "" : target;
        if (url == null) {
            SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.BAD_URL, "URL can not be NULL"), SVNLogType.NETWORK);
        }
        editor = this.getDepthFilterEditor(editor, depth, hasTarget);
        Object[] buffer = new Object[]{"switch", SVNRepositoryImpl.getRevisionObject(revision), target, recursive, url.toString(), SVNDepth.asString(depth)};
        try {
            this.openConnection();
            this.write("(w((n)swsw))", buffer);
            this.authenticate();
            reporter.report(this);
            this.authenticate();
            SVNEditModeReader editReader = new SVNEditModeReader(this.myConnection, editor, false);
            editReader.driveEditor();
            this.read("", null, false);
        }
        catch (SVNException e) {
            this.closeSession();
            throw e;
        }
        finally {
            this.closeConnection();
        }
    }

    public void update(long revision, String target, SVNDepth depth, boolean sendCopyFromArgs, ISVNReporterBaton reporter, ISVNEditor editor) throws SVNException {
        boolean hasTarget = target != null;
        target = target == null ? "" : target;
        boolean recursive = SVNRepositoryImpl.getRecurseFromDepth(depth);
        editor = this.getDepthFilterEditor(editor, depth, hasTarget);
        Object[] buffer = new Object[]{"update", SVNRepositoryImpl.getRevisionObject(revision), target, recursive, SVNDepth.asString(depth), sendCopyFromArgs};
        try {
            this.openConnection();
            this.write("(w((n)swww))", buffer);
            this.authenticate();
            reporter.report(this);
            this.authenticate();
            SVNEditModeReader editReader = new SVNEditModeReader(this.myConnection, editor, false);
            editReader.driveEditor();
            this.read("", null, false);
        }
        catch (SVNException e) {
            this.closeSession();
            throw e;
        }
        finally {
            this.closeConnection();
        }
    }

    protected Map getMergeInfoImpl(String[] paths, long revision, SVNMergeInfoInheritance inherit, boolean includeDescendants) throws SVNException {
        try {
            this.openConnection();
            String[] repositoryPaths = this.getRepositoryPaths(paths);
            if (repositoryPaths == null || repositoryPaths.length == 0) {
                repositoryPaths = new String[]{""};
            }
            Object[] buffer = new Object[]{"get-mergeinfo", repositoryPaths, SVNRepositoryImpl.getRevisionObject(revision), inherit.toString(), includeDescendants};
            this.write("(w((*s)(n)ww))", buffer);
            this.authenticate();
            List items = this.read("l", null, false);
            items = (List)items.get(0);
            SVNHashMap pathsToMergeInfos = new SVNHashMap();
            for (SVNItem item : items) {
                List values;
                String path;
                if (item.getKind() != 2) {
                    SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_SVN_MALFORMED_DATA, "Merge info element is not a list");
                    SVNErrorManager.error(err, SVNLogType.NETWORK);
                }
                path = (path = SVNReader.getString(values = SVNReader.parseTuple("ss", item.getItems(), null), 0)).startsWith("/") ? path.substring(1) : path;
                path = this.getRepositoryPath(path);
                String mergeInfoToParse = SVNReader.getString(values, 1);
                Map srcsToRangeLists = SVNMergeInfoUtil.parseMergeInfo(new StringBuffer(mergeInfoToParse), null);
                SVNMergeInfo mergeInfo = new SVNMergeInfo(path, srcsToRangeLists);
                pathsToMergeInfos.put(path, mergeInfo);
            }
            SVNHashMap sVNHashMap = pathsToMergeInfos;
            return sVNHashMap;
        }
        catch (SVNException e) {
            this.closeSession();
            throw e;
        }
        finally {
            this.closeConnection();
        }
    }

    public boolean hasCapability(SVNCapability capability) throws SVNException {
        if (capability == null) {
            return false;
        }
        try {
            this.openConnection();
            boolean bl = this.myConnection.hasCapability(capability.toString());
            return bl;
        }
        catch (SVNException e) {
            this.closeSession();
            throw e;
        }
        finally {
            this.closeConnection();
        }
    }

    protected ISVNEditor getCommitEditorInternal(Map locks, boolean keepLocks, SVNProperties revProps, ISVNWorkspaceMediator mediator) throws SVNException {
        try {
            this.openConnection();
            String logMessage = revProps.getStringValue("svn:log");
            if (revProps.size() > 1 && !this.myConnection.isCommitRevprops()) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_NOT_IMPLEMENTED, "Server doesn't support setting arbitrary revision properties during commit");
                SVNErrorManager.error(err, SVNLogType.NETWORK);
            }
            this.write("(w(s(*l)w(*l)))", new Object[]{"commit", logMessage, locks, keepLocks, revProps});
            this.authenticate();
            this.read("", null, false);
            return new SVNCommitEditor(this, this.myConnection, new SVNCommitEditor.ISVNCommitCallback(){

                public void run(SVNException error) {
                    if (error != null) {
                        SVNRepositoryImpl.this.closeSession();
                    }
                    SVNRepositoryImpl.this.closeConnection();
                }
            });
        }
        catch (SVNException e) {
            this.closeConnection();
            this.closeSession();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void replayRangeImpl(long startRevision, long endRevision, long lowRevision, boolean sendDeltas, ISVNReplayHandler handler) throws SVNException {
        Object[] buffer = new Object[]{"replay-range", SVNRepositoryImpl.getRevisionObject(startRevision), SVNRepositoryImpl.getRevisionObject(endRevision), SVNRepositoryImpl.getRevisionObject(lowRevision), sendDeltas};
        try {
            this.openConnection();
            this.write("(w(nnnw))", buffer);
            this.authenticate();
            for (long rev = startRevision; rev <= endRevision; ++rev) {
                List items = this.readTuple("wl", false);
                String word = SVNReader.getString(items, 0);
                if (!"revprops".equals(word)) {
                    SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_SVN_MALFORMED_DATA, "Expected ''revprops'', found ''{0}''", word);
                    SVNErrorManager.error(err, SVNLogType.NETWORK);
                }
                SVNProperties revProps = SVNReader.getProperties(items, 1, null);
                ISVNEditor editor = handler.handleStartRevision(rev, revProps);
                SVNEditModeReader editReader = new SVNEditModeReader(this.myConnection, editor, true);
                editReader.driveEditor();
                handler.handleEndRevision(rev, revProps, editor);
            }
            this.read("", null, false);
        }
        catch (SVNException svne) {
            this.closeSession();
            this.handleUnsupportedCommand(svne, "Server doesn't support the replay-range command");
        }
        finally {
            this.closeConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long getDeletedRevisionImpl(String path, long pegRevision, long endRevision) throws SVNException {
        try {
            this.openConnection();
            Long srev = SVNRepositoryImpl.getRevisionObject(pegRevision);
            Long erev = SVNRepositoryImpl.getRevisionObject(endRevision);
            Object[] buffer = new Object[]{"get-deleted-rev", path, srev, erev};
            this.write("(w(snn))", buffer);
            this.authenticate();
            List values = this.read("r", null, false);
            long l = SVNReader.getLong(values, 0);
            return l;
        }
        catch (SVNException e) {
            this.closeSession();
            this.handleUnsupportedCommand(e, "'get-deleted-rev' not implemented");
        }
        finally {
            this.closeConnection();
        }
        return -1L;
    }

    private static boolean getRecurseFromDepth(SVNDepth depth) {
        return depth == null || depth == SVNDepth.UNKNOWN || depth.compareTo(SVNDepth.FILES) > 0;
    }

    private static String ensureAbsolutePath(String path) {
        if (path != null) {
            path = SVNPathUtil.canonicalizePath(path);
        }
        if (path != null && (path.length() == 0 || path.charAt(0) != '/')) {
            return "/" + path;
        }
        return path;
    }

    private ISVNEditor getDepthFilterEditor(ISVNEditor editor, SVNDepth depth, boolean hasTarget) {
        if (depth != SVNDepth.FILES && depth != SVNDepth.INFINITY) {
            return SVNDepthFilterEditor.getDepthFilterEditor(depth, editor, hasTarget);
        }
        return editor;
    }
}

