/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.svn.svnjava.command.update;

import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmTag;
import org.apache.maven.scm.ScmVersion;
import org.apache.maven.scm.command.changelog.ChangeLogCommand;
import org.apache.maven.scm.command.update.AbstractUpdateCommand;
import org.apache.maven.scm.command.update.UpdateScmResult;
import org.apache.maven.scm.command.update.UpdateScmResultWithRevision;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.svn.SvnTagBranchUtils;
import org.apache.maven.scm.provider.svn.command.SvnCommand;
import org.apache.maven.scm.provider.svn.repository.SvnScmProviderRepository;
import org.apache.maven.scm.provider.svn.svnjava.command.changelog.SvnJavaChangeLogCommand;
import org.apache.maven.scm.provider.svn.svnjava.repository.SvnJavaScmProviderRepository;
import org.apache.maven.scm.provider.svn.svnjava.util.ScmFileEventHandler;
import org.apache.maven.scm.provider.svn.svnjava.util.SvnJavaUtil;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNUpdateClient;

public class SvnJavaUpdateCommand
extends AbstractUpdateCommand
implements SvnCommand {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected UpdateScmResult executeUpdateCommand(ScmProviderRepository repo, ScmFileSet fileSet, ScmVersion tag) throws ScmException {
        SvnScmProviderRepository repository = (SvnScmProviderRepository)repo;
        if (this.getLogger().isInfoEnabled()) {
            this.getLogger().info("SVN update directory: " + fileSet.getBasedir().getAbsolutePath());
        }
        SvnJavaScmProviderRepository javaRepo = (SvnJavaScmProviderRepository)repo;
        try {
            ScmFileEventHandler handler = new ScmFileEventHandler(this.getLogger(), fileSet.getBasedir());
            SVNUpdateClient updateClient = javaRepo.getClientManager().getUpdateClient();
            updateClient.setEventHandler((ISVNEventHandler)handler);
            long revision = 0L;
            if (tag == null || SvnTagBranchUtils.isRevisionSpecifier((ScmVersion)tag)) {
                SVNRevision rev = tag == null ? SVNRevision.parse((String)"") : SVNRevision.parse((String)tag.getName());
                revision = SvnJavaUtil.update(updateClient, fileSet.getBasedir(), rev, true);
            } else {
                revision = SvnJavaUtil.switchToURL(javaRepo.getClientManager(), fileSet.getBasedir(), SVNURL.parseURIEncoded((String)SvnTagBranchUtils.resolveTagUrl((SvnScmProviderRepository)repository, (ScmTag)new ScmTag(tag.getName()))), SVNRevision.HEAD, true);
            }
            UpdateScmResultWithRevision updateScmResultWithRevision = new UpdateScmResultWithRevision("JavaSVN Library", handler.getFiles(), Long.toString(revision));
            return updateScmResultWithRevision;
        }
        catch (SVNException e) {
            UpdateScmResultWithRevision updateScmResultWithRevision = new UpdateScmResultWithRevision("JavaSVN Library", "SVN update failed.", e.getMessage(), Long.toString(-1L), false);
            return updateScmResultWithRevision;
        }
        finally {
            javaRepo.getClientManager().getUpdateClient().setEventHandler(null);
        }
    }

    protected ChangeLogCommand getChangeLogCommand() {
        SvnJavaChangeLogCommand command = new SvnJavaChangeLogCommand();
        command.setLogger(this.getLogger());
        return command;
    }
}

