/*
 * Decompiled with CFR 0.152.
 */
package beast.core.parameter;

import beast.core.Description;
import beast.core.Input;
import beast.core.StateNode;
import beast.core.parameter.Parameter;
import beast.core.util.Log;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.w3c.dom.Node;

@Description(value="State node representing a list of parameter objects, used for model selection problems. The parameters involved are not instances of Parameter.Base, but are instead instances of a local class QuietParameter which is not itself a StateNode.  All constituent parameters must have identical dimensions and bounds.")
public abstract class GeneralParameterList<T>
extends StateNode {
    public final Input<List<Parameter.Base<T>>> initialParamsInput = new Input("initialParam", "Parameter whose value will initially be in parameter list.", new ArrayList());
    public final Input<Integer> dimensionInput = new Input<Integer>("dimension", "Dimension of individual parameters in list.  Default 1.", 1);
    public final Input<Integer> minorDimensionInput = new Input<Integer>("minordimension", "Minor dimension of individual parameters in list. Default 1.", 1);
    protected List<QuietParameter> pList;
    protected List<QuietParameter> pListStored;
    protected TreeSet<Integer> deallocatedKeys;
    protected TreeSet<Integer> deallocatedKeysStored;
    protected int nextUnallocatedKey;
    protected int nextUnallocatedKeyStored;
    protected int dimension;
    protected int minorDimension;
    protected T lowerBound;
    protected T upperBound;

    @Override
    public void initAndValidate() {
        this.pList = new ArrayList<QuietParameter>();
        this.pListStored = new ArrayList<QuietParameter>();
        this.deallocatedKeys = new TreeSet();
        this.deallocatedKeysStored = new TreeSet();
        this.nextUnallocatedKey = 0;
        this.nextUnallocatedKeyStored = 0;
        this.dimension = this.dimensionInput.get();
        this.minorDimension = this.minorDimensionInput.get();
        for (Parameter parameter : this.initialParamsInput.get()) {
            if (parameter.getDimension() != this.dimension) {
                throw new IllegalArgumentException("Parameter dimension does not equal dimension specified in enclosing ParameterList.");
            }
            QuietParameter quietParameter = new QuietParameter(parameter);
            this.allocateKey(quietParameter);
            this.pList.add(quietParameter);
        }
        this.store();
        this.setSomethingIsDirty(false);
    }

    public int size() {
        return this.pList.size();
    }

    public QuietParameter get(int n) {
        return this.pList.get(n);
    }

    public void set(int n, QuietParameter quietParameter) {
        this.startEditing(null);
        this.pList.set(n, quietParameter);
    }

    public void add(QuietParameter quietParameter) {
        this.startEditing(null);
        this.pList.add(quietParameter);
    }

    public void add(int n, QuietParameter quietParameter) {
        this.startEditing(null);
        this.pList.add(n, quietParameter);
    }

    public void remove(QuietParameter quietParameter) {
        this.startEditing(null);
        this.deallocatedKeys.add(quietParameter.key);
        this.pList.remove(quietParameter);
    }

    public void remove(int n) {
        this.startEditing(null);
        this.deallocatedKeys.add(this.pList.get((int)n).key);
        this.pList.remove(n);
    }

    public QuietParameter createNewParam() {
        QuietParameter quietParameter = new QuietParameter();
        this.allocateKey(quietParameter);
        return quietParameter;
    }

    public QuietParameter createNewParam(Parameter<?> parameter) {
        QuietParameter quietParameter = new QuietParameter(parameter);
        this.allocateKey(quietParameter);
        return quietParameter;
    }

    public QuietParameter addNewParam() {
        this.startEditing(null);
        QuietParameter quietParameter = new QuietParameter();
        this.allocateKey(quietParameter);
        this.pList.add(quietParameter);
        return quietParameter;
    }

    public QuietParameter addNewParam(Parameter<?> parameter) {
        this.startEditing(null);
        QuietParameter quietParameter = new QuietParameter(parameter);
        this.allocateKey(quietParameter);
        this.pList.add(quietParameter);
        return quietParameter;
    }

    private void allocateKey(QuietParameter quietParameter) {
        if (this.deallocatedKeys.size() > 0) {
            quietParameter.key = this.deallocatedKeys.first();
            this.deallocatedKeys.remove(quietParameter.key);
        } else {
            quietParameter.key = this.nextUnallocatedKey++;
        }
    }

    @Override
    public StateNode copy() {
        try {
            GeneralParameterList generalParameterList = (GeneralParameterList)this.clone();
            generalParameterList.initAndValidate();
            generalParameterList.pList.clear();
            for (QuietParameter quietParameter : this.pList) {
                QuietParameter quietParameter2 = quietParameter.copy();
                generalParameterList.pList.add(quietParameter2);
            }
            generalParameterList.dimension = this.dimension;
            generalParameterList.minorDimension = this.minorDimension;
            generalParameterList.lowerBound = this.lowerBound;
            generalParameterList.upperBound = this.upperBound;
            generalParameterList.deallocatedKeys.addAll(this.deallocatedKeys);
            generalParameterList.nextUnallocatedKey = this.nextUnallocatedKey;
            return generalParameterList;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            Log.err(cloneNotSupportedException.getMessage());
            return null;
        }
    }

    @Override
    public void assignTo(StateNode stateNode) {
        if (!(stateNode instanceof GeneralParameterList)) {
            throw new RuntimeException("Incompatible statenodes in assignTo call.");
        }
        GeneralParameterList generalParameterList = (GeneralParameterList)stateNode;
        generalParameterList.pList.clear();
        for (QuietParameter quietParameter : this.pList) {
            generalParameterList.pList.add(quietParameter.copy());
        }
        generalParameterList.dimension = this.dimension;
        generalParameterList.minorDimension = this.minorDimension;
        generalParameterList.lowerBound = this.lowerBound;
        generalParameterList.upperBound = this.upperBound;
        generalParameterList.deallocatedKeys = new TreeSet<Integer>((SortedSet<Integer>)this.deallocatedKeys);
        generalParameterList.nextUnallocatedKey = this.nextUnallocatedKey;
    }

    @Override
    public void assignFrom(StateNode stateNode) {
        if (!(stateNode instanceof GeneralParameterList)) {
            throw new RuntimeException("Incompatible statenodes in assignFrom call.");
        }
        GeneralParameterList generalParameterList = (GeneralParameterList)stateNode;
        this.pList.clear();
        for (QuietParameter quietParameter : generalParameterList.pList) {
            this.pList.add(quietParameter);
        }
        this.dimension = generalParameterList.dimension;
        this.minorDimension = generalParameterList.minorDimension;
        this.lowerBound = generalParameterList.lowerBound;
        this.upperBound = generalParameterList.upperBound;
        this.deallocatedKeys = new TreeSet<Integer>((SortedSet<Integer>)generalParameterList.deallocatedKeys);
        this.nextUnallocatedKey = generalParameterList.nextUnallocatedKey;
    }

    @Override
    public void assignFromFragile(StateNode stateNode) {
        this.assignFrom(stateNode);
    }

    @Override
    public String toString() {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(String.format("Dimension: [%d, %d], Bounds: [%s,%s], ", this.dimension, this.minorDimension, String.valueOf(this.lowerBound), String.valueOf(this.upperBound)));
        stringBuilder.append("AvailableKeys: [");
        boolean bl = true;
        for (int n2 : this.deallocatedKeys) {
            if (!bl) {
                stringBuilder.append(",");
            } else {
                bl = false;
            }
            stringBuilder.append(n2);
        }
        stringBuilder.append("], ");
        stringBuilder.append("NextKey: ").append(this.nextUnallocatedKey).append(", ");
        stringBuilder.append("Parameters: [");
        for (n = 0; n < this.pList.size(); ++n) {
            if (n > 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append(this.pList.get(n));
        }
        stringBuilder.append("], ");
        stringBuilder.append("ParameterKeys: [");
        for (n = 0; n < this.pList.size(); ++n) {
            if (n > 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append(this.pList.get((int)n).key);
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    @Override
    public void fromXML(Node node) {
        String string = node.getTextContent();
        Pattern pattern = Pattern.compile("^ *Dimension: *\\[([^]]*)] *, *Bounds: *\\[([^]]*)] *, *AvailableKeys: *\\[([^]]*)] *, *NextKey: *([^, ]*) *, *Parameters: *\\[(.*)] *, *ParameterKeys: *\\[(.*)] *$");
        Matcher matcher = pattern.matcher(string);
        if (!matcher.find()) {
            throw new RuntimeException("Error parsing ParameterList state string.");
        }
        String[] stringArray = matcher.group(1).split(",");
        this.dimension = Integer.parseInt(stringArray[0].trim());
        this.minorDimension = Integer.parseInt(stringArray[1].trim());
        this.deallocatedKeys.clear();
        for (String object2 : matcher.group(3).trim().split(",")) {
            if (object2.trim().length() <= 0) continue;
            this.deallocatedKeys.add(Integer.parseInt(object2));
        }
        this.nextUnallocatedKey = Integer.parseInt(matcher.group(4));
        String[] stringArray2 = matcher.group(2).split(",");
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        String string2 = matcher.group(5).trim();
        pattern = Pattern.compile("\\[([^]]*)]");
        Matcher matcher2 = pattern.matcher(string2);
        while (matcher2.find()) {
            arrayList.add(matcher2.group(1).split(","));
        }
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        for (String string3 : matcher.group(6).split(",")) {
            arrayList2.add(Integer.parseInt(string3.trim()));
        }
        this.readStateFromString(stringArray2, arrayList, arrayList2);
    }

    protected abstract void readStateFromString(String[] var1, List<String[]> var2, List<Integer> var3);

    @Override
    public int scale(double d) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    protected void store() {
        this.pListStored.clear();
        for (QuietParameter quietParameter : this.pList) {
            this.pListStored.add(quietParameter.copy());
        }
        this.deallocatedKeysStored.clear();
        this.deallocatedKeysStored.addAll(this.deallocatedKeys);
        this.nextUnallocatedKeyStored = this.nextUnallocatedKey;
    }

    @Override
    public void restore() {
        this.pList.clear();
        for (QuietParameter quietParameter : this.pListStored) {
            this.pList.add(quietParameter.copy());
        }
        this.deallocatedKeys.clear();
        this.deallocatedKeys.addAll(this.deallocatedKeysStored);
        this.nextUnallocatedKey = this.nextUnallocatedKeyStored;
        this.hasStartedEditing = false;
    }

    @Override
    public void setEverythingDirty(boolean bl) {
        this.setSomethingIsDirty(bl);
    }

    @Override
    public void init(PrintStream printStream) {
        printStream.print(this.getID() + ".size\t");
    }

    @Override
    public void log(int n, PrintStream printStream) {
        printStream.print(this.pList.size() + "\t");
    }

    @Override
    public void close(PrintStream printStream) {
    }

    @Override
    public int getDimension() {
        return 1;
    }

    @Override
    public double getArrayValue() {
        return this.pList.size();
    }

    @Override
    public double getArrayValue(int n) {
        if (n == 0) {
            return this.pList.size();
        }
        return Double.NaN;
    }

    public class QuietParameter
    implements Parameter<T> {
        Object[] values;
        int key = -1;

        QuietParameter() {
            this.values = new Object[GeneralParameterList.this.dimension];
        }

        QuietParameter(Parameter<?> parameter) {
            if (parameter.getDimension() != GeneralParameterList.this.dimension) {
                throw new IllegalArgumentException("Cannot construct ParameterList parameter with a dimension not equal to that specified in the enclosing list.");
            }
            this.values = new Object[GeneralParameterList.this.dimension];
            for (int i = 0; i < parameter.getValues().length; ++i) {
                this.values[i] = parameter.getValue(i);
            }
        }

        public int getKey() {
            return this.key;
        }

        @Override
        public T getValue(int n) {
            return this.values[n];
        }

        @Override
        public T getValue() {
            return this.values[0];
        }

        @Override
        public void setValue(int n, T t) {
            GeneralParameterList.this.startEditing(null);
            this.values[n] = t;
        }

        @Override
        public void setValue(T t) {
            GeneralParameterList.this.startEditing(null);
            this.values[0] = t;
        }

        @Override
        public T getLower() {
            return GeneralParameterList.this.lowerBound;
        }

        @Override
        public void setLower(T t) {
            GeneralParameterList.this.lowerBound = t;
        }

        @Override
        public T getUpper() {
            return GeneralParameterList.this.upperBound;
        }

        @Override
        public void setUpper(T t) {
            GeneralParameterList.this.upperBound = t;
        }

        @Override
        public T[] getValues() {
            return this.values;
        }

        @Override
        public String getID() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public int getMinorDimension1() {
            return GeneralParameterList.this.minorDimension;
        }

        @Override
        public int getMinorDimension2() {
            return GeneralParameterList.this.dimension / GeneralParameterList.this.minorDimension;
        }

        @Override
        public T getMatrixValue(int n, int n2) {
            return this.values[n * GeneralParameterList.this.minorDimension + n2];
        }

        @Override
        public void swap(int n, int n2) {
            GeneralParameterList.this.startEditing(null);
            Object object = this.values[n];
            this.values[n] = this.values[n2];
            this.values[n2] = object;
        }

        @Override
        public int getDimension() {
            return this.values.length;
        }

        @Override
        public double getArrayValue() {
            return (Double)this.values[0];
        }

        @Override
        public double getArrayValue(int n) {
            return (Double)this.values[0];
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder("[");
            for (int i = 0; i < this.values.length; ++i) {
                if (i > 0) {
                    stringBuilder.append(",");
                }
                stringBuilder.append(this.values[i]);
            }
            stringBuilder.append("]");
            return stringBuilder.toString();
        }

        public QuietParameter copy() {
            QuietParameter quietParameter = new QuietParameter(this);
            quietParameter.key = this.key;
            return quietParameter;
        }
    }
}

