/*
 * Decompiled with CFR 0.152.
 */
package beast.core.parameter;

import beast.core.Description;
import beast.core.Input;
import beast.core.parameter.Parameter;
import java.io.PrintStream;

@Description(value="A real-valued parameter represents a value (or array of values if the dimension is larger than one) in the state space that can be changed by operators.")
public class RealParameter
extends Parameter.Base<Double> {
    public final Input<Double> lowerValueInput = new Input("lower", "lower value for this parameter (default -infinity)");
    public final Input<Double> upperValueInput = new Input("upper", "upper value for this parameter (default +infinity)");

    public RealParameter() {
    }

    public RealParameter(Double[] doubleArray) {
        super(doubleArray);
    }

    public RealParameter(String string) {
        this.init(0.0, 0.0, string, 1);
    }

    @Override
    public void initAndValidate() {
        this.m_fLower = this.lowerValueInput.get() != null ? this.lowerValueInput.get() : Double.valueOf(Double.NEGATIVE_INFINITY);
        this.m_fUpper = this.upperValueInput.get() != null ? this.upperValueInput.get() : Double.valueOf(Double.POSITIVE_INFINITY);
        super.initAndValidate();
    }

    @Override
    Double getMax() {
        return Double.POSITIVE_INFINITY;
    }

    @Override
    Double getMin() {
        return Double.NEGATIVE_INFINITY;
    }

    @Override
    public Double getValue() {
        return ((Double[])this.values)[0];
    }

    @Override
    public double getArrayValue() {
        return ((Double[])this.values)[0];
    }

    @Override
    public double getArrayValue(int n) {
        return ((Double[])this.values)[n];
    }

    @Override
    public void log(int n, PrintStream printStream) {
        RealParameter realParameter = (RealParameter)this.getCurrent();
        int n2 = realParameter.getDimension();
        for (int i = 0; i < n2; ++i) {
            printStream.print(realParameter.getValue(i) + "\t");
        }
    }

    @Override
    public int scale(double d) {
        int n = 0;
        for (int i = 0; i < ((Double[])this.values).length; ++i) {
            if (((Double[])this.values)[i] == 0.0) continue;
            Double[] doubleArray = (Double[])this.values;
            int n2 = i;
            Double.valueOf(doubleArray[n2] * d);
            ++n;
            if (!(((Double[])this.values)[i] < (Double)this.m_fLower) && !(((Double[])this.values)[i] > (Double)this.m_fUpper)) continue;
            throw new IllegalArgumentException("parameter scaled our of range");
        }
        return n;
    }

    @Override
    void fromXML(int n, String string, String string2, String[] stringArray) {
        this.setLower(Double.parseDouble(string));
        this.setUpper(Double.parseDouble(string2));
        this.values = new Double[n];
        for (int i = 0; i < stringArray.length; ++i) {
            ((Double[])this.values)[i] = Double.parseDouble(stringArray[i]);
        }
    }
}

