/*
 * Decompiled with CFR 0.152.
 */
package beast.core.util;

import beast.app.BeastMCMC;
import beast.core.BEASTInterface;
import beast.core.Description;
import beast.core.Distribution;
import beast.core.Input;
import beast.core.State;
import beast.core.util.Log;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;

@Description(value="Takes a collection of distributions, typically a number of likelihoods and priors and combines them into the compound of these distributions typically interpreted as the posterior.")
public class CompoundDistribution
extends Distribution {
    public final Input<List<Distribution>> pDistributions = new Input("distribution", "individual probability distributions, e.g. the likelihood and prior making up a posterior", new ArrayList());
    public final Input<Boolean> useThreadsInput = new Input<Boolean>("useThreads", "calculated the distributions in parallel using threads (default false)", false);
    public final Input<Integer> maxNrOfThreadsInput = new Input<Integer>("threads", "maximum number of threads to use, if less than 1 the number of threads in BeastMCMC is used (default -1)", -1);
    public final Input<Boolean> ignoreInput = new Input<Boolean>("ignore", "ignore all distributions and return 1 as distribution (default false)", false);
    boolean useThreads;
    int nrOfThreads;
    boolean ignore;
    public static ExecutorService exec;
    CountDownLatch countDown;

    @Override
    public void initAndValidate() {
        super.initAndValidate();
        this.useThreads = this.useThreadsInput.get() != false && BeastMCMC.m_nThreads > 1;
        int n = this.nrOfThreads = this.useThreads ? BeastMCMC.m_nThreads : 1;
        if (this.useThreads && this.maxNrOfThreadsInput.get() > 0) {
            this.nrOfThreads = Math.min(this.maxNrOfThreadsInput.get(), BeastMCMC.m_nThreads);
        }
        if (this.useThreads) {
            exec = Executors.newFixedThreadPool(this.nrOfThreads);
        }
        this.ignore = this.ignoreInput.get();
        if (this.pDistributions.get().size() == 0) {
            this.logP = 0.0;
        }
    }

    @Override
    public double calculateLogP() {
        this.logP = 0.0;
        if (this.ignore) {
            return this.logP;
        }
        int n = 0;
        if (this.useThreads) {
            for (Distribution distribution : this.pDistributions.get()) {
                if (!distribution.isDirtyCalculation()) continue;
                ++n;
            }
        }
        if (this.useThreads && n > 1) {
            this.logP = this.calculateLogPUsingThreads();
        } else {
            for (Distribution distribution : this.pDistributions.get()) {
                this.logP = distribution.isDirtyCalculation() ? (this.logP += distribution.calculateLogP()) : (this.logP += distribution.getCurrentLogP());
                if (!Double.isInfinite(this.logP) && !Double.isNaN(this.logP)) continue;
                return this.logP;
            }
        }
        return this.logP;
    }

    private double calculateLogPUsingThreads() {
        try {
            int n = 0;
            for (Distribution distribution : this.pDistributions.get()) {
                if (!distribution.isDirtyCalculation()) continue;
                ++n;
            }
            this.countDown = new CountDownLatch(n);
            for (Distribution distribution : this.pDistributions.get()) {
                if (!distribution.isDirtyCalculation()) continue;
                CoreRunnable coreRunnable = new CoreRunnable(distribution);
                exec.execute(coreRunnable);
            }
            this.countDown.await();
            this.logP = 0.0;
            for (Distribution distribution : this.pDistributions.get()) {
                this.logP += distribution.getCurrentLogP();
            }
            return this.logP;
        }
        catch (InterruptedException | RejectedExecutionException exception) {
            this.useThreads = false;
            Log.err.println("Stop using threads: " + exception.getMessage());
            return this.calculateLogP();
        }
    }

    @Override
    public void sample(State state, Random random) {
        for (Distribution distribution : this.pDistributions.get()) {
            distribution.sample(state, random);
        }
    }

    @Override
    public List<String> getArguments() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Distribution distribution : this.pDistributions.get()) {
            arrayList.addAll(distribution.getArguments());
        }
        return arrayList;
    }

    @Override
    public List<String> getConditions() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Distribution distribution : this.pDistributions.get()) {
            arrayList.addAll(distribution.getConditions());
        }
        return arrayList;
    }

    @Override
    public List<BEASTInterface> listActiveBEASTObjects() {
        if (this.ignoreInput.get().booleanValue()) {
            return new ArrayList<BEASTInterface>();
        }
        return super.listActiveBEASTObjects();
    }

    @Override
    public boolean isStochastic() {
        for (Distribution distribution : this.pDistributions.get()) {
            if (!distribution.isStochastic()) continue;
            return true;
        }
        return false;
    }

    @Override
    public double getNonStochasticLogP() {
        double d = 0.0;
        if (this.ignore) {
            return d;
        }
        for (Distribution distribution : this.pDistributions.get()) {
            if (!Double.isInfinite(d += distribution.getNonStochasticLogP()) && !Double.isNaN(d)) continue;
            return d;
        }
        return d;
    }

    static /* synthetic */ double access$000(CompoundDistribution compoundDistribution) {
        return compoundDistribution.logP;
    }

    static /* synthetic */ double access$300(CompoundDistribution compoundDistribution) {
        return compoundDistribution.logP;
    }

    class CoreRunnable
    implements Runnable {
        Distribution distr;

        CoreRunnable(Distribution distribution) {
            this.distr = distribution;
        }

        @Override
        public void run() {
            try {
                if (this.distr.isDirtyCalculation()) {
                    CompoundDistribution.this.logP = CompoundDistribution.this.logP + this.distr.calculateLogP();
                } else {
                    CompoundDistribution.this.logP = CompoundDistribution.this.logP + this.distr.getCurrentLogP();
                }
            }
            catch (Exception exception) {
                Log.err.println("Something went wrong in a calculation of " + this.distr.getID());
                exception.printStackTrace();
                System.exit(1);
            }
            CompoundDistribution.this.countDown.countDown();
        }
    }
}

