/*
 * Decompiled with CFR 0.152.
 */
package beast.evolution.alignment;

import beast.core.Description;
import beast.core.Input;
import beast.evolution.alignment.Alignment;
import beast.evolution.alignment.Taxon;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

@Description(value="A TaxonSet is an ordered set of taxa. The order on the taxa is provided at the time of construction either from a list of taxon objects or an alignment.")
public class TaxonSet
extends Taxon {
    public final Input<List<Taxon>> taxonsetInput = new Input("taxon", "list of taxa making up the set", new ArrayList());
    public final Input<Alignment> alignmentInput = new Input("alignment", "alignment where each sequence represents a taxon");
    protected List<String> taxaNames;
    protected List<Taxon> taxonList;

    public TaxonSet() {
    }

    public TaxonSet(List<Taxon> list) {
        this.taxonsetInput.setValue(list, this);
        this.initAndValidate();
    }

    public TaxonSet(Alignment alignment) {
        this.alignmentInput.setValue(alignment, this);
        this.initAndValidate();
    }

    public TaxonSet(String string, List<Taxon> list) {
        this.setID(string);
        this.taxonsetInput.setValue(list, this);
        this.initAndValidate();
    }

    @Override
    public void initAndValidate() {
        this.taxonList = this.taxonsetInput.get();
        if (this.alignmentInput.get() != null) {
            if (this.taxonList.size() > 0) {
                throw new IllegalArgumentException("Only one of taxon and alignment should be specified, not both (id=" + this.getID() + ").");
            }
            this.taxaNames = this.alignmentInput.get().taxaNames;
        } else {
            if (this.taxonList.size() == 0) {
                throw new IllegalArgumentException(this.getID() + ": Either taxon or alignment should be specified (id=" + this.getID() + ").");
            }
            this.taxaNames = new ArrayList<String>();
            for (Taxon taxon : this.taxonList) {
                this.taxaNames.add(taxon.getID());
            }
        }
    }

    public Set<Taxon> getTaxonSet() {
        HashSet<Taxon> hashSet = new HashSet<Taxon>(this.taxonList);
        return hashSet;
    }

    public List<String> asStringList() {
        if (this.taxaNames == null) {
            return null;
        }
        return Collections.unmodifiableList(this.taxaNames);
    }

    public Set<String> getTaxaNames() {
        return new TreeSet<String>(this.taxaNames);
    }

    public String getTaxonId(int n) {
        return this.taxaNames.get(n);
    }

    public int getTaxonIndex(String string) {
        for (int i = 0; i < this.taxaNames.size(); ++i) {
            if (!this.getTaxonId(i).contentEquals(string)) continue;
            return i;
        }
        return -1;
    }

    public boolean containsAny(Collection<String> collection) {
        List<String> list = this.asStringList();
        for (String string : collection) {
            if (!list.contains(string)) continue;
            return true;
        }
        return false;
    }

    public boolean containsAll(Collection<String> collection) {
        List<String> list = this.asStringList();
        for (String string : collection) {
            if (list.contains(string)) continue;
            return false;
        }
        return true;
    }

    public boolean containsAny(TaxonSet taxonSet) {
        return this.containsAny(taxonSet.asStringList());
    }

    public boolean containsAll(TaxonSet taxonSet) {
        return this.containsAll(taxonSet.asStringList());
    }

    public int getTaxonCount() {
        if (this.taxaNames == null) {
            return 0;
        }
        return this.taxaNames.size();
    }

    @Deprecated
    public int getNrTaxa() {
        return this.getTaxonCount();
    }

    @Override
    public String toString() {
        return this.toString("\t");
    }

    @Override
    protected String toString(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string).append(this.getID()).append("\n");
        string = string + "\t";
        for (Taxon taxon : this.taxonsetInput.get()) {
            stringBuilder.append(taxon.toString(string));
        }
        return stringBuilder.toString();
    }
}

