/*
 * Decompiled with CFR 0.152.
 */
package beast.evolution.substitutionmodel;

import beast.core.Description;
import beast.core.Function;
import beast.core.Input;
import beast.evolution.datatype.DataType;
import beast.evolution.substitutionmodel.DefaultEigenSystem;
import beast.evolution.substitutionmodel.EigenDecomposition;
import beast.evolution.substitutionmodel.EigenSystem;
import beast.evolution.substitutionmodel.SubstitutionModel;
import beast.evolution.tree.Node;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

@Description(value="Specifies transition probability matrix with no restrictions on the rates other than that one of the is equal to one and the others are specified relative to this unit rate. Works for any number of states.")
public class GeneralSubstitutionModel
extends SubstitutionModel.Base {
    public final Input<Function> ratesInput = new Input("rates", "Rate parameter which defines the transition rate matrix. Only the off-diagonal entries need to be specified (diagonal makes row sum to zero in a rate matrix). Entry i specifies the rate from floor(i/(n-1)) to i%(n-1)+delta where n is the number of states and delta=1 if floor(i/(n-1)) <= i%(n-1) and 0 otherwise.", Input.Validate.REQUIRED);
    public final Input<String> eigenSystemClass = new Input<String>("eigenSystem", "Name of the class used for creating an EigenSystem", DefaultEigenSystem.class.getName());
    protected double[][] rateMatrix;
    protected double[] relativeRates;
    protected double[] storedRelativeRates;
    protected EigenSystem eigenSystem;
    protected EigenDecomposition eigenDecomposition;
    private EigenDecomposition storedEigenDecomposition;
    protected boolean updateMatrix = true;
    private boolean storedUpdateMatrix = true;

    @Override
    public void initAndValidate() {
        super.initAndValidate();
        this.updateMatrix = true;
        this.nrOfStates = this.frequencies.getFreqs().length;
        if (this.ratesInput.get().getDimension() != this.nrOfStates * (this.nrOfStates - 1)) {
            throw new IllegalArgumentException("Dimension of input 'rates' is " + this.ratesInput.get().getDimension() + " but a " + "rate matrix of dimension " + this.nrOfStates + "x" + (this.nrOfStates - 1) + "=" + this.nrOfStates * (this.nrOfStates - 1) + " was " + "expected");
        }
        try {
            this.eigenSystem = this.createEigenSystem();
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | SecurityException | InvocationTargetException exception) {
            throw new IllegalArgumentException(exception.getMessage());
        }
        this.rateMatrix = new double[this.nrOfStates][this.nrOfStates];
        this.relativeRates = new double[this.ratesInput.get().getDimension()];
        this.storedRelativeRates = new double[this.ratesInput.get().getDimension()];
    }

    protected EigenSystem createEigenSystem() throws SecurityException, ClassNotFoundException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Constructor<?>[] constructorArray = Class.forName(this.eigenSystemClass.get()).getDeclaredConstructors();
        Constructor<?> constructor = null;
        for (int i = 0; i < constructorArray.length && (constructor = constructorArray[i]).getGenericParameterTypes().length != 1; ++i) {
        }
        constructor.setAccessible(true);
        return (EigenSystem)constructor.newInstance(this.nrOfStates);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getTransitionProbabilities(Node node, double d, double d2, double d3, double[] dArray) {
        int n;
        double d4;
        int n2;
        double d5 = (d - d2) * d3;
        Object object = this;
        synchronized (object) {
            if (this.updateMatrix) {
                this.setupRelativeRates();
                this.setupRateMatrix();
                this.eigenDecomposition = this.eigenSystem.decomposeMatrix(this.rateMatrix);
                this.updateMatrix = false;
            }
        }
        object = new double[this.nrOfStates * this.nrOfStates];
        double[] dArray2 = this.eigenDecomposition.getEigenVectors();
        double[] dArray3 = this.eigenDecomposition.getInverseEigenVectors();
        double[] dArray4 = this.eigenDecomposition.getEigenValues();
        for (n2 = 0; n2 < this.nrOfStates; ++n2) {
            d4 = Math.exp(d5 * dArray4[n2]);
            for (n = 0; n < this.nrOfStates; ++n) {
                object[n2 * this.nrOfStates + n] = dArray3[n2 * this.nrOfStates + n] * d4;
            }
        }
        int n3 = 0;
        for (n2 = 0; n2 < this.nrOfStates; ++n2) {
            for (n = 0; n < this.nrOfStates; ++n) {
                d4 = 0.0;
                for (int i = 0; i < this.nrOfStates; ++i) {
                    d4 += dArray2[n2 * this.nrOfStates + i] * object[i * this.nrOfStates + n];
                }
                dArray[n3] = Math.abs(d4);
                ++n3;
            }
        }
    }

    protected double[][] getRateMatrix() {
        return (double[][])this.rateMatrix.clone();
    }

    protected void setupRelativeRates() {
        Function function = this.ratesInput.get();
        for (int i = 0; i < function.getDimension(); ++i) {
            this.relativeRates[i] = function.getArrayValue(i);
        }
    }

    protected void setupRateMatrix() {
        int n;
        int n2;
        int n3;
        int n4;
        double[] dArray = this.frequencies.getFreqs();
        for (n4 = 0; n4 < this.nrOfStates; ++n4) {
            this.rateMatrix[n4][n4] = 0.0;
            for (n3 = 0; n3 < n4; ++n3) {
                this.rateMatrix[n4][n3] = this.relativeRates[n4 * (this.nrOfStates - 1) + n3];
            }
            for (n3 = n4 + 1; n3 < this.nrOfStates; ++n3) {
                this.rateMatrix[n4][n3] = this.relativeRates[n4 * (this.nrOfStates - 1) + n3 - 1];
            }
        }
        for (n4 = 0; n4 < this.nrOfStates; ++n4) {
            for (n3 = n4 + 1; n3 < this.nrOfStates; ++n3) {
                double[] dArray2 = this.rateMatrix[n4];
                int n5 = n3;
                dArray2[n5] = dArray2[n5] * dArray[n3];
                double[] dArray3 = this.rateMatrix[n3];
                int n6 = n4;
                dArray3[n6] = dArray3[n6] * dArray[n4];
            }
        }
        for (n4 = 0; n4 < this.nrOfStates; ++n4) {
            double d = 0.0;
            for (n2 = 0; n2 < this.nrOfStates; ++n2) {
                if (n4 == n2) continue;
                d += this.rateMatrix[n4][n2];
            }
            this.rateMatrix[n4][n4] = -d;
        }
        double d = 0.0;
        for (n = 0; n < this.nrOfStates; ++n) {
            d += -this.rateMatrix[n][n] * dArray[n];
        }
        for (n = 0; n < this.nrOfStates; ++n) {
            for (n2 = 0; n2 < this.nrOfStates; ++n2) {
                this.rateMatrix[n][n2] = this.rateMatrix[n][n2] / d;
            }
        }
    }

    @Override
    public void store() {
        this.storedUpdateMatrix = this.updateMatrix;
        if (this.eigenDecomposition != null) {
            this.storedEigenDecomposition = this.eigenDecomposition.copy();
        }
        super.store();
    }

    @Override
    public void restore() {
        this.updateMatrix = this.storedUpdateMatrix;
        if (this.storedEigenDecomposition != null) {
            EigenDecomposition eigenDecomposition = this.storedEigenDecomposition;
            this.storedEigenDecomposition = this.eigenDecomposition;
            this.eigenDecomposition = eigenDecomposition;
        }
        super.restore();
    }

    @Override
    protected boolean requiresRecalculation() {
        this.updateMatrix = true;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EigenDecomposition getEigenDecomposition(Node node) {
        GeneralSubstitutionModel generalSubstitutionModel = this;
        synchronized (generalSubstitutionModel) {
            if (this.updateMatrix) {
                this.setupRelativeRates();
                this.setupRateMatrix();
                this.eigenDecomposition = this.eigenSystem.decomposeMatrix(this.rateMatrix);
                this.updateMatrix = false;
            }
        }
        return this.eigenDecomposition;
    }

    @Override
    public boolean canHandleDataType(DataType dataType) {
        return dataType.getStateCount() != Integer.MAX_VALUE;
    }
}

