/*
 * Decompiled with CFR 0.152.
 */
package jam.disclosure;

import jam.disclosure.DisclosureButton;
import jam.disclosure.DisclosureListener;
import jam.util.IconUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class DisclosurePanel
extends JPanel {
    private final DisclosureButton button;
    private final Component titleComponent;
    private final JPanel panel;
    private final List<DisclosureListener> listeners = new ArrayList<DisclosureListener>();
    private static BufferedImage backgroundImage = null;

    static {
        try {
            backgroundImage = IconUtils.getBufferedImage(DisclosurePanel.class, "images/titleBackground.png");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public DisclosurePanel(String title, JPanel panel, boolean isOpen) {
        this(new JLabel(title), -1, panel, isOpen, 50);
    }

    public DisclosurePanel(JComponent titleComponent, JPanel panel, boolean isOpen, int openSpeed) {
        this(titleComponent, -1, panel, isOpen, openSpeed);
    }

    public DisclosurePanel(JComponent titleComponent, int preferredTitleHeight, JPanel contentPanel, boolean isOpen, int openSpeed) {
        this.setOpaque(false);
        this.panel = contentPanel;
        this.panel.setOpaque(false);
        this.button = new DisclosureButton(openSpeed);
        this.titleComponent = titleComponent;
        titleComponent.setOpaque(false);
        JPanel panel1 = new JPanel(new BorderLayout(6, 0)){

            @Override
            public void paint(Graphics graphics) {
                graphics.drawImage(backgroundImage, 0, 0, this.getWidth(), this.getHeight(), null);
                super.paint(graphics);
            }
        };
        panel1.setOpaque(false);
        panel1.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                DisclosurePanel.this.button.doClick();
            }
        });
        JPanel componentPanel = new JPanel(new BorderLayout(6, 0));
        componentPanel.setOpaque(false);
        componentPanel.add((Component)this.button, "West");
        componentPanel.add((Component)titleComponent, "Center");
        panel1.add((Component)componentPanel, "Center");
        if (preferredTitleHeight > 0) {
            panel1.setPreferredSize(new Dimension(0, preferredTitleHeight));
        }
        this.setLayout(new BorderLayout(0, 0));
        this.add((Component)panel1, "North");
        this.add((Component)this.panel, "Center");
        this.setOpen(isOpen);
        this.button.addDisclosureListener(new DisclosureListener(){

            @Override
            public void opening(Component component) {
                DisclosurePanel.this.fireOpening();
            }

            @Override
            public void opened(Component component) {
                DisclosurePanel.this.panel.setVisible(true);
                DisclosurePanel.this.fireOpened();
            }

            @Override
            public void closing(Component component) {
                DisclosurePanel.this.fireClosing();
            }

            @Override
            public void closed(Component component) {
                DisclosurePanel.this.panel.setVisible(false);
                DisclosurePanel.this.fireClosed();
            }
        });
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension size = super.getPreferredSize();
        return size;
    }

    public void setOpen(boolean isOpen) {
        this.button.setSelected(isOpen);
        this.panel.setVisible(isOpen);
    }

    public void addDisclosureListener(DisclosureListener listener) {
        this.listeners.add(listener);
    }

    public void removeDisclosureListener(DisclosureListener listener) {
        this.listeners.remove(listener);
    }

    private void fireOpening() {
        for (DisclosureListener listener : this.listeners) {
            listener.opening(this);
        }
    }

    private void fireOpened() {
        for (DisclosureListener listener : this.listeners) {
            listener.opened(this);
        }
    }

    private void fireClosing() {
        for (DisclosureListener listener : this.listeners) {
            listener.closing(this);
        }
    }

    private void fireClosed() {
        for (DisclosureListener listener : this.listeners) {
            listener.closed(this);
        }
    }

    public DisclosureButton getDisclosureButton() {
        return this.button;
    }

    public Component getTitleComponent() {
        return this.titleComponent;
    }

    public JPanel getContentsPanel() {
        return this.panel;
    }
}

