/*
 * Decompiled with CFR 0.152.
 */
package jam.panels;

import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;

public class OptionsPanel
extends JPanel {
    protected GridBagLayout gridbag = new GridBagLayout();
    private final int hGap;
    private final int vGap;
    private final int alignment;

    public OptionsPanel() {
        this(4, 4, 2);
    }

    public OptionsPanel(int hGap, int vGap) {
        this(hGap, vGap, 2);
    }

    public OptionsPanel(int hGap, int vGap, int alignment) {
        this.hGap = hGap;
        this.vGap = vGap;
        this.alignment = alignment;
        this.setBorder(BorderFactory.createEmptyBorder(3, 6, 6, 6));
        this.setLayout(this.gridbag);
        this.setOpaque(false);
    }

    public void addLabel(String text) {
        JLabel label = new JLabel(text);
        this.adjustComponent(label);
        this.addSpanningComponent(label);
    }

    public void addSpanningComponent(JComponent comp) {
        this.adjustComponent(comp);
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(this.vGap / 2, 0, this.vGap / 2, 0);
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.anchor = 19;
        c.gridwidth = 0;
        this.gridbag.setConstraints(comp, c);
        this.add(comp);
    }

    public void addSeperator() {
        this.addSeparator();
    }

    public void addSeparator() {
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(0, 0, 0, 0);
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.gridwidth = 0;
        c.anchor = 19;
        JSeparator separator = new JSeparator();
        this.adjustComponent(separator);
        separator.setOpaque(false);
        this.gridbag.setConstraints(separator, c);
        this.add(separator);
    }

    public void addFlexibleSpace() {
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(0, 0, 0, 0);
        c.weightx = 0.0;
        c.weighty = 1.0;
        c.fill = 0;
        c.gridwidth = 0;
        JSeparator separator = new JSeparator();
        separator.setPreferredSize(new Dimension(0, 0));
        this.gridbag.setConstraints(separator, c);
        this.add(separator);
    }

    public void addComponent(JComponent comp) {
        this.addComponent(comp, false);
    }

    public void addComponent(JComponent comp, boolean fill) {
        JPanel panel = new JPanel();
        panel.setOpaque(false);
        this.addComponents(panel, false, comp, fill);
    }

    public JLabel addComponentWithLabel(String text, JComponent comp) {
        return this.addComponentWithLabel(text, comp, false);
    }

    public JLabel addComponentWithLabel(String text, JComponent comp, boolean fill) {
        JLabel label = new JLabel(text, 4);
        label.setLabelFor(comp);
        label.setOpaque(false);
        this.addComponents(label, false, comp, fill);
        return label;
    }

    public void addComponents(JComponent comp1, JComponent comp2) {
        this.addComponents(comp1, false, comp2, false);
    }

    public void addComponents(JComponent comp1, boolean fill1, JComponent comp2, boolean fill2) {
        this.adjustComponent(comp1);
        this.adjustComponent(comp2);
        GridBagConstraints c = new GridBagConstraints();
        c.weightx = this.alignment != 2 ? 1.0 : 0.0;
        c.weighty = 0.0;
        c.fill = fill1 ? 2 : 0;
        c.insets = new Insets(this.vGap / 2, 0, this.vGap / 2, this.hGap / 2);
        c.gridwidth = 1;
        c.anchor = 13;
        this.gridbag.setConstraints(comp1, c);
        this.add(comp1);
        c.weightx = this.alignment != 4 ? 1.0 : 0.0;
        c.insets = new Insets(this.vGap / 2, this.hGap / 2, this.vGap / 2, 0);
        c.fill = fill2 ? 2 : 0;
        c.gridwidth = 0;
        c.anchor = 17;
        this.gridbag.setConstraints(comp2, c);
        this.add(comp2);
    }

    protected void adjustComponent(JComponent comp) {
    }
}

