/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.analysis.solvers;

import org.apache.commons.math.ConvergenceException;
import org.apache.commons.math.FunctionEvaluationException;
import org.apache.commons.math.MaxIterationsExceededException;
import org.apache.commons.math.analysis.UnivariateRealFunction;
import org.apache.commons.math.analysis.solvers.UnivariateRealSolverImpl;
import org.apache.commons.math.util.MathUtils;

public class MullerSolver
extends UnivariateRealSolverImpl {
    @Deprecated
    public MullerSolver(UnivariateRealFunction univariateRealFunction) {
        super(univariateRealFunction, 100, 1.0E-6);
    }

    public MullerSolver() {
        super(100, 1.0E-6);
    }

    @Override
    @Deprecated
    public double solve(double d, double d2) throws ConvergenceException, FunctionEvaluationException {
        return this.solve(this.f, d, d2);
    }

    @Override
    @Deprecated
    public double solve(double d, double d2, double d3) throws ConvergenceException, FunctionEvaluationException {
        return this.solve(this.f, d, d2, d3);
    }

    @Override
    public double solve(UnivariateRealFunction univariateRealFunction, double d, double d2, double d3) throws MaxIterationsExceededException, FunctionEvaluationException {
        if (univariateRealFunction.value(d) == 0.0) {
            return d;
        }
        if (univariateRealFunction.value(d2) == 0.0) {
            return d2;
        }
        if (univariateRealFunction.value(d3) == 0.0) {
            return d3;
        }
        this.verifyBracketing(d, d2, univariateRealFunction);
        this.verifySequence(d, d3, d2);
        if (this.isBracketing(d, d3, univariateRealFunction)) {
            return this.solve(univariateRealFunction, d, d3);
        }
        return this.solve(univariateRealFunction, d3, d2);
    }

    @Override
    public double solve(UnivariateRealFunction univariateRealFunction, double d, double d2) throws MaxIterationsExceededException, FunctionEvaluationException {
        double d3 = d;
        double d4 = univariateRealFunction.value(d3);
        double d5 = d2;
        double d6 = univariateRealFunction.value(d5);
        double d7 = 0.5 * (d3 + d5);
        double d8 = univariateRealFunction.value(d7);
        if (d4 == 0.0) {
            return d;
        }
        if (d6 == 0.0) {
            return d2;
        }
        this.verifyBracketing(d, d2, univariateRealFunction);
        double d9 = Double.POSITIVE_INFINITY;
        for (int i = 1; i <= this.maximalIterationCount; ++i) {
            boolean bl;
            double d10 = (d8 - d4) / (d7 - d3);
            double d11 = (d6 - d8) / (d5 - d7);
            double d12 = (d11 - d10) / (d5 - d3);
            double d13 = d10 + (d7 - d3) * d12;
            double d14 = d13 * d13 - 4.0 * d8 * d12;
            double d15 = d7 + -2.0 * d8 / (d13 + Math.sqrt(d14));
            double d16 = d7 + -2.0 * d8 / (d13 - Math.sqrt(d14));
            double d17 = this.isSequence(d3, d15, d5) ? d15 : d16;
            double d18 = univariateRealFunction.value(d17);
            double d19 = Math.max(this.relativeAccuracy * Math.abs(d17), this.absoluteAccuracy);
            if (Math.abs(d17 - d9) <= d19) {
                this.setResult(d17, i);
                return this.result;
            }
            if (Math.abs(d18) <= this.functionValueAccuracy) {
                this.setResult(d17, i);
                return this.result;
            }
            boolean bl2 = bl = d17 < d7 && d7 - d3 > 0.95 * (d5 - d3) || d17 > d7 && d5 - d7 > 0.95 * (d5 - d3) || d17 == d7;
            if (!bl) {
                d3 = d17 < d7 ? d3 : d7;
                d4 = d17 < d7 ? d4 : d8;
                d5 = d17 > d7 ? d5 : d7;
                d6 = d17 > d7 ? d6 : d8;
                d7 = d17;
                d8 = d18;
                d9 = d17;
                continue;
            }
            double d20 = 0.5 * (d3 + d5);
            double d21 = univariateRealFunction.value(d20);
            if (MathUtils.sign(d4) + MathUtils.sign(d21) == 0.0) {
                d5 = d20;
                d6 = d21;
            } else {
                d3 = d20;
                d4 = d21;
            }
            d7 = 0.5 * (d3 + d5);
            d8 = univariateRealFunction.value(d7);
            d9 = Double.POSITIVE_INFINITY;
        }
        throw new MaxIterationsExceededException(this.maximalIterationCount);
    }

    @Deprecated
    public double solve2(double d, double d2) throws MaxIterationsExceededException, FunctionEvaluationException {
        return this.solve2(this.f, d, d2);
    }

    public double solve2(UnivariateRealFunction univariateRealFunction, double d, double d2) throws MaxIterationsExceededException, FunctionEvaluationException {
        double d3 = d;
        double d4 = univariateRealFunction.value(d3);
        double d5 = d2;
        double d6 = univariateRealFunction.value(d5);
        double d7 = 0.5 * (d3 + d5);
        double d8 = univariateRealFunction.value(d7);
        if (d4 == 0.0) {
            return d;
        }
        if (d6 == 0.0) {
            return d2;
        }
        this.verifyBracketing(d, d2, univariateRealFunction);
        double d9 = Double.POSITIVE_INFINITY;
        for (int i = 1; i <= this.maximalIterationCount; ++i) {
            double d10;
            double d11;
            double d12;
            double d13;
            double d14 = (d7 - d5) / (d5 - d3);
            double d15 = (2.0 * d14 + 1.0) * d8 - (1.0 + d14) * (1.0 + d14) * d6 + d14 * d14 * d4;
            double d16 = d14 * (d8 - (1.0 + d14) * d6 + d14 * d4);
            double d17 = (1.0 + d14) * d8;
            double d18 = d15 * d15 - 4.0 * d16 * d17;
            if (d18 >= 0.0) {
                d13 = d15 + Math.sqrt(d18);
                d12 = d15 - Math.sqrt(d18);
                d11 = Math.abs(d13) > Math.abs(d12) ? d13 : d12;
            } else {
                d11 = Math.sqrt(d15 * d15 - d18);
            }
            if (d11 != 0.0) {
                for (d10 = d7 - 2.0 * d17 * (d7 - d5) / d11; d10 == d5 || d10 == d7; d10 += this.absoluteAccuracy) {
                }
            } else {
                d10 = d + Math.random() * (d2 - d);
                d9 = Double.POSITIVE_INFINITY;
            }
            d13 = univariateRealFunction.value(d10);
            d12 = Math.max(this.relativeAccuracy * Math.abs(d10), this.absoluteAccuracy);
            if (Math.abs(d10 - d9) <= d12) {
                this.setResult(d10, i);
                return this.result;
            }
            if (Math.abs(d13) <= this.functionValueAccuracy) {
                this.setResult(d10, i);
                return this.result;
            }
            d3 = d5;
            d4 = d6;
            d5 = d7;
            d6 = d8;
            d7 = d10;
            d8 = d13;
            d9 = d10;
        }
        throw new MaxIterationsExceededException(this.maximalIterationCount);
    }
}

