/*
 * Decompiled with CFR 0.152.
 */
package beast.app.util;

import beast.core.util.Log;
import beast.util.AddOnManager;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.Window;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JOptionPane;

public class Utils6 {
    static Window splashScreen;
    static Canvas can;

    public static void startSplashScreen() {
        Image image = Utils6.getIcon("beast/app/draw/icons/beauti.png").getImage();
        int n = 2 * image.getWidth(null);
        int n2 = image.getHeight(null);
        Window window = new Window(new Frame());
        window.pack();
        can = new Canvas();
        can.setSize(n, n2);
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension dimension = toolkit.getScreenSize();
        window.setBounds(dimension.width / 2 - n / 2, dimension.height / 2 - n2 / 2, n, n2);
        window.add("Center", can);
        MediaTracker mediaTracker = new MediaTracker(can);
        mediaTracker.addImage(image, 0);
        try {
            mediaTracker.waitForAll();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Graphics graphics = can.getBufferedGraphics();
        graphics.drawImage(image, n / 4, 0, can);
        window.setVisible(true);
        window.toFront();
        splashScreen = window;
    }

    public static void endSplashScreen() {
        if (splashScreen != null) {
            splashScreen.dispose();
            can = null;
            splashScreen = null;
        }
    }

    public static ImageIcon getIcon(String string) {
        try {
            URL uRL = ClassLoader.getSystemResource(string);
            if (uRL == null) {
                Log.warning.println("Cannot find icon " + string);
                return null;
            }
            ImageIcon imageIcon = new ImageIcon(uRL);
            return imageIcon;
        }
        catch (Exception exception) {
            Log.warning.println("Cannot load icon " + string + " " + exception.getMessage());
            return null;
        }
    }

    public static boolean testCudaStatusOnMac() {
        String string = "<html>It appears you have CUDA installed, but your computer hardware does not support it.<br>You need to remove CUDA before BEAST/BEAUti can start.<br>To remove CUDA, delete the following folders by typing in a terminal:<br>rm -r /Library/Frameworks/CUDA.framework<br>rm -r /Developer/NVIDIA<br>rm -r /usr/local/cuda<br>You may need 'sudo rm' instead of 'rm'</html>";
        boolean bl = Boolean.valueOf(System.getProperty("java.only"));
        if (bl) {
            return true;
        }
        if (Utils6.isMac()) {
            try {
                if (new File("/Library/Frameworks/CUDA.framework").exists() || new File("/Developer/NVIDIA").exists() || new File("/usr/local/cuda").exists()) {
                    String string2;
                    String string3 = System.getenv("java.home");
                    string3 = string3 == null ? "/usr/bin/java" : string3 + "/bin/java";
                    String string4 = AddOnManager.getPackageUserDir();
                    if (!new File(string4 = string4 + "/BEAST/lib/beast.jar").exists()) {
                        Log.debug.println("Could not find beast.jar, giving up testCudaStatusOnMac");
                        return true;
                    }
                    Process process = Runtime.getRuntime().exec(new String[]{string3, "-cp", string4, "beast.app.util.Utils"});
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                    while ((string2 = bufferedReader.readLine()) != null) {
                        Log.debug.println(string2);
                    }
                    bufferedReader.close();
                    if (process.exitValue() != 0) {
                        if (GraphicsEnvironment.isHeadless()) {
                            string = string.replaceAll("<br>", "\n");
                            string = string.replaceAll("<.?html>", "\n");
                            Log.warning.println("WARNING: " + string);
                        } else {
                            JOptionPane.showMessageDialog(null, string);
                        }
                        return false;
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return true;
    }

    public static boolean isMac() {
        return System.getProperty("os.name").toLowerCase().startsWith("mac");
    }

    public static boolean isWindows() {
        return System.getProperty("os.name").toLowerCase().startsWith("windows");
    }

    public static boolean isLinux() {
        return System.getProperty("os.name").toLowerCase().startsWith("linux");
    }

    public static class Canvas
    extends JComponent {
        private static final long serialVersionUID = 1L;
        Image imageBuffer;

        @Override
        public void paintComponent(Graphics graphics) {
            if (this.imageBuffer != null) {
                graphics.drawImage(this.imageBuffer, 0, 0, this);
            }
        }

        public Graphics getBufferedGraphics() {
            Dimension dimension = this.getSize();
            this.imageBuffer = this.createImage(dimension.width, dimension.height);
            return this.imageBuffer.getGraphics();
        }

        @Override
        public void setBounds(int n, int n2, int n3, int n4) {
            this.setPreferredSize(new Dimension(n3, n4));
            this.setMinimumSize(new Dimension(n3, n4));
            super.setBounds(n, n2, n3, n4);
        }
    }
}

