/*
 * Decompiled with CFR 0.152.
 */
package viz;

import com.itextpdf.awt.PdfGraphics2D;
import com.itextpdf.text.Document;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfWriter;
import jam.framework.Application;
import jam.framework.DocumentFrame;
import jam.mac.Utils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintStream;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.NodeList;
import viz.CladeDrawer;
import viz.GridDrawer;
import viz.Node;
import viz.NodeOrderer;
import viz.TreeFileParser;
import viz.TreeSetPanel;
import viz.graphics.ArcBranchDrawer;
import viz.graphics.BranchDrawer;
import viz.graphics.JFontChooser;
import viz.graphics.SteepArcBranchDrawer;
import viz.graphics.TrapeziumBranchDrawer;
import viz.graphics.TreeDrawer;
import viz.panel.BurninPanel;
import viz.panel.CladePanel;
import viz.panel.ColorPanel;
import viz.panel.ExpandablePanel;
import viz.panel.GeoPanel;
import viz.panel.GridPanel;
import viz.panel.LabelPanel;
import viz.panel.LineWidthPanel;
import viz.panel.ShowPanel;
import viz.process.BranchLengthOptimiser;
import viz.util.Util;

public class DensiTree
extends JPanel
implements ComponentListener {
    static final String VERSION = "2.2.6";
    static final String FRAME_TITLE = "DensiTree - Tree Set Visualizer";
    static final String CITATION = "Remco R. Bouckaert & Joseph Heled\nDensiTree 2: Seeing Trees Through the Forest\nbioRxiv, 2014,\nhttp://dx.doi.org/10.1101/012401\n";
    static int instances = 1;
    public String m_sOptFile = null;
    int m_iOptTree = -1;
    public Node m_optTree = null;
    public String m_sOptTree = null;
    boolean m_bOptimiseRootCanalTree = false;
    static int B = 1;
    JFrame frame;
    private static final long serialVersionUID = 1L;
    public static final String ICONPATH = "viz/icons/";
    static final double DEFAULT_LENGTH = (double)0.001f;
    public Node[] m_trees;
    public Node m_rootcanaltree;
    public List<Node> m_summaryTree = new ArrayList<Node>();
    float[][] m_fLinesX;
    float[][] m_fLinesY;
    public int[][] m_nLineColor;
    public float[][] m_fLineWidth;
    public float[][] m_fTopLineWidth;
    public int[][] m_nCLineColor;
    public float[][] m_fCLineWidth;
    public float[][] m_fTopCLineWidth;
    float[][] m_fRLinesX;
    float[][] m_fRLinesY;
    public int[][] m_nRLineColor;
    public float[][] m_fRLineWidth;
    public float[][] m_fRTopLineWidth;
    public boolean m_bColorByCategory = false;
    public Vector<String> m_sLabels;
    public BufferedImage[] m_LabelImages;
    public int m_nImageSize = 20;
    public boolean m_bHideLabels = false;
    public int m_nNrOfLabels = 0;
    public Vector<Float> m_fLongitude;
    public Vector<Float> m_fLatitude;
    boolean m_bInvertLongitude = false;
    public float m_fMaxLong;
    public float m_fMaxLat;
    public float m_fMinLong;
    public float m_fMinLat;
    String m_sKMLFile = null;
    static float GEO_OFFSET = 3.0f;
    int[] m_nOrder;
    int[] m_nRevOrder;
    int[] m_nTopology;
    int[] m_nTopologyByPopularity;
    int m_nTopologies;
    float[] m_fTreeWeight;
    Node[] m_cTrees;
    float[][] m_fCLinesX;
    float[][] m_fCLinesY;
    public float m_fHeight = 0.0f;
    float m_fScaleX = 10.0f;
    float m_fScaleY = 10.0f;
    float m_fScaleGX = 10.0f;
    float m_fScaleGY = 10.0f;
    float m_fScale = 1.0f;
    public float m_fUserScale = 1.0f;
    float m_fTreeOffset = 0.0f;
    float m_fTreeScale = 1.0f;
    public GridDrawer m_gridDrawer;
    public CladeDrawer m_cladeDrawer;
    double m_cladeThreshold = 1.0E-4;
    public double m_smallestCladeSupport = 0.01;
    boolean m_bLeafCladeSelection = false;
    boolean m_bInitializing;
    int m_nJitter = 0;
    Random m_random = new Random();
    float m_fTreeIntensity = 1.0f;
    float m_fCTreeIntensity = 1.0f;
    int m_nTreeWidth = 1;
    int m_nCTreeWidth = 4;
    public int m_nGeoWidth = 1;
    public int m_nLabelWidth = 100;
    public boolean[] m_bSelection;
    public boolean m_bSelectionChanged;
    java.awt.Rectangle[] m_bLabelRectangle;
    java.awt.Rectangle[] m_bGeoRectangle;
    java.awt.Rectangle m_nSelectedRect = null;
    public int m_nBurnIn = 10;
    public boolean m_bBurnInIsPercentage = true;
    double m_w = 0.0;
    String m_sDir = System.getProperty("user.dir");
    public Color[] m_color;
    public static int HEIGHTCOLOR = 6;
    public static int CONSCOLOR = 4;
    public static int LABELCOLOR = 5;
    public static int BGCOLOR = 7;
    public static int GEOCOLOR = 8;
    public static int ROOTCANALCOLOR = 9;
    public BufferedImage m_bgImage;
    double[] m_fBGImageBox = new double[]{-180.0, -90.0, 180.0, 90.0};
    String m_sOutputFile = null;
    boolean m_bShowBounds = false;
    public float m_fLabelIndent = 0.0f;
    boolean m_bRecord = false;
    int m_nFrameNr;
    public boolean m_bViewEditTree = false;
    public boolean m_bViewClades = false;
    public Set<Integer> m_cladeSelection = new HashSet<Integer>();
    BufferedImage m_rotate;
    public Pattern m_pattern;
    public Pattern m_patternTop;
    static final String DEFAULT_PATTERN = ".*location=\"([^\"]*).*";
    public String m_sPattern = ".*location=\"([^\"]*).*";
    public int m_iPatternForBottom = 1;
    public int m_iPatternForTop = 0;
    String m_sColorPattern = null;
    int[] m_iColor;
    boolean m_bAllowSingleChild = false;
    public boolean m_bRotateTextWhenRootAtTop = false;
    public int m_Xmode = 0;
    boolean m_bUseAngleCorrection = false;
    double m_fAngleCorrectionThresHold = 0.9;
    int m_nShuffleMode = -3;
    public String m_sFileName;
    public boolean m_bCorrectTopOfBranch = false;
    public boolean m_bWidthsAreZeroBased = true;
    String m_asPDF = null;
    Thread thread = null;
    boolean m_bCladesReady;
    public boolean m_bMetaDataReady;
    List<int[]> m_clades;
    List<Double> m_cladeWeight;
    List<Double> m_cladeHeight;
    List<Double> m_cladeHeight95HPDup;
    List<Double> m_cladeHeight95HPDdown;
    public List<List<Double>> m_cladeHeightSetBottom;
    public List<List<Double>> m_cladeHeightSetTop;
    JList<String> m_cladelist;
    DefaultListModel<String> m_cladelistmodel = new DefaultListModel();
    public Map<String, Integer> mapCladeToIndex;
    public Integer[] reverseindex;
    Comparator<Float> floatComparator = new Comparator<Float>(){

        @Override
        public int compare(Float o1, Float o2) {
            return Float.compare(Math.abs(o1.floatValue()), Math.abs(o2.floatValue()));
        }
    };
    Map<Integer, Double> m_cladePairs;
    List<List<ChildClade>> m_cladeChildren;
    float[] m_cladePosition;
    public boolean m_bShowRootCanalTopology = false;
    boolean m_bAllowCladeSelection = true;
    public LineWidthMode m_lineWidthMode = LineWidthMode.DEFAULT;
    public LineWidthMode m_lineWidthModeTop = LineWidthMode.DEFAULT;
    LineWidthMode m_prevLineWidthMode = null;
    public String m_sLineWidthPattern = ".*location=\"([^\"]*).*";
    public String m_sLineWidthPatternTop = ".*location=\"([^\"]*).*";
    String m_sPrevLineWidthPattern = null;
    public String m_lineWidthTag;
    public String m_lineWidthTagTop;
    String m_prevLineWidthTag;
    public LineColorMode m_lineColorMode = LineColorMode.DEFAULT;
    public LineColorMode m_prevLineColorMode = null;
    public String m_sLineColorPattern = ".*location=\"([^\"]*).*";
    String m_sPrevLineColorPattern = null;
    Map<String, Integer> m_colorMetaDataCategories = new HashMap<String, Integer>();
    public List<String> m_metaDataTags = new ArrayList<String>();
    public List<MetaDataType> m_metaDataTypes = new ArrayList<MetaDataType>();
    public String m_lineColorTag;
    String m_prevLineColorTag;
    public boolean m_showLegend = false;
    public TreeDrawer m_treeDrawer = new TreeDrawer();
    int m_nStyle = 0;
    JScrollPane m_jScrollPane;
    public TreeSetPanel m_Panel = null;
    JMenuBar m_menuBar;
    final JLabel m_jStatusBar = new JLabel("Status bar");
    final JToolBar m_jTbTools = new JToolBar();
    final JPanel m_jTbTools2 = new JPanel();
    final JToolBar m_jTbCladeTools = new JToolBar();
    public Font m_font = new Font("sansserif", 0, 12);
    public boolean m_bAlignLabels = false;
    public boolean m_bViewCTrees = false;
    public boolean m_bViewAllTrees = true;
    boolean m_bUseLogScale = false;
    double m_fExponent = 1.0;
    public boolean m_bViewMultiColor = false;
    public boolean m_bDrawGeo = true;
    boolean m_bAnimateOverwrite = false;
    int m_iAnimateTree;
    int m_nAnimationDelay = 100;
    boolean m_bAutoRefresh = true;
    boolean m_bIsDirty = true;
    ViewMode m_viewMode = ViewMode.DRAW;
    public Action a_quit = new MyAction(this, "Exit", "Exit Program", "exit", -1){
        private static final long serialVersionUID = -10L;

        @Override
        public void actionPerformed(ActionEvent ae) {
            System.exit(0);
        }
    };
    Action a_paste = new MyAction(this, "Paste", "Paste tree(s) from clipboard", "paste", 86){
        private static final long serialVersionUID = -10L;

        @Override
        public void actionPerformed(ActionEvent ae) {
            boolean hasTransferableText;
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            Transferable contents = clipboard.getContents(null);
            boolean bl = hasTransferableText = contents != null && contents.isDataFlavorSupported(DataFlavor.stringFlavor);
            if (hasTransferableText) {
                try {
                    String sResult = (String)contents.getTransferData(DataFlavor.stringFlavor);
                    String sFileName = "tmp.clipboard";
                    PrintStream out = new PrintStream(sFileName);
                    out.print(sResult);
                    out.close();
                    this.init(sFileName);
                    this.calcLines();
                    m_jStatusBar.setText("Loaded from clipboard");
                    this.fitToScreen();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    JOptionPane.showMessageDialog(null, "Error pasting from clipboard: " + e.getMessage(), "File paste error", -1);
                }
            }
        }
    };
    Action a_export = new MyAction(this, "Export", "Export", "export", -1){
        private static final long serialVersionUID = -1L;

        @Override
        public void actionPerformed(ActionEvent ae) {
            JFileChooser fc = new JFileChooser(m_sDir);
            fc.addChoosableFileFilter(new MyFileFilter(this){

                @Override
                public String getExtention() {
                    return ".bmp";
                }

                @Override
                public String getDescription() {
                    return "Bitmap files (*.bmp)";
                }
            });
            fc.addChoosableFileFilter(new MyFileFilter(this){

                @Override
                public String getExtention() {
                    return ".jpg";
                }

                @Override
                public String getDescription() {
                    return "JPEG bitmap files (*.jpg)";
                }
            });
            fc.addChoosableFileFilter(new MyFileFilter(this){

                @Override
                public String getExtention() {
                    return ".png";
                }

                @Override
                public String getDescription() {
                    return "PNG bitmap files (*.png)";
                }
            });
            fc.addChoosableFileFilter(new MyFileFilter(this){

                @Override
                public String getExtention() {
                    return ".pdf";
                }

                @Override
                public String getDescription() {
                    return "PDF files (*.pdf)";
                }
            });
            fc.addChoosableFileFilter(new MyFileFilter(this){

                @Override
                public String getExtention() {
                    return ".svg";
                }

                @Override
                public String getDescription() {
                    return "Standard Vector Graphics files";
                }
            });
            fc.setDialogTitle("Export DensiTree As");
            int rval = fc.showSaveDialog(m_Panel);
            if (rval == 0) {
                String sFileName = fc.getSelectedFile().toString();
                if (sFileName.lastIndexOf(47) > 0) {
                    m_sDir = sFileName.substring(0, sFileName.lastIndexOf(47));
                }
                if (sFileName != null && !sFileName.equals("")) {
                    if (!(sFileName.toLowerCase().endsWith(".png") || sFileName.toLowerCase().endsWith(".jpg") || sFileName.toLowerCase().endsWith(".pdf") || sFileName.toLowerCase().endsWith(".bmp") || sFileName.toLowerCase().endsWith(".svg"))) {
                        sFileName = String.valueOf(sFileName) + ((MyFileFilter)fc.getFileFilter()).getExtention();
                    }
                    if (sFileName.toLowerCase().endsWith(".pdf")) {
                        this.exportPDF(sFileName);
                        this.repaint();
                        return;
                    }
                    if (sFileName.toLowerCase().endsWith(".png") || sFileName.toLowerCase().endsWith(".jpg") || sFileName.toLowerCase().endsWith(".bmp")) {
                        BufferedImage bi = new BufferedImage(m_Panel.getWidth(), m_Panel.getHeight(), 1);
                        Graphics g = bi.getGraphics();
                        g.setPaintMode();
                        g.setColor(this.getBackground());
                        g.fillRect(0, 0, m_Panel.getWidth(), m_Panel.getHeight());
                        m_Panel.printAll(g);
                        try {
                            if (sFileName.toLowerCase().endsWith(".png")) {
                                ImageIO.write((RenderedImage)bi, "png", new File(sFileName));
                            } else if (sFileName.toLowerCase().endsWith(".jpg")) {
                                ImageIO.write((RenderedImage)bi, "jpg", new File(sFileName));
                            } else if (sFileName.toLowerCase().endsWith(".bmp")) {
                                ImageIO.write((RenderedImage)bi, "bmp", new File(sFileName));
                            }
                        }
                        catch (Exception e) {
                            JOptionPane.showMessageDialog(null, String.valueOf(sFileName) + " was not written properly: " + e.getMessage());
                            e.printStackTrace();
                        }
                        return;
                    }
                    if (sFileName.toLowerCase().endsWith(".svg")) {
                        m_Panel.toSVG(sFileName);
                        return;
                    }
                    JOptionPane.showMessageDialog(null, "Extention of file " + sFileName + " not recognized as png,bmp,jpg or svg file");
                }
            }
        }
    };
    Action a_print = new MyAction(this, "Print", "Print Graph", "print", 80){
        private static final long serialVersionUID = -20389001859354L;

        @Override
        public void actionPerformed(ActionEvent ae) {
            PrinterJob printJob = PrinterJob.getPrinterJob();
            printJob.setPrintable(m_Panel);
            if (printJob.printDialog()) {
                try {
                    printJob.print();
                }
                catch (PrinterException printerException) {
                    // empty catch block
                }
            }
        }
    };
    Action a_new = new MyAction(this, "New", "New instance of DensiTree", "new", 78){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent ae) {
            DensiTree.startNew(new String[0]);
        }
    };
    Action a_load = new MyAction(this, "Load", "Load tree set", "open", 79){
        private static final long serialVersionUID = -2038911085935515L;

        @Override
        public void actionPerformed(ActionEvent ae) {
            File[] files = Util.getFile("Load Tree Set", true, new File(m_sDir), false, "Nexus trees files", "trees", "tre", "nex", "t");
            if (files != null && files.length > 0) {
                this.doOpen(files[0].getPath());
            }
        }
    };
    public Action a_loadkml = new MyAction(this, "Load locations", "Load geographic locations of taxa", "geo", -1){
        private static final long serialVersionUID = -1L;

        @Override
        public void actionPerformed(ActionEvent ae) {
            JFileChooser fc = new JFileChooser(m_sDir);
            fc.addChoosableFileFilter(new FileFilter(){

                @Override
                public boolean accept(File f) {
                    if (f.isDirectory()) {
                        return true;
                    }
                    String name = f.getName().toLowerCase();
                    return name.endsWith(".kml") || name.endsWith(".kmz");
                }

                @Override
                public String getDescription() {
                    return "KML file with taxon locations";
                }
            });
            fc.addChoosableFileFilter(new FileFilter(){

                @Override
                public boolean accept(File f) {
                    if (f.isDirectory()) {
                        return true;
                    }
                    String name = f.getName().toLowerCase();
                    return name.endsWith(".txt") || name.endsWith(".dat");
                }

                @Override
                public String getDescription() {
                    return "text file with taxon locations, tab delimited";
                }
            });
            fc.setDialogTitle("Load Geographic Locations");
            int rval = fc.showOpenDialog(m_Panel);
            if (rval == 0) {
                String sFileName = fc.getSelectedFile().toString();
                if (sFileName.lastIndexOf(47) > 0) {
                    m_sDir = sFileName.substring(0, sFileName.lastIndexOf(47));
                }
                m_sKMLFile = sFileName;
                this.loadKML();
                m_jStatusBar.setText("Loaded " + sFileName);
                this.fitToScreen();
            }
        }
    };
    Action a_saveas = new MyAction(this, "Save as", "Save as", "save", 83){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent ae) {
            JFileChooser fc = new JFileChooser(m_sDir);
            fc.addChoosableFileFilter(new FileFilter(){

                @Override
                public boolean accept(File f) {
                    if (f.isDirectory()) {
                        return true;
                    }
                    String name = f.getName().toLowerCase();
                    if (name.endsWith(".trees")) {
                        return true;
                    }
                    if (name.endsWith(".tre")) {
                        return true;
                    }
                    if (name.endsWith(".nex")) {
                        return true;
                    }
                    return name.endsWith(".t");
                }

                @Override
                public String getDescription() {
                    return "Nexus trees files";
                }
            });
            fc.setDialogTitle("Save Graph");
            int rval = fc.showSaveDialog(m_Panel);
            if (rval == 0) {
                String sFileName = fc.getSelectedFile().toString();
                if (sFileName.lastIndexOf(47) > 0) {
                    m_sDir = sFileName.substring(0, sFileName.lastIndexOf(47));
                }
                try {
                    FileWriter outfile = new FileWriter(sFileName);
                    StringBuffer buf = new StringBuffer();
                    buf.append("#NEXUS\n");
                    buf.append("Begin trees\n");
                    buf.append("\tTranslate\n");
                    int i = 0;
                    while (i < m_sLabels.size()) {
                        buf.append("\t\t" + i + " " + m_sLabels.get(i));
                        if (i < m_sLabels.size() - 1) {
                            buf.append(",");
                        }
                        buf.append("\n");
                        ++i;
                    }
                    buf.append(";\n");
                    outfile.write(buf.toString());
                    i = 0;
                    while (i < m_trees.length) {
                        outfile.write("tree STATE_" + i + " = " + m_trees[i].toString() + ";\n");
                        System.out.println(m_trees[i].toString(m_sLabels, false));
                        ++i;
                    }
                    outfile.write("End;\n");
                    outfile.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    JOptionPane.showMessageDialog(null, "Error writing file: " + e.getMessage(), "File save error", -1);
                    return;
                }
                m_jStatusBar.setText("Saved " + sFileName);
                this.fitToScreen();
            }
        }
    };
    Action a_loadimage = new MyAction(this, "Background image ", "Load background image", "bgimage", -1){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent ae) {
            JFileChooser fc = new JFileChooser(m_sDir);
            fc.addChoosableFileFilter(new FileFilter(){

                @Override
                public boolean accept(File f) {
                    if (f.isDirectory()) {
                        return true;
                    }
                    String name = f.getName().toLowerCase();
                    return name.endsWith(".jpg") || name.endsWith(".png") || name.endsWith(".gif");
                }

                @Override
                public String getDescription() {
                    return "Image files";
                }
            });
            fc.setDialogTitle("Load Background Image");
            int rval = fc.showOpenDialog(m_Panel);
            if (rval == 0) {
                String sFileName = fc.getSelectedFile().toString();
                if (sFileName.lastIndexOf(47) > 0) {
                    m_sDir = sFileName.substring(0, sFileName.lastIndexOf(47));
                }
                try {
                    this.loadBGImage(sFileName);
                }
                catch (OutOfMemoryError e) {
                    JOptionPane.showMessageDialog(null, "Error loading file: " + e.getMessage(), "File load error", -1);
                    return;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    JOptionPane.showMessageDialog(null, "Error loading file: " + e.getMessage(), "File load error", -1);
                    return;
                }
                this.makeDirty();
            }
        }
    };
    Action a_viewClades = new MyAction(this, "View clades", "List clades and their densities", "viewclades", -1){
        private static final long serialVersionUID = -1L;

        @Override
        public void actionPerformed(ActionEvent ae) {
            JDialog dlg = new JDialog();
            dlg.setModal(true);
            dlg.setSize(400, 400);
            this.setWaitCursor();
            String sCladeText = "";
            for (String s : this.cladesToString()) {
                sCladeText = String.valueOf(sCladeText) + s;
            }
            this.setDefaultCursor();
            JTextArea textArea = new JTextArea(sCladeText);
            JScrollPane scrollPane = new JScrollPane(textArea);
            dlg.add(scrollPane);
            dlg.setTitle("Clades and their probabilities");
            dlg.setVisible(true);
        }
    };
    Action a_help = new MyAction(this, "Help", "DensiTree - Tree Set Visualization Help", "help", -1){
        private static final long serialVersionUID = -20389110859354L;

        @Override
        public void actionPerformed(ActionEvent ae) {
            String sStatus = this.getStatus();
            String sCmdLineOptions = "\n\nTo start with the same settings, use the following command:\njava -jar DensiTree.jar -c " + m_fCTreeIntensity + " -i " + m_fTreeIntensity + " -j " + m_nJitter + " -w " + m_nCTreeWidth + " -v " + m_nTreeWidth + " -f " + m_nAnimationDelay + " -t " + m_Panel.m_nDrawThreads + " -b " + m_nBurnIn;
            System.out.println(sCmdLineOptions);
            JOptionPane.showMessageDialog(null, String.valueOf(this.banner()) + sStatus + sCmdLineOptions, "Help Message", -1);
        }
    };
    public Action a_about = new MyAction(this, "About", "Help about", "about", -1){
        private static final long serialVersionUID = -20389110859353L;

        @Override
        public void actionPerformed(ActionEvent ae) {
            if (JOptionPane.showOptionDialog(null, "DensiTree - Tree Set Visualization\nVersion: 2.2.6\n\nRemco Bouckaert\nremco@cs.waikato.ac.nz\nremco@cs.auckland.ac.nz\n(c) 2010-2014\n\nCitation:\nRemco R. Bouckaert & Joseph Heled\nDensiTree 2: Seeing Trees Through the Forest\nbioRxiv, 2014,\nhttp://dx.doi.org/10.1101/012401\n", "About Message", 0, -1, this.getIcon("DensiTree"), new String[]{"Copy citation to clipboard", "Close"}, "Close") == 0) {
                Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(DensiTree.CITATION), null);
            }
        }
    };
    Action a_labelwidth = new MyAction(this, "Label width", "Label width when root at left", "labelwidth", -1){
        private static final long serialVersionUID = -2L;

        @Override
        public void actionPerformed(ActionEvent ae) {
            String sLabeWidth = JOptionPane.showInputDialog("Labe Width:", (Object)String.valueOf(m_nLabelWidth));
            if (sLabeWidth != null) {
                try {
                    m_nLabelWidth = Integer.parseInt(sLabeWidth);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.fitToScreen();
            }
        }
    };
    Action a_burnin = new MyAction(this, "Burn in", "Burn in", "burnin", -1){
        private static final long serialVersionUID = -2L;

        @Override
        public void actionPerformed(ActionEvent ae) {
            String sBurnIn = JOptionPane.showInputDialog("Burn in:", (Object)String.valueOf(m_nBurnIn));
            if (sBurnIn != null) {
                try {
                    m_nBurnIn = Integer.parseInt(sBurnIn);
                    this.init(m_sFileName);
                    this.calcLines();
                    this.fitToScreen();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    };
    Action a_geolinewidth = new MyAction(this, "Geo line width", "Geographical line width", "geolinewidth", -1){
        private static final long serialVersionUID = -2L;

        @Override
        public void actionPerformed(ActionEvent ae) {
            String sGeoWidth = JOptionPane.showInputDialog("Geographical line width:", (Object)String.valueOf(m_nGeoWidth));
            if (sGeoWidth != null) {
                try {
                    m_nGeoWidth = Integer.parseInt(sGeoWidth);
                    m_Panel.clearImage();
                    this.repaint();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    };
    Action a_viewstatusbar = new MyAction(this, "View statusbar", "View statusbar", "statusbar", -1){
        private static final long serialVersionUID = -20389330812354L;

        @Override
        public void actionPerformed(ActionEvent ae) {
            m_jStatusBar.setVisible(!m_jStatusBar.isVisible());
        }
    };
    Action a_viewtoolbar = new MyAction(this, "View toolbar", "View toolbar", "toolbar", -1){
        private static final long serialVersionUID = -20389110812354L;

        @Override
        public void actionPerformed(ActionEvent ae) {
            m_jTbTools.setVisible(!m_jTbTools.isVisible());
        }
    };
    Action a_viewtoolbar2 = new MyAction(this, "View Sidebar", "View Sidebar", "sidebar", -1){
        private static final long serialVersionUID = -20389110812354L;

        @Override
        public void actionPerformed(ActionEvent ae) {
            m_jTbTools2.setVisible(!m_jTbTools2.isVisible());
        }
    };
    Action a_viewcladetoolbar = new MyAction(this, "View clade toolbar", "View clade toolbar", "cladetoolbar", -1){
        private static final long serialVersionUID = -1L;

        @Override
        public void actionPerformed(ActionEvent ae) {
            m_jTbCladeTools.setVisible(!m_jTbCladeTools.isVisible());
            if (m_jTbCladeTools.isVisible()) {
                JSplitPane pane = (JSplitPane)m_Panel.getParent().getParent().getParent().getParent();
                pane.setDividerLocation(0.8);
            }
        }
    };
    Action a_zoomin = new MyAction(this, "Zoom in", "Zoom in", "zoomin", 61){
        private static final long serialVersionUID = -2038911085935515L;

        @Override
        public void actionPerformed(ActionEvent ae) {
            m_fScale = (float)((double)m_fScale * 1.2);
            a_zoomout.setEnabled(true);
            this.fitToScreen();
            m_jStatusBar.setText("Zooming in");
        }
    };
    Action a_zoomout = new MyAction(this, "Zoom out", "Zoom out", "zoomout", 45){
        private static final long serialVersionUID = -203891108593551L;

        @Override
        public void actionPerformed(ActionEvent ae) {
            m_fScale = (float)((double)m_fScale / 1.2);
            if ((double)m_fScale <= 1.000001) {
                m_fScale = 1.0f;
                a_zoomout.setEnabled(false);
            }
            this.fitToScreen();
            m_jStatusBar.setText("Zooming out");
        }
    };
    Action a_zoomintree = new MyAction(this, "Zoom in height", "Zoom in tree height", "zoominh", 88){
        private static final long serialVersionUID = -1L;

        @Override
        public void actionPerformed(ActionEvent ae) {
            m_fTreeScale = (float)((double)m_fTreeScale * 1.2);
            m_fTreeOffset = m_fHeight - m_fHeight / m_fTreeScale;
            a_zoomouttree.setEnabled(true);
            this.calcLines();
            m_Panel.clearImage();
            this.makeDirty();
            m_jStatusBar.setText("Zooming in tree height");
        }
    };
    Action a_zoomouttree = new MyAction(this, "Zoom out height", "Zoom out tree height", "zoomouth", 600){
        private static final long serialVersionUID = -1L;

        @Override
        public void actionPerformed(ActionEvent ae) {
            m_fTreeScale = (float)((double)m_fTreeScale / 1.2);
            if ((double)m_fTreeScale <= 1.000001) {
                m_fTreeScale = 1.0f;
                a_zoomouttree.setEnabled(false);
            }
            m_fTreeOffset = m_fHeight - m_fHeight / m_fTreeScale;
            this.calcLines();
            m_Panel.clearImage();
            this.makeDirty();
            m_jStatusBar.setText("Zooming out tree height");
        }
    };
    MyAction a_animateStart = new MyAction(this, "Start", "Start Animation", "start", 580){
        private static final long serialVersionUID = -1L;

        @Override
        public void actionPerformed(ActionEvent ae) {
            if (m_viewMode == ViewMode.ANIMATE) {
                m_viewMode = ViewMode.BROWSE;
                a_animateStart.setIcon("start");
            } else {
                if (m_viewMode != ViewMode.BROWSE) {
                    m_iAnimateTree = 0;
                }
                m_viewMode = ViewMode.ANIMATE;
                a_animateStart.setIcon("stop");
            }
            m_Panel.repaint();
        }
    };
    Action a_drawtreeset = new MyAction(this, "Draw Tree Set", "Draw Tree Set", "redraw", 82){
        private static final long serialVersionUID = -4L;

        @Override
        public void actionPerformed(ActionEvent ae) {
            this.setWaitCursor();
            System.err.println("MODS=" + ae.getModifiers());
            if (ae.getModifiers() == 18) {
                System.err.println("start recording: results in /tmp");
                m_nFrameNr = 0;
                m_bRecord = true;
            }
            m_viewMode = ViewMode.DRAW;
            a_animateStart.setIcon("start");
            if (m_bIsDirty) {
                System.err.println("calclines");
                this.calcLines();
            }
            m_Panel.clearImage();
            this.repaint();
            System.gc();
        }
    };
    Action a_selectAll = new MyAction(this, "Select All", "Select All", "selectall", 65){
        private static final long serialVersionUID = 5L;

        @Override
        public void actionPerformed(ActionEvent ae) {
            int i = 0;
            while (i < m_bSelection.length) {
                m_bSelection[i] = true;
                ++i;
            }
            this.repaint();
        }
    };
    Action a_unselectAll = new MyAction(this, "Unselect All", "Unselect All", "unselectall", 85){
        private static final long serialVersionUID = 5L;

        @Override
        public void actionPerformed(ActionEvent ae) {
            int i = 0;
            while (i < m_bSelection.length) {
                m_bSelection[i] = false;
                ++i;
            }
            this.repaint();
        }
    };
    Action a_del = new MyAction(this, "Delete", "Delete selected", "del", -1){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent ae) {
            int nDeleted = 0;
            int i = m_bSelection.length - 1;
            while (i >= 0 && m_nNrOfLabels > 2) {
                if (m_bSelection[i]) {
                    int j = 0;
                    while (j < m_trees.length) {
                        m_trees[j] = this.deleteLeaf(m_trees[j], i);
                        this.renumber(m_trees[j], i);
                        m_trees[j].labelInternalNodes(m_nNrOfLabels - 1);
                        ++j;
                    }
                    j = 0;
                    while (j < m_cTrees.length) {
                        m_cTrees[j] = this.deleteLeaf(m_cTrees[j], i);
                        this.renumber(m_cTrees[j], i);
                        m_cTrees[j].labelInternalNodes(m_nNrOfLabels - 1);
                        ++j;
                    }
                    m_sLabels.remove(i);
                    --m_nNrOfLabels;
                    if (m_fLongitude != null && m_fLongitude.size() > i) {
                        m_fLongitude.remove(i);
                        m_fLatitude.remove(i);
                    }
                    int[] nOrder = new int[m_nOrder.length - 1];
                    int[] nRevOrder = new int[m_nRevOrder.length - 1];
                    int k = 0;
                    int j2 = 0;
                    while (j2 < nOrder.length) {
                        if (m_nOrder[k] == i) {
                            ++k;
                        }
                        nOrder[j2] = m_nOrder[k] < i ? m_nOrder[k] : m_nOrder[k] - 1;
                        ++k;
                        ++j2;
                    }
                    k = 0;
                    j2 = 0;
                    while (j2 < nRevOrder.length) {
                        if (m_nRevOrder[k] == i) {
                            ++k;
                        }
                        nRevOrder[j2] = m_nRevOrder[k] < i ? m_nRevOrder[k] : m_nRevOrder[k] - 1;
                        ++k;
                        ++j2;
                    }
                    m_nOrder = nOrder;
                    m_nRevOrder = nRevOrder;
                    ++nDeleted;
                }
                --i;
            }
            System.err.println("ORDER:" + Arrays.toString(m_nOrder));
            System.err.println("REVOR:" + Arrays.toString(m_nRevOrder));
            m_bSelection = new boolean[m_bSelection.length - nDeleted];
            i = 0;
            while (i < m_bSelection.length) {
                m_bSelection[i] = true;
                ++i;
            }
            this.fitToScreen();
            this.calcPositions();
            this.calcLines();
            m_Panel.clearImage();
            this.repaint();
        }
    };
    int m_iUndo = 0;
    Vector<DoAction> m_doActions = new Vector();
    Action a_undo = new MyAction(this, "Undo", "Undo", "udno", 90){
        private static final long serialVersionUID = -4L;

        @Override
        public void actionPerformed(ActionEvent ae) {
            if (m_iUndo > 0) {
                --m_iUndo;
                m_doActions.elementAt(m_iUndo - 1).doThisAction();
                this.repaint();
            }
        }
    };
    Action a_redo = new MyAction(this, "Redo", "Redo", "reno", 89){
        private static final long serialVersionUID = -4L;

        @Override
        public void actionPerformed(ActionEvent ae) {
            if (m_iUndo < m_doActions.size()) {
                ++m_iUndo;
                m_doActions.elementAt(m_iUndo - 1).doThisAction();
                this.repaint();
            }
        }
    };
    Action a_moveup = new MyAction(this, "Move labels up", "Move selected labels up", "moveup", 77){
        private static final long serialVersionUID = -4L;

        @Override
        public void actionPerformed(ActionEvent ae) {
            if (!this.moveSanityChek()) {
                return;
            }
            this.moveSelectedLabelsUp();
            this.calcLines();
            m_Panel.clearImage();
            this.repaint();
        }
    };
    Action a_movedown = new MyAction(this, "Move labels down", "Move selected labels down", "movedown", 589){
        private static final long serialVersionUID = -4L;

        @Override
        public void actionPerformed(ActionEvent ae) {
            if (!this.moveSanityChek()) {
                return;
            }
            this.moveSelectedLabelsDown();
            this.calcLines();
            m_Panel.clearImage();
            this.repaint();
        }
    };
    Action a_browsefirst = new MyAction(this, "Browse First", "Browse First", "browsefirst", -1){
        private static final long serialVersionUID = 5L;

        @Override
        public void actionPerformed(ActionEvent ae) {
            m_viewMode = ViewMode.BROWSE;
            a_animateStart.setIcon("start");
            m_iAnimateTree = 0;
            this.repaint();
        }
    };
    Action a_browseprev = new MyAction(this, "Browse Prev", "Browse Prev", "browseprev", 592){
        private static final long serialVersionUID = 5L;

        @Override
        public void actionPerformed(ActionEvent ae) {
            m_viewMode = ViewMode.BROWSE;
            a_animateStart.setIcon("start");
            --m_iAnimateTree;
            if (m_iAnimateTree < 0) {
                m_iAnimateTree = 0;
            }
            this.repaint();
        }
    };
    Action a_browsenext = new MyAction(this, "Browse Next", "Browse Next", "browsenext", 590){
        private static final long serialVersionUID = 5L;

        @Override
        public void actionPerformed(ActionEvent ae) {
            m_viewMode = ViewMode.BROWSE;
            a_animateStart.setIcon("start");
            ++m_iAnimateTree;
            if (m_iAnimateTree == m_nTopologies) {
                m_iAnimateTree = m_nTopologies - 1;
            }
            this.repaint();
        }
    };
    Action a_browselast = new MyAction(this, "Browse Last", "Browse Last", "browselast", -1){
        private static final long serialVersionUID = 5L;

        @Override
        public void actionPerformed(ActionEvent ae) {
            m_viewMode = ViewMode.BROWSE;
            a_animateStart.setIcon("start");
            m_iAnimateTree = m_nTopologies - 1;
            this.repaint();
        }
    };
    Action a_setfont = new MyAction(this, "Set Font", "Set Font", "font", -1){
        private static final long serialVersionUID = 5L;

        @Override
        public void actionPerformed(ActionEvent ae) {
            JFontChooser fontChooser = new JFontChooser();
            int result = fontChooser.showDialog(null);
            if (result == 0) {
                m_font = fontChooser.getSelectedFont();
                this.repaint();
            }
        }
    };
    SettingAction a_animationSpeedUp = new SettingAction("Animation Speed+", "Increase Animation Speed", "aspeedup", 70);
    SettingAction a_animationSpeedDown = new SettingAction("Animation Speed-", "Decrease Animation Speed", "aspeeddown", 582);
    SettingAction a_treeWidthUp = new SettingAction("Tree Width+", "Increase Width of Trees", "treewidthup", 86);
    SettingAction a_treeWidthDown = new SettingAction("Tree Width-", "Decrease Width of Trees", "treewidthdown", 598);
    SettingAction a_cTreeWidthUp = new SettingAction("Consensus Tree Width+", "Increase Width of Consensus Trees", "ctreewidthup", 87);
    SettingAction a_cTreeWidthDown = new SettingAction("Consensus Tree Width-", "Decrease Width of Consensus Trees", "ctreewidthdown", 599);
    SettingAction a_intensityUp = new SettingAction("Intensity+", "Increase Intensity of Trees", "intensityup", 73);
    SettingAction a_intensityDown = new SettingAction("Intensity-", "Decrease Intensity of Trees", "intensitydown", 585);
    SettingAction a_cIntensityUp = new SettingAction("Consensus Intensity+", "Increase Intensity of Consensus Trees", "cintensityup", 67);
    SettingAction a_cIntensityDown = new SettingAction("Consensus Intensity-", "Decrease Intensity of Consensus Trees", "cintensitydown", 579);
    SettingAction a_jitterUp = new SettingAction("Jitter+", "Increase Jitter on x-coordinate of Trees", "jitterup", 74);
    SettingAction a_jitterDown = new SettingAction("Jitter-", "Decrease Jitter on x-coordinate of Trees", "jitterdown", 586);
    SettingAction a_threadsUp = new SettingAction("Drawing Threads+", "Increase number of Drawing Threads", "threadsup", 84);
    SettingAction a_threadsDown = new SettingAction("Drawing Threads-", "Decrease number of Drawing Threads", "threadsdown", 596);
    SettingAction a_angleThresholdUp = new SettingAction("Angle Correction+", "Increase Threshold for angle correction", "angleup", 78);
    SettingAction a_a_angleThresholdDown = new SettingAction("Angle Correction-", "Decrease Threshold for angle correction", "angledpown", 590);
    public JCheckBoxMenuItem m_viewEditTree;
    public JCheckBoxMenuItem m_viewClades;
    List<ChangeListener> m_changeListeners = new ArrayList<ChangeListener>();

    public void setWaitCursor() {
        if (this.frame != null && this.frame.getCursor().getType() != 3) {
            this.frame.setCursor(new Cursor(3));
        }
    }

    public void setDefaultCursor() {
        if (this.frame != null && this.frame.getCursor().getType() != 0) {
            this.frame.setCursor(new Cursor(0));
        }
    }

    public DensiTree() {
        this.m_gridDrawer = new GridDrawer(this);
        this.m_cladeDrawer = new CladeDrawer(this);
        ++instances;
    }

    public DensiTree(String[] args) {
        this();
        System.out.println(this.banner());
        this.m_bSelection = new boolean[0];
        this.m_nRevOrder = new int[0];
        this.m_cTrees = new Node[0];
        this.m_trees = new Node[0];
        this.initColors();
        this.setSize(1000, 800);
        this.m_Panel = new TreeSetPanel(this);
        this.parseArgs(args);
        this.m_pattern = this.createPattern();
        System.err.println(String.valueOf(this.getSize().width) + "x" + this.getSize().height);
        this.m_jScrollPane = new JScrollPane(this.m_Panel);
        this.makeToolbar();
        this.makeMenuBar();
        this.addComponentListener(this);
        this.setLayout(new BorderLayout());
        this.add((Component)this.m_jScrollPane, "Center");
        this.a_zoomout.setEnabled(false);
        this.a_zoomouttree.setEnabled(false);
        this.m_Panel.setPreferredSize(this.getSize());
        URL tempURL = ClassLoader.getSystemResource("viz/icons/rotate.png");
        if (tempURL != null) {
            try {
                this.m_rotate = ImageIO.read(tempURL);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public Pattern createPattern() {
        String sPattern = "";
        int i = 0;
        while (i < this.m_iPatternForBottom) {
            sPattern = String.valueOf(sPattern) + "[0-9\\.Ee-]+[^0-9]+";
            ++i;
        }
        sPattern = String.valueOf(sPattern) + "([0-9\\.Ee-]+)";
        if (this.m_iPatternForTop > this.m_iPatternForBottom) {
            i = this.m_iPatternForBottom + 1;
            while (i < this.m_iPatternForTop) {
                sPattern = String.valueOf(sPattern) + "[^0-9]+[0-9\\.Ee-]+";
                ++i;
            }
            sPattern = String.valueOf(sPattern) + "[^0-9]+([0-9\\.Ee-]+)";
        }
        return Pattern.compile(sPattern);
    }

    void initColors() {
        this.m_color = new Color[71];
        this.m_color[0] = Color.getColor("color.1", Color.blue);
        this.m_color[1] = Color.getColor("color.2", Color.red);
        this.m_color[2] = Color.getColor("color.3", Color.green);
        this.m_color[3] = Color.getColor("color.default", new Color(0, 100, 25));
        this.m_color[DensiTree.CONSCOLOR] = Color.getColor("color.cons", Color.blue);
        this.m_color[DensiTree.LABELCOLOR] = Color.getColor("color.label", Color.blue);
        this.m_color[DensiTree.HEIGHTCOLOR] = Color.getColor("color.height", Color.gray);
        this.m_color[DensiTree.BGCOLOR] = Color.getColor("color.bg", Color.white);
        this.m_color[DensiTree.GEOCOLOR] = Color.getColor("color.bg", Color.orange);
        this.m_color[DensiTree.ROOTCANALCOLOR] = Color.getColor("color.rootcanal", Color.blue);
        int k = GEOCOLOR + 1;
        this.m_color[k++] = Color.blue;
        this.m_color[k++] = Color.green;
        this.m_color[k++] = Color.red;
        this.m_color[k++] = Color.gray;
        this.m_color[k++] = Color.orange;
        this.m_color[k++] = Color.yellow;
        this.m_color[k++] = Color.pink;
        this.m_color[k++] = Color.black;
        this.m_color[k++] = Color.cyan;
        this.m_color[k++] = Color.darkGray;
        this.m_color[k++] = Color.magenta;
        this.m_color[k++] = new Color(100, 200, 25);
        float saturation = 0.9f;
        while (saturation >= 0.0f) {
            float hue = 0.0f;
            while (hue < 1.0f) {
                this.m_color[k++] = new Color(Color.HSBtoRGB(hue + saturation / 10.0f, saturation, 0.9f));
                hue = (float)((double)hue + 0.1);
            }
            saturation = (float)((double)saturation - 0.2);
        }
    }

    void parseArgs(String[] args) {
        File cfgFile = new File(".densitree");
        if (cfgFile.exists()) {
            ArrayList<String> cfgArgs = new ArrayList<String>();
            try {
                BufferedReader fin = new BufferedReader(new FileReader(cfgFile));
                String sStr = null;
                while (fin.ready()) {
                    sStr = fin.readLine();
                    if (sStr.length() <= 0 || sStr.matches("^\\s*$")) continue;
                    cfgArgs.add(sStr);
                }
                fin.close();
                String[] stringArray = args;
                int n = args.length;
                int n2 = 0;
                while (n2 < n) {
                    String arg = stringArray[n2];
                    cfgArgs.add(arg);
                    ++n2;
                }
                args = cfgArgs.toArray(new String[0]);
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
                System.err.println("WARNING: could not process cfg file");
            }
        }
        int i = 0;
        try {
            while (i < args.length) {
                int iOld = i;
                if (i < args.length - 1) {
                    if (args[i].equals("")) {
                        ++i;
                    } else if (args[i].equals("-c")) {
                        this.m_fCTreeIntensity = Float.parseFloat(args[i + 1]);
                        i += 2;
                    } else if (args[i].equals("-i")) {
                        this.m_fTreeIntensity = Float.parseFloat(args[i + 1]);
                        i += 2;
                    } else if (args[i].equals("-j")) {
                        this.m_nJitter = (int)Float.parseFloat(args[i + 1]);
                        i += 2;
                    } else if (args[i].equals("-w")) {
                        this.m_nCTreeWidth = (int)Float.parseFloat(args[i + 1]);
                        i += 2;
                    } else if (args[i].equals("-v")) {
                        this.m_nTreeWidth = (int)Float.parseFloat(args[i + 1]);
                        i += 2;
                    } else if (args[i].equals("-f")) {
                        this.m_nAnimationDelay = (int)Float.parseFloat(args[i + 1]);
                        i += 2;
                    } else if (args[i].equals("-t")) {
                        this.m_Panel.m_nDrawThreads = (int)Float.parseFloat(args[i + 1]);
                        if (this.m_Panel.m_nDrawThreads < 1) {
                            this.m_Panel.m_nDrawThreads = 1;
                        }
                        i += 2;
                    } else if (args[i].equals("-b")) {
                        this.m_nBurnIn = (int)Float.parseFloat(args[i + 1]);
                        i += 2;
                    } else if (args[i].equals("-geo")) {
                        String[] sStrs = args[i + 1].split("x");
                        int nWidth = Integer.parseInt(sStrs[0]);
                        int nHeight = Integer.parseInt(sStrs[1]);
                        this.setSize(nWidth, nHeight);
                        i += 2;
                    } else if (args[i].equals("-geooffset")) {
                        GEO_OFFSET = Float.parseFloat(args[i + 1]);
                        i += 2;
                    } else if (args[i].equals("-invertLongitude")) {
                        this.m_bInvertLongitude = true;
                        ++i;
                    } else if (args[i].equals("-scalemode")) {
                        String sMode = args[i + 1].toLowerCase();
                        if (sMode.equals("none")) {
                            this.m_gridDrawer.m_nGridMode = GridDrawer.GridMode.NONE;
                        } else if (sMode.equals("short")) {
                            this.m_gridDrawer.m_nGridMode = GridDrawer.GridMode.SHORT;
                        } else if (sMode.equals("full")) {
                            this.m_gridDrawer.m_nGridMode = GridDrawer.GridMode.FULL;
                        } else {
                            throw new Exception("expected scalemode to be NONE, SHORT or FULL");
                        }
                        i += 2;
                    } else if (args[i].equals("-li")) {
                        this.m_fLabelIndent = Float.parseFloat(args[i + 1]);
                        i += 2;
                    } else if (args[i].equals("-o")) {
                        this.m_sOutputFile = args[i + 1];
                        i += 2;
                    } else if (args[i].equals("-kml")) {
                        this.m_sKMLFile = args[i + 1];
                        i += 2;
                    } else if (args[i].equals("-geowidth")) {
                        this.m_nGeoWidth = Integer.parseInt(args[i + 1]);
                        i += 2;
                    } else if (args[i].equals("-geocolor")) {
                        this.m_color[DensiTree.GEOCOLOR] = Color.decode(args[i + 1]);
                        i += 2;
                    } else if (args[i].equals("-bg")) {
                        try {
                            this.loadBGImage(args[i + 1]);
                        }
                        catch (Exception e) {
                            System.err.println("Error loading file: " + e.getMessage());
                            return;
                        }
                        i += 2;
                    } else if (args[i].equals("-bd")) {
                        BranchDrawer bd = (BranchDrawer)Class.forName(args[i + 1]).newInstance();
                        this.m_treeDrawer.setBranchDrawer(bd);
                        i += 2;
                    } else if (args[i].equals("-pattern")) {
                        this.m_sPattern = args[i + 1];
                        i += 2;
                    } else if (args[i].equals("-colorpattern")) {
                        this.m_sColorPattern = args[i + 1];
                        i += 2;
                    } else if (args[i].equals("-linecolortag")) {
                        this.m_lineColorTag = args[i + 1];
                        this.m_lineColorMode = LineColorMode.COLOR_BY_METADATA_TAG;
                        i += 2;
                    } else if (args[i].equals("-linecolorlegend")) {
                        this.m_showLegend = true;
                        ++i;
                    } else if (args[i].equals("-singlechild")) {
                        this.m_bAllowSingleChild = Boolean.parseBoolean(args[i + 1]);
                        i += 2;
                    } else if (args[i].equals("-rotatetext")) {
                        this.m_bRotateTextWhenRootAtTop = true;
                        ++i;
                    } else if (args[i].equals("-transform")) {
                        this.m_bUseLogScale = true;
                        this.m_fExponent = Double.parseDouble(args[i + 1]);
                        i += 2;
                    } else if (args[i].equals("-allowLeafsToBeMovedIKnowThisMessesUpInternalCladePositions")) {
                        this.m_bLeafCladeSelection = true;
                        ++i;
                    } else if (args[i].equals("-optfile")) {
                        this.m_sOptFile = args[i + 1];
                        i += 2;
                    } else if (args[i].equals("-rootcanaltree")) {
                        try {
                            this.m_iOptTree = Integer.parseInt(args[i + 1]);
                        }
                        catch (NumberFormatException e) {
                            this.m_sOptTree = args[i + 1];
                        }
                        i += 2;
                    } else if (args[i].equals("-rawrootcanaltree")) {
                        this.m_sOptTree = args[i + 1];
                        this.m_bOptimiseRootCanalTree = false;
                        i += 2;
                    } else if (args[i].equals("-asPDF")) {
                        this.m_asPDF = args[i + 1];
                        i += 2;
                    } else if (args[i].equals("-cladeThreshold")) {
                        this.m_cladeThreshold = Double.parseDouble(args[i + 1]);
                        i += 2;
                    }
                    if (i != iOld) continue;
                    if (new File(args[i]).exists()) {
                        this.init(args[i++]);
                        this.calcLines();
                        if (i != args.length) {
                            String[] args2 = new String[args.length - 1];
                            int k = 0;
                            while (k < i - 1) {
                                args2[k] = args[k];
                                ++k;
                            }
                            k = i;
                            while (k < args.length) {
                                args2[k - 1] = args[k];
                                ++k;
                            }
                            DensiTree.startNew(args2);
                        }
                        return;
                    }
                    throw new Exception("Wrong argument");
                }
                this.init(args[i++]);
                this.calcLines();
            }
            if (this.m_asPDF != null) {
                new Thread(){

                    @Override
                    public void run() {
                        try {
                            Thread.sleep(5000L);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        while (!DensiTree.this.m_bMetaDataReady) {
                            try {
                                Thread.sleep(100L);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        DensiTree.this.exportPDF(DensiTree.this.m_asPDF);
                        System.exit(0);
                    }
                }.start();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, "Error parsing command line arguments: " + Arrays.toString(args) + "\nArguments ignored\n\n" + this.getStatus(), "Argument Parsing Error", -1);
        }
    }

    String banner() {
        return "DensiTree - Tree Set Visualizer\nVersion 2.2.6\n\nRemco Bouckaert\nremco@cs.auckland.ac.nz\nrrb@xm.co.nz\n(c) 2010-2015\n\n\nKey shortcuts:\nc/Ctrl-c decrease/increase consensus tree intensity\ni/Ctrl-i decrease/increase tree intensity\nj/Ctrl-j decrease/increase jitter on trees (not consensus trees)\nw/Ctrl-w decrease/increase consensus tree line width\nv/Ctrl-v decrease/increase tree line width\nf/Ctrl-f decrease/increase animation time delay - shorter delay = faster animation\nt/Ctrl-t decrease/increase number of drawing threads for drawing tree set\n\nArrow keys & Page-Up/Down to scroll\n";
    }

    String formatColor(int iColor) {
        return " 0x" + Integer.toHexString(this.m_color[iColor].getRGB()).substring(2) + ' ';
    }

    String getStatus() {
        return "\n\nCurrent status:\n" + this.m_trees.length + " trees with " + this.m_cTrees.length + " topologies\n" + "Tree intensity: " + this.m_fTreeIntensity + "\n" + "Consensus Tree intensity: " + this.m_fCTreeIntensity + "\n" + "Tree width: " + this.m_nTreeWidth + "\n" + "Consensus Tree width: " + this.m_nCTreeWidth + "\n" + "Jitter: " + this.m_nJitter + "\n" + "Animation delay: " + this.m_nAnimationDelay + "\n" + "Height: " + this.m_fHeight + "\n" + "Zoom: " + this.m_fScale + "\n" + "Number of drawing threads: " + this.m_Panel.m_nDrawThreads + "\n" + "Burn in: " + this.m_nBurnIn + "\n\nColor 1:" + this.formatColor(0) + "\tColor 2:" + this.formatColor(1) + "\tColor 3:" + this.formatColor(2) + "\tDefault Color:" + this.formatColor(3) + "\nConsensus Color:" + this.formatColor(CONSCOLOR) + "\tLabel color:" + this.formatColor(LABELCOLOR) + "\tBackground color:" + this.formatColor(BGCOLOR) + "\tHeight color:" + this.formatColor(HEIGHTCOLOR);
    }

    public void init(String sFile) throws Exception {
        if (this.m_Panel != null) {
            this.setWaitCursor();
        }
        if (this.m_jStatusBar != null) {
            this.m_jStatusBar.setText("Initializing...");
            this.m_jStatusBar.repaint();
        }
        this.m_sFileName = sFile;
        this.m_bInitializing = true;
        this.m_viewMode = ViewMode.DRAW;
        this.a_animateStart.setIcon("start");
        this.m_prevLineColorMode = null;
        LineColorMode orgLineColorMode = this.m_lineColorMode;
        this.m_lineColorMode = LineColorMode.DEFAULT;
        this.m_prevLineWidthMode = null;
        this.m_lineWidthMode = LineWidthMode.DEFAULT;
        System.err.print("Initializing...");
        this.m_iAnimateTree = 0;
        this.m_fHeight = 0.0f;
        this.m_fScaleX = 10.0f;
        this.m_fScaleY = 10.0f;
        this.m_fScale = 1.0f;
        this.m_fTreeScale = 1.0f;
        this.m_fTreeOffset = 0.0f;
        this.m_doActions = new Vector();
        this.m_iUndo = 0;
        this.m_random = new Random();
        this.m_Panel.m_drawThread = new Thread[this.m_Panel.m_nDrawThreads];
        this.m_rootcanaltree = null;
        try {
            if (this.thread != null) {
                try {
                    this.thread.stop();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.m_sLabels = new Vector();
            this.m_fLongitude = new Vector();
            this.m_fLatitude = new Vector();
            this.m_fMinLat = 360.0f;
            this.m_fMinLong = 360.0f;
            this.m_fMaxLat = 0.0f;
            this.m_fMaxLong = 0.0f;
            this.m_nOrder = null;
            TreeFileParser parser = new TreeFileParser(this);
            this.m_trees = parser.parseFile(sFile);
            this.m_nBurnIn = parser.m_nBurnIn;
            if (this.m_iOptTree >= 0) {
                this.m_optTree = this.m_trees[this.m_iOptTree - this.m_nBurnIn];
            }
            this.a_loadkml.setEnabled(true);
            float fOffset = GEO_OFFSET;
            this.m_fMaxLong = parser.m_fMaxLong + fOffset;
            this.m_fMaxLat = parser.m_fMaxLat + fOffset;
            this.m_fMinLong = parser.m_fMinLong - fOffset;
            this.m_fMinLat = parser.m_fMinLat - fOffset;
            this.m_nNrOfLabels = parser.m_nNrOfLabels;
            if (this.m_trees.length == 0) {
                this.m_sLabels = null;
                JOptionPane.showMessageDialog(null, "No trees found in file\nMaybe burn in is too large?", "Help Message", -1);
                return;
            }
            this.m_bSelection = new boolean[this.m_sLabels.size()];
            this.m_bLabelRectangle = new java.awt.Rectangle[this.m_sLabels.size()];
            this.m_bGeoRectangle = new java.awt.Rectangle[this.m_sLabels.size()];
            int i = 0;
            while (i < this.m_bSelection.length) {
                this.m_bSelection[i] = true;
                this.m_bLabelRectangle[i] = new java.awt.Rectangle();
                this.m_bGeoRectangle[i] = new java.awt.Rectangle();
                ++i;
            }
            this.m_bSelectionChanged = false;
            double fMinRootLength = Double.MAX_VALUE;
            int i2 = 0;
            while (i2 < this.m_trees.length) {
                fMinRootLength = Math.min(fMinRootLength, (double)this.m_trees[i2].m_fLength);
                ++i2;
            }
            i2 = 0;
            while (i2 < this.m_trees.length) {
                this.m_trees[i2].m_fLength = (float)((double)this.m_trees[i2].m_fLength - fMinRootLength);
                ++i2;
            }
            float[] fHeights = new float[this.m_trees.length];
            int i3 = 0;
            while (i3 < this.m_trees.length) {
                fHeights[i3] = this.positionHeight(this.m_trees[i3], 0.0f);
                this.m_fHeight = Math.max(this.m_fHeight, fHeights[i3]);
                ++i3;
            }
            i3 = 0;
            while (i3 < this.m_trees.length) {
                this.offsetHeight(this.m_trees[i3], this.m_fHeight - fHeights[i3]);
                ++i3;
            }
            this.m_nTopology = new int[this.m_trees.length];
            HashMap<String, Integer> map = new HashMap<String, Integer>();
            int i4 = 0;
            while (i4 < this.m_trees.length) {
                Node tree = this.m_trees[i4];
                String sNewick = tree.toShortNewick();
                if (map.containsKey(sNewick)) {
                    this.m_nTopology[i4] = (Integer)map.get(sNewick);
                } else {
                    this.m_nTopology[i4] = map.size();
                    map.put(sNewick, map.size());
                }
                ++i4;
            }
            this.m_nTopologies = map.size();
            int[] nTopologies = new int[this.m_nTopologies];
            int i5 = 0;
            while (i5 < this.m_trees.length) {
                int n = this.m_nTopology[i5];
                nTopologies[n] = nTopologies[n] + 1;
                ++i5;
            }
            i5 = 0;
            while (i5 < this.m_trees.length) {
                int j = i5 + 1;
                while (j < this.m_trees.length) {
                    if (nTopologies[this.m_nTopology[i5]] < nTopologies[this.m_nTopology[j]] || nTopologies[this.m_nTopology[i5]] == nTopologies[this.m_nTopology[j]] && this.m_nTopology[i5] > this.m_nTopology[j]) {
                        int h = this.m_nTopology[j];
                        this.m_nTopology[j] = this.m_nTopology[i5];
                        this.m_nTopology[i5] = h;
                        Node tree = this.m_trees[j];
                        this.m_trees[j] = this.m_trees[i5];
                        this.m_trees[i5] = tree;
                    }
                    ++j;
                }
                ++i5;
            }
            Node tree = this.m_trees[0];
            this.m_nOrder = new int[this.m_sLabels.size()];
            this.m_nRevOrder = new int[this.m_sLabels.size()];
            this.initOrder(tree, 0);
            int nSum = 0;
            int i6 = 0;
            while (i6 < this.m_nOrder.length) {
                nSum += this.m_nOrder[i6];
                ++i6;
            }
            if (nSum != this.m_nNrOfLabels * (this.m_nNrOfLabels - 1) / 2) {
                JOptionPane.showMessageDialog(this, "The tree set possibly contains non-binary trees. Expect that not all nodes are shown.");
            }
            i6 = 0;
            int iOld = 0;
            int iConsTree = 0;
            this.m_fTreeWeight = new float[this.m_nTopologies];
            this.m_cTrees = new Node[this.m_nTopologies];
            while (i6 < this.m_trees.length) {
                Node consensusTree = tree = this.m_trees[i6].copy();
                ++i6;
                while (i6 < this.m_trees.length && this.m_nTopology[i6] == this.m_nTopology[i6 - 1]) {
                    tree = this.m_trees[i6];
                    this.addLength(tree, consensusTree);
                    ++i6;
                }
                this.divideLength(consensusTree, i6 - iOld);
                this.m_fTreeWeight[iConsTree] = (float)((double)(i6 - iOld) + 0.0) / (float)this.m_trees.length;
                float fHeight = this.positionHeight(consensusTree, 0.0f);
                this.offsetHeight(consensusTree, this.m_fHeight - fHeight);
                this.m_cTrees[iConsTree] = consensusTree;
                ++iConsTree;
                iOld = i6;
            }
            this.m_nTopologyByPopularity = new int[this.m_trees.length];
            int nColor = 0;
            this.m_nTopologyByPopularity[0] = 0;
            i6 = 1;
            while (i6 < this.m_trees.length) {
                if (this.m_nTopology[i6] != this.m_nTopology[i6 - 1]) {
                    // empty if block
                }
                this.m_nTopologyByPopularity[i6] = ++nColor;
                ++i6;
            }
            this.m_fLinesX = new float[this.m_trees.length][];
            this.m_fLinesY = new float[this.m_trees.length][];
            this.m_fCLinesX = new float[this.m_nTopologies][];
            this.m_fCLinesY = new float[this.m_nTopologies][];
            this.m_bCladesReady = false;
            this.reshuffle(-3);
            this.calcPositions();
            this.m_bMetaDataReady = false;
            this.thread = new Thread(){

                @Override
                public void run() {
                    DensiTree.this.m_jStatusBar.setText("Calculating clades");
                    DensiTree.this.calcClades();
                    DensiTree.this.m_bCladesReady = true;
                    DensiTree.this.m_jStatusBar.setText("Optimising node order");
                    int[] oldOrder = (int[])DensiTree.this.m_nOrder.clone();
                    if (!DensiTree.this.m_bAllowSingleChild) {
                        DensiTree.this.reshuffle(8);
                        DensiTree.this.calcPositions();
                        DensiTree.this.calcLines();
                        DensiTree.this.notifyChangeListeners();
                        if (DensiTree.this.orderChanged(oldOrder)) {
                            System.err.println("Node order changed");
                            DensiTree.this.makeDirty();
                        }
                    }
                    String statusMsg = "Parsing metadata";
                    int k = 0;
                    while (k < DensiTree.this.m_trees.length) {
                        this.parseMetaData(DensiTree.this.m_trees[k]);
                        if (k % 100 == 0) {
                            statusMsg = String.valueOf(statusMsg) + ".";
                            DensiTree.this.m_jStatusBar.setText(statusMsg);
                            DensiTree.this.setWaitCursor();
                        }
                        ++k;
                    }
                    DensiTree.this.m_metaDataTags = new ArrayList<String>();
                    DensiTree.this.m_metaDataTypes = new ArrayList<MetaDataType>();
                    DensiTree.this.collectMetaDataTags(DensiTree.this.m_trees[0]);
                    if (DensiTree.this.m_metaDataTags.size() > 0) {
                        DensiTree.this.calcPositions();
                        DensiTree.this.calcLines();
                        DensiTree.this.makeDirty();
                    }
                    DensiTree.this.m_bMetaDataReady = true;
                    DensiTree.this.notifyChangeListeners();
                    DensiTree.this.m_jStatusBar.setText("Done parsing metadata");
                    DensiTree.this.thread = null;
                }

                private void parseMetaData(Node node) {
                    node.parseMetaData();
                    if (!node.isLeaf()) {
                        this.parseMetaData(node.m_left);
                        if (node.m_right != null) {
                            this.parseMetaData(node.m_right);
                        }
                    }
                }
            };
            this.thread.start();
            this.m_metaDataTags = new ArrayList<String>();
            this.m_metaDataTypes = new ArrayList<MetaDataType>();
            this.collectMetaDataTags(this.m_trees[0]);
            this.notifyChangeListeners();
            if (orgLineColorMode != LineColorMode.DEFAULT) {
                while (!this.m_bMetaDataReady) {
                    Thread.sleep(100L);
                }
                this.m_lineColorMode = orgLineColorMode;
                this.calcColors(false);
                this.makeDirty();
            }
        }
        catch (OutOfMemoryError e) {
            this.clear();
            JOptionPane.showMessageDialog(null, "Not enough memory is reserved for java to process this tree. Try starting DensiTree with more memory\n\n(for example use:\njava -Xmx3g DensiTree.jar\nfrom the command line) where DensiTree is in the path\nor subsample your tree set to create a smaller tree file.");
            this.setDefaultCursor();
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.clear();
            this.setDefaultCursor();
            throw e;
        }
        this.m_bInitializing = false;
        if (this.m_sColorPattern != null) {
            this.calcColorPattern();
        }
        this.addAction(new DoAction());
        if (this.frame != null) {
            this.frame.setTitle("DensiTree - Tree Set Visualizer " + sFile);
        }
        if (this.m_sKMLFile != null) {
            this.loadKML();
        }
        System.err.println("Done");
    }

    void notifyChangeListeners() {
        for (ChangeListener listener : this.m_changeListeners) {
            listener.stateChanged(null);
        }
    }

    private boolean orderChanged(int[] oldOrder) {
        int i = 0;
        while (i < oldOrder.length) {
            if (oldOrder[i] != this.m_nOrder[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void collectMetaDataTags(Node node) {
        Map<String, Object> metaDataMap = node.getMetaDataSet();
        if (metaDataMap != null) {
            for (String key : metaDataMap.keySet()) {
                if (this.m_metaDataTags.contains(key)) continue;
                this.m_metaDataTags.add(key);
                Object o = metaDataMap.get(key);
                if (o instanceof Double) {
                    this.m_metaDataTypes.add(MetaDataType.NUMERIC);
                    continue;
                }
                String s = o.toString();
                if (s.length() > 0 && s.charAt(0) == '{') {
                    this.m_metaDataTypes.add(MetaDataType.SET);
                    continue;
                }
                this.m_metaDataTypes.add(MetaDataType.STRING);
            }
        }
        if (!node.isLeaf()) {
            this.collectMetaDataTags(node.m_left);
            if (node.m_right != null) {
                this.collectMetaDataTags(node.m_right);
            }
        }
    }

    private void calcClades() {
        if (this.m_bAllowSingleChild) {
            return;
        }
        this.m_clades = new ArrayList<int[]>();
        this.m_cladeWeight = new ArrayList<Double>();
        this.m_cladeHeight = new ArrayList<Double>();
        this.m_cladeHeight95HPDup = new ArrayList<Double>();
        this.m_cladeHeight95HPDdown = new ArrayList<Double>();
        this.m_cladeHeightSetBottom = new ArrayList<List<Double>>();
        this.m_cladeHeightSetTop = new ArrayList<List<Double>>();
        this.m_cladeChildren = new ArrayList<List<ChildClade>>();
        this.mapCladeToIndex = new HashMap<String, Integer>();
        int i = 0;
        while (i < this.m_nNrOfLabels) {
            int[] clade = new int[]{i++};
            this.m_clades.add(clade);
            this.m_cladeWeight.add(1.0);
            this.m_cladeHeight.add(0.0);
            this.m_cladeHeight95HPDup.add(0.0);
            this.m_cladeHeight95HPDdown.add(0.0);
            this.m_cladeHeightSetBottom.add(new ArrayList());
            this.m_cladeHeightSetTop.add(new ArrayList());
            this.m_cladeChildren.add(new ArrayList());
            this.mapCladeToIndex.put(Arrays.toString(clade), this.mapCladeToIndex.size());
        }
        i = 0;
        while (i < this.m_cTrees.length) {
            this.calcCladeForNode(this.m_cTrees[i], this.mapCladeToIndex, this.m_fTreeWeight[i], this.m_cTrees[i].m_fPosY);
            ++i;
        }
        i = 0;
        while (i < this.m_trees.length) {
            this.calcCladeForNode2(this.m_trees[i], this.mapCladeToIndex, 1.0 / (double)this.m_trees.length, this.m_trees[i].m_fPosY);
            ++i;
        }
        i = 0;
        while (i < this.m_cladeHeight.size()) {
            this.m_cladeHeight.set(i, this.m_cladeHeight.get(i) / this.m_cladeWeight.get(i));
            ++i;
        }
        i = 0;
        while (i < this.m_cladeHeight.size()) {
            ArrayList heights = new ArrayList();
            heights.addAll(this.m_cladeHeightSetBottom.get(i));
            Collections.sort(heights);
            int upIndex = heights.size() * 190 / 200;
            int downIndex = heights.size() * 5 / 200;
            this.m_cladeHeight95HPDup.set(i, (Double)heights.get(upIndex));
            this.m_cladeHeight95HPDdown.set(i, (Double)heights.get(downIndex));
            ++i;
        }
        double fHeight0 = this.m_fHeight;
        int i2 = 0;
        while (i2 < this.m_cladeHeight.size()) {
            fHeight0 = Math.min(fHeight0, this.m_cladeHeight.get(i2));
            ++i2;
        }
        this.m_cladePosition = new float[this.m_clades.size()];
        Integer[] index = new Integer[this.m_cladePosition.length];
        int i3 = 0;
        while (i3 < this.m_cladePosition.length) {
            index[i3] = i3;
            ++i3;
        }
        Arrays.sort(index, new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                if (Math.abs(DensiTree.this.m_cladeWeight.get(o1) - DensiTree.this.m_cladeWeight.get(o2)) < DensiTree.this.m_cladeThreshold) {
                    return (int)Math.signum(DensiTree.this.m_clades.get(o1).length - DensiTree.this.m_clades.get(o2).length);
                }
                return -Double.compare(DensiTree.this.m_cladeWeight.get(o1), DensiTree.this.m_cladeWeight.get(o2));
            }
        });
        ArrayList<int[]> clades = new ArrayList<int[]>();
        ArrayList<Double> cladeWeight = new ArrayList<Double>();
        ArrayList<Double> cladeHeight = new ArrayList<Double>();
        ArrayList<Double> cladeHeight95HPDup = new ArrayList<Double>();
        ArrayList<Double> cladeHeight95HPDdown = new ArrayList<Double>();
        ArrayList<List<Double>> cladeHeightSetBottom = new ArrayList<List<Double>>();
        ArrayList<List<Double>> cladeHeightSetTop = new ArrayList<List<Double>>();
        ArrayList<List<ChildClade>> cladeChildren = new ArrayList<List<ChildClade>>();
        int i4 = 0;
        while (i4 < this.m_cladePosition.length) {
            clades.add(this.m_clades.get(index[i4]));
            cladeWeight.add(this.m_cladeWeight.get(index[i4]));
            cladeHeight.add(this.m_cladeHeight.get(index[i4]));
            cladeHeight95HPDdown.add(this.m_cladeHeight95HPDdown.get(index[i4]));
            cladeHeight95HPDup.add(this.m_cladeHeight95HPDup.get(index[i4]));
            cladeChildren.add(this.m_cladeChildren.get(index[i4]));
            cladeHeightSetBottom.add(this.m_cladeHeightSetBottom.get(index[i4]));
            cladeHeightSetTop.add(this.m_cladeHeightSetTop.get(index[i4]));
            ++i4;
        }
        this.m_clades = clades;
        this.m_cladeWeight = cladeWeight;
        this.m_cladeHeight = cladeHeight;
        this.m_cladeHeight95HPDdown = cladeHeight95HPDdown;
        this.m_cladeHeight95HPDup = cladeHeight95HPDup;
        this.m_cladeChildren = cladeChildren;
        this.m_cladeHeightSetBottom = cladeHeightSetBottom;
        this.m_cladeHeightSetTop = cladeHeightSetTop;
        this.reverseindex = new Integer[this.m_cladePosition.length];
        i4 = 0;
        while (i4 < this.m_cladePosition.length) {
            this.reverseindex[index[i4].intValue()] = i4;
            ++i4;
        }
        i4 = 0;
        while (i4 < this.m_cladePosition.length) {
            List<ChildClade> list = this.m_cladeChildren.get(i4);
            for (ChildClade childClade : list) {
                childClade.m_iLeft = this.reverseindex[childClade.m_iLeft];
                childClade.m_iRight = this.reverseindex[childClade.m_iRight];
            }
            ++i4;
        }
        i4 = 0;
        while (i4 < this.m_cTrees.length) {
            this.resetCladeNr(this.m_cTrees[i4], this.reverseindex);
            ++i4;
        }
        i4 = 0;
        while (i4 < this.m_trees.length) {
            this.setCladeNr(this.m_trees[i4], this.m_cTrees[this.m_nTopologyByPopularity[i4]]);
            ++i4;
        }
        this.m_cladePairs = new HashMap<Integer, Double>();
        i4 = 0;
        while (i4 < this.m_cTrees.length) {
            this.calcCladePairs(this.m_cTrees[i4], this.m_fTreeWeight[i4]);
            ++i4;
        }
        int iMaxCladeProbTopology = 0;
        double fMaxCladeProb = this.cladeProb(this.m_cTrees[0], true);
        double fMaxMinCladeProb = this.cladeProb(this.m_cTrees[0], false);
        double fMaxCCDProb = this.CCDProb(this.m_cTrees[0]);
        int i5 = 1;
        while (i5 < this.m_cTrees.length) {
            double fCladeProb = this.cladeProb(this.m_cTrees[i5], true);
            if (fCladeProb > fMaxCladeProb) {
                iMaxCladeProbTopology = i5;
                fMaxCladeProb = fCladeProb;
            }
            ++i5;
        }
        i5 = 1;
        while (i5 < this.m_cTrees.length) {
            double fMinCladeProb = this.cladeProb(this.m_cTrees[i5], false);
            if (fMinCladeProb > fMaxMinCladeProb) {
                fMaxMinCladeProb = fMinCladeProb;
            }
            ++i5;
        }
        i5 = 1;
        while (i5 < this.m_cTrees.length) {
            double fCCDProb = this.CCDProb(this.m_cTrees[i5]);
            if (fCCDProb > fMaxCCDProb) {
                fMaxCCDProb = fCCDProb;
            }
            ++i5;
        }
        this.m_summaryTree = new ArrayList<Node>();
        this.m_summaryTree.add(this.m_cTrees[iMaxCladeProbTopology].copy());
        this.cleanUpSummaryTree(this.m_summaryTree.get(0));
        if (this.m_bOptimiseRootCanalTree) {
            BranchLengthOptimiser optimiser = new BranchLengthOptimiser(this);
            optimiser.optimiseScore(this.m_summaryTree.get(0));
        }
        float fHeight = this.positionHeight(this.m_summaryTree.get(0), 0.0f);
        this.offsetHeight(this.m_summaryTree.get(0), this.m_fHeight - fHeight);
        this.updateCladeModel();
        if (this.m_sOptTree != null) {
            TreeFileParser parser = new TreeFileParser(this.m_sLabels, null, null, 0);
            try {
                Node tree = parser.parseNewick(this.m_sOptTree);
                tree.sort();
                tree.labelInternalNodes(this.m_nNrOfLabels);
                float fTreeHeight = this.positionHeight(tree, 0.0f);
                this.offsetHeight(tree, this.m_fHeight - fTreeHeight);
                this.calcCladeIDForNode(tree, this.mapCladeToIndex);
                this.resetCladeNr(tree, this.reverseindex);
                this.m_summaryTree.add(tree);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.m_optTree != null) {
            this.m_summaryTree.add(this.m_optTree.copy());
        }
        this.m_rootcanaltree = this.m_summaryTree.get(0);
        this.m_cladeHeightSetBottom = null;
        this.m_cladeHeightSetTop = null;
    }

    public void updateCladeModel() {
        this.m_cladelistmodel.clear();
        List<String> list = this.cladesToString();
        int i = 0;
        while (i < list.size()) {
            this.m_cladelistmodel.add(i, list.get(i));
            ++i;
        }
    }

    private void calcCladePairs(Node node, double fWeight) {
        if (!node.isLeaf()) {
            this.calcCladePairs(node.m_left, fWeight);
            this.calcCladePairs(node.m_right, fWeight);
            int iCladeLeft = Math.min(node.m_left.m_iClade, node.m_right.m_iClade);
            int iCladeRight = Math.max(node.m_left.m_iClade, node.m_right.m_iClade);
            Integer i = (iCladeRight << 16) + iCladeLeft;
            if (!this.m_cladePairs.containsKey(i)) {
                this.m_cladePairs.put(i, fWeight);
            } else {
                this.m_cladePairs.put(i, this.m_cladePairs.get(i) + fWeight);
            }
        }
    }

    private void cleanUpSummaryTree(Node summaryTree) {
        this.setHeightByClade(summaryTree);
        summaryTree.m_fLength = (float)((double)this.m_fHeight - this.m_cladeHeight.get(summaryTree.m_iClade));
        float fHeight = this.positionHeight(summaryTree, 0.0f);
        this.offsetHeight(summaryTree, this.m_fHeight - fHeight);
    }

    private int[] mergeClades(int[] cladeLeft, int[] cladeRight) {
        int[] clade = new int[cladeLeft.length + cladeRight.length];
        int iLeft = 0;
        int iRight = 0;
        int i = 0;
        while (i < clade.length) {
            clade[i] = iLeft == cladeLeft.length ? cladeRight[iRight++] : (iRight == cladeRight.length ? cladeLeft[iLeft++] : (cladeRight[iRight] > cladeLeft[iLeft] ? cladeLeft[iLeft++] : cladeRight[iRight++]));
            ++i;
        }
        return clade;
    }

    private void setHeightByClade(Node node) {
        if (!node.isRoot()) {
            node.m_fLength = (float)(this.m_cladeHeight.get(node.m_iClade) - this.m_cladeHeight.get(node.getParent().m_iClade));
        }
        if (!node.isLeaf()) {
            this.setHeightByClade(node.m_left);
            this.setHeightByClade(node.m_right);
        }
    }

    void resetCladeSelection() {
        this.m_bAllowCladeSelection = false;
        this.m_cladelist.clearSelection();
        for (int i : this.m_cladeSelection) {
            this.m_cladelist.addSelectionInterval(i, i);
            if (this.m_cladeSelection.size() != 1) continue;
            this.m_cladelist.ensureIndexIsVisible(i);
        }
        if (this.m_cladeSelection.size() > 0) {
            Arrays.fill(this.m_bSelection, false);
            for (int i : this.m_cladeSelection) {
                int j = 0;
                while (j < this.m_clades.get(i).length) {
                    this.m_bSelection[this.m_clades.get((int)i)[j]] = true;
                    ++j;
                }
            }
        }
        this.m_bAllowCladeSelection = true;
    }

    public void resetCladeNr(Node node, Integer[] reverseindex) {
        node.m_iClade = reverseindex[node.m_iClade];
        if (!node.isLeaf()) {
            this.resetCladeNr(node.m_left, reverseindex);
            this.resetCladeNr(node.m_right, reverseindex);
        }
    }

    List<String> cladesToString() {
        ArrayList<String> list = new ArrayList<String>();
        DecimalFormat format = new DecimalFormat("###.##");
        int i = 0;
        while (i < this.m_cladePosition.length) {
            if (this.m_cladeWeight.get(i) >= this.m_smallestCladeSupport) {
                String sStr = "";
                sStr = String.valueOf(sStr) + format.format(this.m_cladeWeight.get(i) * 100.0) + "% ";
                sStr = String.valueOf(sStr) + format.format(((double)this.m_fHeight - this.m_cladeHeight95HPDup.get(i)) * (double)this.m_fUserScale) + " ";
                sStr = String.valueOf(sStr) + format.format(((double)this.m_fHeight - this.m_cladeHeight95HPDdown.get(i)) * (double)this.m_fUserScale) + " ";
                sStr = String.valueOf(sStr) + "[";
                int j = 0;
                j = 0;
                while (j < this.m_clades.get(i).length - 1) {
                    sStr = String.valueOf(sStr) + this.m_sLabels.get(this.m_clades.get(i)[j]) + ",";
                    ++j;
                }
                sStr = String.valueOf(sStr) + this.m_sLabels.get(this.m_clades.get(i)[j]) + "]\n";
                list.add(sStr);
            }
            ++i;
        }
        return list;
    }

    private double cladeProb(Node node, boolean useProduct) {
        if (node.isLeaf()) {
            return 1.0;
        }
        double fCladeProb = this.m_cladeWeight.get(node.m_iClade);
        if (useProduct) {
            fCladeProb *= this.cladeProb(node.m_left, useProduct);
            fCladeProb *= this.cladeProb(node.m_right, useProduct);
        } else {
            fCladeProb = Math.min(fCladeProb, this.cladeProb(node.m_left, useProduct));
            fCladeProb = Math.min(fCladeProb, this.cladeProb(node.m_right, useProduct));
        }
        return fCladeProb;
    }

    private double CCDProb(Node node) {
        if (node.isLeaf()) {
            return 1.0;
        }
        int iCladeLeft = Math.min(node.m_left.m_iClade, node.m_right.m_iClade);
        int iCladeRight = Math.max(node.m_left.m_iClade, node.m_right.m_iClade);
        Integer i = (iCladeRight << 16) + iCladeLeft;
        Double f = this.m_cladePairs.get(i);
        if (f == null) {
            f = this.m_cladePairs.get(i);
        }
        double fCladeProb = f;
        fCladeProb *= this.CCDProb(node.m_left);
        return fCladeProb *= this.CCDProb(node.m_right);
    }

    private void setCladeNr(Node node, Node node2) {
        if (node2 == null) {
            throw new RuntimeException("node2 cannot be null");
        }
        if (!node.isLeaf()) {
            node.m_iClade = node2.m_iClade;
            this.setCladeNr(node.m_left, node2.m_left);
            this.setCladeNr(node.m_right, node2.m_right);
        }
    }

    private int[] calcCladeForNode(Node node, Map<String, Integer> mapCladeToIndex, double fWeight, double fHeight) {
        int[] cladeRight;
        if (node.isLeaf()) {
            int[] clade = new int[]{node.getNr()};
            node.m_iClade = node.getNr();
            this.m_cladeHeight.set(node.m_iClade, this.m_cladeHeight.get(node.m_iClade) + fWeight * fHeight);
            return clade;
        }
        int[] cladeLeft = this.calcCladeForNode(node.m_left, mapCladeToIndex, fWeight, fHeight + (double)node.m_left.m_fLength);
        int[] clade = this.mergeClades(cladeLeft, cladeRight = this.calcCladeForNode(node.m_right, mapCladeToIndex, fWeight, fHeight + (double)node.m_right.m_fLength));
        String sClade = Arrays.toString(clade);
        if (!mapCladeToIndex.containsKey(sClade)) {
            mapCladeToIndex.put(sClade, mapCladeToIndex.size());
            this.m_clades.add(clade);
            this.m_cladeWeight.add(0.0);
            this.m_cladeHeight.add(0.0);
            this.m_cladeHeight95HPDup.add(0.0);
            this.m_cladeHeight95HPDdown.add(0.0);
            this.m_cladeHeightSetBottom.add(new ArrayList());
            this.m_cladeHeightSetTop.add(new ArrayList());
            this.m_cladeChildren.add(new ArrayList());
        }
        int iClade = mapCladeToIndex.get(sClade);
        this.m_cladeWeight.set(iClade, this.m_cladeWeight.get(iClade) + fWeight);
        this.m_cladeHeight.set(iClade, this.m_cladeHeight.get(iClade) + fWeight * fHeight);
        node.m_iClade = iClade;
        int iCladeLeft = Math.min(node.m_left.m_iClade, node.m_right.m_iClade);
        int iCladeRight = Math.max(node.m_left.m_iClade, node.m_right.m_iClade);
        List<ChildClade> children = this.m_cladeChildren.get(iClade);
        boolean bFound = false;
        for (ChildClade child : children) {
            if (child.m_iLeft != iCladeLeft || child.m_iRight != iCladeRight) continue;
            child.m_fWeight += fWeight;
            bFound = true;
            break;
        }
        if (!bFound) {
            ChildClade child;
            child = new ChildClade();
            child.m_iLeft = iCladeLeft;
            child.m_iRight = iCladeRight;
            child.m_fWeight = fWeight;
            this.m_cladeChildren.get(iClade).add(child);
        }
        return clade;
    }

    private int[] calcCladeForNode2(Node node, Map<String, Integer> mapCladeToIndex, double fWeight, double fHeight) {
        if (node.isLeaf()) {
            int[] clade = new int[]{node.getNr()};
            node.m_iClade = node.getNr();
            this.m_cladeHeightSetBottom.get(node.m_iClade).add(fHeight);
            this.m_cladeHeightSetTop.get(node.m_iClade).add(fHeight - (double)node.m_fLength);
            return clade;
        }
        int[] cladeLeft = this.calcCladeForNode2(node.m_left, mapCladeToIndex, fWeight, fHeight + (double)node.m_left.m_fLength);
        int[] cladeRight = this.calcCladeForNode2(node.m_right, mapCladeToIndex, fWeight, fHeight + (double)node.m_right.m_fLength);
        int[] clade = new int[cladeLeft.length + cladeRight.length];
        int iLeft = 0;
        int iRight = 0;
        int i = 0;
        while (i < clade.length) {
            clade[i] = iLeft == cladeLeft.length ? cladeRight[iRight++] : (iRight == cladeRight.length ? cladeLeft[iLeft++] : (cladeRight[iRight] > cladeLeft[iLeft] ? cladeLeft[iLeft++] : cladeRight[iRight++]));
            ++i;
        }
        String sClade = Arrays.toString(clade);
        int iClade = mapCladeToIndex.get(sClade);
        this.m_cladeHeightSetBottom.get(iClade).add(fHeight);
        this.m_cladeHeightSetTop.get(iClade).add(fHeight - (double)node.m_fLength);
        node.m_iClade = iClade;
        int iCladeLeft = Math.min(node.m_left.m_iClade, node.m_right.m_iClade);
        int iCladeRight = Math.max(node.m_left.m_iClade, node.m_right.m_iClade);
        List<ChildClade> children = this.m_cladeChildren.get(iClade);
        boolean bFound = false;
        for (ChildClade child : children) {
            if (child.m_iLeft != iCladeLeft || child.m_iRight != iCladeRight) continue;
            child.m_fWeight += fWeight;
            bFound = true;
            break;
        }
        if (!bFound) {
            ChildClade child;
            child = new ChildClade();
            child.m_iLeft = iCladeLeft;
            child.m_iRight = iCladeRight;
            child.m_fWeight = fWeight;
            this.m_cladeChildren.get(iClade).add(child);
        }
        return clade;
    }

    public int[] calcCladeIDForNode(Node node, Map<String, Integer> mapCladeToIndex) {
        if (node.isLeaf()) {
            int[] clade = new int[]{node.getNr()};
            node.m_iClade = node.getNr();
            return clade;
        }
        int[] cladeLeft = this.calcCladeIDForNode(node.m_left, mapCladeToIndex);
        int[] cladeRight = this.calcCladeIDForNode(node.m_right, mapCladeToIndex);
        int[] clade = this.mergeClades(cladeLeft, cladeRight);
        String sClade = Arrays.toString(clade);
        try {
            int iClade;
            node.m_iClade = iClade = mapCladeToIndex.get(sClade).intValue();
        }
        catch (Exception e) {
            node.m_iClade = 0;
        }
        return clade;
    }

    void calcColorPattern() {
        this.m_iColor = new int[this.m_sLabels.size()];
        Pattern pattern = Pattern.compile(".*" + this.m_sColorPattern + ".*");
        ArrayList<String> sPatterns = new ArrayList<String>();
        int i = 0;
        while (i < this.m_sLabels.size()) {
            String sLabel = this.m_sLabels.get(i);
            Matcher matcher = pattern.matcher(sLabel);
            if (matcher.find()) {
                String sMatch = matcher.group(1);
                if (sPatterns.indexOf(sMatch) < 0) {
                    sPatterns.add(sMatch);
                }
                this.m_iColor[i] = sPatterns.indexOf(sMatch);
            }
            ++i;
        }
    }

    void loadKML() {
        String sFileName = this.m_sKMLFile;
        HashMap mapLabel2X = new HashMap();
        HashMap mapLabel2Y = new HashMap();
        if (!new File(sFileName).exists()) {
            JOptionPane.showMessageDialog(this, "Tried to read goe info, but could not find file " + sFileName);
            return;
        }
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(false);
            org.w3c.dom.Document doc = null;
            if (sFileName.toLowerCase().endsWith(".kmz")) {
                ZipFile zf = new ZipFile(sFileName);
                Enumeration<? extends ZipEntry> entries = zf.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry ze = entries.nextElement();
                    if (!ze.getName().toLowerCase().equals("doc.kml")) continue;
                    doc = factory.newDocumentBuilder().parse(zf.getInputStream(ze));
                }
                zf.close();
            } else {
                doc = factory.newDocumentBuilder().parse(new File(sFileName));
            }
            doc.normalize();
            HashMap<String, Integer> mapStyleToColor = new HashMap<String, Integer>();
            NodeList oStyles = doc.getElementsByTagName("Style");
            int iNode = 0;
            while (iNode < oStyles.getLength()) {
                String expression;
                org.w3c.dom.Node oStyle = oStyles.item(iNode);
                String sID = oStyle.getAttributes().getNamedItem("id").getTextContent();
                XPath xpath = XPathFactory.newInstance().newXPath();
                org.w3c.dom.Node oColor = (org.w3c.dom.Node)xpath.evaluate(expression = ".//PolyStyle/color", oStyles.item(iNode), XPathConstants.NODE);
                if (oColor != null) {
                    String sColor = oColor.getTextContent();
                    sColor = sColor.substring(2);
                    Integer nColor = Integer.parseInt(sColor, 16);
                    mapStyleToColor.put(sID, nColor);
                }
                ++iNode;
            }
            NodeList oPlacemarks = doc.getElementsByTagName("Placemark");
            int iNode2 = 0;
            while (iNode2 < oPlacemarks.getLength()) {
                String sPlacemarkName = "";
                Vector<Double> nX = new Vector<Double>();
                Vector<Double> nY = new Vector<Double>();
                org.w3c.dom.Node node = oPlacemarks.item(iNode2);
                NodeList oChildren = node.getChildNodes();
                int iChild = 0;
                while (iChild < oChildren.getLength()) {
                    org.w3c.dom.Node oChild = oChildren.item(iChild);
                    if (oChild.getNodeType() == 1) {
                        String sName = oChild.getNodeName();
                        if (sName.equals("name")) {
                            sPlacemarkName = oChild.getTextContent().trim();
                        } else if (sName.equals("Style")) {
                            String expression = ".//PolyStyle/color";
                            XPath xpath = XPathFactory.newInstance().newXPath();
                            org.w3c.dom.Node oColor = (org.w3c.dom.Node)xpath.evaluate(expression, oStyles.item(iNode2), XPathConstants.NODE);
                            if (oColor != null) {
                                String sColor = oColor.getTextContent();
                                sColor = sColor.substring(2);
                            }
                        } else if (sName.equals("styleUrl")) {
                            String sID = oChild.getTextContent();
                            sID = sID.substring(1);
                            mapStyleToColor.containsKey(sID);
                        } else if (sName.equals("Polygon") || sName.equals("Point") || sName.equals("LineString")) {
                            XPath xpath = XPathFactory.newInstance().newXPath();
                            String expression = ".//coordinates";
                            org.w3c.dom.Node oCoords = (org.w3c.dom.Node)xpath.evaluate(expression, oChild, XPathConstants.NODE);
                            String sCoord = oCoords.getTextContent();
                            String[] sCoords = sCoord.split("\\s+");
                            int i = 0;
                            while (i < sCoords.length) {
                                String sStr = sCoords[i];
                                String[] sStrs = sStr.split(",");
                                if (sStrs.length > 1) {
                                    nX.add(Double.parseDouble(sStrs[0]));
                                    nY.add(Double.parseDouble(sStrs[1]));
                                }
                                ++i;
                            }
                        }
                    }
                    ++iChild;
                }
                if (nX.size() > 0) {
                    mapLabel2X.put(sPlacemarkName.toLowerCase(), nX);
                    mapLabel2Y.put(sPlacemarkName.toLowerCase(), nY);
                    sPlacemarkName = sPlacemarkName.replaceAll("-", "");
                    sPlacemarkName = sPlacemarkName.replaceAll("_", "");
                    if (!mapLabel2X.containsKey(sPlacemarkName)) {
                        mapLabel2X.put(sPlacemarkName.toLowerCase(), nX);
                        mapLabel2Y.put(sPlacemarkName.toLowerCase(), nY);
                    }
                }
                ++iNode2;
            }
        }
        catch (Exception e) {
            try {
                this.m_fMinLat = 90.0f;
                this.m_fMinLong = 180.0f;
                this.m_fMaxLat = -90.0f;
                this.m_fMaxLong = -180.0f;
                BufferedReader fin = new BufferedReader(new FileReader(sFileName));
                String sStr = null;
                sStr = fin.readLine();
                while (fin.ready()) {
                    sStr = fin.readLine();
                    String[] sStrs = sStr.split("\\s+");
                    if (sStrs.length < 3) continue;
                    String sPlacemarkName = sStrs[0];
                    Vector<Double> nX = new Vector<Double>();
                    Vector<Double> nY = new Vector<Double>();
                    nX.add(Double.parseDouble(sStrs[2]));
                    nY.add(Double.parseDouble(sStrs[1]));
                    mapLabel2X.put(sPlacemarkName.toLowerCase(), nX);
                    mapLabel2Y.put(sPlacemarkName.toLowerCase(), nY);
                    sPlacemarkName = sPlacemarkName.replaceAll("-", "");
                    sPlacemarkName = sPlacemarkName.replaceAll("_", "");
                    if (mapLabel2X.containsKey(sPlacemarkName)) continue;
                    mapLabel2X.put(sPlacemarkName.toLowerCase(), nX);
                    mapLabel2Y.put(sPlacemarkName.toLowerCase(), nY);
                }
                fin.close();
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
        try {
            this.m_fMinLat = 90.0f;
            this.m_fMinLong = 180.0f;
            this.m_fMaxLat = -90.0f;
            this.m_fMaxLong = -180.0f;
            int iLabel = 0;
            while (iLabel < this.m_nNrOfLabels) {
                String sTaxon = this.m_sLabels.get(iLabel).toLowerCase();
                String sTaxon2 = sTaxon.replaceAll("[-_]", "");
                if (mapLabel2X.containsKey(sTaxon) || mapLabel2X.containsKey(sTaxon2)) {
                    if (!mapLabel2X.containsKey(sTaxon)) {
                        sTaxon = sTaxon2;
                    }
                    Vector nX = (Vector)mapLabel2X.get(sTaxon);
                    Vector nY = (Vector)mapLabel2Y.get(sTaxon);
                    double fX = 0.0;
                    double fY = 0.0;
                    for (Double f : nX) {
                        fX += f.doubleValue();
                    }
                    fX /= (double)nX.size();
                    for (Double f : nY) {
                        fY += f.doubleValue();
                    }
                    fY /= (double)nY.size();
                    while (this.m_fLatitude.size() <= iLabel) {
                        this.m_fLatitude.add(Float.valueOf(0.0f));
                        this.m_fLongitude.add(Float.valueOf(0.0f));
                    }
                    this.m_fLatitude.set(iLabel, Float.valueOf((float)fY));
                    this.m_fLongitude.set(iLabel, Float.valueOf((float)fX));
                    this.m_fMinLat = Math.min(this.m_fMinLat, (float)fY);
                    this.m_fMaxLat = Math.max(this.m_fMaxLat, (float)fY);
                    this.m_fMinLong = Math.min(this.m_fMinLong, (float)fX);
                    this.m_fMaxLong = Math.max(this.m_fMaxLong, (float)fX);
                } else {
                    System.err.println("No geo info for " + sTaxon + " found (probably because taxon is missing or spelling error)");
                    while (this.m_fLatitude.size() <= iLabel) {
                        this.m_fLatitude.add(Float.valueOf(0.0f));
                        this.m_fLongitude.add(Float.valueOf(0.0f));
                    }
                    this.m_fLatitude.set(iLabel, Float.valueOf(0.0f));
                    this.m_fLongitude.set(iLabel, Float.valueOf(0.0f));
                }
                ++iLabel;
            }
            float fOffset = GEO_OFFSET;
            this.m_fMaxLong += fOffset;
            this.m_fMaxLat += fOffset;
            this.m_fMinLong -= fOffset;
            this.m_fMinLat -= fOffset;
            System.err.println("geo range (" + this.m_fMinLat + "," + this.m_fMinLong + ")x(" + this.m_fMaxLat + "," + this.m_fMaxLong + ")");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void clear() {
        this.m_trees = new Node[0];
        this.m_cTrees = new Node[0];
        this.m_fLinesX = null;
        this.m_fLinesY = null;
        this.m_fCLinesX = null;
        this.m_fCLinesY = null;
        this.m_bInitializing = false;
    }

    void reshuffle(int nMethod) {
        int j;
        int[] oldOrder = (int[])this.m_nOrder.clone();
        this.m_nShuffleMode = nMethod;
        this.setWaitCursor();
        try {
            switch (nMethod) {
                case -3: {
                    this.initOrder(this.m_trees[0], 0);
                    break;
                }
                case -4: {
                    int i = 0;
                    while (i < this.m_sLabels.size()) {
                        System.out.print(String.valueOf(this.m_sLabels.elementAt(i)) + " ");
                        ++i;
                    }
                    String sOrder = JOptionPane.showInputDialog("New node order:", (Object)"");
                    if (sOrder == null) {
                        return;
                    }
                    String[] sIndex = sOrder.split(" ");
                    if (sIndex.length != this.m_nNrOfLabels) {
                        System.err.println("Number of labels/taxa differs from given labels");
                        return;
                    }
                    int[] nOrder = new int[this.m_nOrder.length];
                    int[] nRevOrder = new int[this.m_nRevOrder.length];
                    int i2 = 0;
                    while (i2 < sIndex.length) {
                        j = 0;
                        String sTarget = sIndex[i2];
                        while (j < this.m_sLabels.size() && !this.m_sLabels.elementAt(j).equals(sTarget)) {
                            ++j;
                        }
                        if (j == this.m_sLabels.size()) {
                            System.err.println("Label \"" + sTarget + "\" not found among labels");
                            return;
                        }
                        nOrder[j] = i2;
                        nRevOrder[i2] = j;
                        ++i2;
                    }
                    this.m_nOrder = nOrder;
                    this.m_nRevOrder = nRevOrder;
                    break;
                }
                case 100: {
                    break;
                }
                case 101: {
                    break;
                }
                case 102: {
                    break;
                }
                case -5: {
                    break;
                }
                default: {
                    NodeOrderer h = new NodeOrderer(nMethod);
                    int[] nOrder = h.calcOrder(this.m_nNrOfLabels, this.m_trees, this.m_cTrees, this.m_rootcanaltree, this.m_fTreeWeight, this.m_clades, this.m_cladeWeight);
                    this.m_nOrder = nOrder;
                    int i = 0;
                    while (i < this.m_nNrOfLabels) {
                        this.m_nRevOrder[this.m_nOrder[i]] = i;
                        ++i;
                    }
                    System.err.println();
                    i = 0;
                    while (i < this.m_nNrOfLabels) {
                        System.out.print(String.valueOf(this.m_sLabels.elementAt(this.m_nRevOrder[i])) + " ");
                        ++i;
                    }
                    System.out.println();
                    break;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        int nNodes = this.getNrOfNodes(this.m_trees[0]);
        if (nMethod < 100) {
            this.m_bShowBounds = false;
            this.calcPositions();
            this.calcLines();
            this.makeDirty();
            this.addAction(new DoAction());
        } else {
            this.m_bShowBounds = true;
            this.m_pattern = Pattern.compile(this.m_sPattern);
            switch (nMethod) {
                case 100: {
                    double fMaxX = 0.0;
                    int i = 0;
                    while (i < this.m_trees.length) {
                        double fX = this.positionMetaAll(this.m_trees[i]);
                        fMaxX = Math.max(fMaxX, fX);
                        ++i;
                    }
                    i = 0;
                    while (i < this.m_cTrees.length) {
                        double fX = this.positionMetaAll(this.m_cTrees[i]);
                        fMaxX = Math.max(fMaxX, fX);
                        ++i;
                    }
                    fMaxX = (double)this.m_nNrOfLabels / fMaxX;
                    i = 0;
                    while (i < this.m_trees.length) {
                        this.scaleX(this.m_trees[i], fMaxX);
                        ++i;
                    }
                    i = 0;
                    while (i < this.m_cTrees.length) {
                        this.scaleX(this.m_cTrees[i], fMaxX);
                        ++i;
                    }
                    this.calcLines();
                    break;
                }
                case 101: 
                case 102: {
                    int i;
                    int n;
                    int n2;
                    float[] fArray;
                    float[] fXs;
                    float[] fMetas;
                    float[] fHeights;
                    int i3 = 0;
                    while (i3 < this.m_trees.length) {
                        fHeights = new float[this.m_nNrOfLabels * 2 - 1];
                        fMetas = new float[this.m_nNrOfLabels * 2 - 1];
                        int[] nCounts = new int[this.m_nNrOfLabels * 2 - 1];
                        this.collectHeights(this.m_trees[i3], fHeights, 0);
                        Arrays.sort(fHeights);
                        this.collectMetaData(this.m_trees[i3], fHeights, 0.0f, 0, fMetas, nCounts);
                        this.m_fLinesX[i3] = new float[nNodes * 2 + 2];
                        this.m_fLinesY[i3] = new float[nNodes * 2 + 2];
                        j = 0;
                        while (j < fMetas.length - 1) {
                            this.m_fLinesX[i3][j * 2] = fMetas[j];
                            this.m_fLinesY[i3][j * 2] = (fHeights[j] - this.m_fTreeOffset) * this.m_fTreeScale;
                            this.m_fLinesX[i3][j * 2 + 1] = fMetas[j + 1];
                            this.m_fLinesY[i3][j * 2 + 1] = (fHeights[j + 1] - this.m_fTreeOffset) * this.m_fTreeScale;
                            ++j;
                        }
                        if (nMethod == 102) {
                            j = 0;
                            while (j < fMetas.length - 1) {
                                if (nCounts[j] > 0) {
                                    this.m_fLinesX[i3][j * 2] = fMetas[j] / (float)nCounts[j];
                                }
                                if (nCounts[j + 1] > 0) {
                                    this.m_fLinesX[i3][j * 2 + 1] = fMetas[j + 1] / (float)nCounts[j + 1];
                                }
                                ++j;
                            }
                        }
                        ++i3;
                    }
                    i3 = 0;
                    while (i3 < this.m_cTrees.length) {
                        fHeights = new float[this.m_nNrOfLabels * 2 - 1];
                        fMetas = new float[this.m_nNrOfLabels * 2 - 1];
                        int[] nCounts = new int[this.m_nNrOfLabels * 2 - 1];
                        this.collectHeights(this.m_cTrees[i3], fHeights, 0);
                        Arrays.sort(fHeights);
                        this.collectMetaData(this.m_cTrees[i3], fHeights, 0.0f, 0, fMetas, nCounts);
                        this.m_fCLinesX[i3] = new float[nNodes * 2 + 2];
                        this.m_fCLinesY[i3] = new float[nNodes * 2 + 2];
                        j = 0;
                        while (j < fMetas.length - 1) {
                            this.m_fCLinesX[i3][j * 2] = fMetas[j];
                            this.m_fCLinesY[i3][j * 2] = (fHeights[j] - this.m_fTreeOffset) * this.m_fTreeScale;
                            this.m_fCLinesX[i3][j * 2 + 1] = fMetas[j + 1];
                            this.m_fCLinesY[i3][j * 2 + 1] = (fHeights[j + 1] - this.m_fTreeOffset) * this.m_fTreeScale;
                            ++j;
                        }
                        if (nMethod == 102) {
                            j = 0;
                            while (j < fMetas.length - 1) {
                                if (nCounts[j] > 0) {
                                    this.m_fLinesX[i3][j * 2] = fMetas[j] / (float)nCounts[j];
                                }
                                if (nCounts[j + 1] > 0) {
                                    this.m_fLinesX[i3][j * 2 + 1] = fMetas[j + 1] / (float)nCounts[j + 1];
                                }
                                ++j;
                            }
                        }
                        ++i3;
                    }
                    float fMaxX = 0.0f;
                    float[][] fArray2 = this.m_fLinesX;
                    int n3 = this.m_fLinesX.length;
                    int fMetas2 = 0;
                    while (fMetas2 < n3) {
                        fArray = fXs = fArray2[fMetas2];
                        n2 = fXs.length;
                        n = 0;
                        while (n < n2) {
                            float f = fArray[n];
                            fMaxX = Math.max(f, fMaxX);
                            ++n;
                        }
                        ++fMetas2;
                    }
                    fArray2 = this.m_fCLinesX;
                    n3 = this.m_fCLinesX.length;
                    fMetas2 = 0;
                    while (fMetas2 < n3) {
                        fArray = fXs = fArray2[fMetas2];
                        n2 = fXs.length;
                        n = 0;
                        while (n < n2) {
                            float f = fArray[n];
                            fMaxX = Math.max(f, fMaxX);
                            ++n;
                        }
                        ++fMetas2;
                    }
                    float fScale = (float)this.m_nNrOfLabels / fMaxX;
                    float[][] fArray3 = this.m_fCLinesX;
                    int n4 = this.m_fCLinesX.length;
                    n3 = 0;
                    while (n3 < n4) {
                        float[] fXs2 = fArray3[n3];
                        i = 0;
                        while (i < fXs2.length) {
                            int n5 = i++;
                            fXs2[n5] = fXs2[n5] * fScale;
                        }
                        ++n3;
                    }
                    fArray3 = this.m_fLinesX;
                    n4 = this.m_fLinesX.length;
                    n3 = 0;
                    while (n3 < n4) {
                        float[] fXs3 = fArray3[n3];
                        i = 0;
                        while (i < fXs3.length) {
                            int n6 = i++;
                            fXs3[n6] = fXs3[n6] * fScale;
                        }
                        ++n3;
                    }
                    break;
                }
            }
            if (this.orderChanged(oldOrder)) {
                this.makeDirty();
            }
        }
    }

    void rotateAround(int iRotationPoint) {
        Vector<Integer> iLeafs = new Vector<Integer>();
        this.getRotationLeafs(this.m_cTrees[0], -1, iLeafs, iRotationPoint);
        System.err.println("Rotating " + iRotationPoint + " " + iLeafs);
        int iMin = this.m_nOrder.length;
        int iMax = 0;
        for (Integer i : iLeafs) {
            int j = this.m_nOrder[i];
            iMin = Math.min(j, iMin);
            iMax = Math.max(j, iMax);
        }
        int i = 0;
        while (i < (iMax - iMin) / 2 + 1) {
            int nTmp = this.m_nRevOrder[iMin + i];
            this.m_nRevOrder[iMin + i] = this.m_nRevOrder[iMax - i];
            this.m_nRevOrder[iMax - i] = nTmp;
            ++i;
        }
        i = 0;
        while (i < this.m_sLabels.size()) {
            this.m_nOrder[this.m_nRevOrder[i]] = i;
            ++i;
        }
        this.calcPositions();
        this.calcLines();
        this.makeDirty();
        this.addAction(new DoAction());
    }

    void moveRotationPoint(int iRotationPoint, float fdH) {
        int i2;
        Vector<Integer> iLeafs = new Vector<Integer>();
        this.getRotationLeafs(this.m_cTrees[0], -1, iLeafs, iRotationPoint);
        boolean[] bSelection = this.m_bSelection;
        this.m_bSelection = new boolean[this.m_sLabels.size()];
        for (int i2 : iLeafs) {
            this.m_bSelection[i2] = true;
        }
        i2 = 0;
        while (i2 < this.m_trees.length) {
            this.moveInternalNode(fdH, this.m_trees[i2], iLeafs.size());
            ++i2;
        }
        i2 = 0;
        while (i2 < this.m_cTrees.length) {
            this.moveInternalNode(fdH, this.m_cTrees[i2], iLeafs.size());
            ++i2;
        }
        this.m_bSelection = bSelection;
        this.calcLines();
        this.makeDirty();
    }

    int moveInternalNode(float fdH, Node node, int nSelected) {
        if (node.isLeaf()) {
            return this.m_bSelection[node.getNr()] ? 1 : 0;
        }
        int i = this.moveInternalNode(fdH, node.m_left, nSelected);
        if ((i += this.moveInternalNode(fdH, node.m_right, nSelected)) == nSelected) {
            node.m_fPosX += fdH;
            ++i;
        }
        return i;
    }

    int getRotationLeafs(Node node, int iPos, Vector<Integer> iLeafs, int iRotationPoint) {
        if (node.isLeaf()) {
            iLeafs.add(node.getNr());
        } else {
            if ((iPos = this.getRotationLeafs(node.m_left, iPos, iLeafs, iRotationPoint)) == iRotationPoint) {
                return iPos;
            }
            Vector<Integer> iLeafsR = new Vector<Integer>();
            if (node.m_right != null && (iPos = this.getRotationLeafs(node.m_right, iPos, iLeafsR, iRotationPoint)) == iRotationPoint) {
                iLeafs.removeAllElements();
                iLeafs.addAll(iLeafsR);
                return iPos;
            }
            ++iPos;
            iLeafs.addAll(iLeafsR);
        }
        return iPos;
    }

    int getNrOfNodes(Node node) {
        if (node.isLeaf()) {
            return 1;
        }
        int nNodes = this.getNrOfNodes(node.m_left);
        nNodes = node.m_right != null ? (nNodes += this.getNrOfNodes(node.m_right)) : ++nNodes;
        return nNodes + 1;
    }

    public void calcLines() {
        this.checkSelection();
        if (this.m_trees.length == 0) {
            return;
        }
        this.setWaitCursor();
        int nNodes = this.getNrOfNodes(this.m_trees[0]);
        boolean[] b = new boolean[1];
        int i = 0;
        while (i < this.m_trees.length) {
            if (this.m_bAllowSingleChild) {
                nNodes = this.getNrOfNodes(this.m_trees[i]);
                this.m_fLinesX[i] = new float[nNodes * 2 + 2];
                this.m_fLinesY[i] = new float[nNodes * 2 + 2];
                this.m_trees[i].drawDryWithSingleChild(this.m_fLinesX[i], this.m_fLinesY[i], 0, b, this.m_bSelection, this.m_fTreeOffset, this.m_fTreeScale);
            } else {
                this.m_fLinesX[i] = new float[nNodes * 2 + 2];
                this.m_fLinesY[i] = new float[nNodes * 2 + 2];
                this.calcLinesForNode(this.m_trees[i], this.m_fLinesX[i], this.m_fLinesY[i]);
            }
            ++i;
        }
        i = 0;
        while (i < this.m_cTrees.length) {
            if (this.m_bAllowSingleChild) {
                nNodes = this.getNrOfNodes(this.m_cTrees[i]);
                this.m_fCLinesX[i] = new float[nNodes * 2 + 2];
                this.m_fCLinesY[i] = new float[nNodes * 2 + 2];
                this.m_cTrees[i].drawDryWithSingleChild(this.m_fCLinesX[i], this.m_fCLinesY[i], 0, b, this.m_bSelection, this.m_fTreeOffset, this.m_fTreeScale);
            } else {
                this.m_fCLinesX[i] = new float[nNodes * 2 + 2];
                this.m_fCLinesY[i] = new float[nNodes * 2 + 2];
                this.calcLinesForNode(this.m_cTrees[i], this.m_fCLinesX[i], this.m_fCLinesY[i]);
            }
            ++i;
        }
        this.m_fRLinesX = new float[1][nNodes * 2 + 2];
        this.m_fRLinesY = new float[1][nNodes * 2 + 2];
        if (!this.m_bAllowSingleChild && this.m_bCladesReady) {
            this.calcLinesForNode(this.m_rootcanaltree, this.m_fRLinesX[0], this.m_fRLinesY[0]);
        }
        if (this.m_bUseLogScale) {
            int j;
            System.err.println("Use log scaling");
            float fNormaliser = (float)((double)this.m_fHeight / Math.pow(this.m_fHeight, this.m_fExponent));
            int i2 = 0;
            while (i2 < this.m_trees.length) {
                j = 0;
                while (j < this.m_fLinesY[i2].length) {
                    this.m_fLinesY[i2][j] = (float)Math.pow(this.m_fHeight - this.m_fLinesY[i2][j], this.m_fExponent) / fNormaliser;
                    ++j;
                }
                ++i2;
            }
            i2 = 0;
            while (i2 < this.m_cTrees.length) {
                j = 0;
                while (j < this.m_fCLinesY[i2].length) {
                    this.m_fCLinesY[i2][j] = (float)Math.pow(this.m_fHeight - this.m_fCLinesY[i2][j], this.m_fExponent) / fNormaliser;
                    ++j;
                }
                ++i2;
            }
            int j2 = 0;
            while (j2 < this.m_fRLinesY[0].length) {
                this.m_fRLinesY[0][j2] = (float)Math.pow(this.m_fHeight - this.m_fRLinesY[0][j2], this.m_fExponent) / fNormaliser;
                ++j2;
            }
        }
        this.m_w = 0.0;
        i = 0;
        while (i < this.m_cTrees.length) {
            float[] fCLines = this.m_fCLinesX[i];
            float fWeight = this.m_fTreeWeight[i];
            int j = 0;
            while (j < fCLines.length - 3) {
                this.m_w += (double)(Math.abs(fCLines[j + 1] - fCLines[j + 2]) * fWeight);
                j += 4;
            }
            ++i;
        }
        this.calcColors(false);
        this.calcLineWidths(false);
    }

    void calcLinesForNode(Node node, float[] fLinesX, float[] fLinesY) {
        boolean[] b = new boolean[1];
        if (this.m_bAllowSingleChild) {
            node.drawDryWithSingleChild(fLinesX, fLinesY, 0, b, this.m_bSelection, this.m_fTreeOffset, this.m_fTreeScale);
        } else {
            switch (this.m_Xmode) {
                case 0: {
                    node.drawDry(fLinesX, fLinesY, 0, b, this.m_bSelection, this.m_fTreeOffset, this.m_fTreeScale);
                    break;
                }
                case 1: {
                    node.drawDryCentralised(fLinesX, fLinesY, 0, b, this.m_bSelection, this.m_fTreeOffset, this.m_fTreeScale, new float[2], new float[this.m_nNrOfLabels * 2 - 1], new float[this.m_nNrOfLabels * 2 - 1], this.m_cladePosition);
                    break;
                }
                case 2: {
                    float[] fCladeCenterX = new float[this.m_nNrOfLabels * 2 - 1];
                    float[] fCladeCenterY = new float[this.m_nNrOfLabels * 2 - 1];
                    float[] fPosX = new float[this.m_nNrOfLabels * 2 - 1];
                    float[] fPosY = new float[this.m_nNrOfLabels * 2 - 1];
                    node.getStarTreeCladeCenters(fCladeCenterX, fCladeCenterY, this.m_fTreeOffset, this.m_fTreeScale, this.m_cladePosition, this.m_sLabels.size());
                    node.drawStarTree(fLinesX, fLinesY, fPosX, fPosY, fCladeCenterX, fCladeCenterY, this.m_bSelection, this.m_fTreeOffset, this.m_fTreeScale);
                }
            }
        }
    }

    public void calcLineWidths(boolean forceRecalc) {
        if (!forceRecalc) {
            if (this.m_lineWidthMode == this.m_prevLineWidthMode && this.m_lineWidthTag != null && this.m_lineWidthTag.equals(this.m_prevLineWidthTag) && this.m_sLineWidthPattern.equals(this.m_sPrevLineWidthPattern)) {
                return;
            }
        } else {
            this.calcPositions();
            this.calcLines();
        }
        this.m_prevLineWidthMode = this.m_lineWidthMode;
        this.m_prevLineWidthTag = this.m_lineWidthTag;
        this.m_sPrevLineWidthPattern = this.m_sLineWidthPattern;
        this.setWaitCursor();
        if (this.m_sLabels == null) {
            return;
        }
        if (this.m_lineWidthMode == LineWidthMode.DEFAULT) {
            this.m_fLineWidth = null;
            this.m_fCLineWidth = null;
            this.m_fTopLineWidth = null;
            this.m_fTopCLineWidth = null;
            this.m_fRLineWidth = null;
            this.m_fRTopLineWidth = null;
            return;
        }
        this.m_fLineWidth = new float[this.m_trees.length][];
        this.m_fCLineWidth = new float[this.m_cTrees.length][];
        this.m_fTopLineWidth = new float[this.m_trees.length][];
        this.m_fTopCLineWidth = new float[this.m_cTrees.length][];
        this.m_fRLineWidth = new float[1][];
        this.m_fRTopLineWidth = new float[1][];
        this.checkSelection();
        int nNodes = this.getNrOfNodes(this.m_trees[0]);
        if (this.m_lineWidthMode == LineWidthMode.BY_METADATA_PATTERN) {
            this.m_pattern = Pattern.compile(this.m_sLineWidthPattern);
        }
        if (this.m_lineWidthModeTop == LineWidthMode.BY_METADATA_PATTERN) {
            this.m_patternTop = Pattern.compile(this.m_sLineWidthPatternTop);
        }
        boolean[] b = new boolean[1];
        int i = 0;
        while (i < this.m_trees.length) {
            this.m_fLineWidth[i] = new float[nNodes * 2 + 2];
            this.m_fTopLineWidth[i] = new float[nNodes * 2 + 2];
            this.drawTreeS(this.m_trees[i], this.m_fLinesX[i], this.m_fLinesY[i], this.m_fLineWidth[i], this.m_fTopLineWidth[i], 0, b);
            ++i;
        }
        i = 0;
        while (i < this.m_cTrees.length) {
            this.m_fCLineWidth[i] = new float[nNodes * 2 + 2];
            this.m_fTopCLineWidth[i] = new float[nNodes * 2 + 2];
            this.drawTreeS(this.m_cTrees[i], this.m_fCLinesX[i], this.m_fCLinesY[i], this.m_fCLineWidth[i], this.m_fTopCLineWidth[i], 0, b);
            int nTopologies = 0;
            float[] fCLineWidth = new float[nNodes * 2 + 2];
            float[] fTopCLineWidth = new float[nNodes * 2 + 2];
            int j = 0;
            while (j < this.m_trees.length) {
                if (this.m_nTopologyByPopularity[j] == i) {
                    int k = 0;
                    while (k < fCLineWidth.length) {
                        int n = k;
                        fCLineWidth[n] = fCLineWidth[n] + this.m_fLineWidth[j][k];
                        int n2 = k;
                        fTopCLineWidth[n2] = fTopCLineWidth[n2] + this.m_fTopLineWidth[j][k];
                        ++k;
                    }
                    ++nTopologies;
                }
                ++j;
            }
            int k = 0;
            while (k < fCLineWidth.length) {
                int n = k;
                fCLineWidth[n] = fCLineWidth[n] / (float)nTopologies;
                int n3 = k++;
                fTopCLineWidth[n3] = fTopCLineWidth[n3] / (float)nTopologies;
            }
            this.m_fCLineWidth[i] = fCLineWidth;
            this.m_fTopCLineWidth[i] = fTopCLineWidth;
            ++i;
        }
        this.m_fRLineWidth[0] = new float[nNodes * 2 + 2];
        this.m_fRTopLineWidth[0] = new float[nNodes * 2 + 2];
        this.drawTreeS(this.m_rootcanaltree, this.m_fRLinesX[0], this.m_fRLinesY[0], this.m_fRLineWidth[0], this.m_fRTopLineWidth[0], 0, b);
        this.m_fRLineWidth = null;
        this.m_fRTopLineWidth = null;
    }

    public void calcColors(boolean forceRecalc) {
        if (!forceRecalc && this.m_lineColorMode == this.m_prevLineColorMode && this.m_lineColorTag != null && this.m_lineColorTag.equals(this.m_prevLineColorTag) && this.m_sLineColorPattern.equals(this.m_sPrevLineColorPattern)) {
            return;
        }
        if (this.m_sLabels == null) {
            return;
        }
        this.setWaitCursor();
        this.m_prevLineColorMode = this.m_lineColorMode;
        this.m_prevLineColorTag = this.m_lineColorTag;
        this.m_sPrevLineColorPattern = this.m_sLineColorPattern;
        int nNodes = this.getNrOfNodes(this.m_trees[0]);
        switch (this.m_lineColorMode) {
            case COLOR_BY_CLADE: {
                this.m_nLineColor = new int[this.m_trees.length][];
                this.m_nCLineColor = new int[this.m_cTrees.length][];
                this.m_nRLineColor = new int[1][];
                int i = 0;
                while (i < this.m_trees.length) {
                    if (this.m_bAllowSingleChild) {
                        nNodes = this.getNrOfNodes(this.m_trees[i]);
                    }
                    this.m_nLineColor[i] = new int[nNodes * 2 + 2];
                    this.colorTree(this.m_trees[i], this.m_nLineColor[i], 0);
                    ++i;
                }
                if (this.m_bAllowSingleChild) break;
                i = 0;
                while (i < this.m_cTrees.length) {
                    int nTopologies = 0;
                    this.m_nCLineColor[i] = new int[nNodes * 2 + 2];
                    int[] nCLineColor = this.m_nCLineColor[i];
                    int j = 0;
                    while (j < this.m_trees.length) {
                        int k = 0;
                        while (k < nCLineColor.length) {
                            int n = k;
                            nCLineColor[n] = nCLineColor[n] + this.m_nLineColor[j][k];
                            ++k;
                        }
                        ++nTopologies;
                        ++j;
                    }
                    int k = 0;
                    while (k < nCLineColor.length) {
                        int n = k++;
                        nCLineColor[n] = nCLineColor[n] / nTopologies;
                    }
                    ++i;
                }
                this.m_nRLineColor[0] = new int[nNodes * 2 + 2];
                Arrays.fill(this.m_nRLineColor[0], this.m_color[ROOTCANALCOLOR].getRGB());
                break;
            }
            case BY_METADATA_PATTERN: {
                this.m_pattern = Pattern.compile(this.m_sLineColorPattern);
                this.m_nLineColor = new int[this.m_trees.length][];
                this.m_nCLineColor = new int[this.m_cTrees.length][];
                this.m_nRLineColor = new int[1][];
                this.m_colorMetaDataCategories = new HashMap<String, Integer>();
                int i = 0;
                while (i < this.m_trees.length) {
                    if (this.m_bAllowSingleChild) {
                        nNodes = this.getNrOfNodes(this.m_trees[i]);
                    }
                    this.m_nLineColor[i] = new int[nNodes * 2 + 2];
                    this.colorTreeByMetaData(this.m_trees[i], this.m_nLineColor[i], 0);
                    ++i;
                }
                if (this.m_bAllowSingleChild) break;
                i = 0;
                while (i < this.m_cTrees.length) {
                    int nTopologies = 0;
                    this.m_nCLineColor[i] = new int[nNodes * 2 + 2];
                    int[] nCLineColor = this.m_nCLineColor[i];
                    int j = 0;
                    while (j < this.m_trees.length) {
                        int k = 0;
                        while (k < nCLineColor.length) {
                            int n = k;
                            nCLineColor[n] = nCLineColor[n] + this.m_nLineColor[j][k];
                            ++k;
                        }
                        ++nTopologies;
                        ++j;
                    }
                    int k = 0;
                    while (k < nCLineColor.length) {
                        int n = k++;
                        nCLineColor[n] = nCLineColor[n] / nTopologies;
                    }
                    ++i;
                }
                this.m_nRLineColor[0] = new int[nNodes * 2 + 2];
                Arrays.fill(this.m_nRLineColor[0], this.m_color[ROOTCANALCOLOR].getRGB());
                break;
            }
            case COLOR_BY_METADATA_TAG: {
                this.m_pattern = Pattern.compile(this.m_sPattern);
                this.m_nLineColor = new int[this.m_trees.length][];
                this.m_nCLineColor = new int[this.m_cTrees.length][];
                this.m_nRLineColor = new int[1][];
                this.m_colorMetaDataCategories = new HashMap<String, Integer>();
                boolean colorByCategory = false;
                int i = 0;
                while (i < this.m_metaDataTags.size()) {
                    if (this.m_metaDataTags.get(i).equals(this.m_lineColorTag)) {
                        if (!this.m_metaDataTypes.get(i).equals((Object)MetaDataType.STRING)) break;
                        colorByCategory = true;
                        break;
                    }
                    ++i;
                }
                i = 0;
                while (i < this.m_trees.length) {
                    if (this.m_bAllowSingleChild) {
                        nNodes = this.getNrOfNodes(this.m_trees[i]);
                    }
                    this.m_nLineColor[i] = new int[nNodes * 2 + 2];
                    this.colorTreeByMetaDataTag(this.m_trees[i], this.m_nLineColor[i], 0, colorByCategory);
                    ++i;
                }
                if (this.m_bAllowSingleChild) break;
                i = 0;
                while (i < this.m_cTrees.length) {
                    int nTopologies = 0;
                    this.m_nCLineColor[i] = new int[nNodes * 2 + 2];
                    int[] nCLineColor = this.m_nCLineColor[i];
                    int j = 0;
                    while (j < this.m_trees.length) {
                        int k = 0;
                        while (k < nCLineColor.length) {
                            int n = k;
                            nCLineColor[n] = nCLineColor[n] + this.m_nLineColor[j][k];
                            ++k;
                        }
                        ++nTopologies;
                        ++j;
                    }
                    int k = 0;
                    while (k < nCLineColor.length) {
                        int n = k++;
                        nCLineColor[n] = nCLineColor[n] / nTopologies;
                    }
                    ++i;
                }
                this.m_nRLineColor[0] = new int[nNodes * 2 + 2];
                Arrays.fill(this.m_nRLineColor[0], this.m_color[ROOTCANALCOLOR].getRGB());
                break;
            }
            case DEFAULT: {
                int color;
                this.m_nLineColor = new int[this.m_trees.length][];
                this.m_nCLineColor = new int[this.m_cTrees.length][];
                this.m_nRLineColor = new int[1][];
                int i = 0;
                while (i < this.m_trees.length) {
                    if (this.m_bAllowSingleChild) {
                        nNodes = this.getNrOfNodes(this.m_trees[i]);
                    }
                    this.m_nLineColor[i] = new int[nNodes * 2 + 2];
                    color = 0;
                    switch (this.m_nTopologyByPopularity[i]) {
                        case 0: {
                            color = this.m_color[0].getRGB();
                            break;
                        }
                        case 1: {
                            color = this.m_color[1].getRGB();
                            break;
                        }
                        case 2: {
                            color = this.m_color[2].getRGB();
                            break;
                        }
                        default: {
                            color = this.m_color[3].getRGB();
                        }
                    }
                    Arrays.fill(this.m_nLineColor[i], color);
                    ++i;
                }
                i = 0;
                while (i < this.m_cTrees.length) {
                    color = this.m_color[CONSCOLOR].getRGB();
                    if (this.m_bViewMultiColor) {
                        color = this.m_color[9 + i % (this.m_color.length - 9)].getRGB();
                    }
                    if (this.m_bAllowSingleChild) {
                        nNodes = this.getNrOfNodes(this.m_cTrees[i]);
                    }
                    this.m_nCLineColor[i] = new int[nNodes * 2 + 2];
                    Arrays.fill(this.m_nCLineColor[i], color);
                    ++i;
                }
                if (this.m_bAllowSingleChild) break;
                this.m_nRLineColor[0] = new int[nNodes * 2 + 2];
                Arrays.fill(this.m_nRLineColor[0], this.m_color[ROOTCANALCOLOR].getRGB());
            }
        }
    }

    private int colorTreeByMetaData(Node node, int[] nLineColor, int iPos) {
        if (!node.isLeaf()) {
            iPos = this.colorTreeByMetaData(node.m_left, nLineColor, iPos);
            if (node.m_right != null) {
                iPos = this.colorTreeByMetaData(node.m_right, nLineColor, iPos);
            }
            int color = this.m_color[9 + this.getMetaDataCategory(node.m_left) % (this.m_color.length - 9)].getRGB();
            nLineColor[iPos++] = color;
            nLineColor[iPos++] = color;
            if (node.m_right != null) {
                color = this.m_color[9 + this.getMetaDataCategory(node.m_right) % (this.m_color.length - 9)].getRGB();
            }
            nLineColor[iPos++] = color;
            nLineColor[iPos++] = color;
            if (node.isRoot()) {
                nLineColor[iPos++] = color;
                nLineColor[iPos++] = color;
            }
        }
        return iPos;
    }

    private int colorTreeByMetaDataTag(Node node, int[] nLineColor, int iPos, boolean colorByCategory) {
        if (!node.isLeaf()) {
            iPos = this.colorTreeByMetaDataTag(node.m_left, nLineColor, iPos, colorByCategory);
            if (node.m_right != null) {
                iPos = this.colorTreeByMetaDataTag(node.m_right, nLineColor, iPos, colorByCategory);
            }
            int color = this.colorForNode(node.m_left, colorByCategory);
            nLineColor[iPos++] = color;
            nLineColor[iPos++] = color;
            if (node.m_right != null) {
                color = this.colorForNode(node.m_right, colorByCategory);
            }
            nLineColor[iPos++] = color;
            nLineColor[iPos++] = color;
            if (node.isRoot()) {
                nLineColor[iPos++] = color;
                nLineColor[iPos++] = color;
            }
        }
        return iPos;
    }

    int colorForNode(Node node, boolean colorByCategory) {
        int color = 0;
        Object o = node.getMetaDataSet().get(this.m_lineColorTag);
        if (colorByCategory || this.m_bColorByCategory) {
            if (o != null) {
                if (this.m_colorMetaDataCategories.get(o.toString()) == null) {
                    this.m_colorMetaDataCategories.put(o.toString(), this.m_colorMetaDataCategories.size());
                }
                int i = this.m_colorMetaDataCategories.get(o.toString());
                System.err.println(String.valueOf(i) + " " + (9 + i % (this.m_color.length - 9)) + " " + this.m_color.length);
                color = this.m_color[9 + i % (this.m_color.length - 9)].getRGB();
            }
        } else if (o != null) {
            double frac = ((Double)o - Node.g_minValue.get(this.m_lineColorTag)) / (Node.g_maxValue.get(this.m_lineColorTag) - Node.g_minValue.get(this.m_lineColorTag));
            color = Color.HSBtoRGB((float)frac, 0.5f, 0.8f);
        }
        return color;
    }

    private int colorTree(Node node, int[] nLineColor, int iPos) {
        if (node != null && !node.isLeaf()) {
            iPos = this.colorTree(node.m_left, nLineColor, iPos);
            iPos = this.colorTree(node.m_right, nLineColor, iPos);
            int color = this.m_color[9 + node.m_iClade % 9].getRGB();
            nLineColor[iPos++] = color;
            nLineColor[iPos++] = color;
            nLineColor[iPos++] = color;
            nLineColor[iPos++] = color;
            if (node.isRoot()) {
                nLineColor[iPos++] = color;
                nLineColor[iPos++] = color;
            }
        }
        return iPos;
    }

    int drawTreeS(Node node, float[] nX, float[] nY, float[] fWidth, float[] fWidthTop, int iPos, boolean[] bNeedsDrawing) {
        if (node.isLeaf()) {
            bNeedsDrawing[0] = this.m_bSelection[node.m_iLabel];
        } else {
            boolean[] bChildNeedsDrawing = new boolean[2];
            iPos = this.drawTreeS(node.m_left, nX, nY, fWidth, fWidthTop, iPos, bNeedsDrawing);
            bChildNeedsDrawing[0] = bNeedsDrawing[0];
            if (node.m_right != null) {
                iPos = this.drawTreeS(node.m_right, nX, nY, fWidth, fWidthTop, iPos, bNeedsDrawing);
                bChildNeedsDrawing[1] = bNeedsDrawing[0];
            } else {
                bChildNeedsDrawing[1] = false;
            }
            bNeedsDrawing[0] = false;
            if (bChildNeedsDrawing[0]) {
                fWidth[iPos] = this.getGamma(node.m_left, 1, this.m_lineWidthMode, this.m_lineWidthTag, this.m_pattern);
                fWidthTop[iPos] = this.m_lineWidthModeTop == LineWidthMode.DEFAULT ? fWidth[iPos] : this.getGamma(node.m_left, 2, this.m_lineWidthModeTop, this.m_lineWidthTagTop, this.m_patternTop);
                ++iPos;
                bNeedsDrawing[0] = true;
            } else {
                fWidth[iPos] = this.m_nTreeWidth;
                ++iPos;
            }
            fWidth[iPos] = fWidth[iPos - 1];
            fWidthTop[iPos] = fWidthTop[iPos - 1];
            ++iPos;
            if (bChildNeedsDrawing[1]) {
                fWidth[iPos] = this.getGamma(node.m_right, 1, this.m_lineWidthMode, this.m_lineWidthTag, this.m_pattern);
                fWidthTop[iPos] = this.m_lineWidthModeTop == LineWidthMode.DEFAULT ? fWidth[iPos] : this.getGamma(node.m_right, 2, this.m_lineWidthModeTop, this.m_lineWidthTagTop, this.m_patternTop);
                ++iPos;
                bNeedsDrawing[0] = true;
            } else {
                fWidth[iPos] = this.m_nTreeWidth;
                ++iPos;
            }
            fWidth[iPos] = fWidth[iPos - 1];
            fWidthTop[iPos] = fWidthTop[iPos - 1];
            ++iPos;
            if (this.m_lineWidthModeTop == LineWidthMode.DEFAULT && this.m_bCorrectTopOfBranch) {
                float fCurrentWidth = this.getGamma(node, 1, this.m_lineWidthMode, this.m_lineWidthTag, this.m_pattern);
                float fSumWidth = fWidth[iPos - 2] + fWidth[iPos - 4];
                fWidthTop[iPos - 2] = fCurrentWidth * fWidth[iPos - 2] / fSumWidth;
                fWidthTop[iPos - 4] = fCurrentWidth * fWidth[iPos - 4] / fSumWidth;
            }
            if (node.isRoot()) {
                fWidth[iPos] = 0.0f;
                fWidthTop[iPos] = 0.0f;
                ++iPos;
                ++iPos;
            }
        }
        return iPos;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    float getGamma(Node node, int nGroup, LineWidthMode mode, String tag, Pattern pattern) {
        if (mode == LineWidthMode.BY_METADATA_PATTERN) {
            String sMetaData = node.getMetaData();
            try {
                Matcher matcher = pattern.matcher(sMetaData);
                matcher.find();
                int nGroups = matcher.groupCount();
                if (nGroup > nGroups) {
                    nGroup = 1;
                }
                String sMatch = matcher.group(nGroup);
                return Float.parseFloat(sMatch);
            }
            catch (Exception matcher) {
                return 1.0f;
            }
        }
        if (mode == LineWidthMode.BY_METADATA_NUMBER) {
            int index = 0;
            if (nGroup == 1) {
                index = this.m_iPatternForBottom - 1;
            } else {
                index = this.m_iPatternForTop - 1;
                if (index < 0) {
                    index = this.m_iPatternForBottom - 1;
                }
            }
            if (index >= 0) return (float)(node.getMetaDataList().get(index) / Node.g_maxListValue.get(index));
            index = 0;
            return (float)(node.getMetaDataList().get(index) / Node.g_maxListValue.get(index));
        }
        Map<String, Object> map = node.getMetaDataSet();
        if (map == null) return 1.0f;
        Object o = map.get(tag);
        if (o == null) return 1.0f;
        try {
            if (this.m_bWidthsAreZeroBased) {
                double frac = (Double)o / Node.g_maxValue.get(this.m_lineWidthTag);
                return (float)frac;
            }
            double frac = ((Double)o - Node.g_minValue.get(this.m_lineWidthTag)) / (Node.g_maxValue.get(this.m_lineWidthTag) - Node.g_minValue.get(this.m_lineWidthTag));
            return (float)frac;
        }
        catch (Exception exception) {
            try {
                return 1.0f;
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
        return 1.0f;
    }

    int initOrder(Node node, int iNr) throws Exception {
        if (node.isLeaf()) {
            this.m_nOrder[node.m_iLabel] = iNr;
            this.m_nRevOrder[iNr] = node.m_iLabel;
            return iNr + 1;
        }
        iNr = this.initOrder(node.m_left, iNr);
        if (node.m_right != null) {
            iNr = this.initOrder(node.m_right, iNr);
        }
        return iNr;
    }

    int selectionSize() {
        int nSelected = 0;
        int i = 0;
        while (i < this.m_nRevOrder.length) {
            if (this.m_bSelection[this.m_nRevOrder[i]]) {
                ++nSelected;
            }
            ++i;
        }
        return nSelected;
    }

    void checkSelection() {
        if (this.m_bSelection.length > 0 && this.selectionSize() == 0) {
            int i = 0;
            while (i < this.m_bSelection.length) {
                this.m_bSelection[i] = true;
                ++i;
            }
        }
    }

    boolean moveSanityChek() {
        int nSelected = this.selectionSize();
        if (nSelected > 0 && nSelected < this.m_nRevOrder.length - 1) {
            return true;
        }
        JOptionPane.showMessageDialog(null, "To move labels, select at least one, but not all of the labels", "Move error", -1);
        return false;
    }

    void moveSelectedLabelsDown() {
        int i = 1;
        while (i < this.m_nRevOrder.length) {
            if (this.m_bSelection[this.m_nRevOrder[i]] && !this.m_bSelection[this.m_nRevOrder[i - 1]]) {
                int h = this.m_nRevOrder[i];
                this.m_nRevOrder[i] = this.m_nRevOrder[i - 1];
                this.m_nRevOrder[i - 1] = h;
            }
            ++i;
        }
        i = 0;
        while (i < this.m_nRevOrder.length) {
            this.m_nOrder[this.m_nRevOrder[i]] = i;
            ++i;
        }
        this.calcPositions();
        this.addAction(new DoAction());
    }

    void moveSelectedLabelsUp() {
        int i = this.m_nRevOrder.length - 2;
        while (i >= 0) {
            if (this.m_bSelection[this.m_nRevOrder[i]] && !this.m_bSelection[this.m_nRevOrder[i + 1]]) {
                int h = this.m_nRevOrder[i];
                this.m_nRevOrder[i] = this.m_nRevOrder[i + 1];
                this.m_nRevOrder[i + 1] = h;
            }
            --i;
        }
        i = 0;
        while (i < this.m_nRevOrder.length) {
            this.m_nOrder[this.m_nRevOrder[i]] = i;
            ++i;
        }
        this.calcPositions();
        this.addAction(new DoAction());
    }

    public void calcPositions() {
        if (this.m_sLabels == null) {
            return;
        }
        this.setWaitCursor();
        if (!this.m_bAllowSingleChild && this.m_bCladesReady) {
            int i;
            Arrays.fill(this.m_cladePosition, -1.0f);
            boolean bProgress = true;
            do {
                bProgress = false;
                i = 0;
                while (i < this.m_clades.size()) {
                    if (this.m_cladePosition[i] < 0.0f) {
                        this.m_cladePosition[i] = this.positionClades(i);
                        if (this.m_cladePosition[i] >= 0.0f) {
                            bProgress = true;
                        }
                    }
                    ++i;
                }
            } while (bProgress);
            if (this.m_bUseAngleCorrection) {
                i = 0;
                while (i < this.m_clades.size()) {
                    if (this.m_cladeWeight.get(i) > this.m_fAngleCorrectionThresHold) {
                        for (ChildClade child : this.m_cladeChildren.get(i)) {
                            if (this.m_cladeWeight.get(child.m_iLeft) < this.m_fAngleCorrectionThresHold) {
                                this.m_cladePosition[child.m_iLeft] = this.m_cladePosition[i];
                            }
                            if (!(this.m_cladeWeight.get(child.m_iRight) < this.m_fAngleCorrectionThresHold)) continue;
                            this.m_cladePosition[child.m_iRight] = this.m_cladePosition[i];
                        }
                    }
                    ++i;
                }
            }
        }
        int i = 0;
        while (i < this.m_trees.length) {
            if (this.m_nShuffleMode == -5) {
                this.positionLeafsGeo(this.m_trees[i]);
            } else {
                this.positionLeafs(this.m_trees[i]);
            }
            this.positionRest(this.m_trees[i]);
            ++i;
        }
        i = 0;
        while (i < this.m_cTrees.length) {
            if (this.m_nShuffleMode == -5) {
                this.positionLeafsGeo(this.m_cTrees[i]);
            } else {
                this.positionLeafs(this.m_cTrees[i]);
            }
            this.positionRest(this.m_cTrees[i]);
            ++i;
        }
        if (!this.m_bAllowSingleChild && this.m_bCladesReady) {
            for (Node tree : this.m_summaryTree) {
                this.positionLeafs(tree);
                this.positionRest(tree);
            }
        }
    }

    private float positionClades(int iClade) {
        float fMin = this.m_nNrOfLabels;
        float fMax = 0.0f;
        int[] nArray = this.m_clades.get(iClade);
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            fMin = Math.min(fMin, (float)this.m_nOrder[i]);
            fMax = Math.max(fMax, (float)this.m_nOrder[i]);
            ++n2;
        }
        return (fMin + fMax) / 2.0f + 0.5f;
    }

    void positionLeafs(Node node) {
        if (node.isLeaf()) {
            node.m_fPosX = (float)this.m_nOrder[node.m_iLabel] + 0.5f;
        } else {
            this.positionLeafs(node.m_left);
            if (node.m_right != null) {
                this.positionLeafs(node.m_right);
            }
        }
    }

    void positionLeafsGeo(Node node) {
        if (node.isLeaf()) {
            node.m_fPosX = this.m_treeDrawer.m_bRootAtTop ? (float)this.m_nNrOfLabels * (this.m_fLongitude.elementAt(node.m_iLabel).floatValue() - this.m_fMinLong) / (this.m_fMaxLong - this.m_fMinLong) : (float)this.m_nNrOfLabels * (this.m_fMaxLat - this.m_fLatitude.elementAt(node.m_iLabel).floatValue()) / (this.m_fMaxLat - this.m_fMinLat);
        } else {
            this.positionLeafsGeo(node.m_left);
            this.positionLeafsGeo(node.m_right);
        }
    }

    float positionRest(Node node) {
        if (node.isLeaf()) {
            return node.m_fPosX;
        }
        float fPosX = 0.0f;
        fPosX += this.positionRest(node.m_left);
        if (node.m_right != null) {
            fPosX += this.positionRest(node.m_right);
            fPosX = (float)((double)fPosX / 2.0);
        }
        node.m_fPosX = fPosX;
        return fPosX;
    }

    float getMetaData(Node node) {
        try {
            Matcher matcher = this.m_pattern.matcher(node.getMetaData());
            matcher.find();
            int nGroup = 1;
            int nGroups = matcher.groupCount();
            if (nGroup > nGroups) {
                nGroup = 1;
            }
            return Float.parseFloat(matcher.group(nGroup));
        }
        catch (Exception exception) {
            return 1.0f;
        }
    }

    int getMetaDataCategory(Node node) {
        try {
            String match;
            Matcher matcher = this.m_pattern.matcher(node.getMetaData());
            matcher.find();
            int nGroup = 1;
            int nGroups = matcher.groupCount();
            if (nGroup > nGroups) {
                nGroup = 1;
            }
            if (this.m_colorMetaDataCategories.get(match = matcher.group(nGroup)) == null) {
                this.m_colorMetaDataCategories.put(match, this.m_colorMetaDataCategories.size());
            }
            return this.m_colorMetaDataCategories.get(match);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    double positionMetaAll(Node node) {
        node.m_fPosX = this.getMetaData(node);
        if (!node.isLeaf()) {
            double fX1 = this.positionMetaAll(node.m_left);
            double fX2 = this.positionMetaAll(node.m_right);
            return Math.max(fX1, Math.max(fX2, (double)node.m_fPosX));
        }
        return node.m_fPosX;
    }

    void scaleX(Node node, double fScale) {
        node.m_fPosX = (float)((double)this.m_sLabels.size() - (double)node.m_fPosX * fScale);
        if (!node.isLeaf()) {
            this.scaleX(node.m_left, fScale);
            this.scaleX(node.m_right, fScale);
        }
    }

    int collectHeights(Node node, float[] fHeights, int iPos) {
        fHeights[iPos++] = node.m_fPosY;
        if (!node.isLeaf()) {
            iPos = this.collectHeights(node.m_left, fHeights, iPos);
            iPos = this.collectHeights(node.m_right, fHeights, iPos);
        }
        return iPos;
    }

    int collectMetaData(Node node, float[] fHeights, float fLengthToRoot, int iPos, float[] fMetas, int[] nCounts) {
        float fHeight = node.m_fPosY;
        float fMeta = this.getMetaData(node);
        int i = Arrays.binarySearch(fHeights, fHeight);
        while (i >= 0 && fHeights[i] > fLengthToRoot) {
            int n = i;
            fMetas[n] = fMetas[n] + fMeta;
            int n2 = i--;
            nCounts[n2] = nCounts[n2] + 1;
        }
        if (!node.isLeaf()) {
            iPos = this.collectMetaData(node.m_left, fHeights, fHeight, iPos, fMetas, nCounts);
            iPos = this.collectMetaData(node.m_right, fHeights, fHeight, iPos, fMetas, nCounts);
        }
        return iPos;
    }

    void getPosition(Node node, float[] fPosX) {
        if (node.isLeaf()) {
            fPosX[this.m_nOrder[node.m_iLabel]] = node.m_fPosX;
        } else {
            this.getPosition(node.m_left, fPosX);
            if (node.m_right != null) {
                this.getPosition(node.m_right, fPosX);
            }
        }
    }

    void setPosition(Node node, float[] fPosX) {
        if (node.isLeaf()) {
            node.m_fPosX = fPosX[this.m_nOrder[node.m_iLabel]];
        } else {
            this.setPosition(node.m_left, fPosX);
            if (node.m_right != null) {
                this.setPosition(node.m_right, fPosX);
            }
        }
    }

    public float positionHeight(Node node, float fOffSet) {
        if (node.isLeaf()) {
            node.m_fPosY = fOffSet + node.m_fLength;
            return node.m_fPosY;
        }
        float fPosY = fOffSet + node.m_fLength;
        float fYMax = 0.0f;
        fYMax = Math.max(fYMax, this.positionHeight(node.m_left, fPosY));
        if (node.m_right != null) {
            fYMax = Math.max(fYMax, this.positionHeight(node.m_right, fPosY));
        }
        node.m_fPosY = fPosY;
        return fYMax;
    }

    float height(Node node) {
        if (node.isLeaf()) {
            return node.m_fLength;
        }
        return node.m_fLength + Math.max(this.height(node.m_left), this.height(node.m_right));
    }

    public void offsetHeight(Node node, float f) {
        if (!node.isLeaf()) {
            this.offsetHeight(node.m_left, f);
            if (node.m_right != null) {
                this.offsetHeight(node.m_right, f);
            }
        }
        node.m_fPosY += f;
    }

    void divideLength(Node node, float f) {
        if (!node.isLeaf()) {
            this.divideLength(node.m_left, f);
            if (node.m_right != null) {
                this.divideLength(node.m_right, f);
            }
        }
        node.m_fLength /= f;
    }

    void addLength(Node src, Node target) {
        if (!src.isLeaf()) {
            this.addLength(src.m_left, target.m_left);
            if (src.m_right != null) {
                this.addLength(src.m_right, target.m_right);
            }
        }
        target.m_fLength += src.m_fLength;
    }

    void drawLabels(Node node, Graphics2D g) {
        if (this.m_bHideLabels) {
            return;
        }
        g.setFont(this.m_font);
        if (this.m_bShowBounds) {
            return;
        }
        if (node.isLeaf()) {
            if (this.m_bSelection[node.m_iLabel]) {
                if (this.m_iColor == null) {
                    g.setColor(this.m_color[LABELCOLOR]);
                } else {
                    g.setColor(this.m_color[GEOCOLOR + this.m_iColor[node.m_iLabel] % (this.m_color.length - GEOCOLOR)]);
                }
            } else {
                g.setColor(Color.GRAY);
            }
            if (this.m_treeDrawer.m_bRootAtTop) {
                if (this.m_bRotateTextWhenRootAtTop) {
                    int x = (int)(node.m_fPosX * this.m_fScaleX) - g.getFontMetrics().getHeight() / 3;
                    int y = this.getPosY(((this.m_bAlignLabels ? this.m_fHeight : node.m_fPosY) + this.m_fLabelIndent - this.m_fTreeOffset) * this.m_fTreeScale) + 2;
                    g.rotate(1.5707963267948966);
                    g.translate(y, -x);
                    g.drawString(this.m_sLabels.elementAt(node.m_iLabel), 0, 0);
                    g.translate(-y, x);
                    g.rotate(-1.5707963267948966);
                    java.awt.Rectangle r = this.m_bLabelRectangle[node.m_iLabel];
                    r.x = x;
                    r.y = y - 10;
                    r.height = 10;
                    r.width = this.m_nLabelWidth;
                    this.drawImage(g, x, y, node.m_iLabel);
                } else {
                    String sLabel = this.m_sLabels.elementAt(node.m_iLabel);
                    int x = (int)(node.m_fPosX * this.m_fScaleX) - g.getFontMetrics().stringWidth(sLabel) / 2;
                    int y = this.getPosY(((this.m_bAlignLabels ? this.m_fHeight : node.m_fPosY) + this.m_fLabelIndent - this.m_fTreeOffset) * this.m_fTreeScale) + g.getFontMetrics().getHeight() + 2;
                    g.drawString(sLabel, x, y);
                    java.awt.Rectangle r = this.m_bLabelRectangle[node.m_iLabel];
                    r.x = x;
                    r.y = y - 10;
                    r.height = 10;
                    r.width = this.m_nLabelWidth;
                    this.drawImage(g, x, y, node.m_iLabel);
                }
            } else {
                int y = (int)(node.m_fPosX * this.m_fScaleY) + g.getFontMetrics().getHeight() / 3;
                int x = this.getPosX(((this.m_bAlignLabels ? this.m_fHeight : node.m_fPosY) + this.m_fLabelIndent - this.m_fTreeOffset) * this.m_fTreeScale) + 1;
                g.drawString(this.m_sLabels.elementAt(node.m_iLabel), x, y);
                java.awt.Rectangle r = this.m_bLabelRectangle[node.m_iLabel];
                r.x = x;
                r.y = y - 10;
                r.height = 10;
                r.width = this.m_nLabelWidth;
                this.drawImage(g, x, y, node.m_iLabel);
            }
        } else {
            this.drawLabels(node.m_left, g);
            if (node.m_right != null) {
                this.drawLabels(node.m_right, g);
            }
        }
    }

    private void drawImage(Graphics g, int x, int y, int iLabel) {
        if (this.m_LabelImages != null && this.m_LabelImages[iLabel] != null) {
            BufferedImage img = this.m_LabelImages[iLabel];
            g.drawImage(img, x, y - this.m_nImageSize, x + this.m_nImageSize, y, 0, 0, img.getWidth(), img.getHeight(), null);
        }
    }

    void drawGeo(Node node, Graphics g) {
        if (node.isLeaf()) {
            if (this.m_bSelection[node.m_iLabel]) {
                if (this.m_fLongitude.elementAt(node.m_iLabel).floatValue() == 0.0f && this.m_fLatitude.elementAt(node.m_iLabel).floatValue() == 0.0f) {
                    return;
                }
                int gx = (int)((this.m_fLongitude.elementAt(node.m_iLabel).floatValue() - this.m_fMinLong) * this.m_fScaleGX * this.m_fScale);
                int gy = (int)((this.m_fMaxLat - this.m_fLatitude.elementAt(node.m_iLabel).floatValue()) * this.m_fScaleGY * this.m_fScale);
                g.setColor(this.m_color[GEOCOLOR]);
                if (this.m_treeDrawer.m_bRootAtTop) {
                    int x = (int)(node.m_fPosX * this.m_fScaleX * this.m_fScale) + 10;
                    int y = this.getPosY(node.m_fPosY * this.m_fScale);
                    g.drawLine(x, y, gx, gy);
                    g.setColor(Color.BLACK);
                    g.drawOval(gx - 1, gy - 1, 3, 3);
                } else {
                    int y = (int)(node.m_fPosX * this.m_fScaleY * this.m_fScale);
                    int x = this.getPosX(node.m_fPosY * this.m_fScale);
                    if (this.m_bInvertLongitude) {
                        x = 0;
                    }
                    g.drawLine(x, y, gx, gy);
                    g.setColor(Color.BLACK);
                    g.drawOval(gx - 1, gy - 1, 3, 3);
                }
                java.awt.Rectangle r = this.m_bGeoRectangle[node.m_iLabel];
                r.x = gx - 2;
                r.y = gy - 2;
                r.width = 5;
                r.height = 5;
            }
        } else {
            this.drawGeo(node.m_left, g);
            this.drawGeo(node.m_right, g);
        }
    }

    int getPosY(float fHeight) {
        if (this.m_bUseLogScale) {
            return (int)((double)this.m_fHeight / Math.log((double)this.m_fHeight + 1.0) * (double)this.m_fScaleY * (Math.log((double)this.m_fHeight + 1.0) - Math.log((double)(this.m_fHeight - fHeight) + 1.0)));
        }
        return (int)(fHeight * this.m_fScaleY);
    }

    float screenPosToHeight(int nX, int nY) {
        if (this.m_bUseLogScale) {
            return Float.NaN;
        }
        if (this.m_treeDrawer.m_bRootAtTop) {
            return (this.m_fHeight - ((float)nY / this.m_fScaleY + this.m_fTreeOffset)) * this.m_fUserScale;
        }
        return (this.m_fHeight - ((float)nX / this.m_fScaleX + this.m_fTreeOffset)) * this.m_fUserScale;
    }

    int getPosX(float fHeight) {
        if (this.m_bUseLogScale) {
            return (int)((double)this.m_fHeight / Math.log((double)this.m_fHeight + 1.0) * (double)this.m_fScaleX * (Math.log((double)this.m_fHeight + 1.0) - Math.log((double)(this.m_fHeight - fHeight) + 1.0)));
        }
        return (int)(fHeight * this.m_fScaleX);
    }

    public void fitToScreen() {
        if (this.m_sLabels == null) {
            return;
        }
        this.m_fScaleX = 10.0f;
        this.m_fScaleY = 10.0f;
        int nW = (int)((float)this.getWidth() / this.m_fScale) - 24;
        int nH = (int)((float)this.getHeight() / this.m_fScale) - 24;
        nW = this.getWidth() - 24;
        nH = this.getHeight() - 24;
        if (this.m_treeDrawer.m_bRootAtTop) {
            this.m_fScaleX = ((float)nW + 0.0f) / (float)this.m_sLabels.size();
            this.m_fScaleGX = ((float)nW + 0.0f) / (this.m_fMaxLong - this.m_fMinLong);
            if (this.m_fHeight > 0.0f) {
                if (this.m_bRotateTextWhenRootAtTop) {
                    this.m_fScaleY = ((float)(nH - this.m_nLabelWidth) - 0.0f) / this.m_fHeight;
                    this.m_fScaleGY = ((float)(nH - this.m_nLabelWidth) - 0.0f) / (this.m_fMaxLat - this.m_fMinLat);
                } else {
                    this.m_fScaleY = ((float)nH - 10.0f) / this.m_fHeight;
                    this.m_fScaleGY = ((float)nH - 10.0f) / (this.m_fMaxLat - this.m_fMinLat);
                }
            }
        } else {
            if (this.m_sLabels != null && this.m_sLabels.size() > 0) {
                this.m_fScaleY = ((float)nH + 0.0f) / (float)this.m_sLabels.size();
                this.m_fScaleGY = ((float)nH + 0.0f) / (this.m_fMaxLat - this.m_fMinLat);
            }
            if (this.m_fHeight > 0.0f) {
                this.m_fScaleX = ((float)(nW - this.m_nLabelWidth) + 0.0f) / this.m_fHeight;
                this.m_fScaleGX = ((float)(nW - this.m_nLabelWidth) + 0.0f) / (this.m_fMaxLong - this.m_fMinLong);
            }
        }
        this.m_Panel.setPreferredSize(new Dimension((int)((float)nW * this.m_fScale), (int)((float)nH * this.m_fScale)));
        this.m_fScaleX *= this.m_fScale;
        this.m_fScaleY *= this.m_fScale;
        this.m_jScrollPane.revalidate();
        this.makeDirty();
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
        this.fitToScreen();
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    void selectMode(int nXmode) {
        switch (nXmode) {
            case 0: {
                this.m_Xmode = 0;
                this.m_bUseAngleCorrection = false;
                this.m_treeDrawer.m_bViewBlockTree = false;
                this.m_viewClades.setEnabled(false);
                this.m_viewEditTree.setEnabled(true);
                break;
            }
            case 1: {
                this.m_Xmode = 2;
                this.m_bUseAngleCorrection = false;
                this.m_treeDrawer.m_bViewBlockTree = false;
                this.m_viewClades.setEnabled(true);
                this.m_viewEditTree.setEnabled(false);
                break;
            }
            case 2: {
                this.m_Xmode = 1;
                this.m_bUseAngleCorrection = false;
                this.m_treeDrawer.m_bViewBlockTree = false;
                this.m_viewClades.setEnabled(true);
                this.m_viewEditTree.setEnabled(false);
                break;
            }
            case 3: {
                this.m_Xmode = 1;
                this.m_bUseAngleCorrection = true;
                this.m_treeDrawer.m_bViewBlockTree = false;
                this.m_viewClades.setEnabled(true);
                this.m_viewEditTree.setEnabled(false);
            }
        }
        this.calcPositions();
        this.calcLines();
        this.makeDirty();
        for (ChangeListener listener : this.m_changeListeners) {
            listener.stateChanged(null);
        }
    }

    public void resetStyle() {
        this.setStyle(this.m_nStyle);
    }

    void setStyle(int nStyle) {
        this.m_nStyle = nStyle;
        BranchDrawer bd = null;
        switch (nStyle) {
            case 0: {
                bd = this.m_lineWidthMode != LineWidthMode.DEFAULT ? new TrapeziumBranchDrawer() : new BranchDrawer();
                this.m_treeDrawer.m_bViewBlockTree = false;
                break;
            }
            case 1: {
                bd = this.m_lineWidthMode != LineWidthMode.DEFAULT ? new TrapeziumBranchDrawer() : new BranchDrawer();
                this.m_treeDrawer.m_bViewBlockTree = true;
                break;
            }
            case 2: {
                bd = new ArcBranchDrawer();
                this.m_treeDrawer.m_bViewBlockTree = false;
                break;
            }
            case 3: {
                bd = new SteepArcBranchDrawer();
                this.m_treeDrawer.m_bViewBlockTree = false;
            }
        }
        if (bd != null) {
            this.m_treeDrawer.setBranchDrawer(bd);
            this.makeDirty();
        }
    }

    Icon getIcon(String sIcon) {
        URL tempURL = ClassLoader.getSystemResource(ICONPATH + sIcon + ".png");
        if (tempURL != null) {
            return new ImageIcon(tempURL);
        }
        return null;
    }

    public void makeDirty() {
        this.m_Panel.m_rotationPoints = null;
        if (this.m_bAutoRefresh) {
            this.m_Panel.clearImage();
        } else {
            this.m_bIsDirty = true;
        }
        this.repaint();
    }

    public JMenuBar getMenuBar() {
        return this.m_menuBar;
    }

    void exportPDF(String sFileName) {
        try {
            Document doc = new Document();
            PdfWriter writer = PdfWriter.getInstance(doc, new FileOutputStream(sFileName));
            doc.setPageSize(new Rectangle(this.m_Panel.getWidth(), this.m_Panel.getHeight()));
            doc.open();
            PdfContentByte cb = writer.getDirectContent();
            PdfGraphics2D g = new PdfGraphics2D(cb, this.m_Panel.getWidth(), this.m_Panel.getHeight());
            ((Graphics)g).setPaintMode();
            ((Graphics)g).setColor(this.getBackground());
            ((Graphics)g).fillRect(0, 0, this.m_Panel.getWidth(), this.m_Panel.getHeight());
            this.m_Panel.paint(g);
            ((Graphics)g).dispose();
            doc.close();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this.m_Panel, "Export may have failed: " + e.getMessage());
        }
    }

    public void doOpen(String sFileName) {
        if (sFileName.lastIndexOf(47) > 0) {
            this.m_sDir = sFileName.substring(0, sFileName.lastIndexOf(47));
        }
        try {
            this.init(sFileName);
            this.calcLines();
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, "Error loading file: " + e.getMessage(), "File load error", -1);
            return;
        }
        this.m_jStatusBar.setText("Loaded " + sFileName);
        this.fitToScreen();
    }

    public void loadImages() {
        JFileChooser fc = new JFileChooser(this.m_sDir);
        fc.setDialogTitle("Load Image Map (text file mapping taxon names on image files)");
        int rval = fc.showOpenDialog(this.m_Panel);
        if (rval == 0) {
            String sFileName = fc.getSelectedFile().toString();
            if (sFileName.lastIndexOf(47) > 0) {
                this.m_sDir = sFileName.substring(0, sFileName.lastIndexOf(47));
            }
            try {
                this.m_LabelImages = new BufferedImage[this.m_sLabels.size()];
                BufferedReader fin = new BufferedReader(new FileReader(sFileName));
                String sStr = null;
                fin.readLine();
                while (fin.ready()) {
                    sStr = fin.readLine();
                    if (sStr.trim().equals("")) continue;
                    String[] sStrs = sStr.split("\\s+");
                    if (sStrs.length != 2) {
                        JOptionPane.showMessageDialog(this.m_Panel, "Found \"" + sStr + "\" but expected only two words on a line");
                        this.m_LabelImages = null;
                        fin.close();
                        return;
                    }
                    String sLabel = sStrs[0].toLowerCase();
                    String imageFile = sStrs[1];
                    int k = 0;
                    while (k < this.m_sLabels.size() && !this.m_sLabels.get(k).toLowerCase().equals(sLabel)) {
                        ++k;
                    }
                    if (k == this.m_sLabels.size()) {
                        JOptionPane.showMessageDialog(this.m_Panel, "Taxon \"" + sLabel + "\" could not be found");
                        this.m_LabelImages = null;
                        fin.close();
                        return;
                    }
                    System.err.println("Loading " + imageFile);
                    File file = new File(imageFile);
                    if (file.exists()) {
                        this.m_LabelImages[k] = ImageIO.read(file);
                        continue;
                    }
                    System.err.println("File " + imageFile + " does not exist");
                }
                fin.close();
            }
            catch (OutOfMemoryError e) {
                JOptionPane.showMessageDialog(null, "Error loading file: " + e.getMessage(), "File load error", -1);
                this.m_LabelImages = null;
                return;
            }
            catch (Exception e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(null, "Error loading file: " + e.getMessage(), "File load error", -1);
                this.m_LabelImages = null;
                return;
            }
            this.makeDirty();
        }
    }

    void loadBGImage(String sFileName) throws Exception {
        this.m_bgImage = ImageIO.read(new File(sFileName));
        try {
            Pattern pattern = Pattern.compile(".*\\(([0-9\\.Ee-]+),([0-9\\.Ee-]+)\\)x\\(([0-9\\.Ee-]+),([0-9\\.Ee-]+)\\).*");
            Matcher matcher = pattern.matcher(sFileName);
            matcher.find();
            this.m_fBGImageBox[1] = Float.parseFloat(matcher.group(1));
            this.m_fBGImageBox[0] = Float.parseFloat(matcher.group(2));
            this.m_fBGImageBox[3] = Float.parseFloat(matcher.group(3));
            this.m_fBGImageBox[2] = Float.parseFloat(matcher.group(4));
        }
        catch (Exception e) {
            double[] fBGImageBox = new double[]{-180.0, -90.0, 180.0, 90.0};
            this.m_fBGImageBox = fBGImageBox;
        }
    }

    void renumber(Node node, int iNodeNr) {
        if (node.isLeaf()) {
            if (node.getNr() > iNodeNr) {
                --node.m_iLabel;
            }
        } else {
            this.renumber(node.m_left, iNodeNr);
            this.renumber(node.m_right, iNodeNr);
        }
    }

    Node deleteLeaf(Node node, int iNodeNr) {
        if (node.isLeaf()) {
            if (node.getNr() == iNodeNr) {
                Node sibling;
                Node parent = node.getParent();
                Node node2 = sibling = parent.m_left == node ? parent.m_right : parent.m_left;
                if (parent.isRoot()) {
                    sibling.m_Parent = null;
                    return sibling;
                }
                Node grandparent = parent.getParent();
                if (grandparent.m_left == parent) {
                    grandparent.m_left = sibling;
                } else {
                    grandparent.m_right = sibling;
                }
                sibling.m_Parent = grandparent;
                sibling.m_fLength += parent.m_fLength;
            }
        } else {
            Node node2 = this.deleteLeaf(node.m_left, iNodeNr);
            if (node2.isRoot()) {
                return node2;
            }
            node2 = this.deleteLeaf(node.m_right, iNodeNr);
            if (node2.isRoot()) {
                return node2;
            }
        }
        return node;
    }

    void addAction(DoAction action) {
        while (this.m_iUndo < this.m_doActions.size()) {
            this.m_doActions.remove(this.m_iUndo);
        }
        this.m_doActions.add(action);
        ++this.m_iUndo;
    }

    void makeToolbar() {
        this.m_jTbTools.setFloatable(false);
        this.m_jTbTools.add(this.a_load);
        this.m_jTbTools.addSeparator(new Dimension(2, 2));
        this.m_jTbTools.add(this.a_drawtreeset);
        this.m_jTbTools.addSeparator(new Dimension(2, 2));
        this.m_jTbTools.add(this.a_browsefirst);
        this.m_jTbTools.add(this.a_browseprev);
        this.m_jTbTools.add(this.a_animateStart);
        this.m_jTbTools.add(this.a_browsenext);
        this.m_jTbTools.add(this.a_browselast);
        this.m_jTbTools.addSeparator(new Dimension(2, 2));
        this.m_jTbTools.add(this.a_intensityUp);
        this.m_jTbTools.add(this.a_intensityDown);
        this.m_jTbTools.add(this.a_cIntensityUp);
        this.m_jTbTools.add(this.a_cIntensityDown);
        this.m_jTbTools.addSeparator(new Dimension(2, 2));
        this.m_jTbTools.add(this.a_treeWidthUp);
        this.m_jTbTools.add(this.a_treeWidthDown);
        this.m_jTbTools.add(this.a_cTreeWidthUp);
        this.m_jTbTools.add(this.a_cTreeWidthDown);
        this.m_jTbTools.addSeparator(new Dimension(2, 2));
        this.m_jTbTools.add(this.a_animationSpeedDown);
        this.m_jTbTools.add(this.a_animationSpeedUp);
        this.m_jTbTools.addSeparator(new Dimension(2, 2));
        this.m_jTbTools.add(this.a_jitterUp);
        this.m_jTbTools.add(this.a_jitterDown);
        this.m_jTbTools.addSeparator(new Dimension(2, 2));
        this.m_jTbTools.add(this.a_help);
        AbstractAction action = new AbstractAction("Button Label", this.getIcon("modedefault")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                DensiTree.this.selectMode(0);
            }
        };
        AbstractAction action3 = new AbstractAction("", this.getIcon("modestar")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                DensiTree.this.selectMode(1);
            }
        };
        AbstractAction action4 = new AbstractAction("", this.getIcon("modecentralised")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                DensiTree.this.selectMode(2);
            }
        };
        AbstractAction action5 = new AbstractAction("", this.getIcon("modeanglecorrected")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                DensiTree.this.selectMode(3);
            }
        };
        if (Util.isMac()) {
            B = 10;
        }
        JPanel panel = new JPanel();
        panel.setBorder(new EmptyBorder(3, B, 5, B));
        panel.setLayout(new GridLayout(0, 2));
        panel.add(this.createToolBarButton(action));
        panel.add(this.createToolBarButton(action3));
        panel.add(this.createToolBarButton(action4));
        panel.add(this.createToolBarButton(action5));
        JPanel toolPanel = new JPanel();
        toolPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridwidth = 1;
        gbc.fill = 2;
        gbc.anchor = 19;
        gbc.gridx = 0;
        gbc.gridy = 0;
        toolPanel.add((Component)panel, gbc);
        AbstractAction action6 = new AbstractAction("", this.getIcon("stylestraight")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                DensiTree.this.setStyle(0);
            }
        };
        AbstractAction action7 = new AbstractAction("", this.getIcon("styleblock")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                DensiTree.this.setStyle(1);
            }
        };
        AbstractAction action8 = new AbstractAction("", this.getIcon("stylearced")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                DensiTree.this.setStyle(2);
            }
        };
        AbstractAction action9 = new AbstractAction("", this.getIcon("stylesteep")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                DensiTree.this.setStyle(3);
            }
        };
        panel = new JPanel();
        panel.setBorder(new EmptyBorder(3, B, 3, B));
        panel.setLayout(new GridLayout(0, 2));
        panel.add(this.createToolBarButton(action6));
        panel.add(this.createToolBarButton(action7));
        panel.add(this.createToolBarButton(action8));
        panel.add(this.createToolBarButton(action9));
        ++gbc.gridy;
        toolPanel.add((Component)panel, gbc);
        ++gbc.gridy;
        toolPanel.add((Component)new ExpandablePanel("Show", new ShowPanel(this)), gbc);
        ++gbc.gridy;
        toolPanel.add((Component)new ExpandablePanel("Grid", new GridPanel(this)), gbc);
        ++gbc.gridy;
        toolPanel.add((Component)new ExpandablePanel("Label", new LabelPanel(this)), gbc);
        ++gbc.gridy;
        toolPanel.add((Component)new ExpandablePanel("Geography", new GeoPanel(this)), gbc);
        ++gbc.gridy;
        toolPanel.add((Component)new ExpandablePanel("Line Width", new LineWidthPanel(this)), gbc);
        ++gbc.gridy;
        toolPanel.add((Component)new ExpandablePanel("Line Color", new ColorPanel(this)), gbc);
        ++gbc.gridy;
        toolPanel.add((Component)new ExpandablePanel("Burn in", new BurninPanel(this)), gbc);
        ++gbc.gridy;
        toolPanel.add((Component)new ExpandablePanel("Clades", new CladePanel(this)), gbc);
        this.m_jTbTools2.add(toolPanel);
        this.m_cladelist = new JList<String>(this.m_cladelistmodel);
        this.m_cladelist.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (DensiTree.this.m_bAllowCladeSelection) {
                    DensiTree.this.m_cladeSelection.clear();
                    int[] nArray = DensiTree.this.m_cladelist.getSelectedIndices();
                    int n = nArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        int i = nArray[n2];
                        if (DensiTree.this.m_cladeWeight.get(i) > 0.01 && (DensiTree.this.m_Xmode == 1 && DensiTree.this.m_clades.get(i).length > 1 || DensiTree.this.m_Xmode == 2 && DensiTree.this.m_clades.get(i).length == 1)) {
                            DensiTree.this.m_cladeSelection.add(i);
                        }
                        ++n2;
                    }
                    DensiTree.this.resetCladeSelection();
                    System.err.println(DensiTree.this.m_cladelist.getSelectedValuesList());
                    System.err.println(String.valueOf(DensiTree.this.m_cladelist.getSelectedValuesList().size()) + " items selected");
                    DensiTree.this.repaint();
                }
            }
        });
        JScrollPane scrollingList = new JScrollPane(this.m_cladelist);
        this.m_jTbCladeTools.setLayout(new BorderLayout());
        this.m_jTbCladeTools.add((Component)scrollingList, "Center");
        this.m_jTbCladeTools.setFloatable(false);
        this.m_jTbCladeTools.setVisible(false);
    }

    private JButton createToolBarButton(Action action) {
        JButton c1 = new JButton(action);
        c1.setText(null);
        c1.setMargin(new Insets(0, 0, 0, 0));
        return c1;
    }

    void setIcon(JCheckBoxMenuItem item, String sIcon) {
        URL tempURL = ClassLoader.getSystemResource(ICONPATH + sIcon + ".png");
        if (tempURL != null) {
            item.setIcon(new ImageIcon(tempURL));
        } else {
            item.setIcon(new ImageIcon(new BufferedImage(20, 20, 6)));
        }
    }

    protected void makeMenuBar() {
        this.m_menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu("File");
        fileMenu.setMnemonic('F');
        this.m_menuBar.add(fileMenu);
        fileMenu.add(this.a_new);
        fileMenu.add(this.a_load);
        fileMenu.add(this.a_saveas);
        fileMenu.add(this.a_loadimage);
        fileMenu.addSeparator();
        fileMenu.add(this.a_print);
        fileMenu.add(this.a_export);
        if (!Util.isMac()) {
            fileMenu.addSeparator();
            fileMenu.add(this.a_quit);
        }
        JMenu editMenu = new JMenu("Edit");
        editMenu.setMnemonic('E');
        this.m_menuBar.add(editMenu);
        editMenu.add(this.a_undo);
        editMenu.add(this.a_redo);
        editMenu.add(this.a_selectAll);
        editMenu.add(this.a_unselectAll);
        editMenu.add(this.a_del);
        editMenu.add(this.a_paste);
        editMenu.add(this.a_moveup);
        editMenu.add(this.a_movedown);
        this.m_viewEditTree = new JCheckBoxMenuItem("Show Edit Tree", this.m_bViewEditTree);
        this.m_viewEditTree.setIcon(new ImageIcon(new BufferedImage(20, 20, 6)));
        this.m_viewEditTree.addActionListener(ae -> {
            boolean bPrev = this.m_bViewEditTree;
            this.m_bViewEditTree = this.m_viewEditTree.getState();
            if (bPrev != this.m_bViewEditTree) {
                this.makeDirty();
            }
        });
        editMenu.add(this.m_viewEditTree);
        this.m_viewClades = new JCheckBoxMenuItem("Show Clades", this.m_bViewClades);
        this.m_viewClades.setIcon(new ImageIcon(new BufferedImage(20, 20, 6)));
        this.m_viewClades.addActionListener(ae -> {
            boolean bPrev = this.m_bViewClades;
            this.m_bViewClades = this.m_viewClades.getState();
            if (bPrev != this.m_bViewClades) {
                this.makeDirty();
            }
        });
        this.m_viewClades.setEnabled(false);
        editMenu.add(this.m_viewClades);
        JMenu shuffleMenu = new JMenu("Shuffle");
        shuffleMenu.setIcon(new ImageIcon(new BufferedImage(20, 20, 6)));
        shuffleMenu.add(new ShuffleAction("Most Frequent", "Use most frequent tree order", "", -1, -3));
        shuffleMenu.add(new ShuffleAction("Closest Outside First", "Order closest to outside leaf first", "", 595, -2));
        shuffleMenu.add(new ShuffleAction("Optimised root canal tree", "Use root canal tree, then optimise", "", 591, 7));
        shuffleMenu.add(new ShuffleAction("Closest First", "Order closest leaf first", "", 561, -1));
        shuffleMenu.add(new ShuffleAction("Single link", "Single link hierarchical clusterer", "", 562, 0));
        shuffleMenu.add(new ShuffleAction("Complete link", "Complete link hierarchical clusterer", "", 563, 1));
        shuffleMenu.add(new ShuffleAction("Average link", "Average link hierarchical clusterer", "", 564, 2));
        shuffleMenu.add(new ShuffleAction("Mean link", "Mean link hierarchical clusterer", "", 565, 3));
        shuffleMenu.add(new ShuffleAction("Adjusted complete link", "Adjusted complete link hierarchical clusterer", "", 566, 6));
        shuffleMenu.addSeparator();
        shuffleMenu.add(new ShuffleAction("Manual", "Manual", "", -1, -4));
        shuffleMenu.add(new ShuffleAction("By Geography", "By Geography", "", -1, -5));
        shuffleMenu.add(new ShuffleAction("By meta data, all", "By meta data, show all paths", "", 567, 100));
        shuffleMenu.add(new ShuffleAction("By meta data, sum", "By meta data, sum over paths", "", 568, 101));
        shuffleMenu.add(new ShuffleAction("By meta data, mean", "By meta data, average over paths", "", 569, 102));
        editMenu.addSeparator();
        editMenu.add(shuffleMenu);
        JMenu drawallMenu = new JMenu("Draw All");
        drawallMenu.setMnemonic('D');
        this.m_menuBar.add(drawallMenu);
        JCheckBoxMenuItem autoRefresh = new JCheckBoxMenuItem("Automatically refresh", this.m_bAutoRefresh);
        autoRefresh.addActionListener(ae -> {
            this.m_bAutoRefresh = autoRefresh.getState();
            if (this.m_bAutoRefresh && this.m_bIsDirty) {
                this.fitToScreen();
            }
        });
        drawallMenu.add(autoRefresh);
        drawallMenu.add(this.a_drawtreeset);
        JMenu browseMenu = new JMenu("Browse");
        browseMenu.setMnemonic('B');
        this.m_menuBar.add(browseMenu);
        browseMenu.add(this.a_browsefirst);
        browseMenu.add(this.a_browseprev);
        browseMenu.add(this.a_animateStart);
        browseMenu.add(this.a_browsenext);
        browseMenu.add(this.a_browselast);
        browseMenu.addSeparator();
        JCheckBoxMenuItem animateOverWrite = new JCheckBoxMenuItem("Over write", this.m_bAnimateOverwrite);
        animateOverWrite.addActionListener(ae -> {
            this.m_bAnimateOverwrite = animateOverWrite.getState();
        });
        browseMenu.add(animateOverWrite);
        JMenu settingsMenu = new JMenu("Settings");
        settingsMenu.setMnemonic('S');
        this.m_menuBar.add(settingsMenu);
        settingsMenu.addSeparator();
        settingsMenu.add(this.a_intensityUp);
        settingsMenu.add(this.a_intensityDown);
        settingsMenu.add(this.a_cIntensityUp);
        settingsMenu.add(this.a_cIntensityDown);
        settingsMenu.addSeparator();
        settingsMenu.add(this.a_treeWidthUp);
        settingsMenu.add(this.a_treeWidthDown);
        settingsMenu.add(this.a_cTreeWidthUp);
        settingsMenu.add(this.a_cTreeWidthDown);
        settingsMenu.addSeparator();
        settingsMenu.add(this.a_animationSpeedDown);
        settingsMenu.add(this.a_animationSpeedUp);
        settingsMenu.addSeparator();
        settingsMenu.add(this.a_jitterUp);
        settingsMenu.add(this.a_jitterDown);
        settingsMenu.addSeparator();
        settingsMenu.add(this.a_threadsUp);
        settingsMenu.add(this.a_threadsDown);
        JMenu windowMenu = new JMenu("Window");
        windowMenu.setMnemonic('W');
        this.m_menuBar.add(windowMenu);
        windowMenu.add(this.a_viewstatusbar);
        windowMenu.add(this.a_viewtoolbar);
        windowMenu.add(this.a_viewtoolbar2);
        windowMenu.add(this.a_viewcladetoolbar);
        windowMenu.addSeparator();
        windowMenu.add(this.a_zoomin);
        windowMenu.add(this.a_zoomout);
        windowMenu.add(this.a_zoomintree);
        windowMenu.add(this.a_zoomouttree);
        JMenu helpMenu = new JMenu("Help");
        helpMenu.setMnemonic('H');
        this.m_menuBar.add(helpMenu);
        helpMenu.add(this.a_help);
        helpMenu.add(this.a_viewClades);
        if (!Util.isMac()) {
            helpMenu.add(this.a_about);
        }
    }

    public static DensiTree startNew(String[] args) {
        JFrame f;
        final DensiTree a = new DensiTree(new String[0]);
        if (Util.isMac()) {
            try {
                URL url = ClassLoader.getSystemResource("viz/icons/DensiTree.png");
                ImageIcon icon = new ImageIcon(url);
                Application application = new Application(null, "DensiTree", "about", icon){

                    @Override
                    public void initialize() {
                    }

                    @Override
                    protected JFrame getDefaultFrame() {
                        return null;
                    }

                    @Override
                    public void doQuit() {
                        a.a_quit.actionPerformed(null);
                    }

                    @Override
                    public void doAbout() {
                        a.a_about.actionPerformed(null);
                    }

                    @Override
                    public DocumentFrame doOpenFile(File file) {
                        return null;
                    }

                    @Override
                    public DocumentFrame doNew() {
                        return null;
                    }
                };
                Utils.macOSXRegistration(application);
            }
            catch (Exception url) {
                // empty catch block
            }
        }
        a.frame = f = new JFrame(FRAME_TITLE);
        f.setVisible(true);
        a.parseArgs(args);
        JMenuBar menuBar = a.getMenuBar();
        f.setJMenuBar(menuBar);
        f.add((Component)a.m_jTbTools, "North");
        f.add((Component)a.m_jTbTools2, "East");
        JSplitPane splitPane = new JSplitPane(0, a, a.m_jTbCladeTools);
        splitPane.setDividerLocation(0.9);
        f.add((Component)splitPane, "Center");
        f.add((Component)a.m_jStatusBar, "South");
        f.setDefaultCloseOperation(2);
        Dimension dim = a.getSize();
        f.setSize(dim.width + 31, dim.height + 40 + 84);
        f.setLocation(instances * 10, instances * 10);
        a.fitToScreen();
        URL tempURL = ClassLoader.getSystemResource("viz/icons/DensiTree.png");
        try {
            f.setIconImage(ImageIO.read(tempURL));
        }
        catch (Exception exception) {
            // empty catch block
        }
        a.m_Panel.setFocusable(true);
        return a;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.m_changeListeners.add(changeListener);
    }

    public static void main(String[] args) {
        Util.loadUIManager();
        DensiTree.startNew(args);
    }

    class ChildClade {
        int m_iLeft;
        int m_iRight;
        double m_fWeight;

        ChildClade() {
        }

        public String toString() {
            return "(" + this.m_iLeft + "," + this.m_iRight + ")" + this.m_fWeight + " ";
        }
    }

    class ColorAction
    extends MyAction {
        private static final long serialVersionUID = 1L;
        int m_iColor;

        public ColorAction(String sName, String sToolTipText, String sIcon, int nAcceleratorKey, int iColor) {
            super(sName, sToolTipText, sIcon, nAcceleratorKey);
            this.m_iColor = iColor;
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            Color newColor = JColorChooser.showDialog(DensiTree.this.m_Panel, DensiTree.this.getName(), DensiTree.this.m_color[this.m_iColor]);
            if (newColor != null) {
                DensiTree.this.m_color[this.m_iColor] = newColor;
                DensiTree.this.makeDirty();
            }
            DensiTree.this.repaint();
        }
    }

    class DoAction {
        int[] m_nOrder2;
        int[] m_nRevOrder2;
        float[] m_fPosX;

        DoAction() {
            this.m_nOrder2 = (int[])DensiTree.this.m_nOrder.clone();
            this.m_nRevOrder2 = (int[])DensiTree.this.m_nRevOrder.clone();
            this.m_fPosX = new float[DensiTree.this.m_sLabels.size()];
            DensiTree.this.getPosition(DensiTree.this.m_trees[0], this.m_fPosX);
        }

        void doThisAction() {
            DensiTree.this.m_nOrder = (int[])this.m_nOrder2.clone();
            DensiTree.this.m_nRevOrder = (int[])this.m_nRevOrder2.clone();
            int i = 0;
            while (i < DensiTree.this.m_trees.length) {
                DensiTree.this.setPosition(DensiTree.this.m_trees[i], this.m_fPosX);
                DensiTree.this.positionRest(DensiTree.this.m_trees[i]);
                ++i;
            }
            i = 0;
            while (i < DensiTree.this.m_cTrees.length) {
                DensiTree.this.setPosition(DensiTree.this.m_cTrees[i], this.m_fPosX);
                DensiTree.this.positionRest(DensiTree.this.m_cTrees[i]);
                ++i;
            }
            DensiTree.this.calcLines();
            DensiTree.this.makeDirty();
        }
    }

    public static enum LineColorMode {
        COLOR_BY_CLADE,
        BY_METADATA_PATTERN,
        DEFAULT,
        COLOR_BY_METADATA_TAG;

    }

    public static enum LineWidthMode {
        BY_METADATA_PATTERN,
        BY_METADATA_NUMBER,
        DEFAULT,
        BY_METADATA_TAG;

    }

    public static enum MetaDataType {
        NUMERIC,
        STRING,
        SET;

    }

    class MyAction
    extends AbstractAction {
        private static final long serialVersionUID = -2038911111935517L;

        public MyAction(String sName, String sToolTipText, String sIcon, int acceleratorKey) {
            super(sName);
            KeyStroke acceleratorKeystroke = KeyStroke.getKeyStroke(acceleratorKey, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
            if ((acceleratorKey & 0x200) > 0) {
                acceleratorKeystroke = KeyStroke.getKeyStroke(acceleratorKey - 512, 512);
            }
            this.putValue("ShortDescription", sToolTipText);
            this.putValue("LongDescription", sToolTipText);
            if (acceleratorKeystroke != null && acceleratorKeystroke.getKeyCode() >= 0) {
                this.putValue("AcceleratorKey", acceleratorKeystroke);
            }
            this.putValue("MnemonicKey", new Integer(sName.charAt(0)));
            URL tempURL = ClassLoader.getSystemResource(DensiTree.ICONPATH + sIcon + ".png");
            if (tempURL != null) {
                this.putValue("SmallIcon", new ImageIcon(tempURL));
            } else {
                this.putValue("SmallIcon", new ImageIcon(new BufferedImage(20, 20, 6)));
            }
        }

        public MyAction(String sName, String sToolTipText, String sIcon, KeyStroke acceleratorKeystroke) {
            super(sName);
            this.putValue("ShortDescription", sToolTipText);
            this.putValue("LongDescription", sToolTipText);
            if (acceleratorKeystroke != null && acceleratorKeystroke.getKeyCode() >= 0) {
                this.putValue("AcceleratorKey", acceleratorKeystroke);
            }
            this.putValue("MnemonicKey", new Integer(sName.charAt(0)));
            URL tempURL = ClassLoader.getSystemResource(DensiTree.ICONPATH + sIcon + ".png");
            if (!Util.isMac()) {
                if (tempURL != null) {
                    this.putValue("SmallIcon", new ImageIcon(tempURL));
                } else {
                    this.putValue("SmallIcon", new ImageIcon(new BufferedImage(20, 20, 6)));
                }
            }
        }

        void setIcon(String sIcon) {
            URL tempURL = ClassLoader.getSystemResource(DensiTree.ICONPATH + sIcon + ".png");
            if (tempURL != null) {
                this.putValue("SmallIcon", new ImageIcon(tempURL));
            } else {
                this.putValue("SmallIcon", new ImageIcon(new BufferedImage(20, 20, 6)));
            }
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
        }
    }

    abstract class MyFileFilter
    extends FileFilter {
        MyFileFilter() {
        }

        @Override
        public boolean accept(File f) {
            return f.isDirectory() || f.getName().toLowerCase().endsWith(this.getExtention());
        }

        public abstract String getExtention();
    }

    class SettingAction
    extends MyAction {
        private static final long serialVersionUID = 1L;
        String m_sName;

        public SettingAction(String sName, String sToolTipText, String sIcon, int nAcceleratorKey) {
            super(sName, sToolTipText, sIcon, nAcceleratorKey);
            this.m_sName = sName;
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            if (this.m_sName.equals("Jitter+")) {
                ++DensiTree.this.m_nJitter;
                if (DensiTree.this.m_nJitter >= 0) {
                    DensiTree.this.makeDirty();
                }
            }
            if (this.m_sName.equals("Jitter-")) {
                --DensiTree.this.m_nJitter;
                if (DensiTree.this.m_nJitter >= 0) {
                    DensiTree.this.makeDirty();
                }
            }
            if (this.m_sName.equals("Intensity+")) {
                DensiTree.this.m_fTreeIntensity = (float)((double)DensiTree.this.m_fTreeIntensity * 1.1);
                DensiTree.this.makeDirty();
            }
            if (this.m_sName.equals("Intensity-")) {
                DensiTree.this.m_fTreeIntensity = (float)((double)DensiTree.this.m_fTreeIntensity / 1.1);
                DensiTree.this.makeDirty();
            }
            if (this.m_sName.equals("Consensus Intensity+")) {
                DensiTree.this.m_fCTreeIntensity = (float)((double)DensiTree.this.m_fCTreeIntensity * 1.1);
                DensiTree.this.makeDirty();
            }
            if (this.m_sName.equals("Consensus Intensity-")) {
                DensiTree.this.m_fCTreeIntensity = (float)((double)DensiTree.this.m_fCTreeIntensity / 1.1);
                DensiTree.this.makeDirty();
            }
            if (this.m_sName.equals("Consensus Tree Width+")) {
                ++DensiTree.this.m_nCTreeWidth;
                DensiTree.this.makeDirty();
            }
            if (this.m_sName.equals("Consensus Tree Width-")) {
                --DensiTree.this.m_nCTreeWidth;
                if (DensiTree.this.m_nCTreeWidth <= 1) {
                    DensiTree.this.m_nCTreeWidth = 1;
                }
                DensiTree.this.makeDirty();
            }
            if (this.m_sName.equals("Tree Width+")) {
                ++DensiTree.this.m_nTreeWidth;
                DensiTree.this.makeDirty();
            }
            if (this.m_sName.equals("Tree Width-")) {
                --DensiTree.this.m_nTreeWidth;
                if (DensiTree.this.m_nTreeWidth <= 1) {
                    DensiTree.this.m_nTreeWidth = 1;
                }
                DensiTree.this.makeDirty();
            }
            if (this.m_sName.equals("Drawing Threads+")) {
                DensiTree.this.m_Panel.stopDrawThreads();
                ++DensiTree.this.m_Panel.m_nDrawThreads;
                DensiTree.this.m_Panel.m_drawThread = new Thread[DensiTree.this.m_Panel.m_nDrawThreads];
            }
            if (this.m_sName.equals("Drawing Threads-") && DensiTree.this.m_Panel.m_nDrawThreads > 1) {
                DensiTree.this.m_Panel.stopDrawThreads();
                --DensiTree.this.m_Panel.m_nDrawThreads;
                DensiTree.this.m_Panel.m_drawThread = new Thread[DensiTree.this.m_Panel.m_nDrawThreads];
            }
            if (this.m_sName.equals("Animation Speed-")) {
                DensiTree.this.m_nAnimationDelay += 1 + DensiTree.this.m_nAnimationDelay / 10;
            }
            if (this.m_sName.equals("Animation Speed+") && DensiTree.this.m_nAnimationDelay > 0) {
                DensiTree.this.m_nAnimationDelay -= 1 + DensiTree.this.m_nAnimationDelay / 10;
            }
            if (this.m_sName.equals("Angle Correction+")) {
                DensiTree.this.m_fAngleCorrectionThresHold *= 1.1;
                if (DensiTree.this.m_fAngleCorrectionThresHold > 0.999) {
                    DensiTree.this.m_fAngleCorrectionThresHold = 0.999;
                }
                System.err.println("Angle Correction ThresHold = " + DensiTree.this.m_fAngleCorrectionThresHold);
                DensiTree.this.calcPositions();
                DensiTree.this.calcLines();
                DensiTree.this.makeDirty();
            }
            if (this.m_sName.equals("Angle Correction-")) {
                DensiTree.this.m_fAngleCorrectionThresHold /= 1.1;
                System.err.println("Angle Correction ThresHold = " + DensiTree.this.m_fAngleCorrectionThresHold);
                DensiTree.this.calcPositions();
                DensiTree.this.calcLines();
                DensiTree.this.makeDirty();
            }
            DensiTree.this.repaint();
            System.err.print(DensiTree.this.getStatus());
        }
    }

    class ShuffleAction
    extends MyAction {
        private static final long serialVersionUID = 1L;
        int m_nMode;

        public ShuffleAction(String sName, String sToolTipText, String sIcon, int nAcceleratorKey, int nMode) {
            super(sName, sToolTipText, sIcon, nAcceleratorKey);
            this.m_nMode = nMode;
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            DensiTree.this.setWaitCursor();
            DensiTree.this.reshuffle(this.m_nMode);
            DensiTree.this.setDefaultCursor();
        }
    }

    public static enum ViewMode {
        DRAW,
        ANIMATE,
        BROWSE;

    }
}

