/*
 * This file is autogenerated with bcop:
 * The Compiz option code generator
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */


#include <core/core.h>

#include "shelf_options.h"

ShelfOptions::ShelfOptions (bool init /* = true */) :
    mOptions (ShelfOptions::OptionNum),
    mNotify (ShelfOptions::OptionNum)
{
    if (init)
        initOptions ();
}

void
ShelfOptions::initOptions ()
{
    unsigned int state;
    CompAction action;

    // trigger_key
    mOptions[ShelfOptions::TriggerKey].setName ("trigger_key", CompOption::TypeKey);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitKey);
    action.keyFromString ("<Super>l");
    mOptions[ShelfOptions::TriggerKey].value().set (action);
    if (screen) screen->addAction (&mOptions[ShelfOptions::TriggerKey].value ().action ());

    // reset_key
    mOptions[ShelfOptions::ResetKey].setName ("reset_key", CompOption::TypeKey);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitKey);
    mOptions[ShelfOptions::ResetKey].value().set (action);
    if (screen) screen->addAction (&mOptions[ShelfOptions::ResetKey].value ().action ());

    // triggerscreen_key
    mOptions[ShelfOptions::TriggerscreenKey].setName ("triggerscreen_key", CompOption::TypeKey);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitKey);
    action.keyFromString ("<Super>p");
    mOptions[ShelfOptions::TriggerscreenKey].value().set (action);
    if (screen) screen->addAction (&mOptions[ShelfOptions::TriggerscreenKey].value ().action ());

    // dec_button
    mOptions[ShelfOptions::DecButton].setName ("dec_button", CompOption::TypeButton);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitButton);
    action.buttonFromString ("<Alt><Super>Button4");
    mOptions[ShelfOptions::DecButton].value().set (action);
    if (screen) screen->addAction (&mOptions[ShelfOptions::DecButton].value ().action ());

    // inc_button
    mOptions[ShelfOptions::IncButton].setName ("inc_button", CompOption::TypeButton);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitButton);
    action.buttonFromString ("<Alt><Super>Button5");
    mOptions[ShelfOptions::IncButton].value().set (action);
    if (screen) screen->addAction (&mOptions[ShelfOptions::IncButton].value ().action ());

    // animtime
    mOptions[ShelfOptions::Animtime].setName ("animtime", CompOption::TypeInt);
    mOptions[ShelfOptions::Animtime].rest ().set (1, 10000);
    mOptions[ShelfOptions::Animtime].value().set((int) 150);

    // interval
    mOptions[ShelfOptions::Interval].setName ("interval", CompOption::TypeFloat);
    mOptions[ShelfOptions::Interval].rest ().set (0.100, 0.999, 0.001);
    mOptions[ShelfOptions::Interval].value().set((float) 0.9);

}

ShelfOptions::~ShelfOptions ()
{
}


CompOption::Vector &
ShelfOptions::getOptions ()
{
    return mOptions;
}

bool
ShelfOptions::setOption (const CompString &name, CompOption::Value &value)
{
    CompOption   *o;
    unsigned int index;

    o = CompOption::findOption (mOptions, name, &index);

    if (!o)
        return false;

    switch (index)
    {
        case ShelfOptions::TriggerKey:
            if (o->set (value))
            {
                if (!mNotify[ShelfOptions::TriggerKey].empty ())
                    mNotify[ShelfOptions::TriggerKey] (o, ShelfOptions::TriggerKey);
                return true;
            }
            break;
        case ShelfOptions::ResetKey:
            if (o->set (value))
            {
                if (!mNotify[ShelfOptions::ResetKey].empty ())
                    mNotify[ShelfOptions::ResetKey] (o, ShelfOptions::ResetKey);
                return true;
            }
            break;
        case ShelfOptions::TriggerscreenKey:
            if (o->set (value))
            {
                if (!mNotify[ShelfOptions::TriggerscreenKey].empty ())
                    mNotify[ShelfOptions::TriggerscreenKey] (o, ShelfOptions::TriggerscreenKey);
                return true;
            }
            break;
        case ShelfOptions::DecButton:
            if (o->set (value))
            {
                if (!mNotify[ShelfOptions::DecButton].empty ())
                    mNotify[ShelfOptions::DecButton] (o, ShelfOptions::DecButton);
                return true;
            }
            break;
        case ShelfOptions::IncButton:
            if (o->set (value))
            {
                if (!mNotify[ShelfOptions::IncButton].empty ())
                    mNotify[ShelfOptions::IncButton] (o, ShelfOptions::IncButton);
                return true;
            }
            break;
        case ShelfOptions::Animtime:
            if (o->set (value))
            {
                if (!mNotify[ShelfOptions::Animtime].empty ())
                    mNotify[ShelfOptions::Animtime] (o, ShelfOptions::Animtime);
                return true;
            }
            break;
        case ShelfOptions::Interval:
            if (o->set (value))
            {
                if (!mNotify[ShelfOptions::Interval].empty ())
                    mNotify[ShelfOptions::Interval] (o, ShelfOptions::Interval);
                return true;
            }
            break;
        default:
            break;
    }
    return false;

}

