/*
 * Decompiled with CFR 0.152.
 */
package org.easymock.internal;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import org.easymock.internal.BridgeMethodResolver;
import org.easymock.internal.Invocation;
import org.easymock.internal.MethodSerializationWrapper;
import org.easymock.internal.MockInvocationHandler;
import org.easymock.internal.MocksControl;
import org.easymock.internal.ReflectionUtils;

public class ObjectMethodsFilter
implements InvocationHandler,
Serializable {
    private static final long serialVersionUID = -1726286682930686024L;
    private transient Method equalsMethod;
    private transient Method hashCodeMethod;
    private transient Method toStringMethod;
    private transient Method finalizeMethod;
    private final MockInvocationHandler delegate;
    private final String name;

    public ObjectMethodsFilter(Class<?> clazz, MockInvocationHandler mockInvocationHandler, String string) {
        if (string != null && !Invocation.isJavaIdentifier(string)) {
            throw new IllegalArgumentException(String.format("'%s' is not a valid Java identifier.", string));
        }
        if (clazz.isInterface()) {
            this.equalsMethod = ReflectionUtils.OBJECT_EQUALS;
            this.hashCodeMethod = ReflectionUtils.OBJECT_HASHCODE;
            this.toStringMethod = ReflectionUtils.OBJECT_TOSTRING;
            this.finalizeMethod = ReflectionUtils.OBJECT_FINALIZE;
        } else {
            try {
                this.equalsMethod = ObjectMethodsFilter.extractMethod(clazz, "equals", Object.class);
                this.hashCodeMethod = ObjectMethodsFilter.extractMethod(clazz, "hashCode", null);
                this.toStringMethod = ObjectMethodsFilter.extractMethod(clazz, "toString", null);
                this.finalizeMethod = ReflectionUtils.findMethod(clazz, "finalize", null);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new RuntimeException("An Object method could not be found!", noSuchMethodException);
            }
        }
        this.delegate = mockInvocationHandler;
        this.name = string;
    }

    private static Method extractMethod(Class<?> clazz, String string, Class<?> ... classArray) throws NoSuchMethodException {
        Method method = clazz.getMethod(string, classArray);
        if (method.isBridge()) {
            method = BridgeMethodResolver.findBridgedMethod(method);
        }
        return method;
    }

    @Override
    public final Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
        if (this.equalsMethod.equals(method)) {
            return object == objectArray[0];
        }
        if (this.hashCodeMethod.equals(method)) {
            return System.identityHashCode(object);
        }
        if (this.toStringMethod.equals(method)) {
            return this.mockToString(object);
        }
        if (this.finalizeMethod.equals(method)) {
            return null;
        }
        return this.delegate.invoke(object, method, objectArray);
    }

    private String mockToString(Object object) {
        return this.name != null ? this.name : "EasyMock for " + MocksControl.getMockedType(object);
    }

    public MockInvocationHandler getDelegate() {
        return this.delegate;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        try {
            this.toStringMethod = ((MethodSerializationWrapper)objectInputStream.readObject()).getMethod();
            this.equalsMethod = ((MethodSerializationWrapper)objectInputStream.readObject()).getMethod();
            this.hashCodeMethod = ((MethodSerializationWrapper)objectInputStream.readObject()).getMethod();
            this.finalizeMethod = ((MethodSerializationWrapper)objectInputStream.readObject()).getMethod();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IOException(noSuchMethodException.toString());
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(new MethodSerializationWrapper(this.toStringMethod));
        objectOutputStream.writeObject(new MethodSerializationWrapper(this.equalsMethod));
        objectOutputStream.writeObject(new MethodSerializationWrapper(this.hashCodeMethod));
        objectOutputStream.writeObject(new MethodSerializationWrapper(this.finalizeMethod));
    }
}

