/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.afm;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.fontbox.afm.CharMetric;
import org.apache.fontbox.afm.Composite;
import org.apache.fontbox.afm.CompositePart;
import org.apache.fontbox.afm.FontMetrics;
import org.apache.fontbox.afm.KernPair;
import org.apache.fontbox.afm.Ligature;
import org.apache.fontbox.afm.TrackKern;
import org.apache.fontbox.util.BoundingBox;
import org.apache.fontbox.util.Charsets;

public class AFMParser {
    public static final String COMMENT = "Comment";
    public static final String START_FONT_METRICS = "StartFontMetrics";
    public static final String END_FONT_METRICS = "EndFontMetrics";
    public static final String FONT_NAME = "FontName";
    public static final String FULL_NAME = "FullName";
    public static final String FAMILY_NAME = "FamilyName";
    public static final String WEIGHT = "Weight";
    public static final String FONT_BBOX = "FontBBox";
    public static final String VERSION = "Version";
    public static final String NOTICE = "Notice";
    public static final String ENCODING_SCHEME = "EncodingScheme";
    public static final String MAPPING_SCHEME = "MappingScheme";
    public static final String ESC_CHAR = "EscChar";
    public static final String CHARACTER_SET = "CharacterSet";
    public static final String CHARACTERS = "Characters";
    public static final String IS_BASE_FONT = "IsBaseFont";
    public static final String V_VECTOR = "VVector";
    public static final String IS_FIXED_V = "IsFixedV";
    public static final String CAP_HEIGHT = "CapHeight";
    public static final String X_HEIGHT = "XHeight";
    public static final String ASCENDER = "Ascender";
    public static final String DESCENDER = "Descender";
    public static final String UNDERLINE_POSITION = "UnderlinePosition";
    public static final String UNDERLINE_THICKNESS = "UnderlineThickness";
    public static final String ITALIC_ANGLE = "ItalicAngle";
    public static final String CHAR_WIDTH = "CharWidth";
    public static final String IS_FIXED_PITCH = "IsFixedPitch";
    public static final String START_CHAR_METRICS = "StartCharMetrics";
    public static final String END_CHAR_METRICS = "EndCharMetrics";
    public static final String CHARMETRICS_C = "C";
    public static final String CHARMETRICS_CH = "CH";
    public static final String CHARMETRICS_WX = "WX";
    public static final String CHARMETRICS_W0X = "W0X";
    public static final String CHARMETRICS_W1X = "W1X";
    public static final String CHARMETRICS_WY = "WY";
    public static final String CHARMETRICS_W0Y = "W0Y";
    public static final String CHARMETRICS_W1Y = "W1Y";
    public static final String CHARMETRICS_W = "W";
    public static final String CHARMETRICS_W0 = "W0";
    public static final String CHARMETRICS_W1 = "W1";
    public static final String CHARMETRICS_VV = "VV";
    public static final String CHARMETRICS_N = "N";
    public static final String CHARMETRICS_B = "B";
    public static final String CHARMETRICS_L = "L";
    public static final String STD_HW = "StdHW";
    public static final String STD_VW = "StdVW";
    public static final String START_TRACK_KERN = "StartTrackKern";
    public static final String END_TRACK_KERN = "EndTrackKern";
    public static final String START_KERN_DATA = "StartKernData";
    public static final String END_KERN_DATA = "EndKernData";
    public static final String START_KERN_PAIRS = "StartKernPairs";
    public static final String END_KERN_PAIRS = "EndKernPairs";
    public static final String START_KERN_PAIRS0 = "StartKernPairs0";
    public static final String START_KERN_PAIRS1 = "StartKernPairs1";
    public static final String START_COMPOSITES = "StartComposites";
    public static final String END_COMPOSITES = "EndComposites";
    public static final String CC = "CC";
    public static final String PCC = "PCC";
    public static final String KERN_PAIR_KP = "KP";
    public static final String KERN_PAIR_KPH = "KPH";
    public static final String KERN_PAIR_KPX = "KPX";
    public static final String KERN_PAIR_KPY = "KPY";
    private static final int BITS_IN_HEX = 16;
    private final InputStream input;

    public AFMParser(InputStream inputStream) {
        this.input = inputStream;
    }

    public FontMetrics parse() throws IOException {
        return this.parseFontMetric(false);
    }

    public FontMetrics parse(boolean bl) throws IOException {
        return this.parseFontMetric(bl);
    }

    private FontMetrics parseFontMetric(boolean bl) throws IOException {
        String string;
        FontMetrics fontMetrics = new FontMetrics();
        String string2 = this.readString();
        if (!START_FONT_METRICS.equals(string2)) {
            throw new IOException("Error: The AFM file should start with StartFontMetrics and not '" + string2 + "'");
        }
        fontMetrics.setAFMVersion(this.readFloat());
        boolean bl2 = false;
        while (!END_FONT_METRICS.equals(string = this.readString())) {
            Object object;
            Object object2;
            if (FONT_NAME.equals(string)) {
                fontMetrics.setFontName(this.readLine());
                continue;
            }
            if (FULL_NAME.equals(string)) {
                fontMetrics.setFullName(this.readLine());
                continue;
            }
            if (FAMILY_NAME.equals(string)) {
                fontMetrics.setFamilyName(this.readLine());
                continue;
            }
            if (WEIGHT.equals(string)) {
                fontMetrics.setWeight(this.readLine());
                continue;
            }
            if (FONT_BBOX.equals(string)) {
                BoundingBox boundingBox = new BoundingBox();
                boundingBox.setLowerLeftX(this.readFloat());
                boundingBox.setLowerLeftY(this.readFloat());
                boundingBox.setUpperRightX(this.readFloat());
                boundingBox.setUpperRightY(this.readFloat());
                fontMetrics.setFontBBox(boundingBox);
                continue;
            }
            if (VERSION.equals(string)) {
                fontMetrics.setFontVersion(this.readLine());
                continue;
            }
            if (NOTICE.equals(string)) {
                fontMetrics.setNotice(this.readLine());
                continue;
            }
            if (ENCODING_SCHEME.equals(string)) {
                fontMetrics.setEncodingScheme(this.readLine());
                continue;
            }
            if (MAPPING_SCHEME.equals(string)) {
                fontMetrics.setMappingScheme(this.readInt());
                continue;
            }
            if (ESC_CHAR.equals(string)) {
                fontMetrics.setEscChar(this.readInt());
                continue;
            }
            if (CHARACTER_SET.equals(string)) {
                fontMetrics.setCharacterSet(this.readLine());
                continue;
            }
            if (CHARACTERS.equals(string)) {
                fontMetrics.setCharacters(this.readInt());
                continue;
            }
            if (IS_BASE_FONT.equals(string)) {
                fontMetrics.setIsBaseFont(this.readBoolean());
                continue;
            }
            if (V_VECTOR.equals(string)) {
                float[] fArray = new float[]{this.readFloat(), this.readFloat()};
                fontMetrics.setVVector(fArray);
                continue;
            }
            if (IS_FIXED_V.equals(string)) {
                fontMetrics.setIsFixedV(this.readBoolean());
                continue;
            }
            if (CAP_HEIGHT.equals(string)) {
                fontMetrics.setCapHeight(this.readFloat());
                continue;
            }
            if (X_HEIGHT.equals(string)) {
                fontMetrics.setXHeight(this.readFloat());
                continue;
            }
            if (ASCENDER.equals(string)) {
                fontMetrics.setAscender(this.readFloat());
                continue;
            }
            if (DESCENDER.equals(string)) {
                fontMetrics.setDescender(this.readFloat());
                continue;
            }
            if (STD_HW.equals(string)) {
                fontMetrics.setStandardHorizontalWidth(this.readFloat());
                continue;
            }
            if (STD_VW.equals(string)) {
                fontMetrics.setStandardVerticalWidth(this.readFloat());
                continue;
            }
            if (COMMENT.equals(string)) {
                fontMetrics.addComment(this.readLine());
                continue;
            }
            if (UNDERLINE_POSITION.equals(string)) {
                fontMetrics.setUnderlinePosition(this.readFloat());
                continue;
            }
            if (UNDERLINE_THICKNESS.equals(string)) {
                fontMetrics.setUnderlineThickness(this.readFloat());
                continue;
            }
            if (ITALIC_ANGLE.equals(string)) {
                fontMetrics.setItalicAngle(this.readFloat());
                continue;
            }
            if (CHAR_WIDTH.equals(string)) {
                float[] fArray = new float[]{this.readFloat(), this.readFloat()};
                fontMetrics.setCharWidth(fArray);
                continue;
            }
            if (IS_FIXED_PITCH.equals(string)) {
                fontMetrics.setFixedPitch(this.readBoolean());
                continue;
            }
            if (START_CHAR_METRICS.equals(string)) {
                int n = this.readInt();
                object2 = new ArrayList<CharMetric>(n);
                for (int i = 0; i < n; ++i) {
                    CharMetric charMetric = this.parseCharMetric();
                    object2.add(charMetric);
                }
                object = this.readString();
                if (!((String)object).equals(END_CHAR_METRICS)) {
                    throw new IOException("Error: Expected 'EndCharMetrics' actual '" + (String)object + "'");
                }
                bl2 = true;
                fontMetrics.setCharMetrics((List<CharMetric>)object2);
                continue;
            }
            if (!bl && START_COMPOSITES.equals(string)) {
                int n = this.readInt();
                for (int i = 0; i < n; ++i) {
                    object = this.parseComposite();
                    fontMetrics.addComposite((Composite)object);
                }
                object2 = this.readString();
                if (((String)object2).equals(END_COMPOSITES)) continue;
                throw new IOException("Error: Expected 'EndComposites' actual '" + (String)object2 + "'");
            }
            if (!bl && START_KERN_DATA.equals(string)) {
                this.parseKernData(fontMetrics);
                continue;
            }
            if (bl && bl2) break;
            throw new IOException("Unknown AFM key '" + string + "'");
        }
        return fontMetrics;
    }

    private void parseKernData(FontMetrics fontMetrics) throws IOException {
        String string;
        while (!(string = this.readString()).equals(END_KERN_DATA)) {
            String string2;
            Object object;
            int n;
            if (START_TRACK_KERN.equals(string)) {
                n = this.readInt();
                for (int i = 0; i < n; ++i) {
                    object = new TrackKern();
                    ((TrackKern)object).setDegree(this.readInt());
                    ((TrackKern)object).setMinPointSize(this.readFloat());
                    ((TrackKern)object).setMinKern(this.readFloat());
                    ((TrackKern)object).setMaxPointSize(this.readFloat());
                    ((TrackKern)object).setMaxKern(this.readFloat());
                    fontMetrics.addTrackKern((TrackKern)object);
                }
                string2 = this.readString();
                if (string2.equals(END_TRACK_KERN)) continue;
                throw new IOException("Error: Expected 'EndTrackKern' actual '" + string2 + "'");
            }
            if (START_KERN_PAIRS.equals(string)) {
                n = this.readInt();
                for (int i = 0; i < n; ++i) {
                    object = this.parseKernPair();
                    fontMetrics.addKernPair((KernPair)object);
                }
                string2 = this.readString();
                if (string2.equals(END_KERN_PAIRS)) continue;
                throw new IOException("Error: Expected 'EndKernPairs' actual '" + string2 + "'");
            }
            if (START_KERN_PAIRS0.equals(string)) {
                n = this.readInt();
                for (int i = 0; i < n; ++i) {
                    object = this.parseKernPair();
                    fontMetrics.addKernPair0((KernPair)object);
                }
                string2 = this.readString();
                if (string2.equals(END_KERN_PAIRS)) continue;
                throw new IOException("Error: Expected 'EndKernPairs' actual '" + string2 + "'");
            }
            if (START_KERN_PAIRS1.equals(string)) {
                n = this.readInt();
                for (int i = 0; i < n; ++i) {
                    object = this.parseKernPair();
                    fontMetrics.addKernPair1((KernPair)object);
                }
                string2 = this.readString();
                if (string2.equals(END_KERN_PAIRS)) continue;
                throw new IOException("Error: Expected 'EndKernPairs' actual '" + string2 + "'");
            }
            throw new IOException("Unknown kerning data type '" + string + "'");
        }
    }

    private KernPair parseKernPair() throws IOException {
        KernPair kernPair = new KernPair();
        String string = this.readString();
        if (KERN_PAIR_KP.equals(string)) {
            kernPair.setFirstKernCharacter(this.readString());
            kernPair.setSecondKernCharacter(this.readString());
            kernPair.setX(this.readFloat());
            kernPair.setY(this.readFloat());
        } else if (KERN_PAIR_KPH.equals(string)) {
            kernPair.setFirstKernCharacter(this.hexToString(this.readString()));
            kernPair.setSecondKernCharacter(this.hexToString(this.readString()));
            kernPair.setX(this.readFloat());
            kernPair.setY(this.readFloat());
        } else if (KERN_PAIR_KPX.equals(string)) {
            kernPair.setFirstKernCharacter(this.readString());
            kernPair.setSecondKernCharacter(this.readString());
            kernPair.setX(this.readFloat());
            kernPair.setY(0.0f);
        } else if (KERN_PAIR_KPY.equals(string)) {
            kernPair.setFirstKernCharacter(this.readString());
            kernPair.setSecondKernCharacter(this.readString());
            kernPair.setX(0.0f);
            kernPair.setY(this.readFloat());
        } else {
            throw new IOException("Error expected kern pair command actual='" + string + "'");
        }
        return kernPair;
    }

    private String hexToString(String string) throws IOException {
        if (string.length() < 2) {
            throw new IOException("Error: Expected hex string of length >= 2 not='" + string);
        }
        if (string.charAt(0) != '<' || string.charAt(string.length() - 1) != '>') {
            throw new IOException("String should be enclosed by angle brackets '" + string + "'");
        }
        string = string.substring(1, string.length() - 1);
        byte[] byArray = new byte[string.length() / 2];
        for (int i = 0; i < string.length(); i += 2) {
            String string2 = "" + string.charAt(i) + string.charAt(i + 1);
            try {
                byArray[i / 2] = (byte)Integer.parseInt(string2, 16);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                throw new IOException("Error parsing AFM file:" + numberFormatException);
            }
        }
        return new String(byArray, Charsets.ISO_8859_1);
    }

    private Composite parseComposite() throws IOException {
        int n;
        Composite composite = new Composite();
        String string = this.readLine();
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ;");
        String string2 = stringTokenizer.nextToken();
        if (!string2.equals(CC)) {
            throw new IOException("Expected 'CC' actual='" + string2 + "'");
        }
        String string3 = stringTokenizer.nextToken();
        composite.setName(string3);
        try {
            n = Integer.parseInt(stringTokenizer.nextToken());
        }
        catch (NumberFormatException numberFormatException) {
            throw new IOException("Error parsing AFM document:" + numberFormatException);
        }
        for (int i = 0; i < n; ++i) {
            CompositePart compositePart = new CompositePart();
            String string4 = stringTokenizer.nextToken();
            if (!string4.equals(PCC)) {
                throw new IOException("Expected 'PCC' actual='" + string4 + "'");
            }
            String string5 = stringTokenizer.nextToken();
            try {
                int n2 = Integer.parseInt(stringTokenizer.nextToken());
                int n3 = Integer.parseInt(stringTokenizer.nextToken());
                compositePart.setName(string5);
                compositePart.setXDisplacement(n2);
                compositePart.setYDisplacement(n3);
                composite.addPart(compositePart);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                throw new IOException("Error parsing AFM document:" + numberFormatException);
            }
        }
        return composite;
    }

    private CharMetric parseCharMetric() throws IOException {
        CharMetric charMetric = new CharMetric();
        String string = this.readLine();
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        try {
            while (stringTokenizer.hasMoreTokens()) {
                Object object;
                String string2 = stringTokenizer.nextToken();
                if (string2.equals(CHARMETRICS_C)) {
                    object = stringTokenizer.nextToken();
                    charMetric.setCharacterCode(Integer.parseInt((String)object));
                    this.verifySemicolon(stringTokenizer);
                    continue;
                }
                if (string2.equals(CHARMETRICS_CH)) {
                    object = stringTokenizer.nextToken();
                    charMetric.setCharacterCode(Integer.parseInt((String)object, 16));
                    this.verifySemicolon(stringTokenizer);
                    continue;
                }
                if (string2.equals(CHARMETRICS_WX)) {
                    charMetric.setWx(Float.parseFloat(stringTokenizer.nextToken()));
                    this.verifySemicolon(stringTokenizer);
                    continue;
                }
                if (string2.equals(CHARMETRICS_W0X)) {
                    charMetric.setW0x(Float.parseFloat(stringTokenizer.nextToken()));
                    this.verifySemicolon(stringTokenizer);
                    continue;
                }
                if (string2.equals(CHARMETRICS_W1X)) {
                    charMetric.setW1x(Float.parseFloat(stringTokenizer.nextToken()));
                    this.verifySemicolon(stringTokenizer);
                    continue;
                }
                if (string2.equals(CHARMETRICS_WY)) {
                    charMetric.setWy(Float.parseFloat(stringTokenizer.nextToken()));
                    this.verifySemicolon(stringTokenizer);
                    continue;
                }
                if (string2.equals(CHARMETRICS_W0Y)) {
                    charMetric.setW0y(Float.parseFloat(stringTokenizer.nextToken()));
                    this.verifySemicolon(stringTokenizer);
                    continue;
                }
                if (string2.equals(CHARMETRICS_W1Y)) {
                    charMetric.setW1y(Float.parseFloat(stringTokenizer.nextToken()));
                    this.verifySemicolon(stringTokenizer);
                    continue;
                }
                if (string2.equals(CHARMETRICS_W)) {
                    object = new float[2];
                    object[0] = Float.parseFloat(stringTokenizer.nextToken());
                    object[1] = Float.parseFloat(stringTokenizer.nextToken());
                    charMetric.setW((float[])object);
                    this.verifySemicolon(stringTokenizer);
                    continue;
                }
                if (string2.equals(CHARMETRICS_W0)) {
                    object = new float[2];
                    object[0] = Float.parseFloat(stringTokenizer.nextToken());
                    object[1] = Float.parseFloat(stringTokenizer.nextToken());
                    charMetric.setW0((float[])object);
                    this.verifySemicolon(stringTokenizer);
                    continue;
                }
                if (string2.equals(CHARMETRICS_W1)) {
                    object = new float[2];
                    object[0] = Float.parseFloat(stringTokenizer.nextToken());
                    object[1] = Float.parseFloat(stringTokenizer.nextToken());
                    charMetric.setW1((float[])object);
                    this.verifySemicolon(stringTokenizer);
                    continue;
                }
                if (string2.equals(CHARMETRICS_VV)) {
                    object = new float[2];
                    object[0] = Float.parseFloat(stringTokenizer.nextToken());
                    object[1] = Float.parseFloat(stringTokenizer.nextToken());
                    charMetric.setVv((float[])object);
                    this.verifySemicolon(stringTokenizer);
                    continue;
                }
                if (string2.equals(CHARMETRICS_N)) {
                    charMetric.setName(stringTokenizer.nextToken());
                    this.verifySemicolon(stringTokenizer);
                    continue;
                }
                if (string2.equals(CHARMETRICS_B)) {
                    object = new BoundingBox();
                    ((BoundingBox)object).setLowerLeftX(Float.parseFloat(stringTokenizer.nextToken()));
                    ((BoundingBox)object).setLowerLeftY(Float.parseFloat(stringTokenizer.nextToken()));
                    ((BoundingBox)object).setUpperRightX(Float.parseFloat(stringTokenizer.nextToken()));
                    ((BoundingBox)object).setUpperRightY(Float.parseFloat(stringTokenizer.nextToken()));
                    charMetric.setBoundingBox((BoundingBox)object);
                    this.verifySemicolon(stringTokenizer);
                    continue;
                }
                if (string2.equals(CHARMETRICS_L)) {
                    object = new Ligature();
                    ((Ligature)object).setSuccessor(stringTokenizer.nextToken());
                    ((Ligature)object).setLigature(stringTokenizer.nextToken());
                    charMetric.addLigature((Ligature)object);
                    this.verifySemicolon(stringTokenizer);
                    continue;
                }
                throw new IOException("Unknown CharMetrics command '" + string2 + "'");
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new IOException("Error: Corrupt AFM document:" + numberFormatException);
        }
        return charMetric;
    }

    private void verifySemicolon(StringTokenizer stringTokenizer) throws IOException {
        if (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            if (!string.equals(";")) {
                throw new IOException("Error: Expected semicolon in stream actual='" + string + "'");
            }
        } else {
            throw new IOException("CharMetrics is missing a semicolon after a command");
        }
    }

    private boolean readBoolean() throws IOException {
        String string = this.readString();
        return Boolean.valueOf(string);
    }

    private int readInt() throws IOException {
        String string = this.readString();
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IOException("Error parsing AFM document:" + numberFormatException);
        }
    }

    private float readFloat() throws IOException {
        String string = this.readString();
        return Float.parseFloat(string);
    }

    private String readLine() throws IOException {
        StringBuilder stringBuilder = new StringBuilder(60);
        int n = this.input.read();
        while (this.isWhitespace(n)) {
            n = this.input.read();
        }
        stringBuilder.append((char)n);
        while (!this.isEOL(n = this.input.read())) {
            stringBuilder.append((char)n);
        }
        return stringBuilder.toString();
    }

    private String readString() throws IOException {
        StringBuilder stringBuilder = new StringBuilder(24);
        int n = this.input.read();
        while (this.isWhitespace(n)) {
            n = this.input.read();
        }
        stringBuilder.append((char)n);
        while (!this.isWhitespace(n = this.input.read())) {
            stringBuilder.append((char)n);
        }
        return stringBuilder.toString();
    }

    private boolean isEOL(int n) {
        return n == 13 || n == 10;
    }

    private boolean isWhitespace(int n) {
        return n == 32 || n == 9 || n == 13 || n == 10;
    }
}

