/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.net.ftp;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import org.apache.commons.net.MalformedServerReplyException;
import org.apache.commons.net.ProtocolCommandSupport;
import org.apache.commons.net.SocketClient;
import org.apache.commons.net.ftp.FTPCmd;
import org.apache.commons.net.ftp.FTPCommand;
import org.apache.commons.net.ftp.FTPConnectionClosedException;
import org.apache.commons.net.ftp.FTPReply;
import org.apache.commons.net.io.CRLFLineReader;

public class FTP
extends SocketClient {
    public static final int DEFAULT_DATA_PORT = 20;
    public static final int DEFAULT_PORT = 21;
    public static final int ASCII_FILE_TYPE = 0;
    public static final int EBCDIC_FILE_TYPE = 1;
    public static final int BINARY_FILE_TYPE = 2;
    public static final int LOCAL_FILE_TYPE = 3;
    public static final int NON_PRINT_TEXT_FORMAT = 4;
    public static final int TELNET_TEXT_FORMAT = 5;
    public static final int CARRIAGE_CONTROL_TEXT_FORMAT = 6;
    public static final int FILE_STRUCTURE = 7;
    public static final int RECORD_STRUCTURE = 8;
    public static final int PAGE_STRUCTURE = 9;
    public static final int STREAM_TRANSFER_MODE = 10;
    public static final int BLOCK_TRANSFER_MODE = 11;
    public static final int COMPRESSED_TRANSFER_MODE = 12;
    public static final String DEFAULT_CONTROL_ENCODING = "ISO-8859-1";
    public static final int REPLY_CODE_LEN = 3;
    private static final String __modes = "AEILNTCFRPSBC";
    protected int _replyCode;
    protected ArrayList<String> _replyLines;
    protected boolean _newReplyString;
    protected String _replyString;
    protected String _controlEncoding;
    protected ProtocolCommandSupport _commandSupport_;
    protected boolean strictMultilineParsing = false;
    protected BufferedReader _controlInput_;
    protected BufferedWriter _controlOutput_;

    public FTP() {
        this.setDefaultPort(21);
        this._replyLines = new ArrayList();
        this._newReplyString = false;
        this._replyString = null;
        this._controlEncoding = DEFAULT_CONTROL_ENCODING;
        this._commandSupport_ = new ProtocolCommandSupport(this);
    }

    private boolean __strictCheck(String string, String string2) {
        return !string.startsWith(string2) || string.charAt(3) != ' ';
    }

    private boolean __lenientCheck(String string) {
        return string.length() <= 3 || string.charAt(3) == '-' || !Character.isDigit(string.charAt(0));
    }

    private void __getReply() throws IOException {
        this.__getReply(true);
    }

    protected void __getReplyNoReport() throws IOException {
        this.__getReply(false);
    }

    private void __getReply(boolean bl) throws IOException {
        this._newReplyString = true;
        this._replyLines.clear();
        String string = this._controlInput_.readLine();
        if (string == null) {
            throw new FTPConnectionClosedException("Connection closed without indication.");
        }
        int n = string.length();
        if (n < 3) {
            throw new MalformedServerReplyException("Truncated server reply: " + string);
        }
        String string2 = null;
        try {
            string2 = string.substring(0, 3);
            this._replyCode = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new MalformedServerReplyException("Could not parse response code.\nServer Reply: " + string);
        }
        this._replyLines.add(string);
        if (n > 3 && string.charAt(3) == '-') {
            do {
                if ((string = this._controlInput_.readLine()) == null) {
                    throw new FTPConnectionClosedException("Connection closed without indication.");
                }
                this._replyLines.add(string);
            } while (!this.isStrictMultilineParsing() ? this.__lenientCheck(string) : this.__strictCheck(string, string2));
        }
        if (bl) {
            this.fireReplyReceived(this._replyCode, this.getReplyString());
        }
        if (this._replyCode == 421) {
            throw new FTPConnectionClosedException("FTP response 421 received.  Server closed connection.");
        }
    }

    @Override
    protected void _connectAction_() throws IOException {
        this._connectAction_(null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void _connectAction_(Reader reader) throws IOException {
        super._connectAction_();
        this._controlInput_ = reader == null ? new CRLFLineReader(new InputStreamReader(this._input_, this.getControlEncoding())) : new CRLFLineReader(reader);
        this._controlOutput_ = new BufferedWriter(new OutputStreamWriter(this._output_, this.getControlEncoding()));
        if (this.connectTimeout > 0) {
            int n = this._socket_.getSoTimeout();
            this._socket_.setSoTimeout(this.connectTimeout);
            try {
                this.__getReply();
                if (!FTPReply.isPositivePreliminary(this._replyCode)) return;
                this.__getReply();
                return;
            }
            catch (SocketTimeoutException socketTimeoutException) {
                IOException iOException = new IOException("Timed out waiting for initial connect reply");
                iOException.initCause(socketTimeoutException);
                throw iOException;
            }
            finally {
                this._socket_.setSoTimeout(n);
            }
        } else {
            this.__getReply();
            if (!FTPReply.isPositivePreliminary(this._replyCode)) return;
            this.__getReply();
        }
    }

    public void setControlEncoding(String string) {
        this._controlEncoding = string;
    }

    public String getControlEncoding() {
        return this._controlEncoding;
    }

    @Override
    public void disconnect() throws IOException {
        super.disconnect();
        this._controlInput_ = null;
        this._controlOutput_ = null;
        this._newReplyString = false;
        this._replyString = null;
    }

    public int sendCommand(String string, String string2) throws IOException {
        if (this._controlOutput_ == null) {
            throw new IOException("Connection is not open");
        }
        String string3 = this.__buildMessage(string, string2);
        this.__send(string3);
        this.fireCommandSent(string, string3);
        this.__getReply();
        return this._replyCode;
    }

    private String __buildMessage(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string);
        if (string2 != null) {
            stringBuilder.append(' ');
            stringBuilder.append(string2);
        }
        stringBuilder.append("\r\n");
        return stringBuilder.toString();
    }

    private void __send(String string) throws IOException, FTPConnectionClosedException, SocketException {
        try {
            this._controlOutput_.write(string);
            this._controlOutput_.flush();
        }
        catch (SocketException socketException) {
            if (!this.isConnected()) {
                throw new FTPConnectionClosedException("Connection unexpectedly closed.");
            }
            throw socketException;
        }
    }

    protected void __noop() throws IOException {
        String string = this.__buildMessage(FTPCmd.NOOP.getCommand(), null);
        this.__send(string);
        this.__getReplyNoReport();
    }

    @Deprecated
    public int sendCommand(int n, String string) throws IOException {
        return this.sendCommand(FTPCommand.getCommand(n), string);
    }

    public int sendCommand(FTPCmd fTPCmd) throws IOException {
        return this.sendCommand(fTPCmd, null);
    }

    public int sendCommand(FTPCmd fTPCmd, String string) throws IOException {
        return this.sendCommand(fTPCmd.getCommand(), string);
    }

    public int sendCommand(String string) throws IOException {
        return this.sendCommand(string, null);
    }

    public int sendCommand(int n) throws IOException {
        return this.sendCommand(n, null);
    }

    public int getReplyCode() {
        return this._replyCode;
    }

    public int getReply() throws IOException {
        this.__getReply();
        return this._replyCode;
    }

    public String[] getReplyStrings() {
        return this._replyLines.toArray(new String[this._replyLines.size()]);
    }

    public String getReplyString() {
        if (!this._newReplyString) {
            return this._replyString;
        }
        StringBuilder stringBuilder = new StringBuilder(256);
        for (String string : this._replyLines) {
            stringBuilder.append(string);
            stringBuilder.append("\r\n");
        }
        this._newReplyString = false;
        this._replyString = stringBuilder.toString();
        return this._replyString;
    }

    public int user(String string) throws IOException {
        return this.sendCommand(FTPCmd.USER, string);
    }

    public int pass(String string) throws IOException {
        return this.sendCommand(FTPCmd.PASS, string);
    }

    public int acct(String string) throws IOException {
        return this.sendCommand(FTPCmd.ACCT, string);
    }

    public int abor() throws IOException {
        return this.sendCommand(FTPCmd.ABOR);
    }

    public int cwd(String string) throws IOException {
        return this.sendCommand(FTPCmd.CWD, string);
    }

    public int cdup() throws IOException {
        return this.sendCommand(FTPCmd.CDUP);
    }

    public int quit() throws IOException {
        return this.sendCommand(FTPCmd.QUIT);
    }

    public int rein() throws IOException {
        return this.sendCommand(FTPCmd.REIN);
    }

    public int smnt(String string) throws IOException {
        return this.sendCommand(FTPCmd.SMNT, string);
    }

    public int port(InetAddress inetAddress, int n) throws IOException {
        StringBuilder stringBuilder = new StringBuilder(24);
        stringBuilder.append(inetAddress.getHostAddress().replace('.', ','));
        int n2 = n >>> 8;
        stringBuilder.append(',');
        stringBuilder.append(n2);
        stringBuilder.append(',');
        n2 = n & 0xFF;
        stringBuilder.append(n2);
        return this.sendCommand(FTPCmd.PORT, stringBuilder.toString());
    }

    public int eprt(InetAddress inetAddress, int n) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        String string = inetAddress.getHostAddress();
        int n2 = string.indexOf("%");
        if (n2 > 0) {
            string = string.substring(0, n2);
        }
        stringBuilder.append("|");
        if (inetAddress instanceof Inet4Address) {
            stringBuilder.append("1");
        } else if (inetAddress instanceof Inet6Address) {
            stringBuilder.append("2");
        }
        stringBuilder.append("|");
        stringBuilder.append(string);
        stringBuilder.append("|");
        stringBuilder.append(n);
        stringBuilder.append("|");
        return this.sendCommand(FTPCmd.EPRT, stringBuilder.toString());
    }

    public int pasv() throws IOException {
        return this.sendCommand(FTPCmd.PASV);
    }

    public int epsv() throws IOException {
        return this.sendCommand(FTPCmd.EPSV);
    }

    public int type(int n, int n2) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(__modes.charAt(n));
        stringBuilder.append(' ');
        if (n == 3) {
            stringBuilder.append(n2);
        } else {
            stringBuilder.append(__modes.charAt(n2));
        }
        return this.sendCommand(FTPCmd.TYPE, stringBuilder.toString());
    }

    public int type(int n) throws IOException {
        return this.sendCommand(FTPCmd.TYPE, __modes.substring(n, n + 1));
    }

    public int stru(int n) throws IOException {
        return this.sendCommand(FTPCmd.STRU, __modes.substring(n, n + 1));
    }

    public int mode(int n) throws IOException {
        return this.sendCommand(FTPCmd.MODE, __modes.substring(n, n + 1));
    }

    public int retr(String string) throws IOException {
        return this.sendCommand(FTPCmd.RETR, string);
    }

    public int stor(String string) throws IOException {
        return this.sendCommand(FTPCmd.STOR, string);
    }

    public int stou() throws IOException {
        return this.sendCommand(FTPCmd.STOU);
    }

    public int stou(String string) throws IOException {
        return this.sendCommand(FTPCmd.STOU, string);
    }

    public int appe(String string) throws IOException {
        return this.sendCommand(FTPCmd.APPE, string);
    }

    public int allo(int n) throws IOException {
        return this.sendCommand(FTPCmd.ALLO, Integer.toString(n));
    }

    public int feat() throws IOException {
        return this.sendCommand(FTPCmd.FEAT);
    }

    public int allo(int n, int n2) throws IOException {
        return this.sendCommand(FTPCmd.ALLO, Integer.toString(n) + " R " + Integer.toString(n2));
    }

    public int rest(String string) throws IOException {
        return this.sendCommand(FTPCmd.REST, string);
    }

    public int mdtm(String string) throws IOException {
        return this.sendCommand(FTPCmd.MDTM, string);
    }

    public int mfmt(String string, String string2) throws IOException {
        return this.sendCommand(FTPCmd.MFMT, string2 + " " + string);
    }

    public int rnfr(String string) throws IOException {
        return this.sendCommand(FTPCmd.RNFR, string);
    }

    public int rnto(String string) throws IOException {
        return this.sendCommand(FTPCmd.RNTO, string);
    }

    public int dele(String string) throws IOException {
        return this.sendCommand(FTPCmd.DELE, string);
    }

    public int rmd(String string) throws IOException {
        return this.sendCommand(FTPCmd.RMD, string);
    }

    public int mkd(String string) throws IOException {
        return this.sendCommand(FTPCmd.MKD, string);
    }

    public int pwd() throws IOException {
        return this.sendCommand(FTPCmd.PWD);
    }

    public int list() throws IOException {
        return this.sendCommand(FTPCmd.LIST);
    }

    public int list(String string) throws IOException {
        return this.sendCommand(FTPCmd.LIST, string);
    }

    public int mlsd() throws IOException {
        return this.sendCommand(FTPCmd.MLSD);
    }

    public int mlsd(String string) throws IOException {
        return this.sendCommand(FTPCmd.MLSD, string);
    }

    public int mlst() throws IOException {
        return this.sendCommand(FTPCmd.MLST);
    }

    public int mlst(String string) throws IOException {
        return this.sendCommand(FTPCmd.MLST, string);
    }

    public int nlst() throws IOException {
        return this.sendCommand(FTPCmd.NLST);
    }

    public int nlst(String string) throws IOException {
        return this.sendCommand(FTPCmd.NLST, string);
    }

    public int site(String string) throws IOException {
        return this.sendCommand(FTPCmd.SITE, string);
    }

    public int syst() throws IOException {
        return this.sendCommand(FTPCmd.SYST);
    }

    public int stat() throws IOException {
        return this.sendCommand(FTPCmd.STAT);
    }

    public int stat(String string) throws IOException {
        return this.sendCommand(FTPCmd.STAT, string);
    }

    public int help() throws IOException {
        return this.sendCommand(FTPCmd.HELP);
    }

    public int help(String string) throws IOException {
        return this.sendCommand(FTPCmd.HELP, string);
    }

    public int noop() throws IOException {
        return this.sendCommand(FTPCmd.NOOP);
    }

    public boolean isStrictMultilineParsing() {
        return this.strictMultilineParsing;
    }

    public void setStrictMultilineParsing(boolean bl) {
        this.strictMultilineParsing = bl;
    }

    @Override
    protected ProtocolCommandSupport getCommandSupport() {
        return this._commandSupport_;
    }
}

