/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.osgi.locator;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.geronimo.osgi.registry.api.ProviderRegistry;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;

public class ProviderLocator {
    private static BundleContext context;
    private static Object registryTracker;

    private ProviderLocator() {
    }

    public static void init(BundleContext bundleContext) {
        try {
            registryTracker = new ServiceTracker(bundleContext, "org.apache.geronimo.osgi.registry.api.ProviderRegistry", null);
            ((ServiceTracker)registryTracker).open();
            context = bundleContext;
        }
        catch (Throwable throwable) {
            registryTracker = null;
        }
    }

    public static void destroy() {
        if (registryTracker != null) {
            ((ServiceTracker)registryTracker).close();
            registryTracker = null;
        }
    }

    public static Class<?> locate(String string) {
        Object object = ProviderLocator.getRegistry();
        if (object == null) {
            return null;
        }
        return ((ProviderRegistry)object).locate(string);
    }

    public static List<Class<?>> locateAll(String string) {
        Object object = ProviderLocator.getRegistry();
        if (object == null) {
            return new ArrayList();
        }
        return ((ProviderRegistry)object).locateAll(string);
    }

    public static Class<?> loadClass(String string) throws ClassNotFoundException {
        return ProviderLocator.loadClass(string, null, Thread.currentThread().getContextClassLoader());
    }

    public static Class<?> loadClass(String string, Class<?> clazz) throws ClassNotFoundException {
        return ProviderLocator.loadClass(string, clazz, Thread.currentThread().getContextClassLoader());
    }

    public static Class<?> loadClass(String string, Class<?> clazz, ClassLoader classLoader) throws ClassNotFoundException {
        Class<?> clazz2 = ProviderLocator.locate(string);
        if (clazz2 != null) {
            return clazz2;
        }
        if (classLoader != null) {
            try {
                return classLoader.loadClass(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (clazz != null) {
            classLoader = clazz.getClassLoader();
        }
        return Class.forName(string, true, classLoader);
    }

    public static Object getService(String string, Class<?> clazz, ClassLoader classLoader) throws Exception {
        Class<?> clazz2;
        Object object = ProviderLocator.getRegistry();
        if (object != null && (clazz2 = ((ProviderRegistry)object).getService(string)) != null) {
            return clazz2;
        }
        clazz2 = ProviderLocator.locateServiceClass(string, clazz, classLoader);
        if (clazz2 != null) {
            return clazz2.newInstance();
        }
        return null;
    }

    public static Class<?> getServiceClass(String string, Class<?> clazz, ClassLoader classLoader) throws ClassNotFoundException {
        Class clazz2;
        Object object = ProviderLocator.getRegistry();
        if (object != null && (clazz2 = ((ProviderRegistry)object).getServiceClass(string)) != null) {
            return clazz2;
        }
        return ProviderLocator.locateServiceClass(string, clazz, classLoader);
    }

    public static List<Object> getServices(String string, Class<?> clazz, ClassLoader classLoader) throws Exception {
        Collection<Object> collection;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Object object = ProviderLocator.getRegistry();
        if (object != null && (collection = ((ProviderRegistry)object).getServices(string)) != null) {
            arrayList.addAll(collection);
        }
        if ((collection = ProviderLocator.locateServiceClasses(string, clazz, classLoader)) != null) {
            for (Class clazz2 : collection) {
                arrayList.add(clazz2.newInstance());
            }
        }
        return arrayList;
    }

    public static List<Class<?>> getServiceClasses(String string, Class<?> clazz, ClassLoader classLoader) throws Exception {
        Collection<Object> collection;
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        Object object = ProviderLocator.getRegistry();
        if (object != null && (collection = ((ProviderRegistry)object).getServiceClasses(string)) != null) {
            linkedHashSet.addAll(collection);
        }
        if ((collection = ProviderLocator.locateServiceClasses(string, clazz, classLoader)) != null) {
            linkedHashSet.addAll(collection);
        }
        return new ArrayList(linkedHashSet);
    }

    private static String locateServiceClassName(String string, Class<?> clazz, ClassLoader classLoader) {
        String string2 = ProviderLocator.locateServiceClassName(string, classLoader);
        if (string2 != null) {
            return string2;
        }
        if (clazz != null && (string2 = ProviderLocator.locateServiceClassName(string, clazz.getClassLoader())) != null) {
            return string2;
        }
        return null;
    }

    private static String locateServiceClassName(String string, ClassLoader classLoader) {
        if (classLoader != null) {
            try {
                String string2 = "META-INF/services/" + string;
                Enumeration<URL> enumeration = classLoader.getResources(string2);
                while (enumeration.hasMoreElements()) {
                    List<String> list = ProviderLocator.parseServiceDefinition(enumeration.nextElement());
                    if (list.isEmpty()) continue;
                    return list.get(0);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    private static Class<?> locateServiceClass(String string, Class<?> clazz, ClassLoader classLoader) throws ClassNotFoundException {
        String string2 = ProviderLocator.locateServiceClassName(string, clazz, classLoader);
        if (string2 == null) {
            return null;
        }
        return ProviderLocator.loadClass(string2, clazz, classLoader);
    }

    private static Collection<String> locateServiceClassNames(String string, Class<?> clazz, ClassLoader classLoader) {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        ProviderLocator.locateServiceClassNames(string, classLoader, linkedHashSet);
        if (clazz != null) {
            ProviderLocator.locateServiceClassNames(string, clazz.getClassLoader(), linkedHashSet);
        }
        return linkedHashSet;
    }

    static void locateServiceClassNames(String string, ClassLoader classLoader, Set set) {
        if (classLoader != null) {
            try {
                String string2 = "META-INF/services/" + string;
                Enumeration<URL> enumeration = classLoader.getResources(string2);
                while (enumeration.hasMoreElements()) {
                    List<String> list = ProviderLocator.parseServiceDefinition(enumeration.nextElement());
                    set.addAll(list);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static Collection<Class<?>> locateServiceClasses(String string, Class<?> clazz, ClassLoader classLoader) throws ClassNotFoundException {
        Collection<String> collection = ProviderLocator.locateServiceClassNames(string, clazz, classLoader);
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        for (String string2 : collection) {
            linkedHashSet.add(ProviderLocator.loadClass(string2, clazz, classLoader));
        }
        return linkedHashSet;
    }

    private static List<String> parseServiceDefinition(URL uRL) {
        String string = uRL.toString();
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string.endsWith("/")) {
            return arrayList;
        }
        String string2 = string.substring(string.lastIndexOf("/") + 1);
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream(), "UTF-8"));
            String string3 = bufferedReader.readLine();
            while (string3 != null) {
                int n = string3.indexOf(35);
                if (n != -1) {
                    string3 = string3.substring(0, n);
                }
                if ((string3 = string3.trim()).length() > 0) {
                    arrayList.add(string3);
                }
                string3 = bufferedReader.readLine();
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String lookupByJREPropertyFile(String string, String string2) throws IOException {
        String string3 = System.getProperty("java.home");
        File file = new File(string3 + File.separator + string);
        if (file.exists() && file.canRead()) {
            Properties properties = new Properties();
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(file);
                properties.load(fileInputStream);
                String string4 = properties.getProperty(string2);
                return string4;
            }
            finally {
                if (fileInputStream != null) {
                    try {
                        ((InputStream)fileInputStream).close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        return null;
    }

    private static Object getRegistry() {
        if (registryTracker == null) {
            return null;
        }
        return ((ServiceTracker)registryTracker).getService();
    }
}

