/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core.filter;

import com.fasterxml.jackson.core.Base64Variant;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonStreamContext;
import com.fasterxml.jackson.core.SerializableString;
import com.fasterxml.jackson.core.filter.TokenFilter;
import com.fasterxml.jackson.core.filter.TokenFilterContext;
import com.fasterxml.jackson.core.util.JsonGeneratorDelegate;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;

public class FilteringGeneratorDelegate
extends JsonGeneratorDelegate {
    protected TokenFilter rootFilter;
    protected boolean _allowMultipleMatches;
    protected boolean _includePath;
    @Deprecated
    protected boolean _includeImmediateParent;
    protected TokenFilterContext _filterContext;
    protected TokenFilter _itemFilter;
    protected int _matchCount;

    public FilteringGeneratorDelegate(JsonGenerator jsonGenerator, TokenFilter tokenFilter, boolean bl, boolean bl2) {
        super(jsonGenerator, false);
        this.rootFilter = tokenFilter;
        this._itemFilter = tokenFilter;
        this._filterContext = TokenFilterContext.createRootContext(tokenFilter);
        this._includePath = bl;
        this._allowMultipleMatches = bl2;
    }

    public TokenFilter getFilter() {
        return this.rootFilter;
    }

    public JsonStreamContext getFilterContext() {
        return this._filterContext;
    }

    public int getMatchCount() {
        return this._matchCount;
    }

    @Override
    public JsonStreamContext getOutputContext() {
        return this._filterContext;
    }

    @Override
    public void writeStartArray() throws IOException {
        if (this._itemFilter == null) {
            this._filterContext = this._filterContext.createChildArrayContext(null, false);
            return;
        }
        if (this._itemFilter == TokenFilter.INCLUDE_ALL) {
            this._filterContext = this._filterContext.createChildArrayContext(this._itemFilter, true);
            this.delegate.writeStartArray();
            return;
        }
        this._itemFilter = this._filterContext.checkValue(this._itemFilter);
        if (this._itemFilter == null) {
            this._filterContext = this._filterContext.createChildArrayContext(null, false);
            return;
        }
        if (this._itemFilter != TokenFilter.INCLUDE_ALL) {
            this._itemFilter = this._itemFilter.filterStartArray();
        }
        if (this._itemFilter == TokenFilter.INCLUDE_ALL) {
            this._checkParentPath();
            this._filterContext = this._filterContext.createChildArrayContext(this._itemFilter, true);
            this.delegate.writeStartArray();
        } else {
            this._filterContext = this._filterContext.createChildArrayContext(this._itemFilter, false);
        }
    }

    @Override
    public void writeStartArray(int n) throws IOException {
        if (this._itemFilter == null) {
            this._filterContext = this._filterContext.createChildArrayContext(null, false);
            return;
        }
        if (this._itemFilter == TokenFilter.INCLUDE_ALL) {
            this._filterContext = this._filterContext.createChildArrayContext(this._itemFilter, true);
            this.delegate.writeStartArray(n);
            return;
        }
        this._itemFilter = this._filterContext.checkValue(this._itemFilter);
        if (this._itemFilter == null) {
            this._filterContext = this._filterContext.createChildArrayContext(null, false);
            return;
        }
        if (this._itemFilter != TokenFilter.INCLUDE_ALL) {
            this._itemFilter = this._itemFilter.filterStartArray();
        }
        if (this._itemFilter == TokenFilter.INCLUDE_ALL) {
            this._checkParentPath();
            this._filterContext = this._filterContext.createChildArrayContext(this._itemFilter, true);
            this.delegate.writeStartArray(n);
        } else {
            this._filterContext = this._filterContext.createChildArrayContext(this._itemFilter, false);
        }
    }

    @Override
    public void writeEndArray() throws IOException {
        this._filterContext = this._filterContext.closeArray(this.delegate);
        if (this._filterContext != null) {
            this._itemFilter = this._filterContext.getFilter();
        }
    }

    @Override
    public void writeStartObject() throws IOException {
        if (this._itemFilter == null) {
            this._filterContext = this._filterContext.createChildObjectContext(this._itemFilter, false);
            return;
        }
        if (this._itemFilter == TokenFilter.INCLUDE_ALL) {
            this._filterContext = this._filterContext.createChildObjectContext(this._itemFilter, true);
            this.delegate.writeStartObject();
            return;
        }
        TokenFilter tokenFilter = this._filterContext.checkValue(this._itemFilter);
        if (tokenFilter == null) {
            return;
        }
        if (tokenFilter != TokenFilter.INCLUDE_ALL) {
            tokenFilter = tokenFilter.filterStartObject();
        }
        if (tokenFilter == TokenFilter.INCLUDE_ALL) {
            this._checkParentPath();
            this._filterContext = this._filterContext.createChildObjectContext(tokenFilter, true);
            this.delegate.writeStartObject();
        } else {
            this._filterContext = this._filterContext.createChildObjectContext(tokenFilter, false);
        }
    }

    @Override
    public void writeEndObject() throws IOException {
        this._filterContext = this._filterContext.closeObject(this.delegate);
        if (this._filterContext != null) {
            this._itemFilter = this._filterContext.getFilter();
        }
    }

    @Override
    public void writeFieldName(String string) throws IOException {
        TokenFilter tokenFilter = this._filterContext.setFieldName(string);
        if (tokenFilter == null) {
            this._itemFilter = null;
            return;
        }
        if (tokenFilter == TokenFilter.INCLUDE_ALL) {
            this._itemFilter = tokenFilter;
            this.delegate.writeFieldName(string);
            return;
        }
        this._itemFilter = tokenFilter = tokenFilter.includeProperty(string);
        if (tokenFilter == TokenFilter.INCLUDE_ALL) {
            this._checkPropertyParentPath();
        }
    }

    @Override
    public void writeFieldName(SerializableString serializableString) throws IOException {
        TokenFilter tokenFilter = this._filterContext.setFieldName(serializableString.getValue());
        if (tokenFilter == null) {
            this._itemFilter = null;
            return;
        }
        if (tokenFilter == TokenFilter.INCLUDE_ALL) {
            this._itemFilter = tokenFilter;
            this.delegate.writeFieldName(serializableString);
            return;
        }
        this._itemFilter = tokenFilter = tokenFilter.includeProperty(serializableString.getValue());
        if (tokenFilter == TokenFilter.INCLUDE_ALL) {
            this._checkPropertyParentPath();
        }
    }

    @Override
    public void writeString(String string) throws IOException {
        if (this._itemFilter == null) {
            return;
        }
        if (this._itemFilter != TokenFilter.INCLUDE_ALL) {
            TokenFilter tokenFilter = this._filterContext.checkValue(this._itemFilter);
            if (tokenFilter == null) {
                return;
            }
            if (tokenFilter != TokenFilter.INCLUDE_ALL && !tokenFilter.includeString(string)) {
                return;
            }
            this._checkParentPath();
        }
        this.delegate.writeString(string);
    }

    @Override
    public void writeString(char[] cArray, int n, int n2) throws IOException {
        if (this._itemFilter == null) {
            return;
        }
        if (this._itemFilter != TokenFilter.INCLUDE_ALL) {
            String string = new String(cArray, n, n2);
            TokenFilter tokenFilter = this._filterContext.checkValue(this._itemFilter);
            if (tokenFilter == null) {
                return;
            }
            if (tokenFilter != TokenFilter.INCLUDE_ALL && !tokenFilter.includeString(string)) {
                return;
            }
            this._checkParentPath();
        }
        this.delegate.writeString(cArray, n, n2);
    }

    @Override
    public void writeString(SerializableString serializableString) throws IOException {
        if (this._itemFilter == null) {
            return;
        }
        if (this._itemFilter != TokenFilter.INCLUDE_ALL) {
            TokenFilter tokenFilter = this._filterContext.checkValue(this._itemFilter);
            if (tokenFilter == null) {
                return;
            }
            if (tokenFilter != TokenFilter.INCLUDE_ALL && !tokenFilter.includeString(serializableString.getValue())) {
                return;
            }
            this._checkParentPath();
        }
        this.delegate.writeString(serializableString);
    }

    @Override
    public void writeRawUTF8String(byte[] byArray, int n, int n2) throws IOException {
        if (this._checkRawValueWrite()) {
            this.delegate.writeRawUTF8String(byArray, n, n2);
        }
    }

    @Override
    public void writeUTF8String(byte[] byArray, int n, int n2) throws IOException {
        if (this._checkRawValueWrite()) {
            this.delegate.writeUTF8String(byArray, n, n2);
        }
    }

    @Override
    public void writeRaw(String string) throws IOException {
        if (this._checkRawValueWrite()) {
            this.delegate.writeRaw(string);
        }
    }

    @Override
    public void writeRaw(String string, int n, int n2) throws IOException {
        if (this._checkRawValueWrite()) {
            this.delegate.writeRaw(string);
        }
    }

    @Override
    public void writeRaw(SerializableString serializableString) throws IOException {
        if (this._checkRawValueWrite()) {
            this.delegate.writeRaw(serializableString);
        }
    }

    @Override
    public void writeRaw(char[] cArray, int n, int n2) throws IOException {
        if (this._checkRawValueWrite()) {
            this.delegate.writeRaw(cArray, n, n2);
        }
    }

    @Override
    public void writeRaw(char c) throws IOException {
        if (this._checkRawValueWrite()) {
            this.delegate.writeRaw(c);
        }
    }

    @Override
    public void writeRawValue(String string) throws IOException {
        if (this._checkRawValueWrite()) {
            this.delegate.writeRaw(string);
        }
    }

    @Override
    public void writeRawValue(String string, int n, int n2) throws IOException {
        if (this._checkRawValueWrite()) {
            this.delegate.writeRaw(string, n, n2);
        }
    }

    @Override
    public void writeRawValue(char[] cArray, int n, int n2) throws IOException {
        if (this._checkRawValueWrite()) {
            this.delegate.writeRaw(cArray, n, n2);
        }
    }

    @Override
    public void writeBinary(Base64Variant base64Variant, byte[] byArray, int n, int n2) throws IOException {
        if (this._checkBinaryWrite()) {
            this.delegate.writeBinary(base64Variant, byArray, n, n2);
        }
    }

    @Override
    public int writeBinary(Base64Variant base64Variant, InputStream inputStream, int n) throws IOException {
        if (this._checkBinaryWrite()) {
            return this.delegate.writeBinary(base64Variant, inputStream, n);
        }
        return -1;
    }

    @Override
    public void writeNumber(short s) throws IOException {
        if (this._itemFilter == null) {
            return;
        }
        if (this._itemFilter != TokenFilter.INCLUDE_ALL) {
            TokenFilter tokenFilter = this._filterContext.checkValue(this._itemFilter);
            if (tokenFilter == null) {
                return;
            }
            if (tokenFilter != TokenFilter.INCLUDE_ALL && !tokenFilter.includeNumber(s)) {
                return;
            }
            this._checkParentPath();
        }
        this.delegate.writeNumber(s);
    }

    @Override
    public void writeNumber(int n) throws IOException {
        if (this._itemFilter == null) {
            return;
        }
        if (this._itemFilter != TokenFilter.INCLUDE_ALL) {
            TokenFilter tokenFilter = this._filterContext.checkValue(this._itemFilter);
            if (tokenFilter == null) {
                return;
            }
            if (tokenFilter != TokenFilter.INCLUDE_ALL && !tokenFilter.includeNumber(n)) {
                return;
            }
            this._checkParentPath();
        }
        this.delegate.writeNumber(n);
    }

    @Override
    public void writeNumber(long l) throws IOException {
        if (this._itemFilter == null) {
            return;
        }
        if (this._itemFilter != TokenFilter.INCLUDE_ALL) {
            TokenFilter tokenFilter = this._filterContext.checkValue(this._itemFilter);
            if (tokenFilter == null) {
                return;
            }
            if (tokenFilter != TokenFilter.INCLUDE_ALL && !tokenFilter.includeNumber(l)) {
                return;
            }
            this._checkParentPath();
        }
        this.delegate.writeNumber(l);
    }

    @Override
    public void writeNumber(BigInteger bigInteger) throws IOException {
        if (this._itemFilter == null) {
            return;
        }
        if (this._itemFilter != TokenFilter.INCLUDE_ALL) {
            TokenFilter tokenFilter = this._filterContext.checkValue(this._itemFilter);
            if (tokenFilter == null) {
                return;
            }
            if (tokenFilter != TokenFilter.INCLUDE_ALL && !tokenFilter.includeNumber(bigInteger)) {
                return;
            }
            this._checkParentPath();
        }
        this.delegate.writeNumber(bigInteger);
    }

    @Override
    public void writeNumber(double d) throws IOException {
        if (this._itemFilter == null) {
            return;
        }
        if (this._itemFilter != TokenFilter.INCLUDE_ALL) {
            TokenFilter tokenFilter = this._filterContext.checkValue(this._itemFilter);
            if (tokenFilter == null) {
                return;
            }
            if (tokenFilter != TokenFilter.INCLUDE_ALL && !tokenFilter.includeNumber(d)) {
                return;
            }
            this._checkParentPath();
        }
        this.delegate.writeNumber(d);
    }

    @Override
    public void writeNumber(float f) throws IOException {
        if (this._itemFilter == null) {
            return;
        }
        if (this._itemFilter != TokenFilter.INCLUDE_ALL) {
            TokenFilter tokenFilter = this._filterContext.checkValue(this._itemFilter);
            if (tokenFilter == null) {
                return;
            }
            if (tokenFilter != TokenFilter.INCLUDE_ALL && !tokenFilter.includeNumber(f)) {
                return;
            }
            this._checkParentPath();
        }
        this.delegate.writeNumber(f);
    }

    @Override
    public void writeNumber(BigDecimal bigDecimal) throws IOException {
        if (this._itemFilter == null) {
            return;
        }
        if (this._itemFilter != TokenFilter.INCLUDE_ALL) {
            TokenFilter tokenFilter = this._filterContext.checkValue(this._itemFilter);
            if (tokenFilter == null) {
                return;
            }
            if (tokenFilter != TokenFilter.INCLUDE_ALL && !tokenFilter.includeNumber(bigDecimal)) {
                return;
            }
            this._checkParentPath();
        }
        this.delegate.writeNumber(bigDecimal);
    }

    @Override
    public void writeNumber(String string) throws IOException, UnsupportedOperationException {
        if (this._itemFilter == null) {
            return;
        }
        if (this._itemFilter != TokenFilter.INCLUDE_ALL) {
            TokenFilter tokenFilter = this._filterContext.checkValue(this._itemFilter);
            if (tokenFilter == null) {
                return;
            }
            if (tokenFilter != TokenFilter.INCLUDE_ALL && !tokenFilter.includeRawValue()) {
                return;
            }
            this._checkParentPath();
        }
        this.delegate.writeNumber(string);
    }

    @Override
    public void writeBoolean(boolean bl) throws IOException {
        if (this._itemFilter == null) {
            return;
        }
        if (this._itemFilter != TokenFilter.INCLUDE_ALL) {
            TokenFilter tokenFilter = this._filterContext.checkValue(this._itemFilter);
            if (tokenFilter == null) {
                return;
            }
            if (tokenFilter != TokenFilter.INCLUDE_ALL && !tokenFilter.includeBoolean(bl)) {
                return;
            }
            this._checkParentPath();
        }
        this.delegate.writeBoolean(bl);
    }

    @Override
    public void writeNull() throws IOException {
        if (this._itemFilter == null) {
            return;
        }
        if (this._itemFilter != TokenFilter.INCLUDE_ALL) {
            TokenFilter tokenFilter = this._filterContext.checkValue(this._itemFilter);
            if (tokenFilter == null) {
                return;
            }
            if (tokenFilter != TokenFilter.INCLUDE_ALL && !tokenFilter.includeNull()) {
                return;
            }
            this._checkParentPath();
        }
        this.delegate.writeNull();
    }

    @Override
    public void writeOmittedField(String string) throws IOException {
        if (this._itemFilter != null) {
            this.delegate.writeOmittedField(string);
        }
    }

    @Override
    public void writeObjectId(Object object) throws IOException {
        if (this._itemFilter != null) {
            this.delegate.writeObjectId(object);
        }
    }

    @Override
    public void writeObjectRef(Object object) throws IOException {
        if (this._itemFilter != null) {
            this.delegate.writeObjectRef(object);
        }
    }

    @Override
    public void writeTypeId(Object object) throws IOException {
        if (this._itemFilter != null) {
            this.delegate.writeTypeId(object);
        }
    }

    protected void _checkParentPath() throws IOException {
        ++this._matchCount;
        if (this._includePath) {
            this._filterContext.writePath(this.delegate);
        }
        if (!this._allowMultipleMatches) {
            this._filterContext.skipParentChecks();
        }
    }

    protected void _checkPropertyParentPath() throws IOException {
        ++this._matchCount;
        if (this._includePath) {
            this._filterContext.writePath(this.delegate);
        } else if (this._includeImmediateParent) {
            this._filterContext.writeImmediatePath(this.delegate);
        }
        if (!this._allowMultipleMatches) {
            this._filterContext.skipParentChecks();
        }
    }

    protected boolean _checkBinaryWrite() throws IOException {
        if (this._itemFilter == null) {
            return false;
        }
        if (this._itemFilter == TokenFilter.INCLUDE_ALL) {
            return true;
        }
        if (this._itemFilter.includeBinary()) {
            this._checkParentPath();
            return true;
        }
        return false;
    }

    protected boolean _checkRawValueWrite() throws IOException {
        if (this._itemFilter == null) {
            return false;
        }
        if (this._itemFilter == TokenFilter.INCLUDE_ALL) {
            return true;
        }
        if (this._itemFilter.includeRawValue()) {
            this._checkParentPath();
            return true;
        }
        return false;
    }
}

