/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ser;

import com.fasterxml.jackson.annotation.ObjectIdGenerator;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.cfg.HandlerInstantiator;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.databind.jsonschema.JsonSchema;
import com.fasterxml.jackson.databind.jsonschema.SchemaAware;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.ser.SerializerFactory;
import com.fasterxml.jackson.databind.ser.impl.WritableObjectId;
import com.fasterxml.jackson.databind.util.ClassUtil;
import java.io.Closeable;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;

public abstract class DefaultSerializerProvider
extends SerializerProvider
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected transient Map<Object, WritableObjectId> _seenObjectIds;
    protected transient ArrayList<ObjectIdGenerator<?>> _objectIdGenerators;
    protected transient JsonGenerator _generator;

    protected DefaultSerializerProvider() {
    }

    protected DefaultSerializerProvider(SerializerProvider serializerProvider, SerializationConfig serializationConfig, SerializerFactory serializerFactory) {
        super(serializerProvider, serializationConfig, serializerFactory);
    }

    protected DefaultSerializerProvider(DefaultSerializerProvider defaultSerializerProvider) {
        super(defaultSerializerProvider);
    }

    public abstract DefaultSerializerProvider createInstance(SerializationConfig var1, SerializerFactory var2);

    public DefaultSerializerProvider copy() {
        throw new IllegalStateException("DefaultSerializerProvider sub-class not overriding copy()");
    }

    @Override
    public JsonSerializer<Object> serializerInstance(Annotated annotated, Object object) throws JsonMappingException {
        JsonSerializer jsonSerializer;
        if (object == null) {
            return null;
        }
        if (object instanceof JsonSerializer) {
            jsonSerializer = (JsonSerializer)object;
        } else {
            if (!(object instanceof Class)) {
                throw new IllegalStateException("AnnotationIntrospector returned serializer definition of type " + object.getClass().getName() + "; expected type JsonSerializer or Class<JsonSerializer> instead");
            }
            Class clazz = (Class)object;
            if (clazz == JsonSerializer.None.class || ClassUtil.isBogusClass(clazz)) {
                return null;
            }
            if (!JsonSerializer.class.isAssignableFrom(clazz)) {
                throw new IllegalStateException("AnnotationIntrospector returned Class " + clazz.getName() + "; expected Class<JsonSerializer>");
            }
            HandlerInstantiator handlerInstantiator = this._config.getHandlerInstantiator();
            JsonSerializer jsonSerializer2 = jsonSerializer = handlerInstantiator == null ? null : handlerInstantiator.serializerInstance(this._config, annotated, clazz);
            if (jsonSerializer == null) {
                jsonSerializer = (JsonSerializer)ClassUtil.createInstance(clazz, this._config.canOverrideAccessModifiers());
            }
        }
        return this._handleResolvable(jsonSerializer);
    }

    @Override
    public WritableObjectId findObjectId(Object object, ObjectIdGenerator<?> objectIdGenerator) {
        ObjectIdGenerator<?> objectIdGenerator2;
        if (this._seenObjectIds == null) {
            this._seenObjectIds = this._createObjectIdMap();
        } else {
            objectIdGenerator2 = this._seenObjectIds.get(object);
            if (objectIdGenerator2 != null) {
                return objectIdGenerator2;
            }
        }
        objectIdGenerator2 = null;
        if (this._objectIdGenerators == null) {
            this._objectIdGenerators = new ArrayList(8);
        } else {
            int n = this._objectIdGenerators.size();
            for (int i = 0; i < n; ++i) {
                ObjectIdGenerator<?> objectIdGenerator3 = this._objectIdGenerators.get(i);
                if (!objectIdGenerator3.canUseFor(objectIdGenerator)) continue;
                objectIdGenerator2 = objectIdGenerator3;
                break;
            }
        }
        if (objectIdGenerator2 == null) {
            objectIdGenerator2 = objectIdGenerator.newForSerialization((Object)this);
            this._objectIdGenerators.add(objectIdGenerator2);
        }
        WritableObjectId writableObjectId = new WritableObjectId(objectIdGenerator2);
        this._seenObjectIds.put(object, writableObjectId);
        return writableObjectId;
    }

    protected Map<Object, WritableObjectId> _createObjectIdMap() {
        if (this.isEnabled(SerializationFeature.USE_EQUALITY_FOR_OBJECT_ID)) {
            return new HashMap<Object, WritableObjectId>();
        }
        return new IdentityHashMap<Object, WritableObjectId>();
    }

    public boolean hasSerializerFor(Class<?> clazz, AtomicReference<Throwable> atomicReference) {
        if (clazz == Object.class && !this._config.isEnabled(SerializationFeature.FAIL_ON_EMPTY_BEANS)) {
            return true;
        }
        try {
            JsonSerializer<Object> jsonSerializer = this._findExplicitUntypedSerializer(clazz);
            return jsonSerializer != null;
        }
        catch (JsonMappingException jsonMappingException) {
            if (atomicReference != null) {
                atomicReference.set((Throwable)((Object)jsonMappingException));
            }
        }
        catch (RuntimeException runtimeException) {
            if (atomicReference == null) {
                throw runtimeException;
            }
            atomicReference.set(runtimeException);
        }
        return false;
    }

    @Override
    public JsonGenerator getGenerator() {
        return this._generator;
    }

    public void serializeValue(JsonGenerator jsonGenerator, Object object) throws IOException {
        boolean bl;
        this._generator = jsonGenerator;
        if (object == null) {
            this._serializeNull(jsonGenerator);
            return;
        }
        Class<?> clazz = object.getClass();
        JsonSerializer<Object> jsonSerializer = this.findTypedValueSerializer(clazz, true, null);
        PropertyName propertyName = this._config.getFullRootName();
        if (propertyName == null) {
            bl = this._config.isEnabled(SerializationFeature.WRAP_ROOT_VALUE);
            if (bl) {
                jsonGenerator.writeStartObject();
                PropertyName propertyName2 = this._config.findRootName(object.getClass());
                jsonGenerator.writeFieldName(propertyName2.simpleAsEncoded(this._config));
            }
        } else if (propertyName.isEmpty()) {
            bl = false;
        } else {
            bl = true;
            jsonGenerator.writeStartObject();
            jsonGenerator.writeFieldName(propertyName.getSimpleName());
        }
        try {
            jsonSerializer.serialize(object, jsonGenerator, this);
            if (bl) {
                jsonGenerator.writeEndObject();
            }
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            String string = exception.getMessage();
            if (string == null) {
                string = "[no message for " + exception.getClass().getName() + "]";
            }
            throw new JsonMappingException((Closeable)jsonGenerator, string, (Throwable)exception);
        }
    }

    public void serializeValue(JsonGenerator jsonGenerator, Object object, JavaType javaType) throws IOException {
        boolean bl;
        this._generator = jsonGenerator;
        if (object == null) {
            this._serializeNull(jsonGenerator);
            return;
        }
        if (!javaType.getRawClass().isAssignableFrom(object.getClass())) {
            this._reportIncompatibleRootType(object, javaType);
        }
        JsonSerializer<Object> jsonSerializer = this.findTypedValueSerializer(javaType, true, null);
        PropertyName propertyName = this._config.getFullRootName();
        if (propertyName == null) {
            bl = this._config.isEnabled(SerializationFeature.WRAP_ROOT_VALUE);
            if (bl) {
                jsonGenerator.writeStartObject();
                PropertyName propertyName2 = this._config.findRootName(object.getClass());
                jsonGenerator.writeFieldName(propertyName2.simpleAsEncoded(this._config));
            }
        } else if (propertyName.isEmpty()) {
            bl = false;
        } else {
            bl = true;
            jsonGenerator.writeStartObject();
            jsonGenerator.writeFieldName(propertyName.getSimpleName());
        }
        try {
            jsonSerializer.serialize(object, jsonGenerator, this);
            if (bl) {
                jsonGenerator.writeEndObject();
            }
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            String string = exception.getMessage();
            if (string == null) {
                string = "[no message for " + exception.getClass().getName() + "]";
            }
            this.reportMappingProblem(exception, string, new Object[0]);
        }
    }

    public void serializeValue(JsonGenerator jsonGenerator, Object object, JavaType javaType, JsonSerializer<Object> jsonSerializer) throws IOException {
        boolean bl;
        PropertyName propertyName;
        this._generator = jsonGenerator;
        if (object == null) {
            this._serializeNull(jsonGenerator);
            return;
        }
        if (javaType != null && !javaType.getRawClass().isAssignableFrom(object.getClass())) {
            this._reportIncompatibleRootType(object, javaType);
        }
        if (jsonSerializer == null) {
            jsonSerializer = this.findTypedValueSerializer(javaType, true, null);
        }
        if ((propertyName = this._config.getFullRootName()) == null) {
            bl = this._config.isEnabled(SerializationFeature.WRAP_ROOT_VALUE);
            if (bl) {
                jsonGenerator.writeStartObject();
                PropertyName propertyName2 = javaType == null ? this._config.findRootName(object.getClass()) : this._config.findRootName(javaType);
                jsonGenerator.writeFieldName(propertyName2.simpleAsEncoded(this._config));
            }
        } else if (propertyName.isEmpty()) {
            bl = false;
        } else {
            bl = true;
            jsonGenerator.writeStartObject();
            jsonGenerator.writeFieldName(propertyName.getSimpleName());
        }
        try {
            jsonSerializer.serialize(object, jsonGenerator, this);
            if (bl) {
                jsonGenerator.writeEndObject();
            }
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            String string = exception.getMessage();
            if (string == null) {
                string = "[no message for " + exception.getClass().getName() + "]";
            }
            this.reportMappingProblem(exception, string, new Object[0]);
        }
    }

    public void serializePolymorphic(JsonGenerator jsonGenerator, Object object, JavaType javaType, JsonSerializer<Object> jsonSerializer, TypeSerializer typeSerializer) throws IOException {
        boolean bl;
        PropertyName propertyName;
        this._generator = jsonGenerator;
        if (object == null) {
            this._serializeNull(jsonGenerator);
            return;
        }
        if (javaType != null && !javaType.getRawClass().isAssignableFrom(object.getClass())) {
            this._reportIncompatibleRootType(object, javaType);
        }
        if (jsonSerializer == null) {
            jsonSerializer = javaType != null && javaType.isContainerType() ? this.findValueSerializer(javaType, null) : this.findValueSerializer(object.getClass(), null);
        }
        if ((propertyName = this._config.getFullRootName()) == null) {
            bl = this._config.isEnabled(SerializationFeature.WRAP_ROOT_VALUE);
            if (bl) {
                jsonGenerator.writeStartObject();
                PropertyName propertyName2 = this._config.findRootName(object.getClass());
                jsonGenerator.writeFieldName(propertyName2.simpleAsEncoded(this._config));
            }
        } else if (propertyName.isEmpty()) {
            bl = false;
        } else {
            bl = true;
            jsonGenerator.writeStartObject();
            jsonGenerator.writeFieldName(propertyName.getSimpleName());
        }
        try {
            jsonSerializer.serializeWithType(object, jsonGenerator, this, typeSerializer);
            if (bl) {
                jsonGenerator.writeEndObject();
            }
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            String string = exception.getMessage();
            if (string == null) {
                string = "[no message for " + exception.getClass().getName() + "]";
            }
            this.reportMappingProblem(exception, string, new Object[0]);
        }
    }

    @Deprecated
    public void serializePolymorphic(JsonGenerator jsonGenerator, Object object, TypeSerializer typeSerializer) throws IOException {
        JavaType javaType = object == null ? null : this._config.constructType(object.getClass());
        this.serializePolymorphic(jsonGenerator, object, javaType, null, typeSerializer);
    }

    protected void _serializeNull(JsonGenerator jsonGenerator) throws IOException {
        JsonSerializer<Object> jsonSerializer = this.getDefaultNullValueSerializer();
        try {
            jsonSerializer.serialize(null, jsonGenerator, this);
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            String string = exception.getMessage();
            if (string == null) {
                string = "[no message for " + exception.getClass().getName() + "]";
            }
            this.reportMappingProblem(exception, string, new Object[0]);
        }
    }

    public int cachedSerializersCount() {
        return this._serializerCache.size();
    }

    public void flushCachedSerializers() {
        this._serializerCache.flush();
    }

    public void acceptJsonFormatVisitor(JavaType javaType, JsonFormatVisitorWrapper jsonFormatVisitorWrapper) throws JsonMappingException {
        if (javaType == null) {
            throw new IllegalArgumentException("A class must be provided");
        }
        jsonFormatVisitorWrapper.setProvider(this);
        this.findValueSerializer(javaType, null).acceptJsonFormatVisitor(jsonFormatVisitorWrapper, javaType);
    }

    @Deprecated
    public JsonSchema generateJsonSchema(Class<?> clazz) throws JsonMappingException {
        JsonNode jsonNode;
        if (clazz == null) {
            throw new IllegalArgumentException("A class must be provided");
        }
        JsonSerializer<Object> jsonSerializer = this.findValueSerializer(clazz, null);
        JsonNode jsonNode2 = jsonNode = jsonSerializer instanceof SchemaAware ? ((SchemaAware)((Object)jsonSerializer)).getSchema(this, null) : JsonSchema.getDefaultSchemaNode();
        if (!(jsonNode instanceof ObjectNode)) {
            throw new IllegalArgumentException("Class " + clazz.getName() + " would not be serialized as a JSON object and therefore has no schema");
        }
        return new JsonSchema((ObjectNode)jsonNode);
    }

    public static final class Impl
    extends DefaultSerializerProvider {
        private static final long serialVersionUID = 1L;

        public Impl() {
        }

        public Impl(Impl impl) {
            super(impl);
        }

        protected Impl(SerializerProvider serializerProvider, SerializationConfig serializationConfig, SerializerFactory serializerFactory) {
            super(serializerProvider, serializationConfig, serializerFactory);
        }

        @Override
        public DefaultSerializerProvider copy() {
            if (this.getClass() != Impl.class) {
                return super.copy();
            }
            return new Impl(this);
        }

        @Override
        public Impl createInstance(SerializationConfig serializationConfig, SerializerFactory serializerFactory) {
            return new Impl(this, serializationConfig, serializerFactory);
        }
    }
}

