/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rtextarea;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ClipboardHistory {
    private static ClipboardHistory INSTANCE;
    private List<String> history = new ArrayList<String>();
    private int maxSize = 12;
    private static final int DEFAULT_MAX_SIZE = 12;

    private ClipboardHistory() {
    }

    public void add(String string) {
        int n = this.history.size();
        if (n == 0) {
            this.history.add(string);
        } else {
            int n2 = this.history.indexOf(string);
            if (n2 != n - 1) {
                if (n2 > -1) {
                    this.history.remove(n2);
                }
                this.history.add(string);
            }
            this.trim();
        }
    }

    public static final ClipboardHistory get() {
        if (INSTANCE == null) {
            INSTANCE = new ClipboardHistory();
        }
        return INSTANCE;
    }

    public List<String> getHistory() {
        ArrayList<String> arrayList = new ArrayList<String>(this.history);
        Collections.reverse(arrayList);
        return arrayList;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("Maximum size must be >= 0");
        }
        this.maxSize = n;
        this.trim();
    }

    private void trim() {
        while (this.history.size() > this.maxSize) {
            this.history.remove(0);
        }
    }
}

