/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.model.atompub;

import com.google.common.collect.Lists;
import com.google.gdata.client.CoreErrorDomain;
import com.google.gdata.client.Service;
import com.google.gdata.data.Reference;
import com.google.gdata.data.introspection.ICollection;
import com.google.gdata.model.AttributeKey;
import com.google.gdata.model.Element;
import com.google.gdata.model.ElementCreator;
import com.google.gdata.model.ElementKey;
import com.google.gdata.model.ElementMetadata;
import com.google.gdata.model.MetadataRegistry;
import com.google.gdata.model.QName;
import com.google.gdata.model.ValidationContext;
import com.google.gdata.model.atom.Source;
import com.google.gdata.model.atom.TextContent;
import com.google.gdata.model.atompub.Accept;
import com.google.gdata.model.atompub.Categories;
import com.google.gdata.util.Namespaces;
import com.google.gdata.util.Version;
import java.util.ArrayList;
import java.util.List;

public class Collection
extends Element
implements Reference,
ICollection {
    private final Version coreVersion = Service.getVersion();
    public static final ElementKey<Void, Collection> KEY = ElementKey.of(new QName(Namespaces.atomPubStandardNs, "collection"), Collection.class);
    public static final AttributeKey<String> HREF = AttributeKey.of(new QName("href"));
    public static final AttributeKey<String> TITLE = AttributeKey.of(new QName("title"));

    public static void registerMetadata(MetadataRegistry registry) {
        if (registry.isRegistered(KEY)) {
            return;
        }
        ElementCreator builder = registry.build(KEY);
        builder.addAttribute(TITLE).setVisible(false);
        builder.addAttribute(HREF);
        builder.addElement(Accept.KEY).setCardinality(ElementMetadata.Cardinality.MULTIPLE);
        builder.addElement(Categories.KEY).setCardinality(ElementMetadata.Cardinality.MULTIPLE);
        builder.addElement(Source.TITLE).setRequired(true);
    }

    public Collection() {
        super(KEY);
    }

    protected Collection(ElementKey<?, ? extends Collection> key) {
        super(key);
    }

    protected Collection(ElementKey<?, ? extends Collection> key, Element source) {
        super(key, source);
    }

    public Collection(String href) {
        this();
        this.setHref(href);
    }

    public Collection(String href, TextContent title, String ... accepts) {
        this();
        this.setHref(href);
        this.setTitle(title);
        for (String accept : accepts) {
            this.addAccept(accept);
        }
    }

    public List<Accept> getAccepts() {
        ArrayList accepts = super.getElements(Accept.KEY);
        if (this.coreVersion.isCompatible(Service.Versions.V1)) {
            ArrayList result = Lists.newArrayList();
            for (Accept accept : accepts) {
                String acceptValue = accept.getValue();
                if (acceptValue != null && acceptValue.indexOf(44) != -1) {
                    String[] split;
                    for (String part : split = acceptValue.split(",")) {
                        result.add(new Accept(part));
                    }
                    continue;
                }
                result.add(accept);
            }
            accepts = result;
        }
        return accepts;
    }

    @Override
    public List<String> getAcceptList() {
        List<Accept> accepts = this.getAccepts();
        ArrayList result = Lists.newArrayListWithCapacity((int)accepts.size());
        for (Accept accept : accepts) {
            result.add(accept.getValue());
        }
        return result;
    }

    public Collection addAccept(Accept accept) {
        super.addElement(Accept.KEY, (Element)accept);
        return this;
    }

    public Collection addAccept(String accept) {
        super.addElement(Accept.KEY, (Element)new Accept(accept));
        return this;
    }

    public boolean removeAccept(Accept accept) {
        return super.removeElement(Accept.KEY, accept);
    }

    public boolean removeAccept(String acceptStr) {
        boolean modified = false;
        for (Accept accept : this.getAccepts()) {
            if (!acceptStr.equals(accept.getValue())) continue;
            super.removeElement(Accept.KEY, accept);
            modified = true;
        }
        return modified;
    }

    public boolean hasAccepts() {
        return super.hasElement(Accept.KEY);
    }

    public List<Categories> getCategorieses() {
        return super.getElements(Categories.KEY);
    }

    public Collection addCategories(Categories categories) {
        super.addElement(Categories.KEY, (Element)categories);
        return this;
    }

    public boolean hasCategorieses() {
        return super.hasElement(Categories.KEY);
    }

    @Override
    public String getHref() {
        return super.getAttributeValue(HREF);
    }

    @Override
    public void setHref(String href) {
        this.setAttributeValue(HREF, (Object)href);
    }

    public boolean hasHref() {
        return this.getHref() != null;
    }

    @Override
    public TextContent getTitle() {
        return super.getElement(Source.TITLE);
    }

    public Collection setTitle(TextContent title) {
        this.setAttributeValue(TITLE, (Object)(title == null ? null : title.getPlainText()));
        super.setElement(Source.TITLE, (Element)title);
        return this;
    }

    public boolean hasTitle() {
        return super.hasElement(Source.TITLE);
    }

    @Override
    public Element resolve(ElementMetadata<?, ?> metadata, ValidationContext vc) {
        List<Accept> accepts;
        String titleAttribute = this.getAttributeValue(TITLE);
        TextContent title = this.getElement(Source.TITLE);
        if (titleAttribute != null) {
            if (title == null) {
                title = TextContent.plainText(titleAttribute);
                this.addElement(Source.TITLE, (Element)title);
            } else {
                String titleContent = title.getPlainText();
                if (!titleAttribute.equals(titleContent)) {
                    vc.addError((Element)this, CoreErrorDomain.ERR.duplicateTitle);
                }
            }
        } else if (title != null) {
            titleAttribute = title.getPlainText();
            this.setAttributeValue(TITLE, (Object)titleAttribute);
        }
        if (this.coreVersion.isCompatible(Service.Versions.V1) && (accepts = this.getAccepts()).size() > 1) {
            StringBuilder sb = new StringBuilder();
            for (Accept accept : accepts) {
                if (sb.length() > 0) {
                    sb.append(',');
                }
                sb.append(accept.getValue());
            }
            this.removeElement(Accept.KEY);
            this.addAccept(sb.toString());
        }
        return super.resolve(metadata, vc);
    }

    @Override
    public String toString() {
        return "{Collection href=" + this.getAttributeValue(HREF) + "}";
    }
}

