/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.slick.protocol.jabber;

import java.util.Hashtable;
import junit.framework.TestSuite;
import net.java.sip.communicator.slick.protocol.jabber.JabberSlickFixture;
import net.java.sip.communicator.slick.protocol.jabber.TestAccountInstallation;
import net.java.sip.communicator.slick.protocol.jabber.TestAccountUninstallation;
import net.java.sip.communicator.slick.protocol.jabber.TestAccountUninstallationPersistence;
import net.java.sip.communicator.slick.protocol.jabber.TestOperationSetBasicInstantMessaging;
import net.java.sip.communicator.slick.protocol.jabber.TestOperationSetFileTransferImpl;
import net.java.sip.communicator.slick.protocol.jabber.TestOperationSetInstantMessageTransformJabberImpl;
import net.java.sip.communicator.slick.protocol.jabber.TestOperationSetPersistentPresence;
import net.java.sip.communicator.slick.protocol.jabber.TestOperationSetPresence;
import net.java.sip.communicator.slick.protocol.jabber.TestOperationSetTypingNotifications;
import net.java.sip.communicator.slick.protocol.jabber.TestProtocolProviderServiceJabberImpl;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public class JabberProtocolProviderServiceLick
extends TestSuite
implements BundleActivator {
    public static final String ACCOUNT_1_PREFIX = "accounts.jabber.account1.";
    public static final String ACCOUNT_2_PREFIX = "accounts.jabber.account2.";
    public static final String ACCOUNT_3_PREFIX = "accounts.jabber.account3.";
    public static final String DISABLE_ONLINE_TESTS_PROPERTY_NAME = "accounts.jabber.DISABLE_ONLINE_TESTING";
    public static final String CHAT_ROOM_NAME = "accounts.jabber.CHAT_ROOM_NAME";
    public static final String CONTACT_LIST_PROPERTY_NAME = "accounts.jabber.CONTACT_LIST";

    public void start(BundleContext context) {
        this.setName("JabberProtocolProviderSlick");
        Hashtable<String, String> properties = new Hashtable<String, String>();
        properties.put("service.pid", this.getName());
        JabberSlickFixture.bc = context;
        String offlineMode = System.getProperty(DISABLE_ONLINE_TESTS_PROPERTY_NAME, null);
        if (offlineMode != null && offlineMode.equalsIgnoreCase("true")) {
            JabberSlickFixture.onlineTestingDisabled = true;
        }
        this.addTestSuite(TestAccountInstallation.class);
        this.addTestSuite(TestProtocolProviderServiceJabberImpl.class);
        this.addTest(TestOperationSetPresence.suite());
        if (!JabberSlickFixture.onlineTestingDisabled) {
            this.addTest(TestOperationSetPersistentPresence.suite());
            this.addTest(TestOperationSetBasicInstantMessaging.suite());
            this.addTest(TestOperationSetInstantMessageTransformJabberImpl.suite());
            this.addTest(TestOperationSetTypingNotifications.suite());
            this.addTestSuite(TestOperationSetFileTransferImpl.class);
        }
        this.addTest(TestAccountUninstallation.suite());
        this.addTestSuite(TestAccountUninstallationPersistence.class);
        context.registerService(((Object)((Object)this)).getClass().getName(), (Object)this, properties);
    }

    public void stop(BundleContext context) {
    }
}

