/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.defaultresourcepack;

import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.TreeMap;
import net.java.sip.communicator.plugin.defaultresourcepack.DefaultResourcePackActivator;
import net.java.sip.communicator.service.resources.ImagePack;

public class DefaultImagePackImpl
implements ImagePack {
    private static final String DEFAULT_RESOURCE_PATH = "resources.images.images";

    public Map<String, String> getResources() {
        ResourceBundle resourceBundle = ResourceBundle.getBundle(DEFAULT_RESOURCE_PATH);
        TreeMap<String, String> resources = new TreeMap<String, String>();
        this.initResources(resourceBundle, resources);
        this.initPluginResources(resources);
        return resources;
    }

    public String getName() {
        return "Default Image Resources";
    }

    public String getDescription() {
        return "Provide Jitsi default Image resource pack.";
    }

    private void initResources(ResourceBundle resourceBundle, Map<String, String> resources) {
        Enumeration<String> colorKeys = resourceBundle.getKeys();
        while (colorKeys.hasMoreElements()) {
            String key = colorKeys.nextElement();
            String value = resourceBundle.getString(key);
            resources.put(key, value);
        }
    }

    private void initPluginResources(Map<String, String> resources) {
        Iterator<String> pluginProperties = DefaultResourcePackActivator.findResourcePaths("resources/images", "images-*.properties");
        while (pluginProperties.hasNext()) {
            String resourceBundleName = pluginProperties.next();
            ResourceBundle resourceBundle = ResourceBundle.getBundle(resourceBundleName.substring(0, resourceBundleName.indexOf(".properties")));
            this.initResources(resourceBundle, resources);
        }
    }
}

