/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.utils;

import java.awt.Image;
import java.awt.event.MouseEvent;
import java.io.File;
import java.net.MalformedURLException;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JToolTip;
import net.java.sip.communicator.impl.gui.utils.ImageLoader;
import net.java.sip.communicator.plugin.desktoputil.ExtendedTooltip;
import net.java.sip.communicator.plugin.desktoputil.FileDragLabel;
import net.java.sip.communicator.plugin.desktoputil.ImageUtils;
import net.java.sip.communicator.util.FileUtils;
import net.java.sip.communicator.util.Logger;

public class FileImageLabel
extends FileDragLabel {
    private static final Logger logger = Logger.getLogger(FileImageLabel.class);
    private ImageIcon tooltipIcon;
    private String tooltipTitle;

    public void setToolTipImage(ImageIcon icon) {
        this.tooltipIcon = this.scaleFileIcon(icon, 640, 480);
    }

    public void setToolTipText(String text) {
        super.setToolTipText("");
        this.tooltipTitle = text;
    }

    public JToolTip createToolTip() {
        ExtendedTooltip tip = new ExtendedTooltip(false);
        if (this.tooltipIcon != null) {
            tip.setImage(this.tooltipIcon);
        }
        if (this.tooltipTitle != null) {
            tip.setTitle(this.tooltipTitle);
        }
        tip.setComponent((JComponent)((Object)this));
        return tip;
    }

    public void setFile(File file) {
        super.setFile(file);
        this.setFileIcon(file);
    }

    public String getToolTipText(MouseEvent event) {
        if (this.tooltipIcon != null) {
            return this.tooltipIcon.toString();
        }
        return "";
    }

    private void setFileIcon(File file) {
        if (FileUtils.isImage((String)file.getName())) {
            try {
                ImageIcon icon = new ImageIcon(file.toURI().toURL());
                this.setToolTipImage(icon);
                ImageIcon image = this.scaleFileIcon(icon, 64, 64);
                this.setIcon(image);
            }
            catch (MalformedURLException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Could not locate image.", (Throwable)e);
                }
                this.setIcon(new ImageIcon(ImageLoader.getImage(ImageLoader.DEFAULT_FILE_ICON)));
            }
        } else {
            Icon icon = FileUtils.getIcon((File)file);
            if (icon == null) {
                icon = new ImageIcon(ImageLoader.getImage(ImageLoader.DEFAULT_FILE_ICON));
            }
            this.setIcon(icon);
        }
    }

    private ImageIcon scaleFileIcon(ImageIcon icon, int width, int height) {
        ImageIcon image = null;
        image = icon.getIconWidth() <= width && icon.getIconHeight() <= height ? icon : ImageUtils.getScaledRoundedIcon((Image)icon.getImage(), (int)width, (int)height);
        return image;
    }
}

