/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.desktoputil.presence;

import java.util.Iterator;
import javax.swing.Icon;
import net.java.sip.communicator.plugin.desktoputil.DesktopUtilActivator;
import net.java.sip.communicator.plugin.desktoputil.presence.AbstractStatusMessageMenu;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.OperationSetPresence;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.util.Logger;
import net.java.sip.communicator.util.account.AccountUtils;

public class GlobalStatusMessageMenu
extends AbstractStatusMessageMenu {
    private static final Logger logger = Logger.getLogger(GlobalStatusMessageMenu.class);

    public GlobalStatusMessageMenu(boolean swing) {
        super(swing);
    }

    @Override
    public String getCurrentStatusMessage() {
        return "";
    }

    @Override
    public void publishStatusMessage(String message, Object menuItem, boolean saveIfNewMessage) {
        new PublishStatusMessageThread(message, menuItem, saveIfNewMessage).start();
    }

    @Override
    public Object getDescriptor() {
        return GlobalStatusMessageMenu.class;
    }

    @Override
    protected Icon getMenuIcon() {
        return DesktopUtilActivator.getResources().getImage("service.gui.statusmessage.GLOBAL_STATUS_MESSAGE_ICON");
    }

    private class PublishStatusMessageThread
    extends Thread {
        private String message;
        private Object menuItem;
        private boolean saveIfNewMessage;

        public PublishStatusMessageThread(String message, Object menuItem, boolean saveIfNewMessage) {
            this.message = message;
            this.menuItem = menuItem;
            this.saveIfNewMessage = saveIfNewMessage;
        }

        @Override
        public void run() {
            Iterator pProvidersIter = AccountUtils.getRegisteredProviders().iterator();
            while (pProvidersIter.hasNext()) {
                try {
                    ProtocolProviderService protocolProvider = (ProtocolProviderService)pProvidersIter.next();
                    OperationSetPresence presenceOpSet = (OperationSetPresence)protocolProvider.getOperationSet(OperationSetPresence.class);
                    if (presenceOpSet == null || !protocolProvider.isRegistered()) continue;
                    presenceOpSet.publishPresenceStatus(presenceOpSet.getPresenceStatus(), this.message);
                }
                catch (IllegalArgumentException e1) {
                    logger.error((Object)"Error - changing status", (Throwable)e1);
                }
                catch (IllegalStateException e1) {
                    logger.error((Object)"Error - changing status", (Throwable)e1);
                }
                catch (OperationFailedException e1) {
                    if (e1.getErrorCode() == 1) {
                        logger.error((Object)"General error occured while publishing presence status.", (Throwable)e1);
                        continue;
                    }
                    if (e1.getErrorCode() == 2) {
                        logger.error((Object)"Network failure occured while publishing presence status.", (Throwable)e1);
                        continue;
                    }
                    if (e1.getErrorCode() != 3) continue;
                    logger.error((Object)"Protocol provider must beregistered in order to change status.", (Throwable)e1);
                }
            }
        }
    }
}

