/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.aimaccregwizz;

import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import net.java.sip.communicator.plugin.aimaccregwizz.AimAccRegWizzActivator;
import net.java.sip.communicator.plugin.aimaccregwizz.AimAccountRegistration;
import net.java.sip.communicator.plugin.aimaccregwizz.FirstWizardPage;
import net.java.sip.communicator.plugin.aimaccregwizz.Resources;
import net.java.sip.communicator.service.gui.DesktopAccountRegistrationWizard;
import net.java.sip.communicator.service.gui.WizardContainer;
import net.java.sip.communicator.service.gui.WizardPage;
import net.java.sip.communicator.service.protocol.AccountID;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.ProtocolProviderFactory;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.util.Logger;
import org.osgi.framework.ServiceReference;

public class AimAccountRegistrationWizard
extends DesktopAccountRegistrationWizard {
    private final Logger logger = Logger.getLogger(AimAccountRegistrationWizard.class);
    private FirstWizardPage firstWizardPage;
    private final AimAccountRegistration registration = new AimAccountRegistration();
    private ProtocolProviderService protocolProvider;

    public AimAccountRegistrationWizard(WizardContainer wizardContainer) {
        this.setWizardContainer(wizardContainer);
        wizardContainer.setFinishButtonText(Resources.getString("service.gui.SIGN_IN"));
    }

    public byte[] getIcon() {
        return Resources.getImage(Resources.AIM_LOGO);
    }

    public byte[] getPageImage() {
        return Resources.getImage(Resources.PAGE_IMAGE);
    }

    public String getProtocolName() {
        return Resources.getString("plugin.aimaccregwizz.PROTOCOL_NAME");
    }

    public String getProtocolDescription() {
        return Resources.getString("plugin.aimaccregwizz.PROTOCOL_DESCRIPTION");
    }

    public Iterator<WizardPage> getPages() {
        ArrayList<FirstWizardPage> pages = new ArrayList<FirstWizardPage>();
        if (this.firstWizardPage == null) {
            this.firstWizardPage = new FirstWizardPage(this);
        }
        pages.add(this.firstWizardPage);
        return pages.iterator();
    }

    public Iterator<Map.Entry<String, String>> getSummary() {
        Hashtable<String, String> summaryTable = new Hashtable<String, String>();
        summaryTable.put(Resources.getString("plugin.aimaccregwizz.USERNAME"), this.registration.getUin());
        summaryTable.put(Resources.getString("service.gui.REMEMBER_PASSWORD"), Boolean.toString(this.registration.isRememberPassword()));
        return summaryTable.entrySet().iterator();
    }

    public ProtocolProviderService signin() throws OperationFailedException {
        this.firstWizardPage.commitPage();
        return this.signin(this.registration.getUin(), this.registration.getPassword());
    }

    public ProtocolProviderService signin(String userName, String password) throws OperationFailedException {
        ProtocolProviderFactory factory = AimAccRegWizzActivator.getAimProtocolProviderFactory();
        return this.installAccount(factory, userName, password);
    }

    public ProtocolProviderService installAccount(ProtocolProviderFactory providerFactory, String user, String passwd) throws OperationFailedException {
        Hashtable<String, String> accountProperties = new Hashtable<String, String>();
        accountProperties.put("ACCOUNT_ICON_PATH", "resources/images/protocol/aim/aim32x32.png");
        if (this.registration.isRememberPassword()) {
            accountProperties.put("PASSWORD", passwd);
        }
        if (this.isModification()) {
            providerFactory.modifyAccount(this.protocolProvider, accountProperties);
            this.setModification(false);
            return this.protocolProvider;
        }
        try {
            AccountID accountID = providerFactory.installAccount(user, accountProperties);
            ServiceReference serRef = providerFactory.getProviderForAccount(accountID);
            this.protocolProvider = (ProtocolProviderService)AimAccRegWizzActivator.bundleContext.getService(serRef);
        }
        catch (IllegalStateException exc) {
            this.logger.warn((Object)exc.getMessage());
            throw new OperationFailedException("Account already exists.", 10);
        }
        catch (Exception exc) {
            this.logger.warn((Object)exc.getMessage());
            throw new OperationFailedException("Failed to add account", 1);
        }
        return this.protocolProvider;
    }

    public void loadAccount(ProtocolProviderService protocolProvider) {
        this.setModification(true);
        this.protocolProvider = protocolProvider;
        this.firstWizardPage.loadAccount(protocolProvider);
    }

    public AimAccountRegistration getRegistration() {
        return this.registration;
    }

    public Dimension getSize() {
        return new Dimension(600, 500);
    }

    public Object getFirstPageIdentifier() {
        return this.firstWizardPage.getIdentifier();
    }

    public Object getLastPageIdentifier() {
        return this.firstWizardPage.getIdentifier();
    }

    public String getUserNameExample() {
        return "Ex: johnsmith";
    }

    public void webSignup() {
        AimAccRegWizzActivator.getBrowserLauncher().openURL("https://new.aol.com");
    }

    public boolean isWebSignupSupported() {
        return true;
    }

    public Object getSimpleForm(boolean isCreateAccount) {
        this.firstWizardPage = new FirstWizardPage(this);
        return this.firstWizardPage.getSimpleForm();
    }
}

