/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media;

import java.awt.Component;
import java.io.IOException;
import java.util.Vector;
import javax.media.AudioDeviceUnavailableEvent;
import javax.media.CachingControl;
import javax.media.CachingControlEvent;
import javax.media.Clock;
import javax.media.ClockStartedError;
import javax.media.Control;
import javax.media.Controller;
import javax.media.ControllerClosedEvent;
import javax.media.ControllerErrorEvent;
import javax.media.ControllerEvent;
import javax.media.ControllerListener;
import javax.media.DownloadProgressListener;
import javax.media.DurationUpdateEvent;
import javax.media.EndOfMediaEvent;
import javax.media.ExtendedCachingControl;
import javax.media.GainControl;
import javax.media.IncompatibleSourceException;
import javax.media.IncompatibleTimeBaseException;
import javax.media.MediaLocator;
import javax.media.NotPrefetchedError;
import javax.media.NotRealizedError;
import javax.media.Player;
import javax.media.Processor;
import javax.media.ResourceUnavailableEvent;
import javax.media.RestartingEvent;
import javax.media.SizeChangeEvent;
import javax.media.StartEvent;
import javax.media.StopAtTimeEvent;
import javax.media.StopByRequestEvent;
import javax.media.StopEvent;
import javax.media.StopTimeChangeEvent;
import javax.media.Time;
import javax.media.TimeBase;
import javax.media.control.BufferControl;
import javax.media.protocol.DataSource;
import javax.media.protocol.Positionable;
import javax.media.protocol.RateConfiguration;
import javax.media.protocol.RateConfigureable;
import javax.media.protocol.RateRange;
import net.sf.fmj.media.BasicController;
import net.sf.fmj.media.Log;
import net.sf.fmj.media.PlayThread;
import net.sf.fmj.media.SeekFailedEvent;
import net.sf.fmj.media.StatsThread;
import net.sf.fmj.media.control.SliderRegionControl;
import net.sf.fmj.media.control.SliderRegionControlAdapter;

public abstract class BasicPlayer
extends BasicController
implements Player,
ControllerListener,
DownloadProgressListener {
    protected DataSource source = null;
    protected Vector controllerList = new Vector();
    private Vector optionalControllerList = new Vector();
    private Vector removedControllerList = new Vector();
    private Vector currentControllerList = new Vector();
    private Vector potentialEventsList = null;
    private Vector receivedEventList = new Vector();
    private boolean receivedAllEvents = false;
    private Vector configureEventList = new Vector();
    private Vector realizeEventList = new Vector();
    private Vector prefetchEventList = new Vector();
    private Vector stopEventList = new Vector();
    private Controller restartFrom = null;
    private Vector eomEventsReceivedFrom = new Vector();
    private Vector stopAtTimeReceivedFrom = new Vector();
    private PlayThread playThread = null;
    private StatsThread statsThread = null;
    private Time duration = DURATION_UNKNOWN;
    private Time startTime;
    private Time mediaTimeAtStart;
    private boolean aboutToRestart = false;
    private boolean closing = false;
    private boolean prefetchFailed = false;
    protected boolean framePositioning = true;
    protected Control[] controls = null;
    protected Component controlComp = null;
    public SliderRegionControl regionControl = null;
    protected CachingControl cachingControl = null;
    protected ExtendedCachingControl extendedCachingControl = null;
    protected BufferControl bufferControl = null;
    private Object startSync = new Object();
    private Object mediaTimeSync = new Object();
    long lastTime = 0L;
    static final int LOCAL_STOP = 0;
    static final int STOP_BY_REQUEST = 1;
    static final int RESTARTING = 2;

    public BasicPlayer() {
        this.configureEventList.addElement("javax.media.ConfigureCompleteEvent");
        this.configureEventList.addElement("javax.media.ResourceUnavailableEvent");
        this.realizeEventList.addElement("javax.media.RealizeCompleteEvent");
        this.realizeEventList.addElement("javax.media.ResourceUnavailableEvent");
        this.prefetchEventList.addElement("javax.media.PrefetchCompleteEvent");
        this.prefetchEventList.addElement("javax.media.ResourceUnavailableEvent");
        this.stopEventList.addElement("javax.media.StopEvent");
        this.stopEventList.addElement("javax.media.StopByRequestEvent");
        this.stopEventList.addElement("javax.media.StopAtTimeEvent");
        this.stopThreadEnabled = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final void abortPrefetch() {
        if (this.controllerList != null) {
            int i = this.controllerList.size();
            while (--i >= 0) {
                Controller c = (Controller)this.controllerList.elementAt(i);
                c.deallocate();
            }
        }
        BasicPlayer basicPlayer = this;
        synchronized (basicPlayer) {
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final void abortRealize() {
        if (this.controllerList != null) {
            int i = this.controllerList.size();
            while (--i >= 0) {
                Controller c = (Controller)this.controllerList.elementAt(i);
                c.deallocate();
            }
        }
        BasicPlayer basicPlayer = this;
        synchronized (basicPlayer) {
            this.notify();
        }
    }

    @Override
    public synchronized void addController(Controller newController) throws IncompatibleTimeBaseException {
        int playerState = this.getState();
        if (playerState == 600) {
            this.throwError(new ClockStartedError("Cannot add controller to a started player"));
        }
        if (playerState == 100 || playerState == 200) {
            this.throwError(new NotRealizedError("A Controller cannot be added to an Unrealized Player"));
        }
        if (newController == null || newController == this) {
            return;
        }
        int controllerState = newController.getState();
        if (controllerState == 100 || controllerState == 200) {
            this.throwError(new NotRealizedError("An Unrealized Controller cannot be added to a Player"));
        }
        if (this.controllerList.contains(newController)) {
            return;
        }
        if (playerState == 500 && (controllerState == 300 || controllerState == 400)) {
            this.deallocate();
        }
        this.manageController(newController);
        newController.setTimeBase(this.getTimeBase());
        newController.setMediaTime(this.getMediaTime());
        newController.setStopTime(this.getStopTime());
        if (newController.setRate(this.getRate()) != this.getRate()) {
            this.setRate(1.0f);
        }
    }

    protected abstract boolean audioEnabled();

    float checkRateConfig(RateConfigureable rc, float rate) {
        RateConfiguration[] config = rc.getRateConfigurations();
        if (config == null) {
            return 1.0f;
        }
        float corrected = 1.0f;
        for (int i = 0; i < config.length; ++i) {
            RateRange rr = config[i].getRate();
            if (rr == null || !rr.inRange(rate)) continue;
            rr.setCurrentRate(rate);
            corrected = rate;
            RateConfiguration c = rc.setRateConfiguration(config[i]);
            if (c == null || (rr = c.getRate()) == null) break;
            corrected = rr.getCurrentRate();
            break;
        }
        return corrected;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void completeConfigure() {
        super.completeConfigure();
        BasicPlayer basicPlayer = this;
        synchronized (basicPlayer) {
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void completePrefetch() {
        super.completePrefetch();
        BasicPlayer basicPlayer = this;
        synchronized (basicPlayer) {
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void completeRealize() {
        this.state = 300;
        try {
            this.slaveToMasterTimeBase(this.getMasterTimeBase());
        }
        catch (IncompatibleTimeBaseException e) {
            Log.error(e);
        }
        super.completeRealize();
        BasicPlayer basicPlayer = this;
        synchronized (basicPlayer) {
            this.notify();
        }
    }

    protected void controllerSetStopTime(Time t) {
        super.setStopTime(t);
    }

    protected void controllerStopAtTime() {
        super.stopAtTime();
    }

    @Override
    public final void controllerUpdate(ControllerEvent evt) {
        this.processEvent(evt);
    }

    protected boolean deviceBusy(BasicController mc) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doClose() {
        BasicPlayer basicPlayer = this;
        synchronized (basicPlayer) {
            this.closing = true;
            this.notifyAll();
        }
        if (this.getState() == 600) {
            this.stop(0);
        }
        if (this.controllerList != null) {
            while (!this.controllerList.isEmpty()) {
                Controller c = (Controller)this.controllerList.firstElement();
                c.close();
                this.controllerList.removeElement(c);
            }
        }
        this.controlComp = null;
        if (this.statsThread != null) {
            this.statsThread.kill();
        }
        this.sendEvent(new ControllerClosedEvent(this));
    }

    @Override
    protected synchronized boolean doConfigure() {
        Controller c;
        this.potentialEventsList = this.configureEventList;
        this.resetReceivedEventList();
        this.receivedAllEvents = false;
        this.currentControllerList.removeAllElements();
        int i = this.controllerList.size();
        while (--i >= 0) {
            c = (Controller)this.controllerList.elementAt(i);
            if (c.getState() != 100 || !(c instanceof Processor) && !(c instanceof BasicController)) continue;
            this.currentControllerList.addElement(c);
        }
        i = this.currentControllerList.size();
        while (--i >= 0) {
            c = (Controller)this.currentControllerList.elementAt(i);
            if (c instanceof Processor) {
                ((Processor)c).configure();
                continue;
            }
            if (!(c instanceof BasicController)) continue;
            ((BasicController)c).configure();
        }
        if (!this.currentControllerList.isEmpty()) {
            try {
                while (!this.closing && !this.receivedAllEvents) {
                    this.wait();
                }
            }
            catch (InterruptedException c2) {
                // empty catch block
            }
            this.currentControllerList.removeAllElements();
        }
        i = this.controllerList.size();
        while (--i >= 0) {
            c = (Controller)this.controllerList.elementAt(i);
            if (!(c instanceof Processor) && !(c instanceof BasicController) || c.getState() >= 180) continue;
            Log.error("Error: Unable to configure " + c);
            this.source.disconnect();
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doFailedConfigure() {
        super.doFailedConfigure();
        BasicPlayer basicPlayer = this;
        synchronized (basicPlayer) {
            this.notify();
        }
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doFailedPrefetch() {
        super.doFailedPrefetch();
        BasicPlayer basicPlayer = this;
        synchronized (basicPlayer) {
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doFailedRealize() {
        super.doFailedRealize();
        BasicPlayer basicPlayer = this;
        synchronized (basicPlayer) {
            this.notify();
        }
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean doPrefetch() {
        Controller c;
        this.potentialEventsList = this.prefetchEventList;
        this.resetReceivedEventList();
        this.receivedAllEvents = false;
        this.currentControllerList.removeAllElements();
        Vector list = this.controllerList;
        if (list == null) {
            return false;
        }
        int i = list.size();
        while (--i >= 0) {
            c = (Controller)list.elementAt(i);
            if (c.getState() != 300) continue;
            this.currentControllerList.addElement(c);
            c.prefetch();
        }
        if (!this.currentControllerList.isEmpty()) {
            c = this;
            synchronized (c) {
                try {
                    while (!this.closing && !this.receivedAllEvents) {
                        this.wait();
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.currentControllerList.removeAllElements();
            }
        }
        i = list.size();
        while (--i >= 0) {
            c = (Controller)list.elementAt(i);
            if (c.getState() >= 500) continue;
            Log.error("Error: Unable to prefetch " + c + "\n");
            if (this.optionalControllerList.contains(c)) {
                this.removedControllerList.addElement(c);
                continue;
            }
            BasicPlayer basicPlayer = this;
            synchronized (basicPlayer) {
                this.prefetchFailed = true;
                this.notifyAll();
            }
            return false;
        }
        if (this.removedControllerList != null) {
            i = this.removedControllerList.size();
            while (--i >= 0) {
                Object o = this.removedControllerList.elementAt(i);
                this.controllerList.removeElement(o);
                ((BasicController)o).close();
                if (this.deviceBusy((BasicController)o)) continue;
                BasicPlayer basicPlayer = this;
                synchronized (basicPlayer) {
                    this.prefetchFailed = true;
                    this.notifyAll();
                }
                return false;
            }
            this.removedControllerList.removeAllElements();
        }
        return true;
    }

    @Override
    protected synchronized boolean doRealize() {
        Controller c;
        this.potentialEventsList = this.realizeEventList;
        this.resetReceivedEventList();
        this.receivedAllEvents = false;
        this.currentControllerList.removeAllElements();
        int i = this.controllerList.size();
        while (--i >= 0) {
            c = (Controller)this.controllerList.elementAt(i);
            if (c.getState() != 100 && c.getState() != 180) continue;
            this.currentControllerList.addElement(c);
        }
        i = this.currentControllerList.size();
        while (--i >= 0) {
            c = (Controller)this.currentControllerList.elementAt(i);
            c.realize();
        }
        if (!this.currentControllerList.isEmpty()) {
            try {
                while (!this.closing && !this.receivedAllEvents) {
                    this.wait();
                }
            }
            catch (InterruptedException c2) {
                // empty catch block
            }
            this.currentControllerList.removeAllElements();
        }
        i = this.controllerList.size();
        while (--i >= 0) {
            c = (Controller)this.controllerList.elementAt(i);
            if (c.getState() >= 300) continue;
            Log.error("Error: Unable to realize " + c);
            this.source.disconnect();
            return false;
        }
        this.updateDuration();
        this.statsThread = new StatsThread(this);
        this.statsThread.start();
        return true;
    }

    @Override
    protected void doSetMediaTime(Time now) {
    }

    @Override
    protected float doSetRate(float factor) {
        return factor;
    }

    private void doSetStopTime(Time t) {
        this.getClock().setStopTime(t);
        Vector list = this.controllerList;
        int i = list.size();
        while (--i >= 0) {
            Controller c = (Controller)this.controllerList.elementAt(i);
            c.setStopTime(t);
        }
    }

    @Override
    protected void doStart() {
    }

    @Override
    protected void doStop() {
    }

    @Override
    public void downloadUpdate() {
        int maxValuePercent;
        if (this.extendedCachingControl == null) {
            return;
        }
        this.sendEvent(new CachingControlEvent(this, this.cachingControl, this.cachingControl.getContentProgress()));
        if (this.regionControl == null) {
            return;
        }
        long contentLength = this.cachingControl.getContentLength();
        if (contentLength == -1L || contentLength <= 0L) {
            maxValuePercent = 0;
        } else {
            long endOffset = this.extendedCachingControl.getEndOffset();
            maxValuePercent = (int)(100.0 * (double)endOffset / (double)contentLength);
            if (maxValuePercent < 0) {
                maxValuePercent = 0;
            } else if (maxValuePercent > 100) {
                maxValuePercent = 100;
            }
        }
        this.regionControl.setMinValue(0L);
        this.regionControl.setMaxValue(maxValuePercent);
    }

    public String getContentType() {
        if (this.source != null) {
            return this.source.getContentType();
        }
        return null;
    }

    public final Vector getControllerList() {
        return this.controllerList;
    }

    @Override
    public Component getControlPanelComponent() {
        int state = this.getState();
        if (state < 300) {
            this.throwError(new NotRealizedError("Cannot get control panel component on an unrealized player"));
        }
        return this.controlComp;
    }

    @Override
    public Control[] getControls() {
        int i;
        if (this.controls != null) {
            return this.controls;
        }
        Vector<Control> cv = new Vector<Control>();
        if (this.cachingControl != null) {
            cv.addElement(this.cachingControl);
        }
        if (this.bufferControl != null) {
            cv.addElement(this.bufferControl);
        }
        int size = this.controllerList.size();
        for (i = 0; i < size; ++i) {
            Controller ctrller = (Controller)this.controllerList.elementAt(i);
            Control[] cs = ctrller.getControls();
            if (cs == null) continue;
            for (int j = 0; j < cs.length; ++j) {
                cv.addElement(cs[j]);
            }
        }
        size = cv.size();
        Control[] ctrls = new Control[size];
        for (i = 0; i < size; ++i) {
            ctrls[i] = (Control)cv.elementAt(i);
        }
        if (this.getState() >= 300) {
            this.controls = ctrls;
        }
        return ctrls;
    }

    @Override
    public Time getDuration() {
        long t = this.getMediaNanoseconds();
        if (t > this.lastTime) {
            this.lastTime = t;
            this.updateDuration();
        }
        return this.duration;
    }

    @Override
    public GainControl getGainControl() {
        int state = this.getState();
        if (state >= 300) {
            return (GainControl)this.getControl("javax.media.GainControl");
        }
        this.throwError(new NotRealizedError("Cannot get gain control on an unrealized player"));
        return null;
    }

    protected abstract TimeBase getMasterTimeBase();

    public MediaLocator getMediaLocator() {
        if (this.source != null) {
            return this.source.getLocator();
        }
        return null;
    }

    private Vector getPotentialEventsList() {
        return this.potentialEventsList;
    }

    private Vector getReceivedEventsList() {
        return this.receivedEventList;
    }

    protected DataSource getSource() {
        return this.source;
    }

    @Override
    public Time getStartLatency() {
        super.getStartLatency();
        long t = 0L;
        for (int i = 0; i < this.controllerList.size(); ++i) {
            Controller c = (Controller)this.controllerList.elementAt(i);
            Time latency = c.getStartLatency();
            if (latency == LATENCY_UNKNOWN || latency.getNanoseconds() <= t) continue;
            t = latency.getNanoseconds();
        }
        if (t == 0L) {
            return LATENCY_UNKNOWN;
        }
        return new Time(t);
    }

    @Override
    public Component getVisualComponent() {
        int state = this.getState();
        if (state < 300) {
            this.throwError(new NotRealizedError("Cannot get visual component on an unrealized player"));
        }
        return null;
    }

    public boolean isAboutToRestart() {
        return this.aboutToRestart;
    }

    @Override
    protected boolean isConfigurable() {
        return false;
    }

    public boolean isFramePositionable() {
        return this.framePositioning;
    }

    protected final void manageController(Controller controller) {
        this.manageController(controller, false);
    }

    protected final void manageController(Controller controller, boolean optional) {
        if (controller != null && !this.controllerList.contains(controller)) {
            this.controllerList.addElement(controller);
            if (optional) {
                this.optionalControllerList.addElement(controller);
            }
            controller.addControllerListener(this);
        }
        this.updateDuration();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyIfAllEventsArrived(Vector controllerList, Vector receivedEventList) {
        if (receivedEventList != null && receivedEventList.size() == this.currentControllerList.size()) {
            this.receivedAllEvents = true;
            this.resetReceivedEventList();
            BasicPlayer basicPlayer = this;
            synchronized (basicPlayer) {
                this.notifyAll();
            }
        }
    }

    final synchronized void play() {
        if (this.getTargetState() != 600) {
            return;
        }
        this.prefetchFailed = false;
        int state = this.getState();
        if (state == 100 || state == 180 || state == 300) {
            this.prefetch();
        }
        while (!(this.closing || this.prefetchFailed || this.getState() != 140 && this.getState() != 200 && this.getState() != 300 && this.getState() != 400)) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.getState() != 600 && this.getTargetState() == 600 && this.getState() == 500) {
            this.syncStart(this.getTimeBase().getTime());
        }
    }

    protected final void processEndOfMedia() {
        super.stop();
        this.sendEvent(new EndOfMediaEvent(this, 600, 500, this.getTargetState(), this.getMediaTime()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processEvent(ControllerEvent evt) {
        Controller c;
        int ii;
        int i;
        Controller source = evt.getSourceController();
        if (evt instanceof AudioDeviceUnavailableEvent) {
            this.sendEvent(new AudioDeviceUnavailableEvent(this));
            return;
        }
        if (evt instanceof ControllerClosedEvent && !this.closing && this.controllerList.contains(source) && !(evt instanceof ResourceUnavailableEvent)) {
            this.controllerList.removeElement(source);
            if (evt instanceof ControllerErrorEvent) {
                this.sendEvent(new ControllerErrorEvent(this, ((ControllerErrorEvent)evt).getMessage()));
            }
            this.close();
        }
        if (evt instanceof SizeChangeEvent && this.controllerList.contains(source)) {
            this.sendEvent(new SizeChangeEvent(this, ((SizeChangeEvent)evt).getWidth(), ((SizeChangeEvent)evt).getHeight(), ((SizeChangeEvent)evt).getScale()));
            return;
        }
        if (evt instanceof DurationUpdateEvent && this.controllerList.contains(source)) {
            this.updateDuration();
            return;
        }
        if (evt instanceof RestartingEvent && this.controllerList.contains(source)) {
            this.restartFrom = source;
            i = this.controllerList.size();
            super.stop();
            this.setTargetState(500);
            for (ii = 0; ii < i; ++ii) {
                c = (Controller)this.controllerList.elementAt(ii);
                if (c == source) continue;
                c.stop();
            }
            super.stop();
            this.sendEvent(new RestartingEvent(this, 600, 400, 600, this.getMediaTime()));
        }
        if (evt instanceof StartEvent && source == this.restartFrom) {
            this.restartFrom = null;
            this.start();
        }
        if (evt instanceof SeekFailedEvent && this.controllerList.contains(source)) {
            i = this.controllerList.size();
            super.stop();
            this.setTargetState(500);
            for (ii = 0; ii < i; ++ii) {
                c = (Controller)this.controllerList.elementAt(ii);
                if (c == source) continue;
                c.stop();
            }
            this.sendEvent(new SeekFailedEvent(this, 600, 500, 500, this.getMediaTime()));
        }
        if (evt instanceof EndOfMediaEvent && this.controllerList.contains(source)) {
            if (this.eomEventsReceivedFrom.contains(source)) {
                return;
            }
            this.eomEventsReceivedFrom.addElement(source);
            if (this.eomEventsReceivedFrom.size() == this.controllerList.size()) {
                super.stop();
                this.sendEvent(new EndOfMediaEvent(this, 600, 500, this.getTargetState(), this.getMediaTime()));
            }
            return;
        }
        if (evt instanceof StopAtTimeEvent && this.controllerList.contains(source) && this.getState() == 600) {
            Vector i2 = this.stopAtTimeReceivedFrom;
            synchronized (i2) {
                boolean allStopped;
                if (this.stopAtTimeReceivedFrom.contains(source)) {
                    return;
                }
                this.stopAtTimeReceivedFrom.addElement(source);
                boolean bl = allStopped = this.stopAtTimeReceivedFrom.size() == this.controllerList.size();
                if (!allStopped) {
                    allStopped = true;
                    for (int i3 = 0; i3 < this.controllerList.size(); ++i3) {
                        Controller c2 = (Controller)this.controllerList.elementAt(i3);
                        if (this.stopAtTimeReceivedFrom.contains(c2) || this.eomEventsReceivedFrom.contains(c2)) continue;
                        allStopped = false;
                        break;
                    }
                }
                if (allStopped) {
                    super.stop();
                    this.doSetStopTime(Clock.RESET);
                    this.sendEvent(new StopAtTimeEvent(this, 600, 500, this.getTargetState(), this.getMediaTime()));
                }
                return;
            }
        }
        if (evt instanceof CachingControlEvent && this.controllerList.contains(source)) {
            CachingControl mcc = ((CachingControlEvent)evt).getCachingControl();
            this.sendEvent(new CachingControlEvent(this, mcc, mcc.getContentProgress()));
            return;
        }
        Vector eventList = this.potentialEventsList;
        if (this.controllerList != null && this.controllerList.contains(source) && eventList != null && eventList.contains(evt.getClass().getName())) {
            this.updateReceivedEventsList(evt);
            this.notifyIfAllEventsArrived(this.controllerList, this.getReceivedEventsList());
        }
    }

    @Override
    public final synchronized void removeController(Controller oldController) {
        int state = this.getState();
        if (state < 300) {
            this.throwError(new NotRealizedError("Cannot remove controller from a unrealized player"));
        }
        if (state == 600) {
            this.throwError(new ClockStartedError("Cannot remove controller from a started player"));
        }
        if (oldController == null) {
            return;
        }
        if (this.controllerList.contains(oldController)) {
            this.controllerList.removeElement(oldController);
            oldController.removeControllerListener(this);
            this.updateDuration();
            try {
                oldController.setTimeBase(null);
            }
            catch (IncompatibleTimeBaseException incompatibleTimeBaseException) {
                // empty catch block
            }
        }
    }

    private void resetReceivedEventList() {
        if (this.receivedEventList != null) {
            this.receivedEventList.removeAllElements();
        }
    }

    @Override
    protected void setMediaLength(long t) {
        this.duration = new Time(t);
        super.setMediaLength(t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setMediaTime(Time now) {
        if (this.state < 300) {
            this.throwError(new NotRealizedError(MediaTimeError));
        }
        Object object = this.mediaTimeSync;
        synchronized (object) {
            if (this.syncStartInProgress()) {
                return;
            }
            if (this.getState() == 600) {
                this.aboutToRestart = true;
                this.stop(2);
            }
            if (this.source instanceof Positionable) {
                now = ((Positionable)((Object)this.source)).setPosition(now, 2);
            }
            super.setMediaTime(now);
            int i = this.controllerList.size();
            while (--i >= 0) {
                ((Controller)this.controllerList.elementAt(i)).setMediaTime(now);
            }
            this.doSetMediaTime(now);
            if (this.aboutToRestart) {
                this.syncStart(this.getTimeBase().getTime());
                this.aboutToRestart = false;
            }
        }
    }

    @Override
    public float setRate(float rate) {
        float rateSet;
        float oldRate;
        if (this.state < 300) {
            this.throwError(new NotRealizedError("Cannot set rate on an unrealized Player."));
        }
        if (this.source instanceof RateConfigureable) {
            rate = this.checkRateConfig((RateConfigureable)((Object)this.source), rate);
        }
        if ((oldRate = this.getRate()) == rate) {
            return rate;
        }
        if (this.getState() == 600) {
            this.aboutToRestart = true;
            this.stop(2);
        }
        if (!this.trySetRate(rate)) {
            if (!this.trySetRate(oldRate)) {
                this.trySetRate(1.0f);
                rateSet = 1.0f;
            } else {
                rateSet = oldRate;
            }
        } else {
            rateSet = rate;
        }
        super.setRate(rateSet);
        if (this.aboutToRestart) {
            this.syncStart(this.getTimeBase().getTime());
            this.aboutToRestart = false;
        }
        return rateSet;
    }

    @Override
    public void setSource(DataSource source) throws IOException, IncompatibleSourceException {
        this.source = source;
        try {
            this.cachingControl = (CachingControl)source.getControl(CachingControl.class.getName());
            if (this.cachingControl != null && this.cachingControl instanceof ExtendedCachingControl) {
                this.extendedCachingControl = (ExtendedCachingControl)this.cachingControl;
                if (this.extendedCachingControl != null) {
                    this.regionControl = new SliderRegionControlAdapter();
                    this.extendedCachingControl.addDownloadProgressListener(this, 100);
                }
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    @Override
    public void setStopTime(Time t) {
        if (this.state < 300) {
            this.throwError(new NotRealizedError("Cannot set stop time on an unrealized controller."));
        }
        if (this.getClock().getStopTime() == null || this.getClock().getStopTime().getNanoseconds() != t.getNanoseconds()) {
            this.sendEvent(new StopTimeChangeEvent(this, t));
        }
        this.doSetStopTime(t);
    }

    @Override
    public void setTimeBase(TimeBase tb) throws IncompatibleTimeBaseException {
        TimeBase oldTimeBase = this.getMasterTimeBase();
        if (tb == null) {
            tb = oldTimeBase;
        }
        Controller c = null;
        if (this.controllerList != null) {
            try {
                int i = this.controllerList.size();
                while (--i >= 0) {
                    c = (Controller)this.controllerList.elementAt(i);
                    c.setTimeBase(tb);
                }
            }
            catch (IncompatibleTimeBaseException e) {
                Controller cx;
                int i = this.controllerList.size();
                while (--i >= 0 && (cx = (Controller)this.controllerList.elementAt(i)) != c) {
                    cx.setTimeBase(oldTimeBase);
                }
                Log.dumpStack(e);
                throw e;
            }
        }
        super.setTimeBase(tb);
    }

    protected void slaveToMasterTimeBase(TimeBase tb) throws IncompatibleTimeBaseException {
        this.setTimeBase(tb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void start() {
        Object object = this.startSync;
        synchronized (object) {
            if (this.restartFrom != null) {
                return;
            }
            if (this.getState() == 600) {
                this.sendEvent(new StartEvent(this, 600, 600, 600, this.mediaTimeAtStart, this.startTime));
                return;
            }
            if (this.playThread == null || !this.playThread.isAlive()) {
                this.setTargetState(600);
                this.playThread = new PlayThread(this);
                this.playThread.start();
            }
        }
    }

    @Override
    public final void stop() {
        this.stop(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stop(int stopType) {
        int state = this.getState();
        switch (state) {
            case 100: 
            case 300: 
            case 500: {
                this.setTargetState(state);
                break;
            }
            case 200: {
                this.setTargetState(300);
                break;
            }
            case 400: 
            case 600: {
                this.setTargetState(500);
            }
        }
        if (this.getState() != 600) {
            switch (stopType) {
                case 1: {
                    this.sendEvent(new StopByRequestEvent(this, this.getState(), this.getState(), this.getTargetState(), this.getMediaTime()));
                    break;
                }
                case 2: {
                    this.sendEvent(new RestartingEvent(this, this.getState(), this.getState(), 600, this.getMediaTime()));
                    break;
                }
                default: {
                    this.sendEvent(new StopEvent(this, this.getState(), this.getState(), this.getTargetState(), this.getMediaTime()));
                    break;
                }
            }
        } else if (this.getState() == 600) {
            BasicPlayer basicPlayer = this;
            synchronized (basicPlayer) {
                this.potentialEventsList = this.stopEventList;
                this.resetReceivedEventList();
                this.receivedAllEvents = false;
                this.currentControllerList.removeAllElements();
                int i = this.controllerList.size();
                while (--i >= 0) {
                    Controller c = (Controller)this.controllerList.elementAt(i);
                    this.currentControllerList.addElement(c);
                    c.stop();
                }
                if (this.currentControllerList == null) {
                    return;
                }
                if (!this.currentControllerList.isEmpty()) {
                    try {
                        while (!this.closing && !this.receivedAllEvents) {
                            this.wait();
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.currentControllerList.removeAllElements();
                }
                super.stop();
                switch (stopType) {
                    case 1: {
                        this.sendEvent(new StopByRequestEvent(this, 600, this.getState(), this.getTargetState(), this.getMediaTime()));
                        break;
                    }
                    case 2: {
                        this.sendEvent(new RestartingEvent(this, 600, this.getState(), 600, this.getMediaTime()));
                        break;
                    }
                    default: {
                        this.sendEvent(new StopEvent(this, 600, this.getState(), this.getTargetState(), this.getMediaTime()));
                    }
                }
            }
        }
    }

    @Override
    protected void stopAtTime() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void syncStart(Time tbt) {
        Object object = this.mediaTimeSync;
        synchronized (object) {
            if (this.syncStartInProgress()) {
                return;
            }
            int state = this.getState();
            if (state == 600) {
                this.throwError(new ClockStartedError("syncStart() cannot be used on an already started player"));
            }
            if (state != 500) {
                this.throwError(new NotPrefetchedError("Cannot start player before it has been prefetched"));
            }
            this.eomEventsReceivedFrom.removeAllElements();
            this.stopAtTimeReceivedFrom.removeAllElements();
            this.setTargetState(600);
            int i = this.controllerList.size();
            while (--i >= 0) {
                if (this.getTargetState() != 600) continue;
                ((Controller)this.controllerList.elementAt(i)).syncStart(tbt);
            }
            if (this.getTargetState() == 600) {
                this.startTime = tbt;
                this.mediaTimeAtStart = this.getMediaTime();
                super.syncStart(tbt);
            }
        }
    }

    private boolean trySetRate(float rate) {
        int i = this.controllerList.size();
        while (--i >= 0) {
            Controller c = (Controller)this.controllerList.elementAt(i);
            if (c.setRate(rate) == rate) continue;
            return false;
        }
        return true;
    }

    public final void unmanageController(Controller controller) {
        if (controller != null && this.controllerList.contains(controller)) {
            this.controllerList.removeElement(controller);
            controller.removeControllerListener(this);
        }
    }

    protected synchronized void updateDuration() {
        Time oldDuration = this.duration;
        this.duration = DURATION_UNKNOWN;
        for (int i = 0; i < this.controllerList.size(); ++i) {
            Controller c = (Controller)this.controllerList.elementAt(i);
            Time dur = c.getDuration();
            if (dur.equals(DURATION_UNKNOWN)) {
                if (c instanceof BasicController) continue;
                this.duration = DURATION_UNKNOWN;
                break;
            }
            if (dur.equals(DURATION_UNBOUNDED)) {
                this.duration = DURATION_UNBOUNDED;
                break;
            }
            if (this.duration.equals(DURATION_UNKNOWN)) {
                this.duration = dur;
                continue;
            }
            if (this.duration.getNanoseconds() >= dur.getNanoseconds()) continue;
            this.duration = dur;
        }
        if (this.duration.getNanoseconds() != oldDuration.getNanoseconds()) {
            this.setMediaLength(this.duration.getNanoseconds());
            this.sendEvent(new DurationUpdateEvent(this, this.duration));
        }
    }

    private void updateReceivedEventsList(ControllerEvent event) {
        if (this.receivedEventList != null) {
            Controller source = event.getSourceController();
            if (this.receivedEventList.contains(source)) {
                return;
            }
            this.receivedEventList.addElement(source);
        }
    }

    public abstract void updateStats();

    protected abstract boolean videoEnabled();
}

