/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.multiplexer.audio;

import com.lti.utils.UnsignedUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.ResourceUnavailableException;
import javax.media.format.AudioFormat;
import javax.media.protocol.ContentDescriptor;
import net.sf.fmj.media.multiplexer.AbstractInputStreamMux;
import net.sf.fmj.utility.FormatArgUtils;
import net.sf.fmj.utility.LoggerSingleton;

public class CsvAudioMux
extends AbstractInputStreamMux {
    private static final Logger logger = LoggerSingleton.logger;
    private boolean headerWritten = false;
    private boolean trailerWritten = false;

    public static void audioBufferToStream(AudioFormat f, Buffer buffer, OutputStream os) throws IOException {
        byte[] data = (byte[])buffer.getData();
        int sampleSizeInBytes = f.getSampleSizeInBits() / 8;
        if (sampleSizeInBytes * 8 != f.getSampleSizeInBits()) {
            throw new RuntimeException("Sample size in bytes must be divisible by 8");
        }
        int frameSizeInBytes = sampleSizeInBytes * f.getChannels();
        int framesInBuffer = buffer.getLength() / frameSizeInBytes;
        if (buffer.getLength() != framesInBuffer * frameSizeInBytes) {
            throw new RuntimeException("Length of buffer not an integral number of samples");
        }
        long inputUnsignedMax = (1L << f.getSampleSizeInBits()) - 1L;
        long inputSignedMax = (1L << f.getSampleSizeInBits() - 1) - 1L;
        for (int frame = 0; frame < framesInBuffer; ++frame) {
            for (int channel = 0; channel < f.getChannels(); ++channel) {
                long inputSampleLongWithSign;
                int offset = buffer.getOffset() + frame * frameSizeInBytes + channel * sampleSizeInBytes;
                int inputSampleLiteral = CsvAudioMux.getSample(data, offset, sampleSizeInBytes, f.getEndian());
                long inputSampleLongWithoutSign = UnsignedUtils.uIntToLong(inputSampleLiteral);
                if (f.getSigned() == 0) {
                    inputSampleLongWithSign = inputSampleLongWithoutSign;
                } else if (f.getSigned() == 1) {
                    inputSampleLongWithSign = inputSampleLongWithoutSign > inputSignedMax ? inputSampleLongWithoutSign - inputUnsignedMax - 1L : inputSampleLongWithoutSign;
                } else {
                    throw new RuntimeException("input format signed not specified");
                }
                if (channel > 0) {
                    os.write(",".getBytes());
                }
                os.write(("" + inputSampleLongWithSign).getBytes());
            }
            os.write("\n".getBytes());
        }
    }

    private static int getSample(byte[] inputBufferData, int byteOffsetOfSample, int inputSampleSizeInBytes, int inputEndian) {
        int sample = 0;
        for (int j = 0; j < inputSampleSizeInBytes; ++j) {
            int offsetWithinSample = inputEndian == 1 ? j : inputSampleSizeInBytes - 1 - j;
            byte b = inputBufferData[byteOffsetOfSample + offsetWithinSample];
            sample <<= 8;
            sample |= b & 0xFF;
        }
        return sample;
    }

    public CsvAudioMux() {
        super(new ContentDescriptor("audio.csv"));
    }

    @Override
    public void close() {
        if (!this.trailerWritten) {
            try {
                this.outputTrailer(this.getOutputStream());
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "" + e, e);
                throw new RuntimeException(e);
            }
            this.trailerWritten = true;
        }
        super.close();
    }

    @Override
    protected void doProcess(Buffer buffer, int trackID, OutputStream os) throws IOException {
        if (!this.headerWritten) {
            this.outputHeader(os);
            this.headerWritten = true;
        }
        if (buffer.isEOM()) {
            if (!this.trailerWritten) {
                this.outputTrailer(os);
                this.trailerWritten = true;
            }
            os.close();
            return;
        }
        if (buffer.isDiscard()) {
            return;
        }
        CsvAudioMux.audioBufferToStream((AudioFormat)this.inputFormats[0], buffer, os);
    }

    @Override
    public Format[] getSupportedInputFormats() {
        return new Format[]{new AudioFormat("LINEAR", -1.0, -1, -1, -1, -1, -1, -1.0, Format.byteArray)};
    }

    @Override
    public void open() throws ResourceUnavailableException {
        super.open();
        if (!this.headerWritten) {
            try {
                this.outputHeader(this.getOutputStream());
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "" + e, e);
                throw new ResourceUnavailableException("" + e);
            }
            this.headerWritten = true;
        }
    }

    private void outputHeader(OutputStream os) throws IOException {
        os.write(FormatArgUtils.toString(this.inputFormats[0]).getBytes());
        os.write("\n".getBytes());
    }

    private void outputTrailer(OutputStream os) throws IOException {
    }

    @Override
    public Format setInputFormat(Format format, int trackID) {
        logger.finer("setInputFormat " + format + " " + trackID);
        boolean match = false;
        for (Format supported : this.getSupportedInputFormats()) {
            if (!format.matches(supported)) continue;
            match = true;
            break;
        }
        if (!match) {
            logger.warning("Input format does not match any supported input format: " + format);
            return null;
        }
        if (this.inputFormats != null) {
            this.inputFormats[trackID] = format;
        }
        return format;
    }
}

