/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.renderer.video;

import com.lti.utils.StringUtils;
import java.awt.Component;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.format.JPEGFormat;
import javax.media.format.VideoFormat;
import javax.media.renderer.VideoRenderer;
import net.sf.fmj.media.AbstractVideoRenderer;
import net.sf.fmj.media.renderer.video.JVideoComponent;
import net.sf.fmj.utility.LoggerSingleton;

public class JPEGRenderer
extends AbstractVideoRenderer
implements VideoRenderer {
    private static final Logger logger = LoggerSingleton.logger;
    private boolean scale;
    private final Format[] supportedInputFormats = new Format[]{new JPEGFormat()};
    private JVideoComponent component = new JVideoComponent();
    private Object[] controls = new Object[]{this};

    @Override
    public int doProcess(Buffer buffer) {
        BufferedImage image;
        if (buffer.isEOM()) {
            logger.warning(this.getClass().getSimpleName() + "passed buffer with EOM flag");
            return 0;
        }
        if (buffer.getData() == null) {
            logger.warning("buffer.getData() == null, eom=" + buffer.isEOM());
            return 1;
        }
        if (buffer.getLength() == 0) {
            logger.warning("buffer.getLength() == 0, eom=" + buffer.isEOM());
            return 1;
        }
        if (buffer.isDiscard()) {
            logger.warning("JPEGRenderer passed buffer with discard flag");
            return 1;
        }
        try {
            image = ImageIO.read(new ByteArrayInputStream((byte[])buffer.getData(), buffer.getOffset(), buffer.getLength()));
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "" + e, e);
            logger.log(Level.WARNING, "data: " + StringUtils.byteArrayToHexString((byte[])buffer.getData(), buffer.getLength(), buffer.getOffset()));
            return 1;
        }
        if (image == null) {
            logger.log(Level.WARNING, "Failed to read image (ImageIO.read returned null).");
            logger.log(Level.WARNING, "data: " + StringUtils.byteArrayToHexString((byte[])buffer.getData(), buffer.getLength(), buffer.getOffset()));
            return 1;
        }
        try {
            this.component.setImage(image);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "" + e, e);
            logger.log(Level.WARNING, "data: " + StringUtils.byteArrayToHexString((byte[])buffer.getData(), buffer.getLength(), buffer.getOffset()));
            return 1;
        }
        return 0;
    }

    @Override
    public Component getComponent() {
        return this.component;
    }

    @Override
    public Object[] getControls() {
        return this.controls;
    }

    @Override
    public String getName() {
        return "JPEG Renderer";
    }

    @Override
    public Format[] getSupportedInputFormats() {
        return this.supportedInputFormats;
    }

    @Override
    public Format setInputFormat(Format format) {
        VideoFormat chosenFormat = (VideoFormat)super.setInputFormat(format);
        if (chosenFormat != null) {
            this.getComponent().setPreferredSize(chosenFormat.getSize());
        }
        return chosenFormat;
    }
}

