/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.icq;

import java.util.Hashtable;
import java.util.Map;
import net.java.sip.communicator.impl.protocol.icq.IcqAccountID;
import net.java.sip.communicator.impl.protocol.icq.IcqActivator;
import net.java.sip.communicator.impl.protocol.icq.ProtocolProviderServiceIcqImpl;
import net.java.sip.communicator.service.protocol.AccountID;
import net.java.sip.communicator.service.protocol.ProtocolProviderFactory;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class ProtocolProviderFactoryIcqImpl
extends ProtocolProviderFactory {
    private boolean isAimFactory = false;

    protected ProtocolProviderFactoryIcqImpl(boolean isAimFactory) {
        super(IcqActivator.getBundleContext(), isAimFactory ? "AIM" : "ICQ");
        this.isAimFactory = isAimFactory;
    }

    public AccountID installAccount(String userIDStr, Map<String, String> accountProperties) {
        IcqAccountID accountID;
        BundleContext context = IcqActivator.getBundleContext();
        if (context == null) {
            throw new NullPointerException("The specified BundleContext was null");
        }
        if (userIDStr == null) {
            throw new NullPointerException("The specified AccountID was null");
        }
        if (accountProperties == null) {
            throw new NullPointerException("The specified property map was null");
        }
        accountProperties.put("USER_ID", userIDStr);
        if (this.isAimFactory) {
            accountProperties.put("IS_AIM", "true");
        }
        if (this.registeredAccounts.containsKey((Object)(accountID = new IcqAccountID(userIDStr, accountProperties)))) {
            throw new IllegalStateException("An account for id " + userIDStr + " was already installed!");
        }
        this.storeAccount(accountID, false);
        accountID = this.loadAccount(accountProperties);
        return accountID;
    }

    public AccountID loadAccount(Map<String, String> accountProperties) {
        boolean accountPropertiesIsAIM = IcqAccountID.isAIM(accountProperties);
        if (accountPropertiesIsAIM && !this.isAimFactory || !accountPropertiesIsAIM && this.isAimFactory) {
            return null;
        }
        return super.loadAccount(accountProperties);
    }

    public boolean loadAccount(AccountID accountID) {
        boolean accountPropertiesIsAIM = IcqAccountID.isAIM(accountID.getAccountProperties());
        if (accountPropertiesIsAIM && !this.isAimFactory || !accountPropertiesIsAIM && this.isAimFactory) {
            return false;
        }
        return super.loadAccount(accountID);
    }

    public AccountID createAccount(Map<String, String> accountProperties) {
        boolean accountPropertiesIsAIM = IcqAccountID.isAIM(accountProperties);
        if (accountPropertiesIsAIM && !this.isAimFactory || !accountPropertiesIsAIM && this.isAimFactory) {
            return null;
        }
        return super.createAccount(accountProperties);
    }

    protected AccountID createAccountID(String userID, Map<String, String> accountProperties) {
        return new IcqAccountID(userID, accountProperties);
    }

    protected ProtocolProviderService createService(String userID, AccountID accountID) {
        ProtocolProviderServiceIcqImpl service = new ProtocolProviderServiceIcqImpl();
        service.initialize(userID, accountID);
        return service;
    }

    public void modifyAccount(ProtocolProviderService protocolProvider, Map<String, String> accountProperties) throws NullPointerException {
        if (protocolProvider == null) {
            throw new NullPointerException("The specified Protocol Provider was null");
        }
        if (accountProperties == null) {
            throw new NullPointerException("The specified property map was null");
        }
        BundleContext context = IcqActivator.getBundleContext();
        if (context == null) {
            throw new NullPointerException("The specified BundleContext was null");
        }
        IcqAccountID accountID = (IcqAccountID)protocolProvider.getAccountID();
        if (!this.registeredAccounts.containsKey((Object)accountID)) {
            return;
        }
        ServiceRegistration registration = (ServiceRegistration)this.registeredAccounts.get((Object)accountID);
        if (registration != null) {
            registration.unregister();
        }
        accountProperties.put("USER_ID", accountID.getUserID());
        if (!accountProperties.containsKey("PROTOCOL_NAME")) {
            accountProperties.put("PROTOCOL_NAME", "ICQ");
        }
        accountID.setAccountProperties(accountProperties);
        this.storeAccount(accountID);
        Hashtable<String, String> properties = new Hashtable<String, String>();
        properties.put("PROTOCOL_NAME", "ICQ");
        properties.put("USER_ID", accountID.getUserID());
        ((ProtocolProviderServiceIcqImpl)protocolProvider).initialize(accountID.getUserID(), accountID);
        this.storeAccount(accountID);
        registration = context.registerService(ProtocolProviderService.class.getName(), (Object)protocolProvider, properties);
        this.registeredAccounts.put(accountID, registration);
    }
}

