/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.rvproto.getfile;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.List;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.LiveWritable;
import net.kano.joscar.MiscTools;
import net.kano.joscar.rvcmd.SegmentedFilename;
import net.kano.joscar.tlv.ImmutableTlvChain;
import net.kano.joscar.tlv.Tlv;
import net.kano.joscar.tlv.TlvTools;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetFileEntry
implements LiveWritable {
    public static final long FLAG_DIR = 1L;
    private static final int TYPE_LASTMOD = 257;
    private static final int TYPE_FILESIZE = 771;
    private static final int TYPE_FILENAME = 1028;
    private static final int TYPE_FLAGS = 2304;
    private static final int TYPE_SENTINEL = 2313;
    private final SegmentedFilename filename;
    private final long filesize;
    private final long lastmod;
    private final long flags;
    private final int totalTlvCount;

    @Nullable
    public static GetFileEntry readEntry(List<Tlv> tlvs, int offset) {
        int totalTlvCount;
        DefensiveTools.checkNull(tlvs, "tlvs");
        DefensiveTools.checkRange(offset, "offset", 0, tlvs.size() - 1);
        boolean gotLastmod = false;
        int lastTlv = -1;
        for (int i = offset; i < tlvs.size(); ++i) {
            Tlv tlv = tlvs.get(i);
            DefensiveTools.checkNull(tlv, "tlvs elements");
            int type = tlv.getType();
            if (type == 257) {
                if (!gotLastmod) {
                    gotLastmod = true;
                    continue;
                }
                lastTlv = i - 1;
                break;
            }
            if (type != 2313) continue;
            lastTlv = i;
            break;
        }
        if ((totalTlvCount = lastTlv == -1 ? tlvs.size() - offset : lastTlv - offset + 1) == 0) {
            return null;
        }
        ImmutableTlvChain chain = TlvTools.createChain(tlvs, offset, totalTlvCount);
        SegmentedFilename filename = null;
        String ftFilenameStr = chain.getString(1028);
        if (ftFilenameStr != null) {
            filename = SegmentedFilename.fromFTFilename(ftFilenameStr);
        }
        Tlv lastmodTlv = chain.getFirstTlv(257);
        long lastmod = -1L;
        if (lastmodTlv != null) {
            lastmod = lastmodTlv.getDataAsUInt();
        }
        Tlv filesizeTlv = chain.getFirstTlv(771);
        long filesize = -1L;
        if (filesizeTlv != null) {
            filesize = filesizeTlv.getDataAsUInt();
        }
        Tlv flagsTlv = chain.getFirstTlv(2304);
        long flags = 0L;
        if (flagsTlv != null && (flags = flagsTlv.getDataAsUInt()) == -1L) {
            flags = 0L;
        }
        return new GetFileEntry(filename, filesize, lastmod, flags, totalTlvCount);
    }

    private GetFileEntry(SegmentedFilename filename, long filesize, long lastmod, long flags, int totalTlvCount) {
        this.filename = filename;
        this.filesize = filesize;
        this.lastmod = lastmod;
        this.flags = flags;
        this.totalTlvCount = totalTlvCount;
    }

    public GetFileEntry(File file) {
        this(SegmentedFilename.fromNativeFilename(file.getName()), file);
    }

    public GetFileEntry(SegmentedFilename filename, File file) {
        this(filename, file.length(), file.lastModified() / 1000L, file.isDirectory() ? 1L : 0L);
    }

    public GetFileEntry(SegmentedFilename filename, long filesize, long lastmod, long flags) {
        DefensiveTools.checkRange(lastmod, "lastmod", -1L);
        DefensiveTools.checkRange(filesize, "filesize", -1L);
        DefensiveTools.checkRange(flags, "flags", -1L);
        long realFlags = flags == -1L ? 0L : flags;
        this.lastmod = lastmod;
        this.filesize = filesize;
        this.filename = filename;
        this.flags = realFlags;
        this.totalTlvCount = -1;
    }

    public final SegmentedFilename getFilename() {
        return this.filename;
    }

    public final long getFileSize() {
        return this.filesize;
    }

    public final long getLastmod() {
        return this.lastmod;
    }

    public final long getFlags() {
        return this.flags;
    }

    public final int getTotalTlvCount() {
        return this.totalTlvCount;
    }

    @Override
    public void write(OutputStream out) throws IOException {
        if (this.lastmod != -1L) {
            Tlv.getUIntInstance(257, this.lastmod).write(out);
        }
        if (this.filesize != -1L) {
            Tlv.getUIntInstance(771, this.filesize).write(out);
        }
        Tlv.getUShortInstance(1285, 0).write(out);
        if (this.filename != null) {
            String ftFilename = this.filename.toFTFilename();
            Tlv.getStringInstance(1028, ftFilename).write(out);
        }
        if (this.flags != 0L) {
            Tlv.getUIntInstance(2304, this.flags).write(out);
        }
        new Tlv(2313).write(out);
    }

    public String toString() {
        return "GetFileEntry: file=<" + this.filename + ">, " + (float)this.filesize / 1024.0f + " KB, last modified " + new Date(this.lastmod * 1000L) + " (flags=" + this.flags + " - " + MiscTools.getFlagFieldsString(GetFileEntry.class, this.flags, "FLAG_.*") + ")";
    }
}

