/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.ippiaccregwizz;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.text.MessageFormat;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import net.java.sip.communicator.plugin.desktoputil.TransparentPanel;
import net.java.sip.communicator.plugin.desktoputil.TrimTextField;
import net.java.sip.communicator.plugin.ippiaccregwizz.IppiAccRegWizzActivator;
import net.java.sip.communicator.plugin.sipaccregwizz.NewAccount;
import net.java.sip.communicator.plugin.sipaccregwizz.SIPAccountCreationFormService;
import net.java.sip.communicator.util.Logger;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;

public class CreateIppiAccountForm
extends TransparentPanel
implements SIPAccountCreationFormService {
    private static final long serialVersionUID = 0L;
    private static final Logger logger = Logger.getLogger(CreateIppiAccountForm.class);
    private final JTextField usernameField = new TrimTextField();
    private final JPasswordField passField = new JPasswordField();
    private final JPasswordField retypePassField = new JPasswordField();
    private final JTextField emailField = new JTextField();
    private final JTextPane errorPane = new JTextPane();
    private static final String registerLink = IppiAccRegWizzActivator.getResources().getSettingsString("plugin.ippiaccregwizz.REGISTER_LINK");

    public CreateIppiAccountForm() {
        super((LayoutManager)new BorderLayout());
        this.init();
    }

    private void init() {
        TransparentPanel mainPanel = new TransparentPanel((LayoutManager)new BorderLayout());
        mainPanel.setBorder(BorderFactory.createTitledBorder(IppiAccRegWizzActivator.getResources().getI18NString("plugin.sipaccregwizz.CREATE_ACCOUNT_TITLE")));
        TransparentPanel labelsPanel = new TransparentPanel((LayoutManager)new GridLayout(0, 1, 0, 4));
        TransparentPanel valuesPanel = new TransparentPanel((LayoutManager)new GridLayout(0, 1, 0, 4));
        JLabel usernameLabel = new JLabel(IppiAccRegWizzActivator.getResources().getI18NString("plugin.sip2sipaccregwizz.USERNAME"));
        JLabel passLabel = new JLabel(IppiAccRegWizzActivator.getResources().getI18NString("service.gui.PASSWORD"));
        JLabel retypePasswordLabel = new JLabel(IppiAccRegWizzActivator.getResources().getI18NString("plugin.sip2sipaccregwizz.RETYPE_PASSWORD"));
        JLabel emailLabel = new JLabel(IppiAccRegWizzActivator.getResources().getI18NString("plugin.sip2sipaccregwizz.EMAIL"));
        labelsPanel.add(usernameLabel);
        labelsPanel.add(passLabel);
        labelsPanel.add(retypePasswordLabel);
        labelsPanel.add(emailLabel);
        valuesPanel.add(this.usernameField);
        valuesPanel.add(this.passField);
        valuesPanel.add(this.retypePassField);
        valuesPanel.add(this.emailField);
        JLabel emailDescriptionLabel = new JLabel(IppiAccRegWizzActivator.getResources().getI18NString("plugin.sip2sipaccregwizz.EMAIL_NOTE"), 0);
        emailDescriptionLabel.setForeground(Color.GRAY);
        emailDescriptionLabel.setFont(emailDescriptionLabel.getFont().deriveFont(8));
        emailDescriptionLabel.setBorder(BorderFactory.createEmptyBorder(0, 10, 8, 10));
        this.initErrorArea();
        mainPanel.add((Component)labelsPanel, "West");
        mainPanel.add((Component)valuesPanel, "Center");
        mainPanel.add((Component)emailDescriptionLabel, "South");
        this.add((Component)mainPanel, "Center");
        JLabel infoLabel = new JLabel(IppiAccRegWizzActivator.getResources().getI18NString("plugin.ippiaccregwizz.INFO_NOTE"), 4);
        infoLabel.setCursor(new Cursor(12));
        infoLabel.setForeground(Color.GRAY);
        infoLabel.setFont(emailDescriptionLabel.getFont().deriveFont(8));
        infoLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 8, 0));
        infoLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                IppiAccRegWizzActivator.getBrowserLauncher().openURL("http://ippi.fr");
            }
        });
        this.add(infoLabel, "South");
    }

    private void initErrorArea() {
        SimpleAttributeSet attribs = new SimpleAttributeSet();
        StyleConstants.setAlignment(attribs, 2);
        StyleConstants.setFontFamily(attribs, this.errorPane.getFont().getFamily());
        StyleConstants.setForeground(attribs, Color.RED);
        this.errorPane.setParagraphAttributes(attribs, true);
        this.errorPane.setPreferredSize(new Dimension(100, 50));
        this.errorPane.setMinimumSize(new Dimension(100, 50));
        this.errorPane.setOpaque(false);
    }

    public NewAccount createAccount() {
        NewAccount newAccount;
        block9: {
            String pass2;
            String pass1 = new String(this.passField.getPassword());
            if (!pass1.equals(pass2 = new String(this.retypePassField.getPassword()))) {
                this.showErrorMessage(IppiAccRegWizzActivator.getResources().getI18NString("plugin.sipaccregwizz.NOT_SAME_PASSWORD"));
                return null;
            }
            newAccount = null;
            try {
                String registerLinkFilled = MessageFormat.format(registerLink, URLEncoder.encode(this.usernameField.getText(), "UTF-8"), URLEncoder.encode(new String(this.passField.getPassword()), "UTF-8"), URLEncoder.encode(this.emailField.getText(), "UTF-8"));
                URL url = new URL(registerLinkFilled);
                URLConnection conn = url.openConnection();
                if (!(conn instanceof HttpURLConnection)) {
                    return null;
                }
                HttpURLConnection httpConn = (HttpURLConnection)conn;
                int responseCode = httpConn.getResponseCode();
                if (responseCode == 200) {
                    String str;
                    BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                    StringBuffer stringBuffer = new StringBuffer();
                    while ((str = in.readLine()) != null) {
                        stringBuffer.append(str);
                    }
                    if (logger.isInfoEnabled()) {
                        logger.info((Object)("JSON response to create account request: " + stringBuffer.toString()));
                    }
                    newAccount = this.parseHttpResponse(stringBuffer.toString());
                }
            }
            catch (MalformedURLException e1) {
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("Failed to create URL with string: " + registerLink), (Throwable)e1);
                }
            }
            catch (IOException e1) {
                if (!logger.isInfoEnabled()) break block9;
                logger.info((Object)"Failed to open connection.", (Throwable)e1);
            }
        }
        return newAccount;
    }

    public Component getForm() {
        return this;
    }

    public void clear() {
        this.usernameField.setText("");
        this.passField.setText("");
        this.retypePassField.setText("");
        this.emailField.setText("");
        this.errorPane.setText("");
        this.remove(this.errorPane);
    }

    private NewAccount parseHttpResponse(String response) {
        NewAccount newAccount;
        block4: {
            newAccount = null;
            try {
                JSONObject jsonObject = (JSONObject)JSONValue.parseWithException((String)response);
                boolean isSuccess = (Boolean)jsonObject.get((Object)"success");
                if (isSuccess) {
                    newAccount = new NewAccount(this.usernameField.getText() + "@ippi.fr", this.passField.getPassword(), null, "ippi.fr");
                } else {
                    this.showErrorMessage((String)jsonObject.get((Object)"error_message"));
                }
            }
            catch (Throwable e1) {
                if (!logger.isInfoEnabled()) break block4;
                logger.info((Object)"Failed Json parsing.", e1);
            }
        }
        return newAccount;
    }

    private void showErrorMessage(String text) {
        this.errorPane.setText(text);
        if (this.errorPane.getParent() == null) {
            this.add(this.errorPane, "North");
        }
        SwingUtilities.getWindowAncestor((Component)((Object)this)).pack();
    }
}

