/*
 * Decompiled with CFR 0.152.
 */
package org.ice4j.stack;

import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ice4j.ResponseCollector;
import org.ice4j.StunException;
import org.ice4j.StunMessageEvent;
import org.ice4j.StunResponseEvent;
import org.ice4j.StunTimeoutEvent;
import org.ice4j.TransportAddress;
import org.ice4j.message.Request;
import org.ice4j.message.Response;
import org.ice4j.stack.StunStack;
import org.ice4j.stack.TransactionID;

public class StunClientTransaction
implements Runnable {
    private static final Logger logger = Logger.getLogger(StunClientTransaction.class.getName());
    public static final int DEFAULT_MAX_RETRANSMISSIONS = 6;
    public static final int DEFAULT_MAX_WAIT_INTERVAL = 1600;
    public static final int DEFAULT_ORIGINAL_WAIT_INTERVAL = 100;
    private static final ExecutorService retransmissionThreadPool = Executors.newCachedThreadPool(new ThreadFactory(){
        private final ThreadFactory defaultThreadFactory = Executors.defaultThreadFactory();

        @Override
        public Thread newThread(Runnable r) {
            Thread t = this.defaultThreadFactory.newThread(r);
            if (t != null) {
                t.setDaemon(true);
                String name = t.getName();
                if (name == null) {
                    name = "";
                }
                t.setName("StunClientTransaction-" + name);
            }
            return t;
        }
    });
    public int maxRetransmissions = 6;
    public int originalWaitInterval = 100;
    public int maxWaitInterval = 1600;
    private final StunStack stackCallback;
    private final Request request;
    private final TransportAddress requestDestination;
    private final TransactionID transactionID;
    private final TransportAddress localAddress;
    private final ResponseCollector responseCollector;
    private boolean cancelled = false;
    private final Lock lock = new ReentrantLock();
    private final Condition lockCondition = this.lock.newCondition();

    public StunClientTransaction(StunStack stackCallback, Request request, TransportAddress requestDestination, TransportAddress localAddress, ResponseCollector responseCollector) {
        this(stackCallback, request, requestDestination, localAddress, responseCollector, TransactionID.createNewTransactionID());
    }

    public StunClientTransaction(StunStack stackCallback, Request request, TransportAddress requestDestination, TransportAddress localAddress, ResponseCollector responseCollector, TransactionID transactionID) {
        this.stackCallback = stackCallback;
        this.request = request;
        this.localAddress = localAddress;
        this.responseCollector = responseCollector;
        this.requestDestination = requestDestination;
        this.initTransactionConfiguration();
        this.transactionID = transactionID;
        try {
            request.setTransactionID(transactionID.getBytes());
        }
        catch (StunException ex) {
            throw new IllegalArgumentException("The TransactionID class generated an invalid transaction ID");
        }
    }

    @Override
    public void run() {
        this.lock.lock();
        try {
            this.runLocked();
        }
        finally {
            this.lock.unlock();
        }
    }

    private void runLocked() {
        int retransmissionCounter = 0;
        int nextWaitInterval = this.originalWaitInterval;
        for (retransmissionCounter = 0; retransmissionCounter < this.maxRetransmissions; ++retransmissionCounter) {
            this.waitFor(nextWaitInterval);
            if (this.cancelled) {
                return;
            }
            int curWaitInterval = nextWaitInterval;
            if (nextWaitInterval < this.maxWaitInterval) {
                nextWaitInterval *= 2;
            }
            try {
                logger.fine("retrying STUN tid " + this.transactionID + " from " + this.localAddress + " to " + this.requestDestination + " waited " + curWaitInterval + " ms retrans " + (retransmissionCounter + 1) + " of " + this.maxRetransmissions);
                this.sendRequest0();
                continue;
            }
            catch (Exception ex) {
                logger.log(Level.INFO, "A client tran retransmission failed", ex);
            }
        }
        if (nextWaitInterval < this.maxWaitInterval) {
            nextWaitInterval *= 2;
        }
        this.waitFor(nextWaitInterval);
        if (this.cancelled) {
            return;
        }
        this.stackCallback.removeClientTransaction(this);
        this.responseCollector.processTimeout(new StunTimeoutEvent(this.stackCallback, this.request, this.getLocalAddress(), this.transactionID));
    }

    void sendRequest() throws IllegalArgumentException, IOException {
        logger.fine("sending STUN  tid " + this.transactionID + " from " + this.localAddress + " to " + this.requestDestination);
        this.sendRequest0();
        retransmissionThreadPool.execute(this);
    }

    private void sendRequest0() throws IllegalArgumentException, IOException {
        if (this.cancelled) {
            logger.finer("Trying to resend a cancelled transaction.");
        } else {
            this.stackCallback.getNetAccessManager().sendMessage(this.request, this.localAddress, this.requestDestination);
        }
    }

    Request getRequest() {
        return this.request;
    }

    void waitFor(long millis) {
        this.lock.lock();
        try {
            this.lockCondition.await(millis, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException ex) {
            throw new RuntimeException(ex);
        }
        finally {
            this.lock.unlock();
        }
    }

    void cancel(boolean waitForResponse) {
        this.cancelled = true;
        if (!waitForResponse && this.lock.tryLock()) {
            try {
                this.lockCondition.signal();
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    void cancel() {
        this.cancel(false);
    }

    public void handleResponse(StunMessageEvent evt) {
        this.lock.lock();
        try {
            TransactionID transactionID = this.getTransactionID();
            logger.log(Level.FINE, "handleResponse tid " + transactionID);
            if (!Boolean.getBoolean("org.ice4j.KEEP_CRANS_AFTER_A_RESPONSE")) {
                this.cancel();
            }
            this.responseCollector.processResponse(new StunResponseEvent(this.stackCallback, evt.getRawMessage(), (Response)evt.getMessage(), this.request, transactionID));
        }
        finally {
            this.lock.unlock();
        }
    }

    TransactionID getTransactionID() {
        return this.transactionID;
    }

    private void initTransactionConfiguration() {
        String maxWaitIntervalStr;
        String originalWaitIntervalStr;
        String maxRetransmissionsStr = System.getProperty("org.ice4j.MAX_RETRANSMISSIONS");
        if (maxRetransmissionsStr != null && maxRetransmissionsStr.trim().length() > 0) {
            try {
                this.maxRetransmissions = Integer.parseInt(maxRetransmissionsStr);
            }
            catch (NumberFormatException e) {
                logger.log(Level.FINE, "Failed to parse MAX_RETRANSMISSIONS", e);
                this.maxRetransmissions = 6;
            }
        }
        if ((originalWaitIntervalStr = System.getProperty("org.ice4j.FIRST_CTRAN_RETRANS_AFTER")) != null && originalWaitIntervalStr.trim().length() > 0) {
            try {
                this.originalWaitInterval = Integer.parseInt(originalWaitIntervalStr);
            }
            catch (NumberFormatException e) {
                logger.log(Level.FINE, "Failed to parse ORIGINAL_WAIT_INTERVAL", e);
                this.originalWaitInterval = 100;
            }
        }
        if ((maxWaitIntervalStr = System.getProperty("org.ice4j.MAX_CTRAN_RETRANS_TIMER")) != null && maxWaitIntervalStr.trim().length() > 0) {
            try {
                this.maxWaitInterval = Integer.parseInt(maxWaitIntervalStr);
            }
            catch (NumberFormatException e) {
                logger.log(Level.FINE, "Failed to parse MAX_WAIT_INTERVAL", e);
                this.maxWaitInterval = 1600;
            }
        }
    }

    public TransportAddress getLocalAddress() {
        return this.localAddress;
    }

    public TransportAddress getRemoteAddress() {
        return this.requestDestination;
    }
}

