/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.irc;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public enum ISupport {
    NICKLEN,
    CHANNELLEN,
    TOPICLEN,
    KICKLEN,
    AWAYLEN,
    CHANLIMIT,
    MONITOR,
    WATCH;

    private static final Pattern PATTERN_CHANLIMIT;

    public static void parseChanLimit(Map<Character, Integer> destination, String chanLimitValue) {
        if (destination == null) {
            throw new IllegalArgumentException("destination cannot be null");
        }
        if (chanLimitValue == null) {
            return;
        }
        Matcher matcher = PATTERN_CHANLIMIT.matcher(chanLimitValue);
        while (matcher.find()) {
            String chanTypes = matcher.group(1);
            String limitValue = matcher.group(2);
            Integer limit = new Integer(limitValue);
            for (char c : chanTypes.toCharArray()) {
                destination.put(Character.valueOf(c), limit);
            }
        }
    }

    static {
        PATTERN_CHANLIMIT = Pattern.compile("([#&!+]++):(\\d*+)(?:,|$)");
    }
}

