/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.irc;

import com.ircclouds.irc.api.Callback;
import com.ircclouds.irc.api.CapabilityNegotiator;
import com.ircclouds.irc.api.IRCApi;
import com.ircclouds.irc.api.IServerParameters;
import com.ircclouds.irc.api.domain.messages.ClientErrorMessage;
import com.ircclouds.irc.api.domain.messages.ErrorMessage;
import com.ircclouds.irc.api.domain.messages.QuitMessage;
import com.ircclouds.irc.api.domain.messages.ServerNotice;
import com.ircclouds.irc.api.listeners.IMessageListener;
import com.ircclouds.irc.api.listeners.VariousMessageListenerAdapter;
import com.ircclouds.irc.api.negotiators.CompositeNegotiator;
import com.ircclouds.irc.api.negotiators.capabilities.SaslCapability;
import com.ircclouds.irc.api.negotiators.capabilities.SimpleCapability;
import com.ircclouds.irc.api.state.IIRCState;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.java.sip.communicator.impl.protocol.irc.ChannelManager;
import net.java.sip.communicator.impl.protocol.irc.ClientConfig;
import net.java.sip.communicator.impl.protocol.irc.IdentityManager;
import net.java.sip.communicator.impl.protocol.irc.IrcConnectionListener;
import net.java.sip.communicator.impl.protocol.irc.IrcStack;
import net.java.sip.communicator.impl.protocol.irc.MessageManager;
import net.java.sip.communicator.impl.protocol.irc.PresenceManager;
import net.java.sip.communicator.impl.protocol.irc.ProtocolProviderServiceIrcImpl;
import net.java.sip.communicator.impl.protocol.irc.Result;
import net.java.sip.communicator.impl.protocol.irc.ServerChannelLister;
import net.java.sip.communicator.service.protocol.RegistrationState;
import net.java.sip.communicator.util.Logger;

public class IrcConnection {
    private static final Logger LOGGER = Logger.getLogger(IrcConnection.class);
    public static final Set<Character> SPECIAL_CHARACTERS;
    private final IrcStack.PersistentContext context;
    private final ClientConfig config;
    private final IRCApi irc;
    private final IIRCState connectionState;
    private final IrcConnectionListener connectionListener;
    private final PresenceManager presence;
    private final ServerChannelLister channelLister;
    private final IdentityManager identity;
    private final ChannelManager channel;
    private final MessageManager message;

    IrcConnection(IrcStack.PersistentContext context, ClientConfig config, IRCApi irc, IServerParameters params, String password, IrcConnectionListener connectionListener) throws Exception {
        if (context == null) {
            throw new IllegalArgumentException("context cannot be null");
        }
        this.context = context;
        if (config == null) {
            throw new IllegalArgumentException("client config cannot be null");
        }
        this.config = config;
        if (irc == null) {
            throw new IllegalArgumentException("irc instance cannot be null");
        }
        this.irc = irc;
        this.connectionListener = connectionListener;
        NegotiationHandler handler = new NegotiationHandler();
        CapabilityNegotiator negotiator = config.isVersion3Allowed() ? IrcConnection.determineNegotiator(params.getNickname(), password, config, handler) : null;
        this.irc.addListener((IMessageListener)new ServerListener());
        this.connectionState = IrcConnection.connectSynchronized(this.context.provider, params, this.irc, negotiator);
        this.identity = new IdentityManager(this.irc, this.connectionState, this.context.provider);
        this.message = new MessageManager(this, this.irc, this.connectionState, this.context.provider, this.identity);
        this.channel = new ChannelManager(this.irc, this.connectionState, this.context.provider, this.config, handler.awayNotify);
        this.presence = new PresenceManager(this.irc, this.connectionState, this.context.provider.getPersistentPresence(), this.config, this.context.nickWatchList);
        this.channelLister = new ServerChannelLister(this.irc, this.connectionState);
    }

    private static CapabilityNegotiator determineNegotiator(String user, String password, ClientConfig config, CompositeNegotiator.Host handler) {
        ArrayList<Object> capabilities = new ArrayList<Object>();
        capabilities.add(new SimpleCapability("away-notify"));
        capabilities.add(new SimpleCapability("multi-prefix"));
        ClientConfig.SASL sasl = config.getSASL();
        if (sasl != null) {
            capabilities.add(new SaslCapability(true, sasl.getRole(), sasl.getUser(), sasl.getPass()));
        }
        return new CompositeNegotiator(capabilities, handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IIRCState connectSynchronized(ProtocolProviderServiceIrcImpl provider, IServerParameters params, IRCApi irc, CapabilityNegotiator negotiator) throws Exception {
        Result result;
        Result result2 = result = new Result();
        synchronized (result2) {
            irc.connect(params, (Callback)new Callback<IIRCState>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onSuccess(IIRCState state) {
                    Result result2 = result;
                    synchronized (result2) {
                        LOGGER.trace((Object)"IRC connected successfully!");
                        result.setDone(state);
                        result.notifyAll();
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onFailure(Exception e) {
                    Result result2 = result;
                    synchronized (result2) {
                        LOGGER.trace((Object)"IRC connection FAILED!", (Throwable)e);
                        result.setDone(e);
                        result.notifyAll();
                    }
                }
            }, negotiator);
            provider.setCurrentRegistrationState(RegistrationState.REGISTERING, 0);
            while (!result.isDone()) {
                LOGGER.trace((Object)"Waiting for the connection to be established ...");
                result.wait();
            }
        }
        Object e = result.getException();
        if (e != null) {
            throw new IOException((Throwable)e);
        }
        IIRCState state = (IIRCState)result.getValue();
        if (state == null) {
            throw new IOException("Failed to connect to IRC server: connection state is null");
        }
        return state;
    }

    public boolean isConnected() {
        return this.connectionState != null && this.connectionState.isConnected();
    }

    public boolean isSecureConnection() {
        return this.isConnected() && this.connectionState.getServer().isSSL() != false;
    }

    void disconnect() {
        try {
            this.irc.disconnect();
        }
        catch (RuntimeException e) {
            LOGGER.debug((Object)"exception occurred while disconnecting", (Throwable)e);
        }
    }

    public IRCApi getClient() {
        return this.irc;
    }

    public PresenceManager getPresenceManager() {
        return this.presence;
    }

    public ServerChannelLister getServerChannelLister() {
        return this.channelLister;
    }

    public IdentityManager getIdentityManager() {
        return this.identity;
    }

    public ChannelManager getChannelManager() {
        return this.channel;
    }

    public MessageManager getMessageManager() {
        return this.message;
    }

    static {
        HashSet<Character> specials = new HashSet<Character>();
        specials.add(Character.valueOf('\u0000'));
        specials.add(Character.valueOf('\n'));
        specials.add(Character.valueOf('\r'));
        specials.add(Character.valueOf(' '));
        specials.add(Character.valueOf(','));
        SPECIAL_CHARACTERS = Collections.unmodifiableSet(specials);
    }

    private static class NegotiationHandler
    implements CompositeNegotiator.Host {
        private static final String AWAY_NOTIFY = "away-notify";
        private boolean awayNotify = false;

        private NegotiationHandler() {
        }

        public void acknowledge(CompositeNegotiator.Capability cap) {
            LOGGER.info((Object)("Capability " + cap.getId() + " acknowledged."));
            if (AWAY_NOTIFY.equals(cap.getId())) {
                this.awayNotify = true;
            }
        }

        public void reject(CompositeNegotiator.Capability cap) {
            LOGGER.info((Object)("Capability " + cap.getId() + " rejected."));
            if (AWAY_NOTIFY.equals(cap.getId())) {
                this.awayNotify = false;
            }
        }
    }

    private final class ServerListener
    extends VariousMessageListenerAdapter {
        private ServerListener() {
        }

        public void onServerNotice(ServerNotice msg) {
            LOGGER.debug((Object)("NOTICE: " + msg.getText()));
        }

        public void onError(ErrorMessage msg) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("SERVER ERROR: " + msg.getSource() + ": " + msg.getText()));
            }
            LOGGER.debug((Object)"Local user received ERROR message: removing server listener.");
            IrcConnection.this.irc.deleteListener((IMessageListener)this);
            if (IrcConnection.this.connectionListener != null) {
                IrcConnection.this.connectionListener.connectionInterrupted(IrcConnection.this);
            }
        }

        public void onClientError(ClientErrorMessage msg) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("CLIENT ERROR: " + msg.getException().getMessage()), (Throwable)msg.getException());
            }
            LOGGER.debug((Object)"Local user received CLIENT ERROR message: removing server listener.");
            IrcConnection.this.irc.deleteListener((IMessageListener)this);
            if (IrcConnection.this.connectionListener != null) {
                IrcConnection.this.connectionListener.connectionInterrupted(IrcConnection.this);
            }
        }

        public void onUserQuit(QuitMessage msg) {
            String user = msg.getSource().getNick();
            if (!IrcConnection.this.connectionState.getNickname().equals(user)) {
                return;
            }
            LOGGER.debug((Object)"Local user's QUIT message received: removing server listener.");
            IrcConnection.this.irc.deleteListener((IMessageListener)this);
            if (IrcConnection.this.connectionListener != null) {
                IrcConnection.this.connectionListener.connectionInterrupted(IrcConnection.this);
            }
        }
    }
}

