/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.irc;

import java.util.Date;
import java.util.EventObject;
import net.java.sip.communicator.impl.protocol.irc.IrcConnection;
import net.java.sip.communicator.impl.protocol.irc.MessageIrcImpl;
import net.java.sip.communicator.impl.protocol.irc.ProtocolProviderServiceIrcImpl;
import net.java.sip.communicator.impl.protocol.irc.exception.BadCommandException;
import net.java.sip.communicator.impl.protocol.irc.exception.BadCommandInvocationException;
import net.java.sip.communicator.impl.protocol.irc.exception.UnsupportedCommandException;
import net.java.sip.communicator.service.protocol.AbstractOperationSetBasicInstantMessaging;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.service.protocol.Message;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.OperationSetBasicInstantMessagingTransport;
import net.java.sip.communicator.service.protocol.event.MessageDeliveredEvent;
import net.java.sip.communicator.service.protocol.event.MessageReceivedEvent;
import net.java.sip.communicator.util.Logger;

public class OperationSetBasicInstantMessagingIrcImpl
extends AbstractOperationSetBasicInstantMessaging
implements OperationSetBasicInstantMessagingTransport {
    private static final Logger LOGGER = Logger.getLogger(OperationSetBasicInstantMessagingIrcImpl.class);
    private final ProtocolProviderServiceIrcImpl provider;

    public OperationSetBasicInstantMessagingIrcImpl(ProtocolProviderServiceIrcImpl provider) {
        if (provider == null) {
            throw new IllegalArgumentException("provider cannot be null");
        }
        this.provider = provider;
    }

    public MessageIrcImpl createMessage(String content, String contentType, String contentEncoding, String subject) {
        return new MessageIrcImpl(content, contentType, contentEncoding, subject);
    }

    public void sendInstantMessage(Contact to, Message original) throws IllegalStateException, IllegalArgumentException {
        if (!(original instanceof MessageIrcImpl)) {
            LOGGER.error((Object)"Invalid class of Message implementation received. Not sending message.");
            return;
        }
        IrcConnection connection = this.provider.getIrcStack().getConnection();
        if (connection == null) {
            throw new IllegalStateException("Connection is not available.");
        }
        MessageDeliveredEvent[] msgDeliveryPendingEvts = this.messageDeliveryPendingTransform(new MessageDeliveredEvent(original, to));
        if (msgDeliveryPendingEvts.length == 0) {
            LOGGER.warn((Object)"Message transformation result does not contain a single message. Nothing to send.");
            return;
        }
        try {
            for (MessageDeliveredEvent event : msgDeliveryPendingEvts) {
                if (event == null) continue;
                Message transformed = event.getSourceMessage();
                MessageIrcImpl message = this.createMessage(transformed.getContent(), transformed.getContentType(), transformed.getEncoding(), "");
                try {
                    if (!event.isMessageEncrypted() && message.isCommand()) {
                        try {
                            connection.getMessageManager().command(to, message);
                        }
                        catch (UnsupportedCommandException e) {
                            this.fireMessageDeliveryFailed((Message)message, to, 7);
                        }
                        catch (BadCommandException e) {
                            LOGGER.error((Object)"Error during command execution. This is most likely due to a bug in the implementation of the command.", (Throwable)e);
                            this.fireMessageDeliveryFailed((Message)message, to, 4);
                        }
                        catch (BadCommandInvocationException e) {
                            StringBuilder helpText = new StringBuilder();
                            if (e.getCause() != null) {
                                helpText.append(e.getCause().getMessage());
                                helpText.append('\n');
                            }
                            helpText.append(e.getHelp());
                            MessageIrcImpl helpMessage = new MessageIrcImpl(helpText.toString(), "text/plain", "UTF-8", "Command usage:");
                            MessageReceivedEvent helpEvent = new MessageReceivedEvent((Message)helpMessage, to, new Date(), 2);
                            this.fireMessageEvent((EventObject)helpEvent);
                        }
                        continue;
                    }
                    connection.getMessageManager().message(to, (Message)message);
                }
                catch (RuntimeException e) {
                    LOGGER.debug((Object)("Failed to deliver (raw) message: " + (Object)((Object)message)));
                    throw e;
                }
            }
            this.fireMessageDelivered(original, to);
        }
        catch (OperationFailedException e) {
            this.fireMessageDeliveryFailed(original, to, e.getErrorCode());
        }
        catch (RuntimeException e) {
            LOGGER.warn((Object)("Failed to deliver message: " + original), (Throwable)e);
            this.fireMessageDeliveryFailed(original, to, 2);
        }
    }

    public boolean isOfflineMessagingSupported() {
        return false;
    }

    public boolean isContentTypeSupported(String contentType) {
        return "text/html".equalsIgnoreCase(contentType);
    }

    protected void fireMessageReceived(Message message, Contact from) {
        super.fireMessageReceived(message, from);
    }

    protected void fireMessageDelivered(Message message, Contact to) {
        super.fireMessageDelivered(message, to);
    }

    protected void fireMessageDeliveryFailed(Message message, Contact to, int errorCode) {
        super.fireMessageDeliveryFailed(message, to, errorCode);
    }

    public int getMaxMessageSize(Contact contact) {
        IrcConnection connection = this.provider.getIrcStack().getConnection();
        if (connection == null) {
            throw new IllegalStateException("Connection is not available.");
        }
        return connection.getMessageManager().calculateMaximumMessageSize(contact);
    }

    public int getMaxNumberOfMessages(Contact contact) {
        return -1;
    }
}

