/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.slick.protocol.icq;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.service.protocol.ContactGroup;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.OperationSetPersistentPresence;
import net.java.sip.communicator.service.protocol.event.ContactPropertyChangeEvent;
import net.java.sip.communicator.service.protocol.event.ServerStoredGroupEvent;
import net.java.sip.communicator.service.protocol.event.ServerStoredGroupListener;
import net.java.sip.communicator.service.protocol.event.SubscriptionEvent;
import net.java.sip.communicator.service.protocol.event.SubscriptionListener;
import net.java.sip.communicator.service.protocol.event.SubscriptionMovedEvent;
import net.java.sip.communicator.slick.protocol.icq.IcqSlickFixture;
import net.java.sip.communicator.util.Logger;

public class TestOperationSetPersistentPresence
extends TestCase {
    private static final Logger logger = Logger.getLogger(TestOperationSetPersistentPresence.class);
    private IcqSlickFixture fixture = new IcqSlickFixture();
    private OperationSetPersistentPresence opSetPersPresence = null;
    private static final String testGroupName = "NewGroup";
    private static final String testGroupName2 = "Renamed";

    public TestOperationSetPersistentPresence(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(TestOperationSetPersistentPresence.class);
        suite.addTest((Test)new TestOperationSetPersistentPresence("postTestCreateGroup"));
        suite.addTest((Test)new TestOperationSetPersistentPresence("postTestRenameGroup"));
        suite.addTest((Test)new TestOperationSetPersistentPresence("postTestRemoveGroup"));
        return suite;
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.fixture.setUp();
        Map supportedOperationSets = this.fixture.provider.getSupportedOperationSets();
        if (supportedOperationSets == null || supportedOperationSets.size() < 1) {
            throw new NullPointerException("No OperationSet implementations are supported by this ICQ implementation. ");
        }
        this.opSetPersPresence = (OperationSetPersistentPresence)supportedOperationSets.get(OperationSetPersistentPresence.class.getName());
        if (this.opSetPersPresence == null) {
            throw new NullPointerException("An implementation of the ICQ service must provide an implementation of at least the one of the Presence Operation Sets");
        }
    }

    protected void tearDown() throws Exception {
        this.fixture.tearDown();
        super.tearDown();
    }

    public void testRetrievingServerStoredContactList() {
        ContactGroup rootGroup = this.opSetPersPresence.getServerStoredContactListRoot();
        logger.debug((Object)"=========== Server Stored Contact List =================");
        logger.debug((Object)("rootGroup=" + rootGroup.getGroupName() + " rootGroup.childContacts=" + rootGroup.countContacts() + "rootGroup.childGroups=" + rootGroup.countSubgroups() + "Printing rootGroupContents=\n" + rootGroup.toString()));
        Hashtable<String, List<String>> expectedContactList = IcqSlickFixture.preInstalledBuddyList;
        logger.debug((Object)"============== Expected Contact List ===================");
        logger.debug(expectedContactList);
        Iterator groups = rootGroup.subgroups();
        while (groups.hasNext()) {
            ContactGroup group = (ContactGroup)groups.next();
            List<String> expectedContactsInGroup = expectedContactList.get(group.getGroupName());
            if (!group.isPersistent()) continue;
            TestOperationSetPersistentPresence.assertNotNull((String)("Group " + group.getGroupName() + " was returned by the server but was not in the expected contact list."), expectedContactsInGroup);
            Iterator contactsIter = group.contacts();
            while (contactsIter.hasNext()) {
                String contactID = ((Contact)contactsIter.next()).getAddress();
                expectedContactsInGroup.remove(contactID);
            }
            if (expectedContactsInGroup.size() != 0) continue;
            expectedContactList.remove(group.getGroupName());
        }
        TestOperationSetPersistentPresence.assertTrue((String)("The following contacts were on the server sidec contact list, but were not returned by the pers. pres. op. set" + expectedContactList.toString()), (boolean)expectedContactList.isEmpty());
    }

    public void postTestPersistentSubscribe() throws Exception {
        logger.trace((Object)"Testing persistent subscriptions.");
        ContactGroup group = this.opSetPersPresence.getServerStoredContactListRoot().getGroup(testGroupName);
        SubscriptionEventCollector evtCollector = new SubscriptionEventCollector();
        this.opSetPersPresence.addSubscriptionListener((SubscriptionListener)evtCollector);
        this.opSetPersPresence.subscribe(group, "38687470");
        evtCollector.waitForEvent(10000L);
        this.opSetPersPresence.removeSubscriptionListener((SubscriptionListener)evtCollector);
        TestOperationSetPersistentPresence.assertEquals((String)"Number of dispatched events", (int)1, (int)evtCollector.collectedEvents.size());
        TestOperationSetPersistentPresence.assertEquals((String)"The SubscriptionEvent had a wrong event id.", (int)1, (int)((SubscriptionEvent)evtCollector.collectedEvents.get(0)).getEventID());
        TestOperationSetPersistentPresence.assertEquals((String)"The parent group in the subscription event did not match.", (Object)group, (Object)((SubscriptionEvent)evtCollector.collectedEvents.get(0)).getParentGroup());
        Contact contact = group.getContact(IcqSlickFixture.testerAgent.getIcqUIN());
        TestOperationSetPersistentPresence.assertNotNull((String)"Couldn't find contact where we created it", (Object)contact);
    }

    public void postTestPersistentUnsubscribe() throws Exception {
        logger.trace((Object)"Testing removal of persistent subscriptions.");
        ContactGroup group = this.opSetPersPresence.getServerStoredContactListRoot().getGroup(testGroupName);
        Contact contact = group.getContact(IcqSlickFixture.testerAgent.getIcqUIN());
        SubscriptionEventCollector evtCollector = new SubscriptionEventCollector();
        this.opSetPersPresence.addSubscriptionListener((SubscriptionListener)evtCollector);
        this.opSetPersPresence.unsubscribe(contact);
        evtCollector.waitForEvent(10000L);
        this.opSetPersPresence.removeSubscriptionListener((SubscriptionListener)evtCollector);
        TestOperationSetPersistentPresence.assertEquals((String)"Number of dispatched events", (int)1, (int)evtCollector.collectedEvents.size());
        TestOperationSetPersistentPresence.assertEquals((String)"The SubscriptionEvent had a wrong event id.", (int)2, (int)((SubscriptionEvent)evtCollector.collectedEvents.get(0)).getEventID());
        TestOperationSetPersistentPresence.assertEquals((String)"The parent group in the subscription event did not match.", (Object)group, (Object)((SubscriptionEvent)evtCollector.collectedEvents.get(0)).getParentGroup());
        contact = group.getContact(IcqSlickFixture.testerAgent.getIcqUIN());
        TestOperationSetPersistentPresence.assertNull((String)"A contact was still present after removing its corresponding subscription", (Object)contact);
    }

    public void postTestCreateGroup() {
        logger.trace((Object)"testing creation of server stored groups");
        GroupChangeCollector groupChangeCollector = new GroupChangeCollector();
        this.opSetPersPresence.addServerStoredGroupChangeListener((ServerStoredGroupListener)groupChangeCollector);
        try {
            this.opSetPersPresence.createServerStoredContactGroup(this.opSetPersPresence.getServerStoredContactListRoot(), testGroupName);
        }
        catch (OperationFailedException ex) {
            TestOperationSetPersistentPresence.fail((String)("Cannot create group " + ex.getMessage()));
        }
        groupChangeCollector.waitForEvent(10000L);
        this.opSetPersPresence.removeServerStoredGroupChangeListener((ServerStoredGroupListener)groupChangeCollector);
        TestOperationSetPersistentPresence.assertEquals((String)"Collected Group Change events: ", (int)1, (int)groupChangeCollector.collectedEvents.size());
        TestOperationSetPersistentPresence.assertEquals((String)"Group name.", (String)testGroupName, (String)((ServerStoredGroupEvent)groupChangeCollector.collectedEvents.get(0)).getSourceGroup().getGroupName());
        ContactGroup group = this.opSetPersPresence.getServerStoredContactListRoot().getGroup(testGroupName);
        TestOperationSetPersistentPresence.assertNotNull((String)"A newly created group was not in the contact list.", (Object)group);
        TestOperationSetPersistentPresence.assertEquals((String)"New group name", (String)testGroupName, (String)group.getGroupName());
    }

    public void postTestRemoveGroup() {
        logger.trace((Object)"testing removal of server stored groups");
        GroupChangeCollector groupChangeCollector = new GroupChangeCollector();
        this.opSetPersPresence.addServerStoredGroupChangeListener((ServerStoredGroupListener)groupChangeCollector);
        try {
            this.opSetPersPresence.removeServerStoredContactGroup(this.opSetPersPresence.getServerStoredContactListRoot().getGroup(testGroupName2));
        }
        catch (OperationFailedException ex) {
            logger.error((Object)"error removing group", (Throwable)ex);
        }
        groupChangeCollector.waitForEvent(10000L);
        this.opSetPersPresence.removeServerStoredGroupChangeListener((ServerStoredGroupListener)groupChangeCollector);
        TestOperationSetPersistentPresence.assertEquals((String)"Collected Group Change event", (int)1, (int)groupChangeCollector.collectedEvents.size());
        TestOperationSetPersistentPresence.assertEquals((String)"Group name.", (String)testGroupName2, (String)((ServerStoredGroupEvent)groupChangeCollector.collectedEvents.get(0)).getSourceGroup().getGroupName());
        ContactGroup group = this.opSetPersPresence.getServerStoredContactListRoot().getGroup(testGroupName2);
        TestOperationSetPersistentPresence.assertNull((String)"A freshly removed group was still on the contact list.", (Object)group);
    }

    public void postTestRenameGroup() {
        logger.trace((Object)"Testing renaming groups.");
        ContactGroup group = this.opSetPersPresence.getServerStoredContactListRoot().getGroup(testGroupName);
        GroupChangeCollector groupChangeCollector = new GroupChangeCollector();
        this.opSetPersPresence.addServerStoredGroupChangeListener((ServerStoredGroupListener)groupChangeCollector);
        this.opSetPersPresence.renameServerStoredContactGroup(group, testGroupName2);
        groupChangeCollector.waitForEvent(10000L);
        this.opSetPersPresence.removeServerStoredGroupChangeListener((ServerStoredGroupListener)groupChangeCollector);
        TestOperationSetPersistentPresence.assertEquals((String)"Collected Group Change event", (int)1, (int)groupChangeCollector.collectedEvents.size());
        TestOperationSetPersistentPresence.assertEquals((String)"Group name.", (String)testGroupName2, (String)((ServerStoredGroupEvent)groupChangeCollector.collectedEvents.get(0)).getSourceGroup().getGroupName());
        ContactGroup oldGroup = this.opSetPersPresence.getServerStoredContactListRoot().getGroup(testGroupName);
        TestOperationSetPersistentPresence.assertNull((String)"A group was still findable by its old name after renaming.", (Object)oldGroup);
        ContactGroup newGroup = this.opSetPersPresence.getServerStoredContactListRoot().getGroup(testGroupName2);
        TestOperationSetPersistentPresence.assertNotNull((String)"Could not find a renamed group by its new name.", (Object)newGroup);
    }

    private class SubscriptionEventCollector
    implements SubscriptionListener {
        public ArrayList<EventObject> collectedEvents = new ArrayList();

        private SubscriptionEventCollector() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitForEvent(long waitFor) {
            logger.trace((Object)"Waiting for a persistent subscription event");
            SubscriptionEventCollector subscriptionEventCollector = this;
            synchronized (subscriptionEventCollector) {
                if (this.collectedEvents.size() > 0) {
                    logger.trace((Object)("SubEvt already received. " + this.collectedEvents));
                    return;
                }
                try {
                    this.wait(waitFor);
                    if (this.collectedEvents.size() > 0) {
                        logger.trace((Object)"Received a SubEvt in provider status.");
                    } else {
                        logger.trace((Object)("No SubEvt received for " + waitFor + "ms."));
                    }
                }
                catch (InterruptedException ex) {
                    logger.debug((Object)"Interrupted while waiting for a subscription evt", (Throwable)ex);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void subscriptionCreated(SubscriptionEvent evt) {
            SubscriptionEventCollector subscriptionEventCollector = this;
            synchronized (subscriptionEventCollector) {
                logger.debug((Object)("Collected evt(" + this.collectedEvents.size() + ")= " + evt));
                this.collectedEvents.add((EventObject)evt);
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void subscriptionRemoved(SubscriptionEvent evt) {
            SubscriptionEventCollector subscriptionEventCollector = this;
            synchronized (subscriptionEventCollector) {
                logger.debug((Object)("Collected evt(" + this.collectedEvents.size() + ")= " + evt));
                this.collectedEvents.add((EventObject)evt);
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void subscriptionFailed(SubscriptionEvent evt) {
            SubscriptionEventCollector subscriptionEventCollector = this;
            synchronized (subscriptionEventCollector) {
                logger.debug((Object)("Collected evt(" + this.collectedEvents.size() + ")= " + evt));
                this.collectedEvents.add((EventObject)evt);
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void subscriptionResolved(SubscriptionEvent evt) {
            SubscriptionEventCollector subscriptionEventCollector = this;
            synchronized (subscriptionEventCollector) {
                logger.debug((Object)("Collected evt(" + this.collectedEvents.size() + ")= " + evt));
                this.collectedEvents.add((EventObject)evt);
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void subscriptionMoved(SubscriptionMovedEvent evt) {
            SubscriptionEventCollector subscriptionEventCollector = this;
            synchronized (subscriptionEventCollector) {
                logger.debug((Object)("Collected evt(" + this.collectedEvents.size() + ")= " + evt));
                this.collectedEvents.add((EventObject)evt);
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void contactModified(ContactPropertyChangeEvent evt) {
            SubscriptionEventCollector subscriptionEventCollector = this;
            synchronized (subscriptionEventCollector) {
                logger.debug((Object)("Collected evt(" + this.collectedEvents.size() + ")= " + evt));
                this.collectedEvents.add((EventObject)evt);
                this.notifyAll();
            }
        }
    }

    private class GroupChangeCollector
    implements ServerStoredGroupListener {
        public ArrayList<EventObject> collectedEvents = new ArrayList();

        private GroupChangeCollector() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitForEvent(long waitFor) {
            GroupChangeCollector groupChangeCollector = this;
            synchronized (groupChangeCollector) {
                if (this.collectedEvents.size() > 0) {
                    logger.trace((Object)("ServerStoredGroupEvent already received. " + this.collectedEvents));
                    return;
                }
                try {
                    this.wait(waitFor);
                }
                catch (InterruptedException ex) {
                    logger.debug((Object)"Interrupted while waiting for a subscription evt", (Throwable)ex);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void groupCreated(ServerStoredGroupEvent evt) {
            GroupChangeCollector groupChangeCollector = this;
            synchronized (groupChangeCollector) {
                logger.debug((Object)("Collected evt(" + this.collectedEvents.size() + ")= " + evt));
                this.collectedEvents.add((EventObject)evt);
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void groupNameChanged(ServerStoredGroupEvent evt) {
            GroupChangeCollector groupChangeCollector = this;
            synchronized (groupChangeCollector) {
                logger.debug((Object)("Collected evt(" + this.collectedEvents.size() + ")= " + evt));
                this.collectedEvents.add((EventObject)evt);
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void groupRemoved(ServerStoredGroupEvent evt) {
            GroupChangeCollector groupChangeCollector = this;
            synchronized (groupChangeCollector) {
                logger.debug((Object)("Collected evt(" + this.collectedEvents.size() + ")= " + evt));
                this.collectedEvents.add((EventObject)evt);
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void groupResolved(ServerStoredGroupEvent evt) {
            GroupChangeCollector groupChangeCollector = this;
            synchronized (groupChangeCollector) {
                logger.debug((Object)("Collected evt(" + this.collectedEvents.size() + ")= " + evt));
                this.collectedEvents.add((EventObject)evt);
                this.notifyAll();
            }
        }
    }
}

