/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.rvproto.directim;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.ImEncodedString;
import net.kano.joscar.ImEncodingParams;
import net.kano.joscar.LiveWritable;
import net.kano.joscar.MiscTools;
import org.jetbrains.annotations.Nullable;

public final class DirectImHeader
implements LiveWritable {
    public static final String DCVERSION_DEFAULT = "ODC2";
    public static final long FLAG_TYPINGPACKET = 2L;
    public static final long FLAG_TYPING = 8L;
    public static final long FLAG_TYPED = 4L;
    public static final long FLAG_CONFIRMATION = 32L;
    public static final long FLAG_CONFIRMATION_UNKNOWN = 64L;
    public static final long FLAG_AUTORESPONSE = 1L;
    private String dcVersion = null;
    private long messageId = 0L;
    private long dataLength = -1L;
    private ImEncodingParams encoding = null;
    private long flags = -1L;
    private String sn = null;
    private int headerSize = -1;

    public static DirectImHeader createTypingHeader() {
        DirectImHeader hdr = new DirectImHeader();
        hdr.setDefaults();
        hdr.setFlags(10L);
        return hdr;
    }

    public static DirectImHeader createTypedHeader() {
        DirectImHeader hdr = new DirectImHeader();
        hdr.setDefaults();
        hdr.setFlags(6L);
        return hdr;
    }

    public static DirectImHeader createTypingErasedHeader() {
        DirectImHeader hdr = new DirectImHeader();
        hdr.setDefaults();
        hdr.setFlags(2L);
        return hdr;
    }

    public static DirectImHeader createMessageHeader(ImEncodedString message) {
        return DirectImHeader.createMessageHeader(message, false);
    }

    public static DirectImHeader createMessageHeader(ImEncodedString message, boolean autoresponse) {
        DefensiveTools.checkNull(message, "message");
        DirectImHeader hdr = new DirectImHeader();
        hdr.setDefaults();
        hdr.setFlags(autoresponse ? 1L : 0L);
        hdr.setEncoding(message.getEncoding());
        hdr.setDataLength(message.getBytes().length);
        return hdr;
    }

    public DirectImHeader() {
    }

    public DirectImHeader(DirectImHeader header) {
        DefensiveTools.checkNull(header, "header");
        this.dcVersion = header.dcVersion;
        this.messageId = header.messageId;
        this.dataLength = header.dataLength;
        this.encoding = header.encoding;
        this.flags = header.flags;
        this.sn = header.sn;
    }

    @Nullable
    public static DirectImHeader readDirectIMHeader(InputStream in) throws IOException {
        DefensiveTools.checkNull(in, "in");
        byte[] miniHeader = new byte[6];
        if (!DirectImHeader.fillBuffer(miniHeader, in)) {
            return null;
        }
        ByteBlock miniHeaderBlock = ByteBlock.wrap(miniHeader);
        DirectImHeader hdr = DirectImHeader.produceInitialHeader(miniHeaderBlock);
        if (hdr == null) {
            return null;
        }
        if (!hdr.getDcVersion().equals(DCVERSION_DEFAULT)) {
            throw new IOException("Unknown DC version " + hdr.getDcVersion());
        }
        byte[] headerData = new byte[hdr.getHeaderSize() - 6];
        if (!DirectImHeader.fillBuffer(headerData, in)) {
            return null;
        }
        return DirectImHeader.readRestOfHeader(hdr, ByteBlock.wrap(headerData));
    }

    @Nullable
    private static DirectImHeader produceInitialHeader(ByteBlock miniHeaderBlock) {
        DirectImHeader hdr = new DirectImHeader();
        ByteBlock verBlock = miniHeaderBlock.subBlock(0, 4);
        hdr.setDcVersion(BinaryTools.getAsciiString(verBlock));
        int headerLen = BinaryTools.getUShort(miniHeaderBlock, 4);
        if (headerLen < 6) {
            return null;
        }
        hdr.setHeaderSize(headerLen);
        return hdr;
    }

    private static boolean fillBuffer(byte[] array, InputStream in) throws IOException {
        int i;
        int count;
        for (i = 0; i < array.length && (count = in.read(array, i, array.length - i)) != -1; i += count) {
        }
        return i == array.length;
    }

    private static DirectImHeader readRestOfHeader(DirectImHeader hdr, ByteBlock header) {
        hdr.setMessageId(BinaryTools.getLong(header, 6));
        hdr.setDataLength(BinaryTools.getUInt(header, 22));
        int charsetCode = BinaryTools.getUShort(header, 26);
        int charsetSubcode = BinaryTools.getUShort(header, 28);
        hdr.setEncoding(new ImEncodingParams(charsetCode, charsetSubcode));
        hdr.setFlags(BinaryTools.getUInt(header, 30));
        ByteBlock snBlock = header.subBlock(38, 16);
        hdr.setScreenname(BinaryTools.getNullPadded(snBlock).getString());
        return hdr;
    }

    public final synchronized String getDcVersion() {
        return this.dcVersion;
    }

    public final synchronized long getMessageId() {
        return this.messageId;
    }

    public final synchronized long getDataLength() {
        return this.dataLength;
    }

    public final synchronized ImEncodingParams getEncoding() {
        return this.encoding;
    }

    public final synchronized long getFlags() {
        return this.flags;
    }

    public final synchronized String getScreenname() {
        return this.sn;
    }

    public final synchronized int getHeaderSize() {
        return this.headerSize;
    }

    public final synchronized void setDcVersion(String dcVersion) {
        this.dcVersion = dcVersion;
    }

    public final synchronized void setMessageId(long messageId) {
        this.messageId = messageId;
    }

    public final synchronized void setDataLength(long dataLength) {
        this.dataLength = dataLength;
    }

    public final synchronized void setEncoding(ImEncodingParams encoding) {
        this.encoding = encoding;
    }

    public final synchronized void setFlags(long flags) {
        this.flags = flags;
    }

    public final synchronized void setScreenname(String sn) {
        this.sn = sn;
    }

    private synchronized void setHeaderSize(int headerSize) {
        this.headerSize = headerSize;
    }

    public final synchronized void setDefaults() {
        this.dcVersion = DCVERSION_DEFAULT;
        this.dataLength = 0L;
        this.encoding = null;
        this.flags = 0L;
        this.sn = "";
    }

    private synchronized void checkValidity() throws IllegalArgumentException {
        DefensiveTools.checkNull(this.dcVersion, "dcVersion");
        DefensiveTools.checkRange(this.dataLength, "dataLength", 0L);
        DefensiveTools.checkRange(this.flags, "flags", 0L);
        DefensiveTools.checkNull(this.sn, "sn");
    }

    public synchronized void write(OutputStream out) throws IOException, IllegalArgumentException {
        DefensiveTools.checkNull(out, "out");
        this.checkValidity();
        ByteArrayOutputStream hout = new ByteArrayOutputStream(76);
        byte[] hdrBytes = BinaryTools.getAsciiBytes(this.dcVersion);
        hout.write(hdrBytes);
        BinaryTools.writeUShort(hout, 76);
        BinaryTools.writeUShort(hout, 1);
        BinaryTools.writeUShort(hout, 6);
        BinaryTools.writeUShort(hout, 0);
        BinaryTools.writeLong(hout, this.messageId);
        hout.write(new byte[8]);
        BinaryTools.writeUInt(hout, this.dataLength);
        ImEncodingParams encoding = this.encoding;
        if (encoding != null) {
            BinaryTools.writeUShort(hout, encoding.getCharsetCode());
            BinaryTools.writeUShort(hout, encoding.getCharsetSubcode());
        } else {
            BinaryTools.writeUShort(hout, 0);
            BinaryTools.writeUShort(hout, 0);
        }
        BinaryTools.writeUInt(hout, this.flags);
        BinaryTools.writeUInt(hout, 0L);
        ByteBlock snBlock = ByteBlock.wrap(BinaryTools.getAsciiBytes(this.sn));
        BinaryTools.writeNullPadded(hout, snBlock, 16);
        hout.write(new byte[16]);
        hout.writeTo(out);
    }

    public synchronized String toString() {
        return "DirectIMHeader: msgid=" + this.messageId + ", dataLen=" + this.dataLength + ", encoding=" + this.encoding + ", flags=0x" + Long.toHexString(this.flags) + " (" + MiscTools.getFlagFieldsString(DirectImHeader.class, this.flags, "FLAG_.*") + "), sn='" + this.sn + "'" + ", headerSize=" + this.headerSize;
    }
}

