/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.codec.audio.g729;

import org.jitsi.impl.neomedia.codec.audio.g729.FloatReference;
import org.jitsi.impl.neomedia.codec.audio.g729.Gainpred;
import org.jitsi.impl.neomedia.codec.audio.g729.IntReference;
import org.jitsi.impl.neomedia.codec.audio.g729.TabLd8k;

class QuaGain {
    private final float[] past_qua_en = new float[]{-14.0f, -14.0f, -14.0f, -14.0f};

    QuaGain() {
    }

    int qua_gain(float[] code, float[] g_coeff, int l_subfr, FloatReference gain_pit, FloatReference gain_code, int tameflag) {
        float g_code;
        float FLT_MAX_G729 = 1.0E38f;
        float GP0999 = 0.9999f;
        float GPCLIP2 = 0.94f;
        int NCAN1 = 4;
        int NCAN2 = 8;
        int NCODE2 = 16;
        float[][] gbk1 = TabLd8k.gbk1;
        float[][] gbk2 = TabLd8k.gbk2;
        int[] map1 = TabLd8k.map1;
        int[] map2 = TabLd8k.map2;
        int index1 = 0;
        int index2 = 0;
        float[] best_gain = new float[2];
        float gcode0 = Gainpred.gain_predict(this.past_qua_en, code, l_subfr);
        float tmp = -1.0f / (4.0f * g_coeff[0] * g_coeff[2] - g_coeff[4] * g_coeff[4]);
        best_gain[0] = (2.0f * g_coeff[2] * g_coeff[1] - g_coeff[3] * g_coeff[4]) * tmp;
        best_gain[1] = (2.0f * g_coeff[0] * g_coeff[3] - g_coeff[1] * g_coeff[4]) * tmp;
        if (tameflag == 1 && best_gain[0] > GPCLIP2) {
            best_gain[0] = GPCLIP2;
        }
        IntReference cand1Ref = new IntReference();
        IntReference cand2Ref = new IntReference();
        this.gbk_presel(best_gain, cand1Ref, cand2Ref, gcode0);
        int cand1 = cand1Ref.value;
        int cand2 = cand2Ref.value;
        float dist_min = FLT_MAX_G729;
        if (tameflag == 1) {
            for (int i = 0; i < NCAN1; ++i) {
                for (int j = 0; j < NCAN2; ++j) {
                    float dist;
                    float g_pitch = gbk1[cand1 + i][0] + gbk2[cand2 + j][0];
                    if (!(g_pitch < GP0999) || !((dist = g_pitch * g_pitch * g_coeff[0] + g_pitch * g_coeff[1] + (g_code = gcode0 * (gbk1[cand1 + i][1] + gbk2[cand2 + j][1])) * g_code * g_coeff[2] + g_code * g_coeff[3] + g_pitch * g_code * g_coeff[4]) < dist_min)) continue;
                    dist_min = dist;
                    index1 = cand1 + i;
                    index2 = cand2 + j;
                }
            }
        } else {
            for (int i = 0; i < NCAN1; ++i) {
                for (int j = 0; j < NCAN2; ++j) {
                    float g_pitch = gbk1[cand1 + i][0] + gbk2[cand2 + j][0];
                    g_code = gcode0 * (gbk1[cand1 + i][1] + gbk2[cand2 + j][1]);
                    float dist = g_pitch * g_pitch * g_coeff[0] + g_pitch * g_coeff[1] + g_code * g_code * g_coeff[2] + g_code * g_coeff[3] + g_pitch * g_code * g_coeff[4];
                    if (!(dist < dist_min)) continue;
                    dist_min = dist;
                    index1 = cand1 + i;
                    index2 = cand2 + j;
                }
            }
        }
        gain_pit.value = gbk1[index1][0] + gbk2[index2][0];
        g_code = gbk1[index1][1] + gbk2[index2][1];
        gain_code.value = g_code * gcode0;
        Gainpred.gain_update(this.past_qua_en, g_code);
        return map1[index1] * NCODE2 + map2[index2];
    }

    private void gbk_presel(float[] best_gain, IntReference cand1, IntReference cand2, float gcode0) {
        float INV_COEF = -0.032623f;
        int NCAN1 = 4;
        int NCAN2 = 8;
        int NCODE1 = 8;
        int NCODE2 = 16;
        float[][] coef = TabLd8k.coef;
        float[] thr1 = TabLd8k.thr1;
        float[] thr2 = TabLd8k.thr2;
        int _cand1 = cand1.value;
        int _cand2 = cand2.value;
        float x = (best_gain[1] - (coef[0][0] * best_gain[0] + coef[1][1]) * gcode0) * INV_COEF;
        float y = (coef[1][0] * (-coef[0][1] + best_gain[0] * coef[0][0]) * gcode0 - coef[0][0] * best_gain[1]) * INV_COEF;
        if (gcode0 > 0.0f) {
            _cand1 = 0;
            while (y > thr1[_cand1] * gcode0 && ++_cand1 < NCODE1 - NCAN1) {
            }
            _cand2 = 0;
            while (x > thr2[_cand2] * gcode0 && ++_cand2 < NCODE2 - NCAN2) {
            }
        } else {
            _cand1 = 0;
            while (y < thr1[_cand1] * gcode0 && ++_cand1 < NCODE1 - NCAN1) {
            }
            _cand2 = 0;
            while (x < thr2[_cand2] * gcode0 && ++_cand2 < NCODE2 - NCAN2) {
            }
        }
        cand1.value = _cand1;
        cand2.value = _cand2;
    }
}

