/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.generalconfig.autoaway;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import net.java.sip.communicator.plugin.generalconfig.GeneralConfigPluginActivator;
import net.java.sip.communicator.plugin.generalconfig.autoaway.Preferences;
import net.java.sip.communicator.plugin.generalconfig.autoaway.StatusUpdateThread;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.OperationSetPresence;
import net.java.sip.communicator.service.protocol.PresenceStatus;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.service.protocol.RegistrationState;
import net.java.sip.communicator.service.protocol.event.RegistrationStateChangeEvent;
import net.java.sip.communicator.service.protocol.event.RegistrationStateChangeListener;
import net.java.sip.communicator.service.sysactivity.SystemActivityChangeListener;
import net.java.sip.communicator.service.sysactivity.SystemActivityNotificationsService;
import net.java.sip.communicator.service.sysactivity.event.SystemActivityEvent;
import net.java.sip.communicator.util.Logger;
import net.java.sip.communicator.util.ServiceUtils;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;

public class AutoAwayWatcher
implements ServiceListener,
RegistrationStateChangeListener {
    private static final Logger logger = Logger.getLogger(AutoAwayWatcher.class);
    private final Map<ProtocolProviderService, PresenceStatus> lastStates = new HashMap<ProtocolProviderService, PresenceStatus>();
    private IdleListener idleListener = null;

    public AutoAwayWatcher() {
        if (Preferences.isEnabled()) {
            this.start();
        }
        Preferences.addEnableChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (Boolean.parseBoolean((String)evt.getNewValue())) {
                    AutoAwayWatcher.this.start();
                } else {
                    AutoAwayWatcher.this.stopInner();
                }
            }
        });
        Preferences.addTimerChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                AutoAwayWatcher.this.stopInner();
                AutoAwayWatcher.this.start();
            }
        });
    }

    private void start() {
        if (this.idleListener == null) {
            this.idleListener = new IdleListener();
            SystemActivityNotificationsService systemActivityNotificationsService = this.getSystemActivityNotificationsService();
            systemActivityNotificationsService.addIdleSystemChangeListener((long)(Preferences.getTimer() * 60 * 1000), (SystemActivityChangeListener)this.idleListener);
            systemActivityNotificationsService.addSystemActivityChangeListener((SystemActivityChangeListener)this.idleListener);
            this.startListeningForNewProviders();
        }
    }

    private void startListeningForNewProviders() {
        GeneralConfigPluginActivator.bundleContext.addServiceListener((ServiceListener)this);
        ServiceReference[] protocolProviderRefs = null;
        try {
            protocolProviderRefs = GeneralConfigPluginActivator.bundleContext.getServiceReferences(ProtocolProviderService.class.getName(), null);
        }
        catch (InvalidSyntaxException ex) {
            logger.error((Object)"Error while retrieving service refs", (Throwable)ex);
            return;
        }
        if (protocolProviderRefs != null) {
            for (int i = 0; i < protocolProviderRefs.length; ++i) {
                ProtocolProviderService provider = (ProtocolProviderService)GeneralConfigPluginActivator.bundleContext.getService(protocolProviderRefs[i]);
                this.handleProviderAdded(provider);
            }
        }
    }

    private void stopListeningForNewProviders() {
        GeneralConfigPluginActivator.bundleContext.removeServiceListener((ServiceListener)this);
        ServiceReference[] protocolProviderRefs = null;
        try {
            protocolProviderRefs = GeneralConfigPluginActivator.bundleContext.getServiceReferences(ProtocolProviderService.class.getName(), null);
        }
        catch (InvalidSyntaxException ex) {
            logger.error((Object)"Error while retrieving service refs", (Throwable)ex);
            return;
        }
        if (protocolProviderRefs != null) {
            for (int i = 0; i < protocolProviderRefs.length; ++i) {
                ProtocolProviderService provider = (ProtocolProviderService)GeneralConfigPluginActivator.bundleContext.getService(protocolProviderRefs[i]);
                this.handleProviderRemoved(provider);
            }
        }
    }

    public void stop() {
        GeneralConfigPluginActivator.bundleContext.removeServiceListener((ServiceListener)this);
        this.stopInner();
    }

    private void stopInner() {
        if (this.idleListener != null) {
            SystemActivityNotificationsService systemActivityNotificationsService = this.getSystemActivityNotificationsService();
            systemActivityNotificationsService.removeIdleSystemChangeListener((SystemActivityChangeListener)this.idleListener);
            systemActivityNotificationsService.removeSystemActivityChangeListener((SystemActivityChangeListener)this.idleListener);
            this.stopListeningForNewProviders();
            this.idleListener = null;
        }
    }

    private void changeProtocolsToAway() {
        for (ProtocolProviderService protocolProvider : GeneralConfigPluginActivator.getProtocolProviders()) {
            PresenceStatus status;
            OperationSetPresence presence = (OperationSetPresence)protocolProvider.getOperationSet(OperationSetPresence.class);
            if (presence == null || (status = presence.getPresenceStatus()).getStatus() < 50) continue;
            PresenceStatus newStatus = StatusUpdateThread.findAwayStatus(presence);
            try {
                if (newStatus == null || status.equals((Object)newStatus)) continue;
                this.addProviderToLastStates(protocolProvider, status);
                presence.publishPresenceStatus(newStatus, newStatus.getStatusName());
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalStateException illegalStateException) {
            }
            catch (OperationFailedException operationFailedException) {
                // empty catch block
            }
        }
    }

    private void changeProtocolsToPreviousState() {
        for (ProtocolProviderService protocolProvider : GeneralConfigPluginActivator.getProtocolProviders()) {
            PresenceStatus lastState = this.lastStates.get(protocolProvider);
            if (lastState == null) continue;
            OperationSetPresence presence = (OperationSetPresence)protocolProvider.getOperationSet(OperationSetPresence.class);
            try {
                presence.publishPresenceStatus(lastState, "");
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalStateException illegalStateException) {
            }
            catch (OperationFailedException operationFailedException) {
                // empty catch block
            }
            this.removeProviderFromLastStates(protocolProvider);
        }
    }

    private SystemActivityNotificationsService getSystemActivityNotificationsService() {
        return (SystemActivityNotificationsService)ServiceUtils.getService((BundleContext)GeneralConfigPluginActivator.bundleContext, SystemActivityNotificationsService.class);
    }

    public void serviceChanged(ServiceEvent serviceEvent) {
        Object service = GeneralConfigPluginActivator.bundleContext.getService(serviceEvent.getServiceReference());
        if (service instanceof ProtocolProviderService) {
            int serviceEventType = serviceEvent.getType();
            if (serviceEventType == 1) {
                this.handleProviderAdded((ProtocolProviderService)service);
            } else if (serviceEventType == 4) {
                this.handleProviderRemoved((ProtocolProviderService)service);
            }
        }
    }

    private synchronized void handleProviderAdded(ProtocolProviderService provider) {
        provider.addRegistrationStateChangeListener((RegistrationStateChangeListener)this);
    }

    private void handleProviderRemoved(ProtocolProviderService provider) {
        provider.removeRegistrationStateChangeListener((RegistrationStateChangeListener)this);
    }

    private synchronized void removeProviderFromLastStates(ProtocolProviderService provider) {
        this.lastStates.remove(provider);
    }

    private synchronized void addProviderToLastStates(ProtocolProviderService provider, PresenceStatus status) {
        if (this.lastStates.size() == 0) {
            this.start();
        }
        this.lastStates.put(provider, status);
    }

    public void registrationStateChanged(RegistrationStateChangeEvent evt) {
        if (evt.getSource() instanceof ProtocolProviderService) {
            if (evt.getNewState().equals((Object)RegistrationState.UNREGISTERED) || evt.getNewState().equals((Object)RegistrationState.CONNECTION_FAILED)) {
                this.removeProviderFromLastStates(evt.getProvider());
            } else if (evt.getNewState().equals((Object)RegistrationState.REGISTERED)) {
                if (this.lastStates.size() == 0) {
                    this.start();
                } else if (this.getSystemActivityNotificationsService().getTimeSinceLastInput() > (long)(Preferences.getTimer() * 60 * 1000)) {
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                Thread.sleep(1000L);
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                            AutoAwayWatcher.this.changeProtocolsToAway();
                        }
                    }).start();
                }
            }
        }
    }

    private class IdleListener
    implements SystemActivityChangeListener {
        private IdleListener() {
        }

        public void activityChanged(SystemActivityEvent event) {
            switch (event.getEventID()) {
                case 2: 
                case 4: 
                case 7: 
                case 10: {
                    AutoAwayWatcher.this.changeProtocolsToAway();
                    break;
                }
                case 3: 
                case 6: 
                case 8: 
                case 11: {
                    AutoAwayWatcher.this.changeProtocolsToPreviousState();
                }
            }
        }
    }
}

