/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.spellcheck;

import java.text.BreakIterator;

class Word {
    private static final BreakIterator WORD_ITR = BreakIterator.getWordInstance();
    private final int start;
    private final String text;
    private final int end;

    public static synchronized Word getWord(String text, int index, boolean before) {
        int end;
        int start;
        WORD_ITR.setText(text);
        if (before) {
            start = WORD_ITR.preceding(index);
            end = WORD_ITR.next();
            if (start == -1) {
                start = 0;
            }
        } else {
            end = WORD_ITR.following(index);
            start = WORD_ITR.previous();
            if (end == -1) {
                end = text.length() - 1;
            }
        }
        return new Word(start, end, text.substring(start, end));
    }

    private Word(int start, int end, String text) {
        this.start = start;
        this.end = end;
        this.text = text;
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public String getText() {
        return this.text;
    }

    public String toString() {
        return this.text;
    }
}

