/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.launcher;

import com.apple.eio.FileManager;

public class BrowserLauncher {
    public void openURL(String url) {
        new LaunchBrowser(url).start();
    }

    private static class LaunchBrowser
    extends Thread {
        private final String url;

        public LaunchBrowser(String url) {
            this.url = url;
        }

        @Override
        public void run() {
            try {
                String osName = System.getProperty("os.name");
                if (osName != null && osName.startsWith("Mac")) {
                    FileManager.openURL((String)this.url);
                } else if (osName != null && osName.startsWith("Windows")) {
                    Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + this.url);
                } else {
                    String[] browsers = new String[]{"firefox", "iceweasel", "opera", "konqueror", "epiphany", "mozilla", "netscape"};
                    String browser = null;
                    for (int i = 0; i < browsers.length && browser == null; ++i) {
                        if (Runtime.getRuntime().exec(new String[]{"which", browsers[i]}).waitFor() != 0) continue;
                        browser = browsers[i];
                    }
                    if (browser == null) {
                        throw new Exception("Could not find web browser");
                    }
                    Runtime.getRuntime().exec(new String[]{browser, this.url});
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

