/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.otr;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.java.sip.communicator.plugin.otr.OtrActivator;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.service.protocol.ContactResource;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.util.Logger;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;

public class OtrContactManager
implements ServiceListener {
    private final Logger logger = Logger.getLogger(OtrContactManager.class);
    private static final Map<Contact, List<OtrContact>> contactsMap = new ConcurrentHashMap<Contact, List<OtrContact>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OtrContact getOtrContact(Contact contact, ContactResource resource) {
        if (contact == null) {
            return null;
        }
        List<OtrContact> otrContactsList = contactsMap.get(contact);
        if (otrContactsList != null) {
            for (OtrContact otrContact : otrContactsList) {
                if (resource == null || !resource.equals((Object)otrContact.resource)) continue;
                return otrContact;
            }
            OtrContact otrContact = new OtrContact(contact, resource);
            List<OtrContact> list = otrContactsList;
            synchronized (list) {
                while (!otrContactsList.contains(otrContact)) {
                    otrContactsList.add(otrContact);
                }
            }
            return otrContact;
        }
        Map<Contact, List<OtrContact>> map = contactsMap;
        synchronized (map) {
            while (!contactsMap.containsKey(contact)) {
                otrContactsList = new ArrayList<OtrContact>();
                contactsMap.put(contact, otrContactsList);
            }
        }
        return OtrContactManager.getOtrContact(contact, resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serviceChanged(ServiceEvent event) {
        Object service = OtrActivator.bundleContext.getService(event.getServiceReference());
        if (!(service instanceof ProtocolProviderService)) {
            return;
        }
        if (event.getType() == 4) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Unregistering a ProtocolProviderService, cleaning OTR's Contact to OtrContact map");
            }
            ProtocolProviderService provider = (ProtocolProviderService)service;
            Map<Contact, List<OtrContact>> map = contactsMap;
            synchronized (map) {
                Iterator<Contact> i = contactsMap.keySet().iterator();
                while (i.hasNext()) {
                    if (!provider.equals(i.next().getProtocolProvider())) continue;
                    i.remove();
                }
            }
        }
    }

    public static class OtrContact {
        public final Contact contact;
        public final ContactResource resource;

        private OtrContact(Contact contact, ContactResource resource) {
            this.contact = contact;
            this.resource = resource;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof OtrContact)) {
                return false;
            }
            OtrContact other = (OtrContact)obj;
            if (this.contact != null && this.contact.equals(other.contact)) {
                if (this.resource != null && this.resource.equals((Object)other.resource)) {
                    return true;
                }
                return this.resource == null && other.resource == null;
            }
            return false;
        }

        public int hashCode() {
            int result = 17;
            result = 31 * result + (this.contact == null ? 0 : this.contact.hashCode());
            result = 31 * result + (this.resource == null ? 0 : this.resource.hashCode());
            return result;
        }
    }
}

