/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.jabber.extensions.colibri;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.java.sip.communicator.impl.protocol.jabber.extensions.colibri.ColibriConferenceIQ;
import net.java.sip.communicator.impl.protocol.jabber.extensions.colibri.RTPLevelRelayType;
import net.java.sip.communicator.impl.protocol.jabber.extensions.colibri.SimulcastMode;
import net.java.sip.communicator.impl.protocol.jabber.extensions.colibri.SourcePacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.ContentPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.IceUdpTransportPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.PayloadTypePacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.RTPHdrExtPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.RtpDescriptionPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.SourceGroupPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.jinglesdp.JingleUtils;
import net.java.sip.communicator.util.Logger;
import org.jitsi.service.neomedia.MediaType;
import org.jitsi.util.StringUtils;
import org.jivesoftware.smack.packet.IQ;

public class ColibriBuilder {
    private static final Logger logger = Logger.getLogger(ColibriBuilder.class);
    private final ColibriConferenceIQ conferenceState;
    private RequestType requestType = RequestType.UNDEFINED;
    private ColibriConferenceIQ request;
    private boolean hasAnyChannelsToExpire = false;
    private Integer channelLastN;
    private Boolean adaptiveLastN;
    private Boolean adaptiveSimulcast;
    private SimulcastMode simulcastMode;
    private Integer audioPacketDelay;
    private RTPLevelRelayType rtpLevelRelayType;

    public ColibriBuilder(ColibriConferenceIQ conferenceState) {
        this.conferenceState = conferenceState;
        this.reset();
    }

    public void reset() {
        this.requestType = RequestType.UNDEFINED;
        this.request = new ColibriConferenceIQ();
        this.request.setID(this.conferenceState.getID());
        this.request.setName(this.conferenceState.getName());
    }

    public boolean addAllocateChannelsReq(boolean useBundle, String endpointName, boolean peerIsInitiator, List<ContentPacketExtension> contents) {
        Objects.requireNonNull(endpointName, "endpointName");
        Objects.requireNonNull(contents, "contents");
        this.assertRequestType(RequestType.ALLOCATE_CHANNELS);
        this.request.setType(IQ.Type.GET);
        boolean hasAnyChanges = false;
        for (ContentPacketExtension cpe : contents) {
            MediaType mediaType = JingleUtils.getMediaType(cpe);
            String contentName = mediaType.toString();
            ColibriConferenceIQ.Content contentRequest = this.request.getOrCreateContent(contentName);
            ColibriConferenceIQ.ChannelCommon remoteChannelRequest = mediaType != MediaType.DATA ? new ColibriConferenceIQ.Channel() : new ColibriConferenceIQ.SctpConnection();
            remoteChannelRequest.setEndpoint(endpointName);
            remoteChannelRequest.setInitiator(peerIsInitiator);
            if (useBundle) {
                remoteChannelRequest.setChannelBundleId(endpointName);
            }
            if (remoteChannelRequest instanceof ColibriConferenceIQ.Channel) {
                RtpDescriptionPacketExtension rdpe = cpe.getFirstChildOfType(RtpDescriptionPacketExtension.class);
                ColibriConferenceIQ.Channel remoteRtpChannelRequest = (ColibriConferenceIQ.Channel)remoteChannelRequest;
                for (PayloadTypePacketExtension ptpe : rdpe.getPayloadTypes()) {
                    remoteRtpChannelRequest.addPayloadType(ptpe);
                }
                for (RTPHdrExtPacketExtension ext : rdpe.getExtmapList()) {
                    remoteRtpChannelRequest.addRtpHeaderExtension(ext);
                }
                remoteRtpChannelRequest.setLastN(this.channelLastN);
                remoteRtpChannelRequest.setAdaptiveLastN(this.adaptiveLastN);
                remoteRtpChannelRequest.setAdaptiveSimulcast(this.adaptiveSimulcast);
                remoteRtpChannelRequest.setSimulcastMode(this.simulcastMode);
                if (MediaType.AUDIO.equals((Object)mediaType)) {
                    remoteRtpChannelRequest.setPacketDelay(this.audioPacketDelay);
                    remoteRtpChannelRequest.setRTPLevelRelayType(this.rtpLevelRelayType);
                }
            }
            if (!useBundle) {
                this.copyTransportOnChannel(cpe, remoteChannelRequest);
            }
            if (remoteChannelRequest instanceof ColibriConferenceIQ.Channel) {
                hasAnyChanges = true;
                contentRequest.addChannel((ColibriConferenceIQ.Channel)remoteChannelRequest);
                continue;
            }
            hasAnyChanges = true;
            contentRequest.addSctpConnection((ColibriConferenceIQ.SctpConnection)remoteChannelRequest);
        }
        if (useBundle && contents.size() >= 1) {
            ColibriConferenceIQ.ChannelBundle bundle = new ColibriConferenceIQ.ChannelBundle(endpointName);
            ContentPacketExtension firstContent = contents.get(0);
            IceUdpTransportPacketExtension transport = firstContent.getFirstChildOfType(IceUdpTransportPacketExtension.class);
            if (transport != null) {
                hasAnyChanges = true;
                bundle.setTransport(IceUdpTransportPacketExtension.cloneTransportAndCandidates(transport, true));
            }
            this.request.addChannelBundle(bundle);
        }
        return hasAnyChanges;
    }

    public boolean addBundleTransportUpdateReq(IceUdpTransportPacketExtension transport, ColibriConferenceIQ localChannelsInfo) throws IllegalArgumentException {
        ColibriConferenceIQ.ChannelBundle localBundle;
        Objects.requireNonNull(transport, "transport");
        Objects.requireNonNull(localChannelsInfo, "localChannelsInfo");
        if (this.conferenceState == null || StringUtils.isNullOrEmpty((String)this.conferenceState.getID())) {
            return false;
        }
        this.assertRequestType(RequestType.CHANNEL_INFO_UPDATE);
        this.request.setType(IQ.Type.SET);
        if (localChannelsInfo.getChannelBundles().size() > 0) {
            localBundle = localChannelsInfo.getChannelBundles().get(0);
            if (localChannelsInfo.getChannelBundles().size() > 1) {
                logger.error((Object)"More than one bundle in local channels info !");
            }
        } else {
            throw new IllegalArgumentException("Expected ChannelBundle as not found");
        }
        ColibriConferenceIQ.ChannelBundle bundleUpdate = new ColibriConferenceIQ.ChannelBundle(localBundle.getId());
        IceUdpTransportPacketExtension transportUpdate = IceUdpTransportPacketExtension.cloneTransportAndCandidates(transport, true);
        bundleUpdate.setTransport(transportUpdate);
        this.request.addChannelBundle(bundleUpdate);
        return true;
    }

    public boolean addExpireChannelsReq(ColibriConferenceIQ channelInfo) {
        ColibriConferenceIQ.Content stateContent;
        Objects.requireNonNull(channelInfo, "channelInfo");
        if (this.conferenceState == null || StringUtils.isNullOrEmpty((String)this.conferenceState.getID())) {
            return false;
        }
        this.assertRequestType(RequestType.EXPIRE_CHANNELS);
        this.request.setType(IQ.Type.SET);
        for (ColibriConferenceIQ.Content expiredContent : channelInfo.getContents()) {
            stateContent = this.conferenceState.getContent(expiredContent.getName());
            if (stateContent == null) continue;
            ColibriConferenceIQ.Content requestContent = this.request.getOrCreateContent(stateContent.getName());
            for (ColibriConferenceIQ.Channel expiredChannel : expiredContent.getChannels()) {
                ColibriConferenceIQ.Channel stateChannel = stateContent.getChannel(expiredChannel.getID());
                if (stateChannel == null) continue;
                ColibriConferenceIQ.Channel channelRequest = new ColibriConferenceIQ.Channel();
                channelRequest.setExpire(0);
                channelRequest.setID(stateChannel.getID());
                requestContent.addChannel(channelRequest);
                this.hasAnyChannelsToExpire = true;
            }
            for (ColibriConferenceIQ.SctpConnection expiredConn : expiredContent.getSctpConnections()) {
                ColibriConferenceIQ.SctpConnection stateConn = stateContent.getSctpConnection(expiredConn.getID());
                if (stateConn == null) continue;
                ColibriConferenceIQ.SctpConnection connRequest = new ColibriConferenceIQ.SctpConnection();
                connRequest.setID(stateConn.getID());
                connRequest.setExpire(0);
                connRequest.setEndpoint(stateConn.getEndpoint());
                requestContent.addSctpConnection(connRequest);
                this.hasAnyChannelsToExpire = true;
            }
        }
        for (ColibriConferenceIQ.Content requestContent : this.request.getContents()) {
            stateContent = this.conferenceState.getContent(requestContent.getName());
            for (ColibriConferenceIQ.Channel requestChannel : requestContent.getChannels()) {
                ColibriConferenceIQ.Channel stateChannel = stateContent.getChannel(requestChannel.getID());
                stateContent.removeChannel(stateChannel);
            }
            for (ColibriConferenceIQ.SctpConnection requestConn : requestContent.getSctpConnections()) {
                ColibriConferenceIQ.SctpConnection stateConn = stateContent.getSctpConnection(requestConn.getID());
                stateContent.removeSctpConnection(stateConn);
            }
        }
        return this.hasAnyChannelsToExpire;
    }

    public boolean addRtpDescription(Map<String, RtpDescriptionPacketExtension> map, ColibriConferenceIQ localChannelsInfo) {
        Objects.requireNonNull(map, "map");
        Objects.requireNonNull(localChannelsInfo, "localChannelsInfo");
        if (this.conferenceState == null || StringUtils.isNullOrEmpty((String)this.conferenceState.getID())) {
            return false;
        }
        this.assertRequestType(RequestType.CHANNEL_INFO_UPDATE);
        this.request.setType(IQ.Type.SET);
        boolean anyUpdates = false;
        for (Map.Entry<String, RtpDescriptionPacketExtension> e : map.entrySet()) {
            List<PayloadTypePacketExtension> pts;
            RtpDescriptionPacketExtension rtpPE;
            String contentName = e.getKey();
            ColibriConferenceIQ.ChannelCommon channel = this.getColibriChannel(localChannelsInfo, contentName);
            if (channel == null || !(channel instanceof ColibriConferenceIQ.Channel) || (rtpPE = e.getValue()) == null || (pts = rtpPE.getPayloadTypes()) == null || pts.isEmpty()) continue;
            anyUpdates = true;
            ColibriConferenceIQ.Channel channelRequest = (ColibriConferenceIQ.Channel)this.getRequestChannel(this.request.getOrCreateContent(contentName), channel);
            if (channelRequest == null) {
                channelRequest = new ColibriConferenceIQ.Channel();
                channelRequest.setID(channel.getID());
            }
            for (PayloadTypePacketExtension ptPE : pts) {
                channelRequest.addPayloadType(ptPE);
            }
        }
        return anyUpdates;
    }

    public boolean addSSSRCInfo(Map<String, List<SourcePacketExtension>> ssrcMap, ColibriConferenceIQ localChannelsInfo) {
        Objects.requireNonNull(ssrcMap, "ssrcMap");
        Objects.requireNonNull(localChannelsInfo, "localChannelsInfo");
        if (this.conferenceState == null || StringUtils.isNullOrEmpty((String)this.conferenceState.getID())) {
            return false;
        }
        this.assertRequestType(RequestType.CHANNEL_INFO_UPDATE);
        this.request.setType(IQ.Type.SET);
        boolean anyUpdates = false;
        for (String contentName : ssrcMap.keySet()) {
            ColibriConferenceIQ.Channel rtpChanel = this.getRtpChannel(localChannelsInfo, contentName);
            if (rtpChanel == null) continue;
            anyUpdates = true;
            ColibriConferenceIQ.Channel reqChannel = (ColibriConferenceIQ.Channel)this.getRequestChannel(this.request.getOrCreateContent(contentName), rtpChanel);
            for (SourcePacketExtension ssrc : ssrcMap.get(contentName)) {
                reqChannel.addSource(ssrc.copy());
            }
            if (reqChannel.getSources() != null && !reqChannel.getSources().isEmpty()) continue;
            SourcePacketExtension emptySource = new SourcePacketExtension();
            emptySource.setSSRC(-1L);
            reqChannel.addSource(emptySource);
        }
        return anyUpdates;
    }

    public boolean addSSSRCGroupsInfo(Map<String, List<SourceGroupPacketExtension>> ssrcGroupMap, ColibriConferenceIQ localChannelsInfo) {
        Objects.requireNonNull(ssrcGroupMap, "ssrcGroupMap");
        Objects.requireNonNull(localChannelsInfo, "localChannelsInfo");
        if (this.conferenceState == null || StringUtils.isNullOrEmpty((String)this.conferenceState.getID())) {
            return false;
        }
        this.assertRequestType(RequestType.CHANNEL_INFO_UPDATE);
        this.request.setType(IQ.Type.SET);
        boolean anyUpdates = false;
        for (String contentName : ssrcGroupMap.keySet()) {
            ColibriConferenceIQ.Channel rtpChannel = this.getRtpChannel(localChannelsInfo, contentName);
            if (rtpChannel == null) continue;
            List<SourceGroupPacketExtension> groups = ssrcGroupMap.get(contentName);
            ColibriConferenceIQ.Channel reqChannel = (ColibriConferenceIQ.Channel)this.getRequestChannel(this.request.getOrCreateContent(contentName), rtpChannel);
            if (groups.isEmpty() && "video".equalsIgnoreCase(contentName)) {
                anyUpdates = true;
                reqChannel.addSourceGroup(SourceGroupPacketExtension.createSimulcastGroup());
            }
            for (SourceGroupPacketExtension group : groups) {
                anyUpdates = true;
                reqChannel.addSourceGroup(group);
            }
        }
        return anyUpdates;
    }

    public boolean addTransportUpdateReq(Map<String, IceUdpTransportPacketExtension> map, ColibriConferenceIQ localChannelsInfo) {
        Objects.requireNonNull(map, "map");
        Objects.requireNonNull(localChannelsInfo, "localChannelsInfo");
        if (this.conferenceState == null || StringUtils.isNullOrEmpty((String)this.conferenceState.getID())) {
            return false;
        }
        boolean hasAnyChanges = false;
        this.assertRequestType(RequestType.CHANNEL_INFO_UPDATE);
        this.request.setType(IQ.Type.SET);
        for (Map.Entry<String, IceUdpTransportPacketExtension> e : map.entrySet()) {
            String contentName = e.getKey();
            ColibriConferenceIQ.ChannelCommon channel = this.getColibriChannel(localChannelsInfo, contentName);
            if (channel == null) continue;
            IceUdpTransportPacketExtension transport = IceUdpTransportPacketExtension.cloneTransportAndCandidates(e.getValue(), true);
            ColibriConferenceIQ.ChannelCommon channelRequest = channel instanceof ColibriConferenceIQ.Channel ? new ColibriConferenceIQ.Channel() : new ColibriConferenceIQ.SctpConnection();
            channelRequest.setID(channel.getID());
            channelRequest.setEndpoint(channel.getEndpoint());
            channelRequest.setTransport(transport);
            this.request.getOrCreateContent(contentName).addChannelCommon(channelRequest);
            hasAnyChanges = true;
        }
        return hasAnyChanges;
    }

    private ColibriConferenceIQ.ChannelCommon getColibriChannel(ColibriConferenceIQ localChannels, String contentName) {
        ColibriConferenceIQ.Content content = localChannels.getContent(contentName);
        if (content == null) {
            return null;
        }
        if (content.getChannelCount() > 0) {
            return content.getChannel(0);
        }
        if (content.getSctpConnections().size() > 0) {
            return content.getSctpConnections().get(0);
        }
        return null;
    }

    public ColibriConferenceIQ getRequest(String videobridge) {
        if (StringUtils.isNullOrEmpty((String)videobridge)) {
            throw new NullPointerException("videobridge");
        }
        this.request.setTo(videobridge);
        if (this.requestType == RequestType.EXPIRE_CHANNELS) {
            if (!this.hasAnyChannelsToExpire) {
                return null;
            }
            this.hasAnyChannelsToExpire = false;
        }
        return this.request;
    }

    public RequestType getRequestType() {
        return this.requestType;
    }

    private void assertRequestType(RequestType currentReqType) {
        if (this.requestType == RequestType.UNDEFINED) {
            this.requestType = currentReqType;
        }
        if (this.requestType != currentReqType) {
            throw new IllegalStateException("Current request type");
        }
    }

    private void copyTransportOnChannel(ContentPacketExtension content, ColibriConferenceIQ.ChannelCommon remoteChannelRequest) {
        IceUdpTransportPacketExtension iceUdpTransportPacketExtension = content.getFirstChildOfType(IceUdpTransportPacketExtension.class);
        IceUdpTransportPacketExtension iceUdpCopy = IceUdpTransportPacketExtension.cloneTransportAndCandidates(iceUdpTransportPacketExtension, true);
        remoteChannelRequest.setTransport(iceUdpCopy);
    }

    public boolean hasAnyChannelsToExpire() {
        return this.hasAnyChannelsToExpire;
    }

    public Integer getChannelLastN() {
        return this.channelLastN;
    }

    public void setChannelLastN(Integer channelLastN) {
        this.channelLastN = channelLastN;
    }

    public Boolean getAdaptiveLastN() {
        return this.adaptiveLastN;
    }

    public void setAdaptiveLastN(Boolean adaptiveLastN) {
        this.adaptiveLastN = adaptiveLastN;
    }

    public Boolean getAdaptiveSimulcast() {
        return this.adaptiveSimulcast;
    }

    public void setAdaptiveSimulcast(Boolean adaptiveSimulcast) {
        this.adaptiveSimulcast = adaptiveSimulcast;
    }

    public Integer getAudioPacketDelay() {
        return this.audioPacketDelay;
    }

    public void setAudioPacketDelay(Integer audioPacketDelay) {
        this.audioPacketDelay = audioPacketDelay;
    }

    public void setSimulcastMode(SimulcastMode simulcastMode) {
        this.simulcastMode = simulcastMode;
    }

    private ColibriConferenceIQ.ChannelCommon getRequestChannel(ColibriConferenceIQ.Content requestContent, ColibriConferenceIQ.ChannelCommon localChannelInfo) {
        ColibriConferenceIQ.ChannelCommon reqChannel = requestContent.getChannel(localChannelInfo.getID());
        if (reqChannel == null) {
            if (localChannelInfo instanceof ColibriConferenceIQ.Channel) {
                reqChannel = new ColibriConferenceIQ.Channel();
            } else if (localChannelInfo instanceof ColibriConferenceIQ.SctpConnection) {
                reqChannel = new ColibriConferenceIQ.SctpConnection();
            } else {
                throw new RuntimeException("Unsupported ChannelCommon class: " + localChannelInfo.getClass());
            }
            reqChannel.setID(localChannelInfo.getID());
            requestContent.addChannelCommon(reqChannel);
        }
        return reqChannel;
    }

    private ColibriConferenceIQ.Channel getRtpChannel(ColibriConferenceIQ localChannelsInfo, String contentName) {
        ColibriConferenceIQ.Content content = localChannelsInfo.getContent(contentName);
        if (content == null) {
            return null;
        }
        return content.getChannelCount() > 0 ? content.getChannel(0) : null;
    }

    public void setRTPLevelRelayType(RTPLevelRelayType rtpLevelRelayType) {
        this.rtpLevelRelayType = rtpLevelRelayType;
    }

    public void setRTPLevelRelayType(String rtpLevelRelayType) {
        this.setRTPLevelRelayType(RTPLevelRelayType.parseRTPLevelRelayType(rtpLevelRelayType));
    }

    public static enum RequestType {
        ALLOCATE_CHANNELS,
        CHANNEL_INFO_UPDATE,
        EXPIRE_CHANNELS,
        UNDEFINED;

    }
}

