/*
 * Decompiled with CFR 0.152.
 */
package JLex;

import JLex.CUtility;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;

class CInput {
    private BufferedReader m_input;
    boolean m_eof_reached;
    boolean m_pushback_line;
    char[] m_line;
    int m_line_read;
    int m_line_index;
    int m_line_number;
    static final boolean EOF = true;
    static final boolean NOT_EOF = false;

    CInput(Reader reader) {
        CUtility.ASSERT(null != reader);
        this.m_input = new BufferedReader(reader);
        this.m_line = null;
        this.m_line_read = 0;
        this.m_line_index = 0;
        this.m_eof_reached = false;
        this.m_line_number = 0;
        this.m_pushback_line = false;
    }

    boolean getLine() throws IOException {
        int n;
        if (this.m_eof_reached) {
            return true;
        }
        if (this.m_pushback_line) {
            this.m_pushback_line = false;
            for (n = 0; n < this.m_line_read && CUtility.isspace(this.m_line[n]); ++n) {
            }
            if (n < this.m_line_read) {
                this.m_line_index = 0;
                return false;
            }
        }
        do {
            String string;
            if (null == (string = this.m_input.readLine())) {
                this.m_eof_reached = true;
                this.m_line_index = 0;
                return true;
            }
            this.m_line = (string + "\n").toCharArray();
            this.m_line_read = this.m_line.length;
            ++this.m_line_number;
            n = 0;
            while (CUtility.isspace(this.m_line[n]) && ++n != this.m_line_read) {
            }
        } while (n >= this.m_line_read);
        this.m_line_index = 0;
        return false;
    }
}

