/*
 * Decompiled with CFR 0.152.
 */
package javax.jmdns.impl;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jmdns.ServiceEvent;
import javax.jmdns.ServiceInfo;
import javax.jmdns.impl.DNSEntry;
import javax.jmdns.impl.DNSIncoming;
import javax.jmdns.impl.DNSOutgoing;
import javax.jmdns.impl.JmDNSImpl;
import javax.jmdns.impl.ServiceEventImpl;
import javax.jmdns.impl.ServiceInfoImpl;
import javax.jmdns.impl.constants.DNSRecordClass;
import javax.jmdns.impl.constants.DNSRecordType;

public abstract class DNSRecord
extends DNSEntry {
    private static Logger logger = Logger.getLogger(DNSRecord.class.getName());
    private int _ttl;
    private long _created;
    private InetAddress _source;
    public static final byte[] EMPTY_TXT = new byte[]{0};

    DNSRecord(String string, DNSRecordType dNSRecordType, DNSRecordClass dNSRecordClass, boolean bl, int n) {
        super(string, dNSRecordType, dNSRecordClass, bl);
        this._ttl = n;
        this._created = System.currentTimeMillis();
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof DNSRecord && super.equals(object) && this.sameValue((DNSRecord)object);
    }

    abstract boolean sameValue(DNSRecord var1);

    boolean sameType(DNSRecord dNSRecord) {
        return this.getRecordType() == dNSRecord.getRecordType();
    }

    abstract boolean handleQuery(JmDNSImpl var1, long var2);

    abstract boolean handleResponse(JmDNSImpl var1);

    abstract DNSOutgoing addAnswer(JmDNSImpl var1, DNSIncoming var2, InetAddress var3, int var4, DNSOutgoing var5) throws IOException;

    boolean suppressedBy(DNSIncoming dNSIncoming) {
        try {
            for (DNSRecord dNSRecord : dNSIncoming.getAllAnswers()) {
                if (!this.suppressedBy(dNSRecord)) continue;
                return true;
            }
            return false;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            logger.log(Level.WARNING, "suppressedBy() message " + dNSIncoming + " exception ", arrayIndexOutOfBoundsException);
            return false;
        }
    }

    boolean suppressedBy(DNSRecord dNSRecord) {
        return this.equals(dNSRecord) && dNSRecord._ttl > this._ttl / 2;
    }

    long getExpirationTime(int n) {
        return this._created + (long)(n * this._ttl) * 10L;
    }

    int getRemainingTTL(long l) {
        return (int)Math.max(0L, (this.getExpirationTime(100) - l) / 1000L);
    }

    @Override
    public boolean isExpired(long l) {
        return this.getExpirationTime(100) <= l;
    }

    @Override
    public boolean isStale(long l) {
        return this.getExpirationTime(50) <= l;
    }

    void resetTTL(DNSRecord dNSRecord) {
        this._created = dNSRecord._created;
        this._ttl = dNSRecord._ttl;
    }

    void setWillExpireSoon(long l) {
        this._created = l;
        this._ttl = 1;
    }

    abstract void write(DNSOutgoing.MessageOutputStream var1);

    public abstract boolean isSingleValued();

    public ServiceInfo getServiceInfo() {
        return this.getServiceInfo(false);
    }

    public abstract ServiceInfo getServiceInfo(boolean var1);

    public abstract ServiceEvent getServiceEvent(JmDNSImpl var1);

    public void setRecordSource(InetAddress inetAddress) {
        this._source = inetAddress;
    }

    public InetAddress getRecordSource() {
        return this._source;
    }

    @Override
    protected void toString(StringBuilder stringBuilder) {
        super.toString(stringBuilder);
        stringBuilder.append(" ttl: '" + this.getRemainingTTL(System.currentTimeMillis()) + "/" + this._ttl + "'");
    }

    public void setTTL(int n) {
        this._ttl = n;
    }

    public int getTTL() {
        return this._ttl;
    }

    public static class HostInformation
    extends DNSRecord {
        String _os;
        String _cpu;

        public HostInformation(String string, DNSRecordClass dNSRecordClass, boolean bl, int n, String string2, String string3) {
            super(string, DNSRecordType.TYPE_HINFO, dNSRecordClass, bl, n);
            this._cpu = string2;
            this._os = string3;
        }

        @Override
        DNSOutgoing addAnswer(JmDNSImpl jmDNSImpl, DNSIncoming dNSIncoming, InetAddress inetAddress, int n, DNSOutgoing dNSOutgoing) throws IOException {
            return dNSOutgoing;
        }

        @Override
        boolean handleQuery(JmDNSImpl jmDNSImpl, long l) {
            return false;
        }

        @Override
        boolean handleResponse(JmDNSImpl jmDNSImpl) {
            return false;
        }

        @Override
        boolean sameValue(DNSRecord dNSRecord) {
            if (!(dNSRecord instanceof HostInformation)) {
                return false;
            }
            HostInformation hostInformation = (HostInformation)dNSRecord;
            if (this._cpu == null && hostInformation._cpu != null) {
                return false;
            }
            if (this._os == null && hostInformation._os != null) {
                return false;
            }
            return this._cpu.equals(hostInformation._cpu) && this._os.equals(hostInformation._os);
        }

        @Override
        public boolean isSingleValued() {
            return true;
        }

        @Override
        void write(DNSOutgoing.MessageOutputStream messageOutputStream) {
            String string = this._cpu + " " + this._os;
            messageOutputStream.writeUTF(string, 0, string.length());
        }

        @Override
        public ServiceInfo getServiceInfo(boolean bl) {
            HashMap<String, String> hashMap = new HashMap<String, String>(2);
            hashMap.put("cpu", this._cpu);
            hashMap.put("os", this._os);
            return new ServiceInfoImpl(this.getQualifiedNameMap(), 0, 0, 0, bl, hashMap);
        }

        @Override
        public ServiceEvent getServiceEvent(JmDNSImpl jmDNSImpl) {
            ServiceInfo serviceInfo = this.getServiceInfo(false);
            ((ServiceInfoImpl)serviceInfo).setDns(jmDNSImpl);
            return new ServiceEventImpl(jmDNSImpl, serviceInfo.getType(), serviceInfo.getName(), serviceInfo);
        }

        @Override
        protected void toString(StringBuilder stringBuilder) {
            super.toString(stringBuilder);
            stringBuilder.append(" cpu: '" + this._cpu + "' os: '" + this._os + "'");
        }
    }

    public static class Service
    extends DNSRecord {
        private static Logger logger1 = Logger.getLogger(Service.class.getName());
        private final int _priority;
        private final int _weight;
        private final int _port;
        private final String _server;

        public Service(String string, DNSRecordClass dNSRecordClass, boolean bl, int n, int n2, int n3, int n4, String string2) {
            super(string, DNSRecordType.TYPE_SRV, dNSRecordClass, bl, n);
            this._priority = n2;
            this._weight = n3;
            this._port = n4;
            this._server = string2;
        }

        @Override
        void write(DNSOutgoing.MessageOutputStream messageOutputStream) {
            messageOutputStream.writeShort(this._priority);
            messageOutputStream.writeShort(this._weight);
            messageOutputStream.writeShort(this._port);
            if (DNSIncoming.USE_DOMAIN_NAME_FORMAT_FOR_SRV_TARGET) {
                messageOutputStream.writeName(this._server);
            } else {
                messageOutputStream.writeUTF(this._server, 0, this._server.length());
                messageOutputStream.writeByte(0);
            }
        }

        @Override
        protected void toByteArray(DataOutputStream dataOutputStream) throws IOException {
            super.toByteArray(dataOutputStream);
            dataOutputStream.writeShort(this._priority);
            dataOutputStream.writeShort(this._weight);
            dataOutputStream.writeShort(this._port);
            try {
                dataOutputStream.write(this._server.getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }

        String getServer() {
            return this._server;
        }

        public int getPriority() {
            return this._priority;
        }

        public int getWeight() {
            return this._weight;
        }

        public int getPort() {
            return this._port;
        }

        @Override
        boolean sameValue(DNSRecord dNSRecord) {
            if (!(dNSRecord instanceof Service)) {
                return false;
            }
            Service service = (Service)dNSRecord;
            return this._priority == service._priority && this._weight == service._weight && this._port == service._port && this._server.equals(service._server);
        }

        @Override
        public boolean isSingleValued() {
            return true;
        }

        @Override
        boolean handleQuery(JmDNSImpl jmDNSImpl, long l) {
            ServiceInfoImpl serviceInfoImpl = (ServiceInfoImpl)jmDNSImpl.getServices().get(this.getKey());
            if (!(serviceInfoImpl == null || !serviceInfoImpl.isAnnouncing() && !serviceInfoImpl.isAnnounced() || this._port == serviceInfoImpl.getPort() && this._server.equalsIgnoreCase(jmDNSImpl.getLocalHost().getName()))) {
                logger1.finer("handleQuery() Conflicting probe detected from: " + this.getRecordSource());
                Service service = new Service(serviceInfoImpl.getQualifiedName(), DNSRecordClass.CLASS_IN, true, 3600, serviceInfoImpl.getPriority(), serviceInfoImpl.getWeight(), serviceInfoImpl.getPort(), jmDNSImpl.getLocalHost().getName());
                try {
                    if (jmDNSImpl.getInterface().equals(this.getRecordSource())) {
                        logger1.warning("Got conflicting probe from ourselves\nincoming: " + this.toString() + "\n" + "local   : " + service.toString());
                    }
                }
                catch (IOException iOException) {
                    logger1.log(Level.WARNING, "IOException", iOException);
                }
                int n = this.compareTo(service);
                if (n == 0) {
                    logger1.finer("handleQuery() Ignoring a identical service query");
                    return false;
                }
                if (!serviceInfoImpl.isProbing() || n <= 0) {
                    return false;
                }
                String string = serviceInfoImpl.getQualifiedName().toLowerCase();
                serviceInfoImpl.setName(jmDNSImpl.incrementName(serviceInfoImpl.getName()));
                jmDNSImpl.getServices().remove(string);
                jmDNSImpl.getServices().put(serviceInfoImpl.getQualifiedName().toLowerCase(), serviceInfoImpl);
                logger1.finer("handleQuery() Lost tie break: new unique name chosen:" + serviceInfoImpl.getName());
                serviceInfoImpl.revertState();
                return true;
            }
            return false;
        }

        @Override
        boolean handleResponse(JmDNSImpl jmDNSImpl) {
            ServiceInfoImpl serviceInfoImpl = (ServiceInfoImpl)jmDNSImpl.getServices().get(this.getKey());
            if (!(serviceInfoImpl == null || this._port == serviceInfoImpl.getPort() && this._server.equalsIgnoreCase(jmDNSImpl.getLocalHost().getName()))) {
                logger1.finer("handleResponse() Denial detected");
                if (serviceInfoImpl.isProbing()) {
                    String string = serviceInfoImpl.getQualifiedName().toLowerCase();
                    serviceInfoImpl.setName(jmDNSImpl.incrementName(serviceInfoImpl.getName()));
                    jmDNSImpl.getServices().remove(string);
                    jmDNSImpl.getServices().put(serviceInfoImpl.getQualifiedName().toLowerCase(), serviceInfoImpl);
                    logger1.finer("handleResponse() New unique name chose:" + serviceInfoImpl.getName());
                }
                serviceInfoImpl.revertState();
                return true;
            }
            return false;
        }

        @Override
        DNSOutgoing addAnswer(JmDNSImpl jmDNSImpl, DNSIncoming dNSIncoming, InetAddress inetAddress, int n, DNSOutgoing dNSOutgoing) throws IOException {
            ServiceInfoImpl serviceInfoImpl = (ServiceInfoImpl)jmDNSImpl.getServices().get(this.getKey());
            if (serviceInfoImpl != null && this._port == serviceInfoImpl.getPort() != this._server.equals(jmDNSImpl.getLocalHost().getName())) {
                return jmDNSImpl.addAnswer(dNSIncoming, inetAddress, n, dNSOutgoing, new Service(serviceInfoImpl.getQualifiedName(), DNSRecordClass.CLASS_IN, true, 3600, serviceInfoImpl.getPriority(), serviceInfoImpl.getWeight(), serviceInfoImpl.getPort(), jmDNSImpl.getLocalHost().getName()));
            }
            return dNSOutgoing;
        }

        @Override
        public ServiceInfo getServiceInfo(boolean bl) {
            return new ServiceInfoImpl(this.getQualifiedNameMap(), this._port, this._weight, this._priority, bl, this._server);
        }

        @Override
        public ServiceEvent getServiceEvent(JmDNSImpl jmDNSImpl) {
            ServiceInfo serviceInfo = this.getServiceInfo(false);
            ((ServiceInfoImpl)serviceInfo).setDns(jmDNSImpl);
            return new ServiceEventImpl(jmDNSImpl, serviceInfo.getType(), serviceInfo.getName(), serviceInfo);
        }

        @Override
        protected void toString(StringBuilder stringBuilder) {
            super.toString(stringBuilder);
            stringBuilder.append(" server: '" + this._server + ":" + this._port + "'");
        }
    }

    public static class Text
    extends DNSRecord {
        private final byte[] _text;

        public Text(String string, DNSRecordClass dNSRecordClass, boolean bl, int n, byte[] byArray) {
            super(string, DNSRecordType.TYPE_TXT, dNSRecordClass, bl, n);
            this._text = byArray != null && byArray.length > 0 ? byArray : EMPTY_TXT;
        }

        byte[] getText() {
            return this._text;
        }

        @Override
        void write(DNSOutgoing.MessageOutputStream messageOutputStream) {
            messageOutputStream.writeBytes(this._text, 0, this._text.length);
        }

        @Override
        boolean sameValue(DNSRecord dNSRecord) {
            if (!(dNSRecord instanceof Text)) {
                return false;
            }
            Text text = (Text)dNSRecord;
            if (this._text == null && text._text != null) {
                return false;
            }
            if (text._text.length != this._text.length) {
                return false;
            }
            int n = this._text.length;
            while (n-- > 0) {
                if (text._text[n] == this._text[n]) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean isSingleValued() {
            return true;
        }

        @Override
        boolean handleQuery(JmDNSImpl jmDNSImpl, long l) {
            return false;
        }

        @Override
        boolean handleResponse(JmDNSImpl jmDNSImpl) {
            return false;
        }

        @Override
        DNSOutgoing addAnswer(JmDNSImpl jmDNSImpl, DNSIncoming dNSIncoming, InetAddress inetAddress, int n, DNSOutgoing dNSOutgoing) throws IOException {
            return dNSOutgoing;
        }

        @Override
        public ServiceInfo getServiceInfo(boolean bl) {
            return new ServiceInfoImpl(this.getQualifiedNameMap(), 0, 0, 0, bl, this._text);
        }

        @Override
        public ServiceEvent getServiceEvent(JmDNSImpl jmDNSImpl) {
            ServiceInfo serviceInfo = this.getServiceInfo(false);
            ((ServiceInfoImpl)serviceInfo).setDns(jmDNSImpl);
            return new ServiceEventImpl(jmDNSImpl, serviceInfo.getType(), serviceInfo.getName(), serviceInfo);
        }

        @Override
        protected void toString(StringBuilder stringBuilder) {
            super.toString(stringBuilder);
            stringBuilder.append(" text: '" + (this._text.length > 20 ? new String(this._text, 0, 17) + "..." : new String(this._text)) + "'");
        }
    }

    public static class Pointer
    extends DNSRecord {
        private final String _alias;

        public Pointer(String string, DNSRecordClass dNSRecordClass, boolean bl, int n, String string2) {
            super(string, DNSRecordType.TYPE_PTR, dNSRecordClass, bl, n);
            this._alias = string2;
        }

        @Override
        public boolean isSameEntry(DNSEntry dNSEntry) {
            return super.isSameEntry(dNSEntry) && dNSEntry instanceof Pointer && this.sameValue((Pointer)dNSEntry);
        }

        @Override
        void write(DNSOutgoing.MessageOutputStream messageOutputStream) {
            messageOutputStream.writeName(this._alias);
        }

        @Override
        boolean sameValue(DNSRecord dNSRecord) {
            if (!(dNSRecord instanceof Pointer)) {
                return false;
            }
            Pointer pointer = (Pointer)dNSRecord;
            if (this._alias == null && pointer._alias != null) {
                return false;
            }
            return this._alias.equals(pointer._alias);
        }

        @Override
        public boolean isSingleValued() {
            return false;
        }

        @Override
        boolean handleQuery(JmDNSImpl jmDNSImpl, long l) {
            return false;
        }

        @Override
        boolean handleResponse(JmDNSImpl jmDNSImpl) {
            return false;
        }

        String getAlias() {
            return this._alias;
        }

        @Override
        DNSOutgoing addAnswer(JmDNSImpl jmDNSImpl, DNSIncoming dNSIncoming, InetAddress inetAddress, int n, DNSOutgoing dNSOutgoing) throws IOException {
            return dNSOutgoing;
        }

        @Override
        public ServiceInfo getServiceInfo(boolean bl) {
            if (this.isServicesDiscoveryMetaQuery()) {
                Map<ServiceInfo.Fields, String> map = ServiceInfoImpl.decodeQualifiedNameMapForType(this.getAlias());
                return new ServiceInfoImpl(map, 0, 0, 0, bl, (byte[])null);
            }
            if (this.isReverseLookup()) {
                return new ServiceInfoImpl(this.getQualifiedNameMap(), 0, 0, 0, bl, (byte[])null);
            }
            if (this.isDomainDiscoveryQuery()) {
                return new ServiceInfoImpl(this.getQualifiedNameMap(), 0, 0, 0, bl, (byte[])null);
            }
            Map<ServiceInfo.Fields, String> map = ServiceInfoImpl.decodeQualifiedNameMapForType(this.getAlias());
            map.put(ServiceInfo.Fields.Subtype, this.getQualifiedNameMap().get((Object)ServiceInfo.Fields.Subtype));
            return new ServiceInfoImpl(map, 0, 0, 0, bl, this.getAlias());
        }

        @Override
        public ServiceEvent getServiceEvent(JmDNSImpl jmDNSImpl) {
            ServiceInfo serviceInfo = this.getServiceInfo(false);
            ((ServiceInfoImpl)serviceInfo).setDns(jmDNSImpl);
            String string = serviceInfo.getType();
            String string2 = JmDNSImpl.toUnqualifiedName(string, this.getAlias());
            return new ServiceEventImpl(jmDNSImpl, string, string2, serviceInfo);
        }

        @Override
        protected void toString(StringBuilder stringBuilder) {
            super.toString(stringBuilder);
            stringBuilder.append(" alias: '" + (this._alias != null ? this._alias.toString() : "null") + "'");
        }
    }

    public static abstract class Address
    extends DNSRecord {
        private static Logger logger1 = Logger.getLogger(Address.class.getName());
        InetAddress _addr;

        protected Address(String string, DNSRecordType dNSRecordType, DNSRecordClass dNSRecordClass, boolean bl, int n, InetAddress inetAddress) {
            super(string, dNSRecordType, dNSRecordClass, bl, n);
            this._addr = inetAddress;
        }

        protected Address(String string, DNSRecordType dNSRecordType, DNSRecordClass dNSRecordClass, boolean bl, int n, byte[] byArray) {
            super(string, dNSRecordType, dNSRecordClass, bl, n);
            try {
                this._addr = InetAddress.getByAddress(byArray);
            }
            catch (UnknownHostException unknownHostException) {
                logger1.log(Level.WARNING, "Address() exception ", unknownHostException);
            }
        }

        boolean same(DNSRecord dNSRecord) {
            if (!(dNSRecord instanceof Address)) {
                return false;
            }
            return this.sameName(dNSRecord) && this.sameValue(dNSRecord);
        }

        boolean sameName(DNSRecord dNSRecord) {
            return this.getName().equalsIgnoreCase(dNSRecord.getName());
        }

        @Override
        boolean sameValue(DNSRecord dNSRecord) {
            if (!(dNSRecord instanceof Address)) {
                return false;
            }
            Address address = (Address)dNSRecord;
            if (this.getAddress() == null && address.getAddress() != null) {
                return false;
            }
            return this.getAddress().equals(address.getAddress());
        }

        @Override
        public boolean isSingleValued() {
            return false;
        }

        InetAddress getAddress() {
            return this._addr;
        }

        @Override
        protected void toByteArray(DataOutputStream dataOutputStream) throws IOException {
            super.toByteArray(dataOutputStream);
            byte[] byArray = this.getAddress().getAddress();
            for (int i = 0; i < byArray.length; ++i) {
                dataOutputStream.writeByte(byArray[i]);
            }
        }

        @Override
        boolean handleQuery(JmDNSImpl jmDNSImpl, long l) {
            if (jmDNSImpl.getLocalHost().conflictWithRecord(this)) {
                Address address = jmDNSImpl.getLocalHost().getDNSAddressRecord(this.getRecordType(), this.isUnique(), 3600);
                int n = this.compareTo(address);
                if (n == 0) {
                    logger1.finer("handleQuery() Ignoring an identical address query");
                    return false;
                }
                logger1.finer("handleQuery() Conflicting query detected.");
                if (jmDNSImpl.isProbing() && n > 0) {
                    jmDNSImpl.getLocalHost().incrementHostName();
                    jmDNSImpl.getCache().clear();
                    for (ServiceInfo serviceInfo : jmDNSImpl.getServices().values()) {
                        ServiceInfoImpl serviceInfoImpl = (ServiceInfoImpl)serviceInfo;
                        serviceInfoImpl.revertState();
                    }
                }
                jmDNSImpl.revertState();
                return true;
            }
            return false;
        }

        @Override
        boolean handleResponse(JmDNSImpl jmDNSImpl) {
            if (jmDNSImpl.getLocalHost().conflictWithRecord(this)) {
                logger1.finer("handleResponse() Denial detected");
                if (jmDNSImpl.isProbing()) {
                    jmDNSImpl.getLocalHost().incrementHostName();
                    jmDNSImpl.getCache().clear();
                    for (ServiceInfo serviceInfo : jmDNSImpl.getServices().values()) {
                        ServiceInfoImpl serviceInfoImpl = (ServiceInfoImpl)serviceInfo;
                        serviceInfoImpl.revertState();
                    }
                }
                jmDNSImpl.revertState();
                return true;
            }
            return false;
        }

        @Override
        DNSOutgoing addAnswer(JmDNSImpl jmDNSImpl, DNSIncoming dNSIncoming, InetAddress inetAddress, int n, DNSOutgoing dNSOutgoing) throws IOException {
            return dNSOutgoing;
        }

        @Override
        public ServiceInfo getServiceInfo(boolean bl) {
            ServiceInfoImpl serviceInfoImpl = new ServiceInfoImpl(this.getQualifiedNameMap(), 0, 0, 0, bl, (byte[])null);
            return serviceInfoImpl;
        }

        @Override
        public ServiceEvent getServiceEvent(JmDNSImpl jmDNSImpl) {
            ServiceInfo serviceInfo = this.getServiceInfo(false);
            ((ServiceInfoImpl)serviceInfo).setDns(jmDNSImpl);
            return new ServiceEventImpl(jmDNSImpl, serviceInfo.getType(), serviceInfo.getName(), serviceInfo);
        }

        @Override
        protected void toString(StringBuilder stringBuilder) {
            super.toString(stringBuilder);
            stringBuilder.append(" address: '" + (this.getAddress() != null ? this.getAddress().getHostAddress() : "null") + "'");
        }
    }

    public static class IPv6Address
    extends Address {
        IPv6Address(String string, DNSRecordClass dNSRecordClass, boolean bl, int n, InetAddress inetAddress) {
            super(string, DNSRecordType.TYPE_AAAA, dNSRecordClass, bl, n, inetAddress);
        }

        IPv6Address(String string, DNSRecordClass dNSRecordClass, boolean bl, int n, byte[] byArray) {
            super(string, DNSRecordType.TYPE_AAAA, dNSRecordClass, bl, n, byArray);
        }

        @Override
        void write(DNSOutgoing.MessageOutputStream messageOutputStream) {
            if (this._addr != null) {
                byte[] byArray = this._addr.getAddress();
                if (this._addr instanceof Inet4Address) {
                    byte[] byArray2 = byArray;
                    byArray = new byte[16];
                    for (int i = 0; i < 16; ++i) {
                        byArray[i] = i < 11 ? byArray2[i - 12] : (byte)0;
                    }
                }
                int n = byArray.length;
                messageOutputStream.writeBytes(byArray, 0, n);
            }
        }

        @Override
        public ServiceInfo getServiceInfo(boolean bl) {
            ServiceInfoImpl serviceInfoImpl = (ServiceInfoImpl)super.getServiceInfo(bl);
            serviceInfoImpl.addAddress((Inet6Address)this._addr);
            return serviceInfoImpl;
        }
    }

    public static class IPv4Address
    extends Address {
        IPv4Address(String string, DNSRecordClass dNSRecordClass, boolean bl, int n, InetAddress inetAddress) {
            super(string, DNSRecordType.TYPE_A, dNSRecordClass, bl, n, inetAddress);
        }

        IPv4Address(String string, DNSRecordClass dNSRecordClass, boolean bl, int n, byte[] byArray) {
            super(string, DNSRecordType.TYPE_A, dNSRecordClass, bl, n, byArray);
        }

        @Override
        void write(DNSOutgoing.MessageOutputStream messageOutputStream) {
            if (this._addr != null) {
                byte[] byArray = this._addr.getAddress();
                if (!(this._addr instanceof Inet4Address)) {
                    byte[] byArray2 = byArray;
                    byArray = new byte[4];
                    System.arraycopy(byArray2, 12, byArray, 0, 4);
                }
                int n = byArray.length;
                messageOutputStream.writeBytes(byArray, 0, n);
            }
        }

        @Override
        public ServiceInfo getServiceInfo(boolean bl) {
            ServiceInfoImpl serviceInfoImpl = (ServiceInfoImpl)super.getServiceInfo(bl);
            serviceInfoImpl.addAddress((Inet4Address)this._addr);
            return serviceInfoImpl;
        }
    }
}

