/*
 * Decompiled with CFR 0.152.
 */
package javax.jmdns.impl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jmdns.ServiceEvent;
import javax.jmdns.ServiceInfo;
import javax.jmdns.impl.DNSCache;
import javax.jmdns.impl.DNSEntry;
import javax.jmdns.impl.DNSListener;
import javax.jmdns.impl.DNSRecord;
import javax.jmdns.impl.DNSStatefulObject;
import javax.jmdns.impl.HostInfo;
import javax.jmdns.impl.JmDNSImpl;
import javax.jmdns.impl.ServiceEventImpl;
import javax.jmdns.impl.constants.DNSRecordClass;
import javax.jmdns.impl.constants.DNSRecordType;
import javax.jmdns.impl.constants.DNSState;
import javax.jmdns.impl.tasks.DNSTask;

public class ServiceInfoImpl
extends ServiceInfo
implements DNSListener,
DNSStatefulObject {
    private static Logger logger = Logger.getLogger(ServiceInfoImpl.class.getName());
    private String _domain;
    private String _protocol;
    private String _application;
    private String _name;
    private String _subtype;
    private String _server;
    private int _port;
    private int _weight;
    private int _priority;
    private byte[] _text;
    private Map<String, byte[]> _props;
    private final Set<Inet4Address> _ipv4Addresses;
    private final Set<Inet6Address> _ipv6Addresses;
    private transient String _key;
    private boolean _persistent;
    private boolean _needTextAnnouncing;
    private final ServiceInfoState _state;
    private Delegate _delegate;

    public ServiceInfoImpl(String string, String string2, String string3, int n, int n2, int n3, boolean bl, String string4) {
        this(ServiceInfoImpl.decodeQualifiedNameMap(string, string2, string3), n, n2, n3, bl, (byte[])null);
        this._server = string4;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(string4.length());
            ServiceInfoImpl.writeUTF(byteArrayOutputStream, string4);
            this._text = byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new RuntimeException("unexpected exception: " + iOException);
        }
    }

    public ServiceInfoImpl(String string, String string2, String string3, int n, int n2, int n3, boolean bl, Map<String, ?> map) {
        this(ServiceInfoImpl.decodeQualifiedNameMap(string, string2, string3), n, n2, n3, bl, ServiceInfoImpl.textFromProperties(map));
    }

    public ServiceInfoImpl(String string, String string2, String string3, int n, int n2, int n3, boolean bl, byte[] byArray) {
        this(ServiceInfoImpl.decodeQualifiedNameMap(string, string2, string3), n, n2, n3, bl, byArray);
    }

    public ServiceInfoImpl(Map<ServiceInfo.Fields, String> map, int n, int n2, int n3, boolean bl, Map<String, ?> map2) {
        this(map, n, n2, n3, bl, ServiceInfoImpl.textFromProperties(map2));
    }

    ServiceInfoImpl(Map<ServiceInfo.Fields, String> map, int n, int n2, int n3, boolean bl, String string) {
        this(map, n, n2, n3, bl, (byte[])null);
        this._server = string;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(string.length());
            ServiceInfoImpl.writeUTF(byteArrayOutputStream, string);
            this._text = byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new RuntimeException("unexpected exception: " + iOException);
        }
    }

    ServiceInfoImpl(Map<ServiceInfo.Fields, String> map, int n, int n2, int n3, boolean bl, byte[] byArray) {
        Map<ServiceInfo.Fields, String> map2 = ServiceInfoImpl.checkQualifiedNameMap(map);
        this._domain = map2.get((Object)ServiceInfo.Fields.Domain);
        this._protocol = map2.get((Object)ServiceInfo.Fields.Protocol);
        this._application = map2.get((Object)ServiceInfo.Fields.Application);
        this._name = map2.get((Object)ServiceInfo.Fields.Instance);
        this._subtype = map2.get((Object)ServiceInfo.Fields.Subtype);
        this._port = n;
        this._weight = n2;
        this._priority = n3;
        this._text = byArray;
        this.setNeedTextAnnouncing(false);
        this._state = new ServiceInfoState(this);
        this._persistent = bl;
        this._ipv4Addresses = Collections.synchronizedSet(new LinkedHashSet());
        this._ipv6Addresses = Collections.synchronizedSet(new LinkedHashSet());
    }

    ServiceInfoImpl(ServiceInfo serviceInfo) {
        this._ipv4Addresses = Collections.synchronizedSet(new LinkedHashSet());
        this._ipv6Addresses = Collections.synchronizedSet(new LinkedHashSet());
        if (serviceInfo != null) {
            this._domain = serviceInfo.getDomain();
            this._protocol = serviceInfo.getProtocol();
            this._application = serviceInfo.getApplication();
            this._name = serviceInfo.getName();
            this._subtype = serviceInfo.getSubtype();
            this._port = serviceInfo.getPort();
            this._weight = serviceInfo.getWeight();
            this._priority = serviceInfo.getPriority();
            this._text = serviceInfo.getTextBytes();
            this._persistent = serviceInfo.isPersistent();
            Inet6Address[] inet6AddressArray = serviceInfo.getInet6Addresses();
            InetAddress[] inetAddressArray = inet6AddressArray;
            int n = inetAddressArray.length;
            for (int i = 0; i < n; ++i) {
                Inet6Address inet6Address = inetAddressArray[i];
                this._ipv6Addresses.add(inet6Address);
            }
            for (InetAddress inetAddress : inetAddressArray = serviceInfo.getInet4Addresses()) {
                this._ipv4Addresses.add((Inet4Address)inetAddress);
            }
        }
        this._state = new ServiceInfoState(this);
    }

    public static Map<ServiceInfo.Fields, String> decodeQualifiedNameMap(String string, String string2, String string3) {
        Map<ServiceInfo.Fields, String> map = ServiceInfoImpl.decodeQualifiedNameMapForType(string);
        map.put(ServiceInfo.Fields.Instance, string2);
        map.put(ServiceInfo.Fields.Subtype, string3);
        return ServiceInfoImpl.checkQualifiedNameMap(map);
    }

    public static Map<ServiceInfo.Fields, String> decodeQualifiedNameMapForType(String string) {
        String string2;
        String string3 = string;
        String string4 = string2 = string.toLowerCase();
        String string5 = "";
        String string6 = "";
        String string7 = "";
        String string8 = "";
        if (string2.contains("in-addr.arpa") || string2.contains("ip6.arpa")) {
            int n = string2.contains("in-addr.arpa") ? string2.indexOf("in-addr.arpa") : string2.indexOf("ip6.arpa");
            string7 = ServiceInfoImpl.removeSeparators(string3.substring(0, n));
            string8 = string3.substring(n);
            string4 = "";
        } else if (!string2.contains("_") && string2.contains(".")) {
            int n = string2.indexOf(46);
            string7 = ServiceInfoImpl.removeSeparators(string3.substring(0, n));
            string8 = ServiceInfoImpl.removeSeparators(string3.substring(n));
            string4 = "";
        } else {
            int n;
            int n2;
            int n3;
            if ((!string2.startsWith("_") || string2.startsWith("_services")) && (n3 = string2.indexOf(46)) > 0) {
                string7 = string3.substring(0, n3);
                if (n3 + 1 < string2.length()) {
                    string2 = string2.substring(n3 + 1);
                    string3 = string3.substring(n3 + 1);
                }
            }
            if ((n3 = string2.lastIndexOf("._")) > 0) {
                n2 = n3 + 2;
                n = string2.indexOf(46, n2);
                string5 = string3.substring(n2, n);
            }
            if (string5.length() > 0) {
                n3 = string2.indexOf("_" + string5.toLowerCase() + ".");
                n2 = n3 + string5.length() + 2;
                n = string2.length() - (string2.endsWith(".") ? 1 : 0);
                string8 = string3.substring(n2, n);
                string4 = string3.substring(0, n3 - 1);
            }
            if ((n3 = string4.toLowerCase().indexOf("._sub")) > 0) {
                n2 = n3 + 5;
                string6 = ServiceInfoImpl.removeSeparators(string4.substring(0, n3));
                string4 = string4.substring(n2);
            }
        }
        HashMap<ServiceInfo.Fields, String> hashMap = new HashMap<ServiceInfo.Fields, String>(5);
        hashMap.put(ServiceInfo.Fields.Domain, ServiceInfoImpl.removeSeparators(string8));
        hashMap.put(ServiceInfo.Fields.Protocol, string5);
        hashMap.put(ServiceInfo.Fields.Application, ServiceInfoImpl.removeSeparators(string4));
        hashMap.put(ServiceInfo.Fields.Instance, string7);
        hashMap.put(ServiceInfo.Fields.Subtype, string6);
        return hashMap;
    }

    protected static Map<ServiceInfo.Fields, String> checkQualifiedNameMap(Map<ServiceInfo.Fields, String> map) {
        String string;
        String string2;
        String string3;
        String string4;
        String string5;
        HashMap<ServiceInfo.Fields, String> hashMap = new HashMap<ServiceInfo.Fields, String>(5);
        String string6 = string5 = map.containsKey((Object)ServiceInfo.Fields.Domain) ? map.get((Object)ServiceInfo.Fields.Domain) : "local";
        if (string5 == null || string5.length() == 0) {
            string5 = "local";
        }
        string5 = ServiceInfoImpl.removeSeparators(string5);
        hashMap.put(ServiceInfo.Fields.Domain, string5);
        String string7 = string4 = map.containsKey((Object)ServiceInfo.Fields.Protocol) ? map.get((Object)ServiceInfo.Fields.Protocol) : "tcp";
        if (string4 == null || string4.length() == 0) {
            string4 = "tcp";
        }
        string4 = ServiceInfoImpl.removeSeparators(string4);
        hashMap.put(ServiceInfo.Fields.Protocol, string4);
        String string8 = string3 = map.containsKey((Object)ServiceInfo.Fields.Application) ? map.get((Object)ServiceInfo.Fields.Application) : "";
        if (string3 == null || string3.length() == 0) {
            string3 = "";
        }
        string3 = ServiceInfoImpl.removeSeparators(string3);
        hashMap.put(ServiceInfo.Fields.Application, string3);
        String string9 = string2 = map.containsKey((Object)ServiceInfo.Fields.Instance) ? map.get((Object)ServiceInfo.Fields.Instance) : "";
        if (string2 == null || string2.length() == 0) {
            string2 = "";
        }
        string2 = ServiceInfoImpl.removeSeparators(string2);
        hashMap.put(ServiceInfo.Fields.Instance, string2);
        String string10 = string = map.containsKey((Object)ServiceInfo.Fields.Subtype) ? map.get((Object)ServiceInfo.Fields.Subtype) : "";
        if (string == null || string.length() == 0) {
            string = "";
        }
        string = ServiceInfoImpl.removeSeparators(string);
        hashMap.put(ServiceInfo.Fields.Subtype, string);
        return hashMap;
    }

    private static String removeSeparators(String string) {
        if (string == null) {
            return "";
        }
        String string2 = string.trim();
        if (string2.startsWith(".")) {
            string2 = string2.substring(1);
        }
        if (string2.startsWith("_")) {
            string2 = string2.substring(1);
        }
        if (string2.endsWith(".")) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        return string2;
    }

    @Override
    public String getType() {
        String string = this.getDomain();
        String string2 = this.getProtocol();
        String string3 = this.getApplication();
        return (string3.length() > 0 ? "_" + string3 + "." : "") + (string2.length() > 0 ? "_" + string2 + "." : "") + string + ".";
    }

    @Override
    public String getTypeWithSubtype() {
        String string = this.getSubtype();
        return (string.length() > 0 ? "_" + string.toLowerCase() + "._sub." : "") + this.getType();
    }

    @Override
    public String getName() {
        return this._name != null ? this._name : "";
    }

    @Override
    public String getKey() {
        if (this._key == null) {
            this._key = this.getQualifiedName().toLowerCase();
        }
        return this._key;
    }

    void setName(String string) {
        this._name = string;
        this._key = null;
    }

    @Override
    public String getQualifiedName() {
        String string = this.getDomain();
        String string2 = this.getProtocol();
        String string3 = this.getApplication();
        String string4 = this.getName();
        return (string4.length() > 0 ? string4 + "." : "") + (string3.length() > 0 ? "_" + string3 + "." : "") + (string2.length() > 0 ? "_" + string2 + "." : "") + string + ".";
    }

    @Override
    public String getServer() {
        return this._server != null ? this._server : "";
    }

    void setServer(String string) {
        this._server = string;
    }

    @Override
    @Deprecated
    public String getHostAddress() {
        String[] stringArray = this.getHostAddresses();
        return stringArray.length > 0 ? stringArray[0] : "";
    }

    @Override
    public String[] getHostAddresses() {
        int n;
        Inet4Address[] inet4AddressArray = this.getInet4Addresses();
        Inet6Address[] inet6AddressArray = this.getInet6Addresses();
        String[] stringArray = new String[inet4AddressArray.length + inet6AddressArray.length];
        for (n = 0; n < inet4AddressArray.length; ++n) {
            stringArray[n] = inet4AddressArray[n].getHostAddress();
        }
        for (n = 0; n < inet6AddressArray.length; ++n) {
            stringArray[n + inet4AddressArray.length] = "[" + inet6AddressArray[n].getHostAddress() + "]";
        }
        return stringArray;
    }

    void addAddress(Inet4Address inet4Address) {
        this._ipv4Addresses.add(inet4Address);
    }

    void addAddress(Inet6Address inet6Address) {
        this._ipv6Addresses.add(inet6Address);
    }

    @Override
    @Deprecated
    public InetAddress getAddress() {
        return this.getInetAddress();
    }

    @Override
    @Deprecated
    public InetAddress getInetAddress() {
        InetAddress[] inetAddressArray = this.getInetAddresses();
        return inetAddressArray.length > 0 ? inetAddressArray[0] : null;
    }

    @Override
    @Deprecated
    public Inet4Address getInet4Address() {
        Inet4Address[] inet4AddressArray = this.getInet4Addresses();
        return inet4AddressArray.length > 0 ? inet4AddressArray[0] : null;
    }

    @Override
    @Deprecated
    public Inet6Address getInet6Address() {
        Inet6Address[] inet6AddressArray = this.getInet6Addresses();
        return inet6AddressArray.length > 0 ? inet6AddressArray[0] : null;
    }

    @Override
    public InetAddress[] getInetAddresses() {
        ArrayList<InetAddress> arrayList = new ArrayList<InetAddress>(this._ipv4Addresses.size() + this._ipv6Addresses.size());
        arrayList.addAll(this._ipv4Addresses);
        arrayList.addAll(this._ipv6Addresses);
        return arrayList.toArray(new InetAddress[arrayList.size()]);
    }

    @Override
    public Inet4Address[] getInet4Addresses() {
        return this._ipv4Addresses.toArray(new Inet4Address[this._ipv4Addresses.size()]);
    }

    @Override
    public Inet6Address[] getInet6Addresses() {
        return this._ipv6Addresses.toArray(new Inet6Address[this._ipv6Addresses.size()]);
    }

    @Override
    public int getPort() {
        return this._port;
    }

    @Override
    public int getPriority() {
        return this._priority;
    }

    @Override
    public int getWeight() {
        return this._weight;
    }

    @Override
    public byte[] getTextBytes() {
        return this._text != null && this._text.length > 0 ? this._text : DNSRecord.EMPTY_TXT;
    }

    @Override
    @Deprecated
    public String getTextString() {
        Map<String, byte[]> map = this.getProperties();
        Iterator<String> iterator = map.keySet().iterator();
        if (iterator.hasNext()) {
            String string = iterator.next();
            byte[] byArray = map.get(string);
            if (byArray != null && byArray.length > 0) {
                return string + "=" + new String(byArray);
            }
            return string;
        }
        return "";
    }

    @Override
    @Deprecated
    public String getURL() {
        return this.getURL("http");
    }

    @Override
    public String[] getURLs() {
        return this.getURLs("http");
    }

    @Override
    @Deprecated
    public String getURL(String string) {
        String[] stringArray = this.getURLs(string);
        return stringArray.length > 0 ? stringArray[0] : string + "://null:" + this.getPort();
    }

    @Override
    public String[] getURLs(String string) {
        InetAddress[] inetAddressArray = this.getInetAddresses();
        String[] stringArray = new String[inetAddressArray.length];
        for (int i = 0; i < inetAddressArray.length; ++i) {
            String string2 = string + "://" + inetAddressArray[i].getHostAddress() + ":" + this.getPort();
            String string3 = this.getPropertyString("path");
            if (string3 != null) {
                string2 = string3.indexOf("://") >= 0 ? string3 : string2 + (string3.startsWith("/") ? string3 : "/" + string3);
            }
            stringArray[i] = string2;
        }
        return stringArray;
    }

    @Override
    public synchronized byte[] getPropertyBytes(String string) {
        return this.getProperties().get(string);
    }

    @Override
    public synchronized String getPropertyString(String string) {
        byte[] byArray = this.getProperties().get(string);
        if (byArray == null) {
            return null;
        }
        if (byArray == NO_VALUE) {
            return "true";
        }
        return this.readUTF(byArray, 0, byArray.length);
    }

    @Override
    public Enumeration<String> getPropertyNames() {
        Map<String, byte[]> map = this.getProperties();
        Set<Object> set = map != null ? map.keySet() : Collections.emptySet();
        return new Vector(set).elements();
    }

    @Override
    public String getApplication() {
        return this._application != null ? this._application : "";
    }

    @Override
    public String getDomain() {
        return this._domain != null ? this._domain : "local";
    }

    @Override
    public String getProtocol() {
        return this._protocol != null ? this._protocol : "tcp";
    }

    @Override
    public String getSubtype() {
        return this._subtype != null ? this._subtype : "";
    }

    @Override
    public Map<ServiceInfo.Fields, String> getQualifiedNameMap() {
        HashMap<ServiceInfo.Fields, String> hashMap = new HashMap<ServiceInfo.Fields, String>(5);
        hashMap.put(ServiceInfo.Fields.Domain, this.getDomain());
        hashMap.put(ServiceInfo.Fields.Protocol, this.getProtocol());
        hashMap.put(ServiceInfo.Fields.Application, this.getApplication());
        hashMap.put(ServiceInfo.Fields.Instance, this.getName());
        hashMap.put(ServiceInfo.Fields.Subtype, this.getSubtype());
        return hashMap;
    }

    static void writeUTF(OutputStream outputStream, String string) throws IOException {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                outputStream.write(c);
                continue;
            }
            if (c > '\u07ff') {
                outputStream.write(0xE0 | c >> 12 & 0xF);
                outputStream.write(0x80 | c >> 6 & 0x3F);
                outputStream.write(0x80 | c >> 0 & 0x3F);
                continue;
            }
            outputStream.write(0xC0 | c >> 6 & 0x1F);
            outputStream.write(0x80 | c >> 0 & 0x3F);
        }
    }

    String readUTF(byte[] byArray, int n, int n2) {
        int n3 = n;
        StringBuffer stringBuffer = new StringBuffer();
        int n4 = n3 + n2;
        while (n3 < n4) {
            int n5 = byArray[n3++] & 0xFF;
            switch (n5 >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    break;
                }
                case 12: 
                case 13: {
                    if (n3 >= n2) {
                        return null;
                    }
                    n5 = (n5 & 0x1F) << 6 | byArray[n3++] & 0x3F;
                    break;
                }
                case 14: {
                    if (n3 + 2 >= n2) {
                        return null;
                    }
                    n5 = (n5 & 0xF) << 12 | (byArray[n3++] & 0x3F) << 6 | byArray[n3++] & 0x3F;
                    break;
                }
                default: {
                    if (n3 + 1 >= n2) {
                        return null;
                    }
                    n5 = (n5 & 0x3F) << 4 | byArray[n3++] & 0xF;
                }
            }
            stringBuffer.append((char)n5);
        }
        return stringBuffer.toString();
    }

    synchronized Map<String, byte[]> getProperties() {
        if (this._props == null && this.getTextBytes() != null) {
            Hashtable<String, byte[]> hashtable = new Hashtable<String, byte[]>();
            try {
                int n = 0;
                while (n < this.getTextBytes().length) {
                    int n2;
                    int n3 = this.getTextBytes()[n++] & 0xFF;
                    if (n3 == 0 || n + n3 > this.getTextBytes().length) {
                        hashtable.clear();
                        break;
                    }
                    for (n2 = 0; n2 < n3 && this.getTextBytes()[n + n2] != 61; ++n2) {
                    }
                    String string = this.readUTF(this.getTextBytes(), n, n2);
                    if (string == null) {
                        hashtable.clear();
                        break;
                    }
                    if (n2 == n3) {
                        hashtable.put(string, NO_VALUE);
                        continue;
                    }
                    byte[] byArray = new byte[n3 - ++n2];
                    System.arraycopy(this.getTextBytes(), n + n2, byArray, 0, n3 - n2);
                    hashtable.put(string, byArray);
                    n += n3;
                }
            }
            catch (Exception exception) {
                logger.log(Level.WARNING, "Malformed TXT Field ", exception);
            }
            this._props = hashtable;
        }
        return this._props != null ? this._props : Collections.emptyMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateRecord(DNSCache dNSCache, long l, DNSEntry dNSEntry) {
        if (dNSEntry instanceof DNSRecord && !dNSEntry.isExpired(l)) {
            Object object;
            boolean bl = false;
            switch (dNSEntry.getRecordType()) {
                case TYPE_A: {
                    if (!dNSEntry.getName().equalsIgnoreCase(this.getServer())) break;
                    this._ipv4Addresses.add((Inet4Address)((DNSRecord.Address)dNSEntry).getAddress());
                    bl = true;
                    break;
                }
                case TYPE_AAAA: {
                    if (!dNSEntry.getName().equalsIgnoreCase(this.getServer())) break;
                    this._ipv6Addresses.add((Inet6Address)((DNSRecord.Address)dNSEntry).getAddress());
                    bl = true;
                    break;
                }
                case TYPE_SRV: {
                    if (!dNSEntry.getName().equalsIgnoreCase(this.getQualifiedName())) break;
                    object = (DNSRecord.Service)dNSEntry;
                    boolean bl2 = this._server == null || !this._server.equalsIgnoreCase(((DNSRecord.Service)object).getServer());
                    this._server = ((DNSRecord.Service)object).getServer();
                    this._port = ((DNSRecord.Service)object).getPort();
                    this._weight = ((DNSRecord.Service)object).getWeight();
                    this._priority = ((DNSRecord.Service)object).getPriority();
                    if (bl2) {
                        this._ipv4Addresses.clear();
                        this._ipv6Addresses.clear();
                        for (DNSEntry dNSEntry2 : dNSCache.getDNSEntryList(this._server, DNSRecordType.TYPE_A, DNSRecordClass.CLASS_IN)) {
                            this.updateRecord(dNSCache, l, dNSEntry2);
                        }
                        for (DNSEntry dNSEntry2 : dNSCache.getDNSEntryList(this._server, DNSRecordType.TYPE_AAAA, DNSRecordClass.CLASS_IN)) {
                            this.updateRecord(dNSCache, l, dNSEntry2);
                        }
                        break;
                    }
                    bl = true;
                    break;
                }
                case TYPE_TXT: {
                    if (!dNSEntry.getName().equalsIgnoreCase(this.getQualifiedName())) break;
                    object = (DNSRecord.Text)dNSEntry;
                    this._text = ((DNSRecord.Text)object).getText();
                    bl = true;
                    break;
                }
                case TYPE_PTR: {
                    if (this.getSubtype().length() != 0 || dNSEntry.getSubtype().length() == 0) break;
                    this._subtype = dNSEntry.getSubtype();
                    bl = true;
                    break;
                }
            }
            if (bl && this.hasData() && (object = this.getDns()) != null) {
                ServiceEvent serviceEvent = ((DNSRecord)dNSEntry).getServiceEvent((JmDNSImpl)object);
                serviceEvent = new ServiceEventImpl((JmDNSImpl)object, serviceEvent.getType(), serviceEvent.getName(), this);
                ((JmDNSImpl)object).handleServiceResolved(serviceEvent);
            }
            object = this;
            synchronized (object) {
                this.notifyAll();
            }
        }
    }

    @Override
    public synchronized boolean hasData() {
        return this.getServer() != null && this.hasInetAddress() && this.getTextBytes() != null && this.getTextBytes().length > 0;
    }

    private final boolean hasInetAddress() {
        return this._ipv4Addresses.size() > 0 || this._ipv6Addresses.size() > 0;
    }

    @Override
    public boolean advanceState(DNSTask dNSTask) {
        return this._state.advanceState(dNSTask);
    }

    @Override
    public boolean revertState() {
        return this._state.revertState();
    }

    @Override
    public boolean cancelState() {
        return this._state.cancelState();
    }

    @Override
    public boolean closeState() {
        return this._state.closeState();
    }

    @Override
    public boolean recoverState() {
        return this._state.recoverState();
    }

    @Override
    public void removeAssociationWithTask(DNSTask dNSTask) {
        this._state.removeAssociationWithTask(dNSTask);
    }

    @Override
    public void associateWithTask(DNSTask dNSTask, DNSState dNSState) {
        this._state.associateWithTask(dNSTask, dNSState);
    }

    @Override
    public boolean isAssociatedWithTask(DNSTask dNSTask, DNSState dNSState) {
        return this._state.isAssociatedWithTask(dNSTask, dNSState);
    }

    @Override
    public boolean isProbing() {
        return this._state.isProbing();
    }

    @Override
    public boolean isAnnouncing() {
        return this._state.isAnnouncing();
    }

    @Override
    public boolean isAnnounced() {
        return this._state.isAnnounced();
    }

    @Override
    public boolean isCanceling() {
        return this._state.isCanceling();
    }

    @Override
    public boolean isCanceled() {
        return this._state.isCanceled();
    }

    @Override
    public boolean isClosing() {
        return this._state.isClosing();
    }

    @Override
    public boolean isClosed() {
        return this._state.isClosed();
    }

    @Override
    public boolean waitForAnnounced(long l) {
        return this._state.waitForAnnounced(l);
    }

    @Override
    public boolean waitForCanceled(long l) {
        return this._state.waitForCanceled(l);
    }

    public int hashCode() {
        return this.getQualifiedName().hashCode();
    }

    public boolean equals(Object object) {
        return object instanceof ServiceInfoImpl && this.getQualifiedName().equals(((ServiceInfoImpl)object).getQualifiedName());
    }

    @Override
    public String getNiceTextString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.getTextBytes().length;
        for (int i = 0; i < n; ++i) {
            if (i >= 200) {
                stringBuffer.append("...");
                break;
            }
            int n2 = this.getTextBytes()[i] & 0xFF;
            if (n2 < 32 || n2 > 127) {
                stringBuffer.append("\\0");
                stringBuffer.append(Integer.toString(n2, 8));
                continue;
            }
            stringBuffer.append((char)n2);
        }
        return stringBuffer.toString();
    }

    @Override
    public ServiceInfoImpl clone() {
        ServiceInfoImpl serviceInfoImpl = new ServiceInfoImpl(this.getQualifiedNameMap(), this._port, this._weight, this._priority, this._persistent, this._text);
        Inet6Address[] inet6AddressArray = this.getInet6Addresses();
        InetAddress[] inetAddressArray = inet6AddressArray;
        int n = inetAddressArray.length;
        for (int i = 0; i < n; ++i) {
            Inet6Address inet6Address = inetAddressArray[i];
            serviceInfoImpl._ipv6Addresses.add(inet6Address);
        }
        for (InetAddress inetAddress : inetAddressArray = this.getInet4Addresses()) {
            serviceInfoImpl._ipv4Addresses.add((Inet4Address)inetAddress);
        }
        return serviceInfoImpl;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[" + this.getClass().getSimpleName() + "@" + System.identityHashCode(this) + " ");
        stringBuilder.append("name: '");
        stringBuilder.append((this.getName().length() > 0 ? this.getName() + "." : "") + this.getTypeWithSubtype());
        stringBuilder.append("' address: '");
        InetAddress[] inetAddressArray = this.getInetAddresses();
        if (inetAddressArray.length > 0) {
            for (InetAddress inetAddress : inetAddressArray) {
                stringBuilder.append(inetAddress);
                stringBuilder.append(':');
                stringBuilder.append(this.getPort());
                stringBuilder.append(' ');
            }
        } else {
            stringBuilder.append("(null):");
            stringBuilder.append(this.getPort());
        }
        stringBuilder.append("' status: '");
        stringBuilder.append(this._state.toString());
        stringBuilder.append(this.isPersistent() ? "' is persistent," : "',");
        stringBuilder.append(" has ");
        stringBuilder.append(this.hasData() ? "" : "NO ");
        stringBuilder.append("data");
        if (this.getTextBytes().length > 0) {
            Map<String, byte[]> map = this.getProperties();
            if (!map.isEmpty()) {
                stringBuilder.append("\n");
                for (String string : map.keySet()) {
                    stringBuilder.append("\t" + string + ": " + new String((byte[])map.get(string)) + "\n");
                }
            } else {
                stringBuilder.append(" empty");
            }
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public Collection<DNSRecord> answers(boolean bl, int n, HostInfo hostInfo) {
        ArrayList<DNSRecord> arrayList = new ArrayList<DNSRecord>();
        if (this.getSubtype().length() > 0) {
            arrayList.add(new DNSRecord.Pointer(this.getTypeWithSubtype(), DNSRecordClass.CLASS_IN, false, n, this.getQualifiedName()));
        }
        arrayList.add(new DNSRecord.Pointer(this.getType(), DNSRecordClass.CLASS_IN, false, n, this.getQualifiedName()));
        arrayList.add(new DNSRecord.Service(this.getQualifiedName(), DNSRecordClass.CLASS_IN, bl, n, this._priority, this._weight, this._port, hostInfo.getName()));
        arrayList.add(new DNSRecord.Text(this.getQualifiedName(), DNSRecordClass.CLASS_IN, bl, n, this.getTextBytes()));
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setText(byte[] byArray) throws IllegalStateException {
        ServiceInfoImpl serviceInfoImpl = this;
        synchronized (serviceInfoImpl) {
            this._text = byArray;
            this._props = null;
            this.setNeedTextAnnouncing(true);
        }
    }

    @Override
    public void setText(Map<String, ?> map) throws IllegalStateException {
        this.setText(ServiceInfoImpl.textFromProperties(map));
    }

    void _setText(byte[] byArray) {
        this._text = byArray;
        this._props = null;
    }

    private static byte[] textFromProperties(Map<String, ?> map) {
        byte[] byArray = null;
        if (map != null) {
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(256);
                for (String string : map.keySet()) {
                    byte[] byArray2;
                    Object obj = map.get(string);
                    ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream(100);
                    ServiceInfoImpl.writeUTF(byteArrayOutputStream2, string);
                    if (obj != null) {
                        if (obj instanceof String) {
                            byteArrayOutputStream2.write(61);
                            ServiceInfoImpl.writeUTF(byteArrayOutputStream2, (String)obj);
                        } else if (obj instanceof byte[]) {
                            byArray2 = (byte[])obj;
                            if (byArray2.length > 0) {
                                byteArrayOutputStream2.write(61);
                                byteArrayOutputStream2.write(byArray2, 0, byArray2.length);
                            } else {
                                obj = null;
                            }
                        } else {
                            throw new IllegalArgumentException("invalid property value: " + obj);
                        }
                    }
                    if ((byArray2 = byteArrayOutputStream2.toByteArray()).length > 255) {
                        throw new IOException("Cannot have individual values larger that 255 chars. Offending value: " + string + (obj != null ? "" : "=" + obj));
                    }
                    byteArrayOutputStream.write((byte)byArray2.length);
                    byteArrayOutputStream.write(byArray2, 0, byArray2.length);
                }
                byArray = byteArrayOutputStream.toByteArray();
            }
            catch (IOException iOException) {
                throw new RuntimeException("unexpected exception: " + iOException);
            }
        }
        return byArray != null && byArray.length > 0 ? byArray : DNSRecord.EMPTY_TXT;
    }

    public void setDns(JmDNSImpl jmDNSImpl) {
        this._state.setDns(jmDNSImpl);
    }

    @Override
    public JmDNSImpl getDns() {
        return this._state.getDns();
    }

    @Override
    public boolean isPersistent() {
        return this._persistent;
    }

    public void setNeedTextAnnouncing(boolean bl) {
        this._needTextAnnouncing = bl;
        if (this._needTextAnnouncing) {
            this._state.setTask(null);
        }
    }

    public boolean needTextAnnouncing() {
        return this._needTextAnnouncing;
    }

    Delegate getDelegate() {
        return this._delegate;
    }

    void setDelegate(Delegate delegate) {
        this._delegate = delegate;
    }

    private static final class ServiceInfoState
    extends DNSStatefulObject.DefaultImplementation {
        private static final long serialVersionUID = 1104131034952196820L;
        private final ServiceInfoImpl _info;

        public ServiceInfoState(ServiceInfoImpl serviceInfoImpl) {
            this._info = serviceInfoImpl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void setTask(DNSTask dNSTask) {
            super.setTask(dNSTask);
            if (this._task == null && this._info.needTextAnnouncing()) {
                this.lock();
                try {
                    if (this._task == null && this._info.needTextAnnouncing()) {
                        if (this._state.isAnnounced()) {
                            this.setState(DNSState.ANNOUNCING_1);
                            if (this.getDns() != null) {
                                this.getDns().startAnnouncer();
                            }
                        }
                        this._info.setNeedTextAnnouncing(false);
                    }
                }
                finally {
                    this.unlock();
                }
            }
        }

        @Override
        public void setDns(JmDNSImpl jmDNSImpl) {
            super.setDns(jmDNSImpl);
        }
    }

    public static interface Delegate {
        public void textValueUpdated(ServiceInfo var1, byte[] var2);
    }
}

