" Vim syntax file
" Language: mycron crontab files
" Maintainer: Dirk Sohler
" Latest Revision: 02 November 2012

if exists("b:current_syntax")
	finish
endif

" Match
syn match date /^[0-9\.]\{4}-[0-\.9]\{2}-[0-9\.]\{2}/ nextgroup=sep,time,day
syn match sep /T/ nextgroup=time,day contained
syn match time /[0-9\.]\{2}:[0-9\.]\{2}/ nextgroup=day contained
syn match day /\(\s\)*[1-7\.]\{1,7}\s/ contained
syn match comments  "#.*$"

" Style
hi date      ctermfg=White cterm=bold gui=bold guifg=White
hi sep       ctermfg=Yellow cterm=bold gui=bold guifg=White
hi time      ctermfg=White cterm=bold gui=bold guifg=White
hi day       ctermfg=LightCyan cterm=bold gui=bold guifg=LightCyan
hi comments  ctermfg=LightBlue guifg=LightBlue

let b:current_syntax = "crontab"
